/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Party;
import cms.tmx.entity.Product;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.javafx.MxList;
import cms.tmx.manage.models.AssetGrpMngModel;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.ProductMngServiceImpl;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.ProductRelateAccountTabContent;
import cms.tmx.rights.IUiRightService;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AssetGrpProductTabContent
extends MxTabContent {
    private static final String SURE_NOT_SAVE = "\u4ea7\u54c1\u6388\u6743\u5df2\u53d1\u751f\u4fee\u6539\uff0c\u662f\u5426\u786e\u8ba4\u4e0d\u4fdd\u5b58";
    private static final String ALERT = "\u63d0\u793a";
    private static final String ERROR_ASSETGRP_UNRIGISTERED = "\u8d44\u4ea7\u7ec4\u5df2\u505c\u7528";
    private static final String ERROR_ASSETGRP_NOT_EXIST = "\u8d44\u4ea7\u7ec4\u4e0d\u5b58\u5728";
    @FXML
    private TextField txtSearch;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<Product> tableProduct;
    @FXML
    private TableColumn<Product, String> index;
    @FXML
    private TableColumn<Product, String> creator;
    @FXML
    private TableColumn<Product, String> updater;
    @FXML
    private TableColumn<Product, Boolean> select;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSave;
    @Inject
    private ProductMngServiceImpl productMng;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    @Inject
    private IUiRightService model;
    @Inject
    private AssetGrpMngModel assetGrpMngModel;
    @Inject
    private PartyFactory pFactory;
    private Party selectTreeParty;
    private AssetGrp selectAssetGrp;
    private Product selectTableProduct;
    private TreeItem<Party> oldSelectParty;
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private BooleanProperty save = new SimpleBooleanProperty(false);
    private MxList<Product> mlist = new MxList();
    private List<Product> filterList = new LinkedList<Product>();
    private static final Logger logger = LogManager.getLogger(ProductRelateAccountTabContent.class);
    private List<String> setProducts = new LinkedList<String>();
    private Predicate<Product> pd = inst -> {
        String idName = this.txtSearch.getText().trim();
        return inst.getName().contains(idName);
    };
    private InvalidationListener instModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableProduct.sort();
    };
    private static final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");

    @FXML
    public void initialize() {
        this.selectAssetGrp = this.assetGrpMngModel.getCommonAssetGrp();
        this.labSuccess.setVisible(false);
        TreeItem<Party> root = this.initRoot();
        this.createTableView();
        this.bind();
        this.exe.execute(() -> {
            this.initTree(root);
            this.query(((Party)root.getValue()).getId());
        });
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void initTree(TreeItem<Party> root) {
        try {
            ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
            root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
            root = this.treeParty.getRoot();
            this.treeParty.getSelectionModel().select((Object)root);
            this.oldSelectParty = root;
            Platform.runLater(() -> this.treeParty.refresh());
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
        }
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.instModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> this.onItemClicked((MouseEvent)event));
        this.tableProduct.setOnMouseClicked(event -> {
            if (this.tableProduct.getSelectionModel().getSelectedItem() != null) {
                this.selectTableProduct = (Product)this.tableProduct.getSelectionModel().getSelectedItem();
            }
        });
    }

    private void createTableView() {
        TableUtils.isAuto(this.index);
        TableUtils.initValueFactory(this.tableProduct);
        this.creator.setCellValueFactory(data -> this.userMng.getUserName(((Product)data.getValue()).getCreator()));
        this.updater.setCellValueFactory(data -> this.userMng.getUserName(((Product)data.getValue()).getUpdater()));
        this.select.setCellFactory(cellDate -> new MxCheckBoxTableCell());
        this.select.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
        this.tableProduct.setItems(this.mlist.getList());
    }

    private void onItemClicked(MouseEvent event) {
        TreeItem item;
        if (this.save.get()) {
            if (!this.mAlert.alert(Alert.AlertType.CONFIRMATION, SURE_NOT_SAVE, ALERT)) {
                this.treeParty.getSelectionModel().select(this.oldSelectParty);
                return;
            }
            this.save.set(false);
        }
        this.oldSelectParty = item = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        this.selectTreeParty = (Party)item.getValue();
        this.query(this.selectTreeParty.getId());
    }

    private void query(String partyId) {
        this.setProducts.clear();
        try {
            List<Product> listProduct = this.productMng.getProducts(partyId);
            this.filterList.clear();
            LinkedList<String> listIds = new LinkedList<String>();
            listProduct.forEach(item -> {
                if (this.selectAssetGrp.getAssetUnitId().contains(item.getId())) {
                    item.setSelected(true);
                    this.setProducts.add(item.getId());
                }
                this.filterList.add((Product)item);
                listIds.add(item.getCreator());
                listIds.add(item.getUpdater());
            });
            this.userMng.queryUserNameMap(listIds);
            this.mlist.setAll(this.filterList);
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public boolean save() {
        this.save.set(false);
        try {
            this.assetGrpMng.assignProductToAssetGrp(this.selectAssetGrp, this.setProducts);
        }
        catch (MException e2) {
            if (e2.getCode() == 3053) {
                this.mAlert.alert(Alert.AlertType.ERROR, ERROR_ASSETGRP_UNRIGISTERED);
            } else if (e2.getCode() == 3054) {
                this.mAlert.alert(Alert.AlertType.ERROR, ERROR_ASSETGRP_NOT_EXIST);
            } else {
                this.mAlert.alert(Alert.AlertType.ERROR, e2.getDesc().isEmpty() ? "\u5173\u8054\u5f02\u5e38" : e2.getDesc());
            }
            logger.error("\u8d44\u4ea7\u7ec4\u6388\u6743\u4ea7\u54c1\u5f02\u5e38", (Throwable)e2);
            this.tableProduct.refresh();
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return false;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    private class MxCheckBoxTableCell<S, T>
    extends CheckBoxTableCell<Product, T> {
        Product obj;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    if (this.getTableRow() == null) {
                        return;
                    }
                    this.getTableRow().pseudoClassStateChanged(MXSELECTED, this.checkbox.isSelected());
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(MXSELECTED, now.booleanValue()));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                if (this.getTableRow().getItem() instanceof Product) {
                    this.obj = (Product)Product.class.cast(this.getTableRow().getItem());
                }
                if (this.obj == null) {
                    return;
                }
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected(this.obj));
                this.setGraphic((Node)this.checkbox);
                this.checkbox.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    if (!AssetGrpProductTabContent.this.canUpdate.get()) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{AssetGrpProductTabContent.this.canUpdate}));
            }
        }

        private void checkBoxSelected(Product prod) {
            AssetGrpProductTabContent.this.save.set(true);
            if (prod.selectedProperty().get()) {
                AssetGrpProductTabContent.this.setProducts.add(prod.getId());
            } else {
                AssetGrpProductTabContent.this.setProducts.remove(prod.getId());
            }
        }
    }
}

