/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.Party;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.AssetGrpMngModel;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.PortfolioRelateAccountTabContent;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AssetGrpPortfolioTabContent
extends MxTabContent {
    private static final String SURE_NOT_SAVE = "\u6295\u7ec4\u6743\u9650\u5df2\u53d1\u751f\u4fee\u6539\uff0c\u662f\u5426\u786e\u8ba4\u4e0d\u4fdd\u5b58";
    private static final String ALERT = "\u63d0\u793a";
    private static final String ERROR_ASSETGRP_UNRIGISTERED = "\u8d44\u4ea7\u7ec4\u5df2\u505c\u7528";
    private static final String ERROR_ASSETGRP_NOT_EXIST = "\u8d44\u4ea7\u7ec4\u4e0d\u5b58\u5728";
    @FXML
    private TextField txtSearch;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<Portfolio> tablePortfolio;
    @FXML
    private TableColumn<Portfolio, MxNode> type;
    @FXML
    private TableColumn<Portfolio, String> validityPeriod;
    @FXML
    private TableColumn<Portfolio, Number> duration;
    @FXML
    private TableColumn<Portfolio, String> benchmark;
    @FXML
    private TableColumn<Portfolio, String> des;
    @FXML
    private TableColumn<Portfolio, String> creator;
    @FXML
    private TableColumn<Portfolio, String> updater;
    @FXML
    private TableColumn<Portfolio, String> shares;
    @FXML
    private TableColumn<Portfolio, String> index;
    @FXML
    private TableColumn<Portfolio, Boolean> select;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSave;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private PortfolioMngServiceImpl portfolioMng;
    @Inject
    private AssetGrpMngModel assetGrpMngModel;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    @Inject
    private PartyFactory pFactory;
    private Party selectTreeParty;
    private Portfolio selectTablePortfolio;
    private AssetGrp selectAssetGrp;
    private TreeItem<Party> oldSelectParty;
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private BooleanProperty save = new SimpleBooleanProperty(false);
    private MxList<Portfolio> mlist = new MxList();
    private List<Portfolio> filterList = new LinkedList<Portfolio>();
    private static final Logger logger = LogManager.getLogger(PortfolioRelateAccountTabContent.class);
    private List<String> setPortfolios = new LinkedList<String>();
    private Predicate<Portfolio> pd = portfolio -> {
        String name = this.txtSearch.getText().trim();
        return portfolio.getName().contains(name);
    };
    private InvalidationListener portfolioModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tablePortfolio.sort();
    };
    private static final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");

    @FXML
    public void initialize() {
        this.setPortfolios.clear();
        this.selectAssetGrp = this.assetGrpMngModel.getCommonAssetGrp();
        this.labSuccess.setVisible(false);
        TreeItem<Party> root = this.initRoot();
        this.exe.execute(() -> {
            this.initTree(root);
            this.query(((Party)root.getValue()).getId());
        });
        this.createTableView();
        this.bind();
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void initTree(TreeItem<Party> root) {
        try {
            ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
            root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
            root = this.treeParty.getRoot();
            this.treeParty.getSelectionModel().select((Object)root);
            this.oldSelectParty = root;
            Platform.runLater(() -> this.treeParty.refresh());
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
        }
    }

    private void bind() {
        MxNode node = MxNodeFactory.create((String)"post_status", (String)"1");
        node.load("post_status", "1");
        this.txtSearch.textProperty().addListener(this.portfolioModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> this.onItemClicked((MouseEvent)event));
        this.tablePortfolio.setOnMouseClicked(event -> {
            if (this.tablePortfolio.getSelectionModel().getSelectedItem() != null) {
                this.selectTablePortfolio = (Portfolio)this.tablePortfolio.getSelectionModel().getSelectedItem();
            }
        });
    }

    private void createTableView() {
        TableUtils.initValueFactory(this.tablePortfolio);
        this.validityPeriod.setCellValueFactory(data -> this.setTime((Portfolio)data.getValue()));
        this.duration.setCellValueFactory(cellData -> new SimpleIntegerProperty(Integer.valueOf(((Portfolio)cellData.getValue()).getValPeriod()).intValue()));
        this.des.setCellFactory(data -> new AutoTableCell());
        this.benchmark.setCellValueFactory(data -> {
            List list = ((Portfolio)data.getValue()).getBenchmarkList();
            SimpleStringProperty flage = new SimpleStringProperty("");
            int i = 0;
            while (i < list.size()) {
                String s;
                String id = (String)list.get(i);
                if (i == list.size() - 1) {
                    s = String.valueOf(flage.get()) + (String)this.portfolioMng.getBenchmarkName(id).get();
                    flage.set(s);
                } else {
                    s = String.valueOf(flage.get()) + (String)this.portfolioMng.getBenchmarkName(id).get() + ",";
                    flage.set(s);
                }
                ++i;
            }
            return flage;
        });
        this.creator.setCellValueFactory(data -> this.userMng.getUserName(((Portfolio)data.getValue()).getCreator()));
        this.updater.setCellValueFactory(data -> this.userMng.getUserName(((Portfolio)data.getValue()).getUpdater()));
        this.tablePortfolio.setItems(this.mlist.getList());
        this.select.setCellFactory(cellDate -> new MxCheckBoxTableCell());
        this.select.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
        this.tablePortfolio.setItems(this.mlist.getList());
    }

    private StringProperty setTime(Portfolio p) {
        SimpleStringProperty s = new SimpleStringProperty("\u6c38\u4e45");
        if ("\u5b58\u7eed\u4ea4\u6613\u65e5".equals(p.getToPeriod().getValue())) {
            s.set((Object)p.getTotalPeriod());
        }
        return s;
    }

    private void onItemClicked(MouseEvent event) {
        TreeItem item;
        if (this.save.get()) {
            if (!this.mAlert.alert(Alert.AlertType.CONFIRMATION, SURE_NOT_SAVE, ALERT)) {
                this.treeParty.getSelectionModel().select(this.oldSelectParty);
                return;
            }
            this.save.set(false);
        }
        this.oldSelectParty = item = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        this.selectTreeParty = (Party)item.getValue();
        this.query(this.selectTreeParty.getId());
    }

    private void query(String partyId) {
        this.setPortfolios.clear();
        try {
            this.portfolioMng.queryBenchmarkMap();
            List<Portfolio> listPortfolio = this.portfolioMng.getPortfoliosByParty(partyId);
            this.filterList.clear();
            LinkedList<String> listIds = new LinkedList<String>();
            listPortfolio.forEach(item -> {
                if (this.selectAssetGrp.getAssetUnitId().contains(item.getId())) {
                    item.setSelected(true);
                    this.setPortfolios.add(item.getId());
                }
                this.filterList.add((Portfolio)item);
                listIds.add(item.getCreator());
                listIds.add(item.getUpdater());
            });
            this.userMng.queryUserNameMap(listIds);
            this.mlist.setAll(this.filterList);
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
            this.tablePortfolio.sort();
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public boolean save() {
        this.save.set(false);
        try {
            this.assetGrpMng.assignPortfolioToAssetGrp(this.selectAssetGrp, this.setPortfolios);
        }
        catch (MException e2) {
            if (e2.getCode() == 3053) {
                this.mAlert.alert(Alert.AlertType.ERROR, ERROR_ASSETGRP_UNRIGISTERED);
            } else if (e2.getCode() == 3054) {
                this.mAlert.alert(Alert.AlertType.ERROR, ERROR_ASSETGRP_NOT_EXIST);
            } else {
                this.mAlert.alert(Alert.AlertType.ERROR, e2.getDesc().isEmpty() ? "\u5173\u8054\u5f02\u5e38" : e2.getDesc());
            }
            logger.error("\u8d44\u4ea7\u7ec4\u6388\u6743\u4ea7\u54c1\u5f02\u5e38", (Throwable)e2);
            this.tablePortfolio.refresh();
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return false;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    private class AutoTableCell<S, T>
    extends TableCell<Portfolio, T> {
        Portfolio portfolio;

        private AutoTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                this.portfolio = (Portfolio)Portfolio.class.cast(this.getTableRow().getItem());
                if (this.portfolio == null) {
                    return;
                }
                if (!this.portfolio.getDes().isEmpty()) {
                    Tooltip tooltip = new Tooltip();
                    tooltip.setText(this.portfolio.getDes());
                    this.setTooltip(tooltip);
                } else {
                    this.setTooltip(null);
                }
                this.setText(this.portfolio.getDes());
            }
        }
    }

    private class MxCheckBoxTableCell<S, T>
    extends CheckBoxTableCell<Portfolio, T> {
        Portfolio obj;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    if (this.getTableRow() == null) {
                        return;
                    }
                    this.getTableRow().pseudoClassStateChanged(MXSELECTED, this.checkbox.isSelected());
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(MXSELECTED, now.booleanValue()));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                if (this.getTableRow().getItem() instanceof Portfolio) {
                    this.obj = (Portfolio)Portfolio.class.cast(this.getTableRow().getItem());
                }
                if (this.obj == null) {
                    return;
                }
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected(this.obj));
                this.setGraphic((Node)this.checkbox);
                this.checkbox.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    if (!AssetGrpPortfolioTabContent.this.canUpdate.get()) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{AssetGrpPortfolioTabContent.this.canUpdate}));
            }
        }

        private void checkBoxSelected(Portfolio portf) {
            AssetGrpPortfolioTabContent.this.save.set(true);
            if (portf.selectedProperty().get()) {
                AssetGrpPortfolioTabContent.this.setPortfolios.add(portf.getId());
            } else {
                AssetGrpPortfolioTabContent.this.setPortfolios.remove(portf.getId());
            }
        }
    }
}

