/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Party;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.AddAssetGrpDialog;
import cms.tmx.manage.parts.PortfolioMngPart;
import cms.tmx.manage.parts.UpdateAssetGrpDialog;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AssetGrpMngPart
extends MxPart {
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<AssetGrp> tableAssetGrp;
    @FXML
    private TextField txtSearch;
    @FXML
    private TableColumn<String, String> index;
    @FXML
    private TableColumn<AssetGrp, String> colId;
    @FXML
    private TableColumn<AssetGrp, String> colName;
    @FXML
    private TableColumn<AssetGrp, String> colPartyName;
    @FXML
    private TableColumn<AssetGrp, String> colAssetUnit;
    @FXML
    private TableColumn<AssetGrp, String> colStatus;
    @FXML
    private TableColumn<AssetGrp, MxNode> colType;
    @FXML
    private TableColumn<AssetGrp, String> colCreator;
    @FXML
    private TableColumn<AssetGrp, String> colCreateTime;
    @FXML
    private TableColumn<AssetGrp, String> colUpdater;
    @FXML
    private TableColumn<AssetGrp, String> colUpdateTime;
    @FXML
    private TableColumn<AssetGrp, String> colOpera;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnQuery;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    @Inject
    private UserMngServiceImpl userMng;
    private TreeItem<Party> root;
    @Inject
    private PartyFactory pFactory;
    @Inject
    private MxAlert mAlert;
    private MxList<AssetGrp> mlist = new MxList();
    private List<AssetGrp> filterList = new LinkedList<AssetGrp>();
    private AssetGrp selectTableAssetGrp;
    private TreeItem<Party> selectTreeParty;
    @Inject
    private IUiRightService model;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    private boolean settingFlag = true;
    private boolean statusFlag = true;
    private static final Logger logger = LogManager.getLogger(PortfolioMngPart.class);
    private static final String IS_ENABLE_PORTFOLIO = "\u662f\u5426\u542f\u7528\u8be5\u8d44\u4ea7\u7ec4";
    private static final String IS_DISABLE_PORTFOLIO = "\u662f\u5426\u505c\u7528\u8be5\u8d44\u4ea7\u7ec4";
    private static final String ALERT = "\u63d0\u793a";
    private Boolean all = true;
    private Predicate<AssetGrp> pd = assetGrp -> {
        String name = this.txtSearch.getText().trim();
        return assetGrp.getName().contains(name);
    };
    private InvalidationListener assetGrpModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableAssetGrp.sort();
    };

    @FXML
    public void initialize() {
        this.root = this.initRoot();
        this.exe.execute(() -> {
            this.initTree(this.root);
            this.query(((Party)this.root.getValue()).getId(), this.all);
        });
        this.bind();
        this.createTableView();
        this.checkRights();
    }

    private void initTree(TreeItem<Party> root) {
        block5: {
            try {
                try {
                    ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
                    root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
                    this.partyTree.refresh();
                }
                catch (MException e) {
                    Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
                    logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
                    Platform.runLater(() -> this.treeParty.refresh());
                    break block5;
                }
            }
            catch (Throwable throwable) {
                Platform.runLater(() -> this.treeParty.refresh());
                throw throwable;
            }
            Platform.runLater(() -> this.treeParty.refresh());
        }
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.assetGrpModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> {
            if (this.treeParty.getSelectionModel().getSelectedItem() == null || this.selectTreeParty == this.treeParty.getSelectionModel().getSelectedItem()) {
                return;
            }
            this.selectTableAssetGrp = null;
            this.onItemClicked((TreeItem<Party>)((TreeItem)this.treeParty.getSelectionModel().getSelectedItem()), true);
        });
        this.tableAssetGrp.setOnMouseClicked(event -> {
            if (this.tableAssetGrp.getSelectionModel().getSelectedItem() == null) {
                return;
            }
            this.selectTableAssetGrp = (AssetGrp)this.tableAssetGrp.getSelectionModel().getSelectedItem();
        });
    }

    private void onItemClicked(TreeItem<Party> item, Boolean all) {
        this.selectTreeParty = item;
        if (this.selectTreeParty.getChildren().isEmpty()) {
            all = false;
        }
        this.query(((Party)this.selectTreeParty.getValue()).getId(), all);
    }

    private void checkRights() {
        this.model.registerCheck((Control)this.btnQuery, new String[]{"queryAssetGrpControl"});
        this.model.registerCheckAll((Control)this.btnAdd, new String[]{"addAssetGrpControl", "saveAssetGrpBasic"});
        this.statusFlag = this.model.registerCheck(new String[]{"enableAssetGrpControl"});
        this.settingFlag = this.model.registerCheck(new String[]{"updateAssetGrpControl"});
    }

    protected void afterTableRestore() {
        this.treeParty.getSelectionModel().select(this.root);
        this.selectTreeParty = this.root;
    }

    private void createTableView() {
        this.addViwer(this.tableAssetGrp);
        this.tableAssetGrp.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableAssetGrp);
        this.colId.setCellValueFactory(data -> ((AssetGrp)data.getValue()).idProperty());
        this.colName.setCellValueFactory(data -> ((AssetGrp)data.getValue()).nameProperty());
        this.colPartyName.setCellValueFactory(data -> this.getPartyName((AssetGrp)data.getValue()));
        this.colStatus.setCellValueFactory(data -> ((AssetGrp)data.getValue()).statusTextProperty());
        this.colType.setCellValueFactory(data -> ((AssetGrp)data.getValue()).typeProperty());
        this.colAssetUnit.setCellValueFactory(data -> ((AssetGrp)data.getValue()).assetUnitProperty());
        this.colAssetUnit.setCellFactory(data -> new TooltipTableCell<AssetGrp, String>(){

            public String tooltip() {
                return this.getValue() == null ? null : ((AssetGrp)this.getValue()).getAssetUnit();
            }
        });
        this.colCreator.setCellValueFactory(data -> this.userMng.getUserName(((AssetGrp)data.getValue()).getCreator()));
        this.colCreateTime.setCellValueFactory(data -> ((AssetGrp)data.getValue()).createTimeProperty());
        this.colOpera.setCellFactory(data -> new OperaCell(this.stage, this.tableAssetGrp));
        this.colUpdater.setCellValueFactory(data -> this.userMng.getUserName(((AssetGrp)data.getValue()).getUpdater()));
        this.colUpdateTime.setCellValueFactory(data -> ((AssetGrp)data.getValue()).updateTimeProperty());
        this.tableAssetGrp.setItems(this.mlist.getList());
    }

    public StringProperty getPartyName(AssetGrp assetGrp) {
        if (StringUtils.isEmpty((String)assetGrp.getPartyId())) {
            return new SimpleStringProperty("");
        }
        Party party = this.partyTree.getParty(assetGrp.getPartyId());
        assetGrp.setPartyName(party.getName());
        return party.nameProperty();
    }

    private void refreshTable() {
        if (this.selectTreeParty == null) {
            return;
        }
        this.query(((Party)this.selectTreeParty.getValue()).getId(), true);
        this.tableAssetGrp.getSelectionModel().select((Object)this.selectTableAssetGrp);
        this.tableAssetGrp.scrollTo((Object)this.selectTableAssetGrp);
    }

    private void query(String partyId, boolean all) {
        try {
            List<AssetGrp> listAssetGrp = this.assetGrpMng.getAssetGrpsByPartyId(partyId, all);
            this.filterList.clear();
            listAssetGrp.forEach(item -> this.filterList.add((AssetGrp)item));
            this.mlist.setAll(this.filterList);
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> o1.compareTo(o2));
            this.tableAssetGrp.sort();
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error("\u67e5\u8be2\u8d44\u4ea7\u7ec4\u5217\u8868", (Throwable)e);
        }
    }

    @FXML
    public void refresh() {
        try {
            TreeItem<Party> root = this.partyTree.refresh();
            this.treeParty.setRoot(root);
            root.setExpanded(true);
            if (this.selectTreeParty == null) {
                return;
            }
            if (this.partyMng.getUserParty().getId().equals(((Party)this.selectTreeParty.getValue()).getId())) {
                this.treeParty.getSelectionModel().select(root);
            } else {
                this.treeParty.getSelectionModel().select(this.selectTreeParty);
            }
            this.query(((Party)this.selectTreeParty.getValue()).getId(), true);
            this.tableAssetGrp.getSelectionModel().select((Object)this.selectTableAssetGrp);
            this.tableAssetGrp.scrollTo((Object)this.selectTableAssetGrp);
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public void add() {
        AddAssetGrpDialog obj = (AddAssetGrpDialog)((Object)this.of.create(AddAssetGrpDialog.class));
        TreeItem treeItem = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        if (treeItem == null) {
            obj.setParty((Party)this.treeParty.getRoot().getValue());
        } else {
            obj.setParty((Party)treeItem.getValue());
        }
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u8d44\u4ea7\u7ec4");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
            if (!obj.getNewAssetGrpId().isEmpty()) {
                String assetGrpId = obj.getNewAssetGrpId();
                this.selectTableAssetGrp = this.assetGrpMng.getAssetGrpById(assetGrpId);
                if (this.selectTreeParty == null) {
                    return;
                }
                this.refreshTable();
            }
        }
        catch (MException | Exception e) {
            logger.error((Object)e, e);
        }
    }

    public void update() {
        UpdateAssetGrpDialog obj = (UpdateAssetGrpDialog)((Object)this.of.create(UpdateAssetGrpDialog.class));
        AssetGrp assetGrp = (AssetGrp)this.tableAssetGrp.getSelectionModel().getSelectedItem();
        if (assetGrp == null) {
            return;
        }
        AssetGrp assetGrpSet = (AssetGrp)this.of.create(AssetGrp.class);
        assetGrpSet.update(assetGrp);
        obj.setAssetGrp(assetGrpSet);
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u8d44\u4ea7\u7ec4");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.getButton(ButtonType.CANCEL).setVisible(false);
            dialog.launch();
            this.refreshTable();
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u4fee\u6539\u8d44\u4ea7\u7ec4\u5931\u8d25", (Throwable)e);
        }
    }

    public void enable() {
        AssetGrp item = (AssetGrp)this.tableAssetGrp.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        try {
            if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, IS_ENABLE_PORTFOLIO, ALERT)) {
                this.assetGrpMng.enableAssetGrp(item.getId(), true);
                this.mAlert.alert(Alert.AlertType.INFORMATION, "\u5df2\u542f\u7528\u8d44\u4ea7\u7ec4", ALERT);
            }
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u542f\u7528\u8d44\u4ea7\u7ec4\u5931\u8d25", (Throwable)e);
        }
    }

    public void disable() {
        AssetGrp item = (AssetGrp)this.tableAssetGrp.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        try {
            if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, IS_DISABLE_PORTFOLIO, ALERT)) {
                this.assetGrpMng.enableAssetGrp(item.getId(), false);
                this.mAlert.alert(Alert.AlertType.INFORMATION, "\u5df2\u505c\u7528\u8d44\u4ea7\u7ec4", ALERT);
            }
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error("\u505c\u7528\u8d44\u4ea7\u7ec4\u5931\u8d25", (Throwable)e);
        }
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableAssetGrp);
    }

    @FXML
    private void rightRefresh() {
        this.refresh();
    }

    private class OperaCell
    extends TableCell<AssetGrp, String> {
        final Label updateLab = new Label("\u8bbe\u7f6e");
        final HBox paddedLabel = new HBox();
        final Label statusLab = new Label("\u65e0");

        OperaCell(Stage stage, final TableView table) {
            this.paddedLabel.setSpacing(20.0);
            this.updateLab.setStyle("-fx-cursor:hand;");
            this.statusLab.setStyle("-fx-cursor:hand;");
            this.updateLab.getStyleClass().add((Object)"text-blue");
            this.statusLab.getStyleClass().add((Object)"text-blue");
            if (AssetGrpMngPart.this.settingFlag) {
                this.paddedLabel.getChildren().add((Object)this.updateLab);
                HBox.setMargin((Node)this.updateLab, (Insets)new Insets(0.0, 0.0, 0.0, 20.0));
            }
            if (AssetGrpMngPart.this.statusFlag) {
                this.paddedLabel.getChildren().add((Object)this.statusLab);
            }
            this.updateLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    AssetGrpMngPart.this.update();
                }
            });
            this.statusLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    if (OperaCell.this.getTableRow().getItem() instanceof AssetGrp) {
                        AssetGrp r = (AssetGrp)OperaCell.this.getTableRow().getItem();
                        AssetGrpMngPart.this.selectTableAssetGrp = r;
                        if (!r.isStatus()) {
                            OperaCell.this.statusLab.setText("\u542f\u7528");
                            AssetGrpMngPart.this.enable();
                        } else {
                            OperaCell.this.statusLab.setText("\u505c\u7528");
                            AssetGrpMngPart.this.disable();
                        }
                        AssetGrpMngPart.this.refreshTable();
                    }
                }
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                if (this.getTableRow() != null && this.getTableRow().getItem() instanceof AssetGrp) {
                    AssetGrp r = (AssetGrp)this.getTableRow().getItem();
                    if (r.isStatus()) {
                        this.statusLab.setText("\u505c\u7528");
                    } else {
                        this.statusLab.setText("\u542f\u7528");
                    }
                }
                this.setGraphic((Node)this.paddedLabel);
            } else {
                this.setGraphic(null);
            }
        }
    }
}

