/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Account;
import cms.tmx.entity.Party;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.entity.trade.AssetGrp;
import cms.tmx.javafx.MxList;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.AssetGrpMngModel;
import cms.tmx.manage.models.AssetGrpMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.parts.ProductRelateAccountTabContent;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AssetGrpAccntTabContent
extends MxTabContent {
    private static final String SURE_NOT_SAVE = "\u8d26\u6237\u6388\u6743\u5df2\u53d1\u751f\u4fee\u6539\uff0c\u662f\u5426\u786e\u8ba4\u4e0d\u4fdd\u5b58";
    private static final String ALERT = "\u63d0\u793a";
    @FXML
    private TextField txtSearch;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<Account> tableAccnt;
    @FXML
    private TableColumn<Account, String> index;
    @FXML
    private TableColumn<Account, Boolean> select;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSave;
    @Inject
    private AssetGrpMngModel assetGrpMngModel;
    @Inject
    private AccountMngServiceImpl accountMng;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private MxAlert mAlert;
    @Inject
    private ExecutorService exe;
    @Inject
    private PartyFactory pFactory;
    private Account selectTableAccnt;
    private Party selectTreeParty;
    private AssetGrp selectAssetGrp;
    private TreeItem<Party> oldSelectParty;
    private BooleanProperty canUpdate = new SimpleBooleanProperty(true);
    private BooleanProperty save = new SimpleBooleanProperty(false);
    private MxList<Account> mlist = new MxList();
    private List<Account> filterList = new LinkedList<Account>();
    private static final Logger logger = LogManager.getLogger(ProductRelateAccountTabContent.class);
    private List<String> setAccnts = new LinkedList<String>();
    @Inject
    private AssetGrpMngServiceImpl assetGrpMng;
    private static final String ERROR_ASSETGRP_UNRIGISTERED = "\u8d44\u4ea7\u7ec4\u5df2\u505c\u7528";
    private static final String ERROR_ASSETGRP_NOT_EXIST = "\u8d44\u4ea7\u7ec4\u4e0d\u5b58\u5728";
    private Predicate<Account> pd = accnt -> {
        String idName = this.txtSearch.getText().trim();
        return accnt.getName().contains(idName) || accnt.getInvestorId().contains(idName);
    };
    private InvalidationListener accntModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableAccnt.sort();
    };
    private static final PseudoClass MXSELECTED = PseudoClass.getPseudoClass((String)"mselected");

    @FXML
    public void initialize() {
        this.selectAssetGrp = this.assetGrpMngModel.getCommonAssetGrp();
        this.labSuccess.setVisible(false);
        TreeItem<Party> root = this.initRoot();
        this.createTableView();
        this.bind();
        this.exe.execute(() -> {
            this.initTree(root);
            this.query(((Party)root.getValue()).getId());
        });
    }

    private TreeItem<Party> initRoot() {
        TreeItem root = new TreeItem();
        Party party = this.pFactory.create();
        root.setValue((Object)party);
        this.treeParty.setRoot(root);
        return root;
    }

    private void initTree(TreeItem<Party> root) {
        try {
            ((Party)root.getValue()).update(this.partyTree.getRoot().getValue());
            root.getChildren().addAll((Collection)this.partyTree.getRoot().getChildren());
            root = this.treeParty.getRoot();
            this.treeParty.getSelectionModel().select((Object)root);
            this.oldSelectParty = root;
            Platform.runLater(() -> this.treeParty.refresh());
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error("\u52a0\u8f7d\u673a\u6784\u6811\u5931\u8d25", (Throwable)e);
        }
    }

    private void bind() {
        this.txtSearch.textProperty().addListener(this.accntModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> this.onItemClicked((MouseEvent)event));
        this.tableAccnt.setOnMouseClicked(event -> {
            if (this.tableAccnt.getSelectionModel().getSelectedItem() != null) {
                this.selectTableAccnt = (Account)this.tableAccnt.getSelectionModel().getSelectedItem();
            }
        });
    }

    private void createTableView() {
        TableUtils.isAuto(this.index);
        ((TableColumn)this.tableAccnt.getColumns().get(2)).setCellValueFactory((Callback)new PropertyValueFactory("investorId"));
        ((TableColumn)this.tableAccnt.getColumns().get(3)).setCellValueFactory((Callback)new PropertyValueFactory("name"));
        ((TableColumn)this.tableAccnt.getColumns().get(4)).setCellValueFactory((Callback)new PropertyValueFactory("status"));
        ((TableColumn)this.tableAccnt.getColumns().get(5)).setCellValueFactory((Callback)new PropertyValueFactory("secExchange"));
        ((TableColumn)this.tableAccnt.getColumns().get(6)).setCellValueFactory((Callback)new PropertyValueFactory("partyName"));
        ((TableColumn)this.tableAccnt.getColumns().get(7)).setCellValueFactory((Callback)new PropertyValueFactory("productName"));
        this.select.setCellFactory(cellDate -> new MxCheckBoxTableCell());
        this.select.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
        this.tableAccnt.setItems(this.mlist.getList());
    }

    private void onItemClicked(MouseEvent event) {
        TreeItem item;
        if (this.save.get()) {
            if (!this.mAlert.alert(Alert.AlertType.CONFIRMATION, SURE_NOT_SAVE, ALERT)) {
                this.treeParty.getSelectionModel().select(this.oldSelectParty);
                return;
            }
            this.save.set(false);
        }
        this.oldSelectParty = item = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        if (item == null) {
            return;
        }
        this.selectTreeParty = (Party)item.getValue();
        this.query(this.selectTreeParty.getId());
    }

    private void query(String partyId) {
        this.setAccnts.clear();
        try {
            LinkedList<Account> listAccount = new LinkedList<Account>();
            listAccount.addAll((Collection<Account>)this.accountMng.getAccountListByParty(partyId, PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_OFFSPRING));
            listAccount.addAll((Collection<Account>)this.accountMng.getAccountListByParty(partyId, PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_ONE));
            this.mlist.clear();
            this.filterList.clear();
            listAccount.forEach(item -> {
                if (this.selectAssetGrp.getAssetUnitId().contains(item.getId())) {
                    item.setSelected(true);
                    this.setAccnts.add(item.getId());
                }
            });
            this.filterList.addAll(listAccount);
            this.mlist.update(this.filterList, this.pd);
            if (this.selectTableAccnt == null) {
                return;
            }
            this.tableAccnt.getSelectionModel().select((Object)this.selectTableAccnt);
        }
        catch (MException e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public boolean save() {
        this.save.set(false);
        try {
            this.assetGrpMng.assignAccntToAssetGrp(this.selectAssetGrp, this.setAccnts);
        }
        catch (MException e2) {
            if (e2.getCode() == 3053) {
                this.mAlert.alert(Alert.AlertType.ERROR, ERROR_ASSETGRP_UNRIGISTERED);
            } else if (e2.getCode() == 3054) {
                this.mAlert.alert(Alert.AlertType.ERROR, ERROR_ASSETGRP_NOT_EXIST);
            } else {
                this.mAlert.alert(Alert.AlertType.ERROR, e2.getDesc().isEmpty() ? "\u5173\u8054\u5f02\u5e38" : e2.getDesc());
            }
            logger.error("\u8d44\u4ea7\u7ec4\u6388\u6743\u8d44\u91d1\u8d26\u53f7\u5f02\u5e38", (Throwable)e2);
            this.tableAccnt.refresh();
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return false;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    private class MxCheckBoxTableCell<S, T>
    extends CheckBoxTableCell<Account, T> {
        Account obj;
        CheckBox checkbox;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                try {
                    Field field = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("checkBox");
                    field.setAccessible(true);
                    this.checkbox = (CheckBox)field.get((Object)this);
                    if (this.getTableRow() == null) {
                        return;
                    }
                    this.getTableRow().pseudoClassStateChanged(MXSELECTED, this.checkbox.isSelected());
                    this.checkbox.selectedProperty().addListener((ob, old, now) -> this.getTableRow().pseudoClassStateChanged(MXSELECTED, now.booleanValue()));
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
                if (this.getTableRow().getItem() instanceof Account) {
                    this.obj = (Account)Account.class.cast(this.getTableRow().getItem());
                }
                if (this.obj == null) {
                    return;
                }
                this.checkbox.setOnMouseClicked(event -> this.checkBoxSelected(this.obj));
                this.setGraphic((Node)this.checkbox);
                this.checkbox.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
                    if (!AssetGrpAccntTabContent.this.canUpdate.get()) {
                        return true;
                    }
                    return false;
                }, (Observable[])new Observable[]{AssetGrpAccntTabContent.this.canUpdate}));
            }
        }

        private void checkBoxSelected(Account accnt) {
            AssetGrpAccntTabContent.this.save.set(true);
            if (accnt.selectedProperty().get()) {
                AssetGrpAccntTabContent.this.setAccnts.add(accnt.getId());
            } else {
                AssetGrpAccntTabContent.this.setAccnts.remove(accnt.getId());
            }
        }
    }
}

