/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.formatters.DateStrConverter;
import cms.tmx.control.formatters.TimeStrConverter;
import cms.tmx.control.table.MxCheckBoxTableCell;
import cms.tmx.core.MConfService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.MacInfo;
import cms.tmx.entity.Party;
import cms.tmx.entity.UpdateInfo;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.update.api.UpdateApi;
import cms.tmx.http.update.dto.AddVersionReq;
import cms.tmx.http.update.dto.Member;
import cms.tmx.http.update.dto.UpdateMembersReq;
import cms.tmx.http.update.dto.VersionInfo;
import cms.tmx.javafx.MxList;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.utils.StringUtils;
import com.jfoenix.controls.JFXTimePicker;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddVersionDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(AddVersionDialog.class);
    @FXML
    private Tab tabVersionInfo;
    @FXML
    private Tab tabUpdateList;
    @FXML
    private TabPane tabPane;
    @FXML
    private TextField txtVersion;
    @FXML
    private Button btnSave;
    @FXML
    private DatePicker releaseDate;
    @FXML
    private JFXTimePicker releaseTime;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<MacInfo> tableMacInfo;
    @FXML
    private TableColumn<MacInfo, String> colPartyId;
    @FXML
    private TableColumn<MacInfo, String> colPartyName;
    @FXML
    private TableColumn<MacInfo, String> colMac;
    @FXML
    private TableColumn<MacInfo, Boolean> colNeedUpdate;
    @FXML
    private TextArea textArea;
    @FXML
    private Button btnSaveUpdate;
    @FXML
    private TextField txtSearch;
    @Inject
    private MObjFactory of;
    @Inject
    private ExecutorService exe;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private MxAlert alert;
    @Inject
    private MConfService cs;
    @Inject
    private UpdateApi updateApi;
    @Inject
    private HttpBaseApi httpBaseApi;
    private MxList<MacInfo> macInfoList = new MxList();
    private List<MacInfo> orMacList = new ArrayList<MacInfo>();
    private boolean isAdd = false;
    private boolean isView = false;
    private UpdateInfo version;
    private TreeItem<Party> selectTreeParty;
    protected CheckBox checkBox = new CheckBox();
    DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd");
    DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
    private Predicate<MacInfo> pd = item -> {
        String selectedPartId = "P0000001";
        if (this.selectTreeParty != null) {
            selectedPartId = ((Party)this.selectTreeParty.getValue()).getId();
        }
        if ("P0000001".equals(selectedPartId)) {
            if (StringUtils.isEmpty((String)this.txtSearch.getText())) {
                return true;
            }
            return item.getPartyId().contains(this.txtSearch.getText()) || item.getPartyName().contains(this.txtSearch.getText()) || item.getMac().contains(this.txtSearch.getText());
        }
        if (!item.getPartyId().equals(selectedPartId)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtSearch.getText())) {
            return true;
        }
        return item.getPartyId().contains(this.txtSearch.getText()) || item.getPartyName().contains(this.txtSearch.getText()) || item.getMac().contains(this.txtSearch.getText());
    };

    @FXML
    public void initialize() {
        this.initTree();
        this.createTable();
        this.exe.execute(() -> {
            if (this.treeParty.getRoot() == null) {
                return;
            }
            this.treeParty.getSelectionModel().select(0);
        });
        if (this.isAdd) {
            this.tabUpdateList.setDisable(true);
        }
        if (!this.isAdd) {
            this.queryMacInfos();
        }
        if (this.isView) {
            this.btnSave.setDisable(true);
            this.btnSaveUpdate.setDisable(true);
        }
        this.treeParty.getSelectionModel().selectedItemProperty().addListener((ob, oldV, newV) -> {
            this.selectTreeParty = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
            this.macInfoList.filter(this.orMacList, this.pd);
        });
        this.btnSave.setOnMouseClicked(event -> this.save());
        this.btnSaveUpdate.setOnMouseClicked(event -> this.saveUpdateList());
        this.releaseDate.setConverter((StringConverter)new DateStrConverter("yyyyMMdd"));
        this.releaseDate.setValue((Object)LocalDate.now());
        this.releaseDate.setEditable(false);
        this.releaseTime.setConverter((StringConverter)new TimeStrConverter("HH:mm:ss"));
        this.releaseTime.set24HourView(true);
        this.releaseTime.setValue((Object)LocalTime.now());
        this.releaseTime.setEditable(true);
        this.fillVersionInfo();
        this.checkBox.selectedProperty().addListener((ob, oldV, newV) -> {
            ObservableList observableList = this.macInfoList.getList();
            synchronized (observableList) {
                this.macInfoList.getList().forEach(item -> item.setNeedUpdate(newV.booleanValue()));
            }
        });
        this.txtSearch.textProperty().addListener((ob, oldV, newV) -> this.macInfoList.filter(this.orMacList, this.pd));
    }

    private void fillVersionInfo() {
        if (this.version != null) {
            Platform.runLater(() -> {
                this.txtVersion.setText(this.version.getCurVersion());
                this.releaseDate.getEditor().setText(this.version.getReleaseDate());
                this.releaseDate.setValue((Object)LocalDate.parse(this.version.getReleaseDate(), this.dateFormatter));
                this.releaseTime.setValue((Object)LocalTime.parse(this.version.getReleaseTime(), this.timeFormatter));
                this.textArea.setText(this.version.getDescription());
            });
        }
    }

    private void queryMacInfos() {
        List members = null;
        try {
            members = this.updateApi.getMembersIncludes(this.version.getVersionId());
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u5347\u7ea7\u540d\u5355\u5931\u8d25", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u5347\u7ea7\u540d\u5355\u5931\u8d25" + (Object)((Object)e));
        }
        ArrayList<MacInfo> macs = new ArrayList<MacInfo>();
        if (members != null) {
            for (Member member : members) {
                MacInfo macInfo = new MacInfo();
                macInfo.update(member);
                Party party = this.partyTree.getParty(macInfo.getPartyId());
                if (party != null) {
                    macInfo.setPartyName(party.getName());
                }
                macs.add(macInfo);
            }
        }
        this.orMacList.clear();
        this.orMacList.addAll(macs);
        this.macInfoList.update(this.orMacList);
        this.tabUpdateList.setDisable(false);
        this.tableMacInfo.sort();
    }

    private void createTable() {
        this.colNeedUpdate.setGraphic((Node)this.checkBox);
        this.colNeedUpdate.setCellValueFactory(data -> ((MacInfo)data.getValue()).needUpdateProperty());
        this.colNeedUpdate.setCellFactory(data -> new MxCheckBoxTableCell());
        this.colNeedUpdate.setSortable(false);
        this.colNeedUpdate.getTableView().setEditable(true);
        this.colPartyId.setCellValueFactory(data -> ((MacInfo)data.getValue()).partyIdProperty());
        this.colPartyName.setCellValueFactory(data -> ((MacInfo)data.getValue()).partyNameProperty());
        this.colMac.setCellValueFactory(data -> ((MacInfo)data.getValue()).macProperty());
        this.colNeedUpdate.setCellValueFactory(data -> ((MacInfo)data.getValue()).needUpdateProperty());
        this.tableMacInfo.setItems(this.macInfoList.getList());
        this.colPartyId.setSortType(TableColumn.SortType.ASCENDING);
        this.tableMacInfo.getSortOrder().add(this.colPartyId);
    }

    private void initTree() {
        try {
            TreeItem<Party> root = this.partyTree.getRoot();
            this.treeParty.setRoot(root);
        }
        catch (MException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void save() {
        AddVersionReq req = new AddVersionReq();
        final VersionInfo versionInfo = new VersionInfo();
        versionInfo.setCurVersion(this.txtVersion.getText());
        versionInfo.setReleaseDate(((LocalDate)this.releaseDate.getValue()).format(this.dateFormatter));
        versionInfo.setReleaseTime(((LocalTime)this.releaseTime.getValue()).format(this.timeFormatter));
        versionInfo.setDescription(this.textArea.getText());
        req.setVersionInfo(versionInfo);
        req.setUser(this.httpBaseApi.getHttpOpUser());
        if (this.textArea.getText().length() > 100) {
            this.alert.alert(Alert.AlertType.ERROR, "\u63cf\u8ff0\u8d85\u8fc7100\u5b57\u3002");
            return;
        }
        if (this.isAdd) {
            try {
                VersionInfo addVersionInfos = this.updateApi.addVersionInfos(req);
                versionInfo.setVersionId(addVersionInfos.getVersionId());
            }
            catch (MException e) {
                logger.error("\u65b0\u589e\u7248\u672c\u51fa\u9519" + (Object)((Object)e));
                this.alert.alert(Alert.AlertType.ERROR, "\u65b0\u589e\u7248\u672c\u51fa\u9519" + (Object)((Object)e));
                return;
            }
            this.alert.alert(Alert.AlertType.INFORMATION, "\u4fdd\u5b58\u6210\u529f");
        } else {
            try {
                versionInfo.setVersionId(this.version.getVersionId());
                this.updateApi.updateVersionInfos(req);
            }
            catch (MException e) {
                logger.error("\u65b0\u589e\u7248\u672c\u51fa\u9519" + (Object)((Object)e));
                this.alert.alert(Alert.AlertType.ERROR, "\u4fee\u6539\u7248\u672c\u51fa\u9519" + (Object)((Object)e));
                return;
            }
            this.alert.alert(Alert.AlertType.INFORMATION, "\u4fee\u6539\u6210\u529f");
        }
        if (this.isAdd) {
            Timer timer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    Platform.runLater(() -> {
                        AddVersionDialog.this.tabUpdateList.setDisable(false);
                        AddVersionDialog.this.version = new UpdateInfo();
                        AddVersionDialog.this.version.update(versionInfo);
                        AddVersionDialog.this.version.setVersionId(AddVersionDialog.this.version.getVersionId());
                        AddVersionDialog.this.queryMacInfos();
                    });
                }
            };
            timer.schedule(task, 4000L);
        }
    }

    private void saveUpdateList() {
        UpdateMembersReq req = new UpdateMembersReq();
        ArrayList<Member> members = new ArrayList<Member>();
        for (MacInfo macInfo : this.orMacList) {
            if (!macInfo.isNeedUpdate()) continue;
            Member member = new Member();
            member.setMac(macInfo.getMac());
            member.setPartyId(macInfo.getPartyId());
            member.setPartyName(macInfo.getPartyName());
            members.add(member);
        }
        req.setMember(members);
        req.setUser(this.httpBaseApi.getHttpOpUser());
        try {
            this.updateApi.updateMembersIncludes(req, this.version.getVersionId());
        }
        catch (MException e) {
            logger.error("\u66f4\u65b0\u5347\u7ea7\u540d\u5355\u51fa\u9519, version" + this.version + (Object)((Object)e));
            this.alert.alert(Alert.AlertType.ERROR, "\u66f4\u65b0\u5347\u7ea7\u540d\u5355\u51fa\u9519" + this.version + (Object)((Object)e));
            return;
        }
        this.alert.alert(Alert.AlertType.INFORMATION, "\u66f4\u65b0\u5347\u7ea7\u540d\u5355\u6210\u529f");
    }

    public ButtonType[] getTypes() {
        return new ButtonType[0];
    }

    public boolean isAdd() {
        return this.isAdd;
    }

    public void setAdd(boolean isAdd) {
        this.isAdd = isAdd;
    }

    public UpdateInfo getVersion() {
        return this.version;
    }

    public void setVersion(UpdateInfo version) {
        this.version = version;
    }

    public boolean isView() {
        return this.isView;
    }

    public void setView(boolean isView) {
        this.isView = isView;
    }
}

