/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.User;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.UserMngModel;
import cms.tmx.manage.models.UserMngServiceImpl;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddUserBasic
extends MxTabContent {
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private Label lbTypeErr;
    @FXML
    private TextField txtName;
    @FXML
    private Label lbNameErr;
    @FXML
    private PasswordField pwdPwd;
    @FXML
    private Label lbPwdErr;
    @FXML
    private PasswordField pwdPwdConfirm;
    @FXML
    private Label lbPwdConfirmErr;
    @FXML
    private TextField txtCreditName;
    @FXML
    private Label lbCreditNameErr;
    @FXML
    private TextField txtPhone;
    @FXML
    private Label lbPhoneErr;
    @FXML
    private TextField txtID;
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbCodeErr;
    @FXML
    private Label lbAlert;
    @FXML
    private TextField txtAddr;
    @FXML
    private TextField txtEmail;
    @FXML
    private Label lbEmailErr;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private UserMngModel userModel;
    @Inject
    private MObjFactory of;
    private User user;
    private String newUserId = "";
    private static final Logger logger = LogManager.getLogger(AddUserBasic.class);
    BooleanProperty result = new SimpleBooleanProperty(true);

    @FXML
    public void initialize() {
        this.user = (User)this.of.create(User.class);
        this.labSuccess.setVisible(false);
        this.userModel.setCommonUser(this.user);
        this.initValues();
        this.bind();
        this.addCheck();
    }

    private void bind() {
        this.txtName.textProperty().bindBidirectional((Property)this.user.nameProperty());
        this.pwdPwdConfirm.textProperty().bindBidirectional((Property)this.user.pwdProperty());
        this.txtCreditName.textProperty().bindBidirectional((Property)this.user.useCreditNameProperty());
        this.txtPhone.textProperty().bindBidirectional((Property)this.user.phoneProperty());
        this.user.userCreditTypeProperty().bind((ObservableValue)this.cmbType.valueProperty());
        this.txtCode.textProperty().bindBidirectional((Property)this.user.codeProperty());
        this.txtAddr.textProperty().bindBidirectional((Property)this.user.addressProperty());
        this.txtEmail.textProperty().bindBidirectional((Property)this.user.emailProperty());
    }

    private void addCheck() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.pwdPwd.setTextFormatter((TextFormatter)new MxFormatter("^[\\w`~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?]*$", 20));
        this.pwdPwdConfirm.setTextFormatter((TextFormatter)new MxFormatter("^[\\w`~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?]*$", 20));
        this.txtCreditName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtPhone.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 20));
        this.txtCode.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 50));
        this.txtEmail.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\\-.@]{0,50}", 1000));
        this.txtAddr.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 100));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbCreditNameErr, (ObservableBooleanValue)this.txtCreditName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbPwdErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.pwdPwd.focusedProperty().get() && !TextFieldUtils.isPwd((TextField)this.pwdPwd).get()) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.pwdPwd.focusedProperty(), TextFieldUtils.isPwd((TextField)this.pwdPwd)}));
        this.registerCheck((Node)this.lbPwdConfirmErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.pwdPwdConfirm.focusedProperty().get() && !this.pwdPwdConfirm.getText().equals(this.pwdPwd.getText())) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.pwdPwdConfirm.focusedProperty(), this.pwdPwd.focusedProperty()}));
        this.registerCheck((Node)this.lbPhoneErr, (ObservableBooleanValue)this.txtPhone.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbTypeErr, (ObservableBooleanValue)this.cmbType.getSelectionModel().selectedItemProperty().isNotNull());
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)this.txtCode.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbEmailErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!(this.txtEmail.getText().isEmpty() || this.txtEmail.focusedProperty().get() || TextFieldUtils.isEmail((String)this.txtEmail.getText()))) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtEmail.focusedProperty()}));
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
        this.txtAddr.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.TAB == event.getCode()) {
                this.txtName.requestFocus();
                event.consume();
            }
        });
    }

    private void initValues() {
        MxNode node = MxNodeFactory.create((String)"user_credit_type", (String)"1");
        this.cmbType.setItems(node.getNodes());
        this.pwdPwd.setTooltip(new Tooltip("\u8981\u6c42\u81f3\u5c118\u4f4d\uff0c\u5927\u5199\u5b57\u6bcd\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u7279\u6b8a\u5b57\u7b26\u81f3\u5c113\u79cd\u7ec4\u5408\u642d\u914d"));
        Platform.runLater(() -> this.txtName.requestFocus());
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        if (this.user.getId().isEmpty()) {
            block8: {
                try {
                    if (this.check()) break block8;
                    return false;
                }
                catch (MException e2) {
                    logger.error((Object)e2, (Throwable)e2);
                    Platform.runLater(() -> {
                        this.lbAlert.setText(e2.getMessage());
                        this.lbAlert.requestFocus();
                    });
                    return false;
                }
            }
            String s = this.userMng.addUser(this.user);
            this.userMng.assignUserToParty(this.partyMng.getUserParty().getId(), s);
            this.newUserId = s;
            this.user.setId(this.newUserId);
            this.pwdPwd.setDisable(true);
            this.pwdPwdConfirm.setDisable(true);
        } else {
            try {
                this.userMng.updateUser(this.user);
            }
            catch (MException e3) {
                logger.error((Object)e3, (Throwable)e3);
                Platform.runLater(() -> {
                    this.lbAlert.setText(e3.getMessage());
                    this.lbAlert.requestFocus();
                });
                return false;
            }
        }
        this.result.setValue(Boolean.valueOf(false));
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    private boolean check() {
        if (!this.pwdPwd.getText().equals(this.pwdPwdConfirm.getText())) {
            this.lbPwdConfirmErr.setOpacity(1.0);
            return false;
        }
        return true;
    }

    public String getNewUserId() {
        return this.newUserId;
    }

    public void setNewUserId(String newUserId) {
        this.newUserId = newUserId;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public TextField getTxtAddr() {
        return this.txtAddr;
    }

    public void setTxtAddr(TextField txtAddr) {
        this.txtAddr = txtAddr;
    }

    public TextField getTxtEmail() {
        return this.txtEmail;
    }

    public void setTxtEmail(TextField txtEmail) {
        this.txtEmail = txtEmail;
    }

    public PasswordField getPwdPwd() {
        return this.pwdPwd;
    }

    public void setPwdPwd(PasswordField pwdPwd) {
        this.pwdPwd = pwdPwd;
    }

    public PasswordField getPwdPwdConfirm() {
        return this.pwdPwdConfirm;
    }

    public void setPwdPwdConfirm(PasswordField pwdPwdConfirm) {
        this.pwdPwdConfirm = pwdPwdConfirm;
    }

    public TextField getTxtID() {
        return this.txtID;
    }

    public void setTxtID(TextField txtID) {
        this.txtID = txtID;
    }
}

