/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Party;
import cms.tmx.entity.Role;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.RoleMngModel;
import cms.tmx.manage.models.RoleMngServiceImpl;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddRoleBasic
extends MxTabContent {
    @FXML
    private ComboBox<Party> cmbParty;
    @FXML
    private TextField txtName;
    @FXML
    private TextArea txtMark;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbAlert;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private RoleMngServiceImpl roleMng;
    @Inject
    private RoleMngModel roleModel;
    @Inject
    private MObjFactory of;
    @Inject
    private MxAlert mAlert;
    private Party party;
    private Role role;
    private String newRoleId = "";
    private ObservableList<Party> listParty = FxUtils.newList();
    private static final Logger logger = LogManager.getLogger(AddRoleBasic.class);
    BooleanProperty result = new SimpleBooleanProperty(true);

    @FXML
    public void initialize() {
        this.role = (Role)this.of.create(Role.class);
        this.labSuccess.setVisible(false);
        this.party = this.roleModel.getParentParty();
        this.roleModel.setCommonRole(this.role);
        this.bind();
        this.initValues();
        this.addCheck();
    }

    private void bind() {
        this.txtName.textProperty().bindBidirectional((Property)this.role.nameProperty());
        this.txtMark.textProperty().bindBidirectional((Property)this.role.desProperty());
        this.cmbParty.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.role.setPartyId(now.getId());
            }
        });
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
        this.txtMark.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.TAB == event.getCode()) {
                this.txtName.requestFocus();
                event.consume();
            }
        });
    }

    private void addCheck() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtMark.setTextFormatter((TextFormatter)new MxFormatter(100));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
    }

    private void initValues() {
        try {
            this.listParty.addAll(this.partyMng.getPartyList(this.partyMng.getUserParty().getId(), PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING));
            this.listParty.addAll((Object[])new Party[]{this.partyMng.getParty(this.partyMng.getUserParty().getId())});
            this.cmbParty.setItems(this.listParty);
            this.cmbParty.getSelectionModel().select((Object)this.party);
            Platform.runLater(() -> this.txtName.requestFocus());
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        if (this.role.getId().isEmpty()) {
            try {
                this.role.getRoleType().setRaw("0");
                this.newRoleId = this.roleMng.addRole(this.role);
                this.role.setId(this.newRoleId);
            }
            catch (MException e2) {
                logger.error((Object)e2, (Throwable)e2);
                Platform.runLater(() -> {
                    this.lbAlert.setText(e2.getMessage());
                    this.lbAlert.requestFocus();
                });
                return false;
            }
            this.cmbParty.setDisable(true);
        } else {
            try {
                this.role.getRoleType().setRaw("0");
                this.roleMng.updateRole(this.role);
            }
            catch (MException e3) {
                logger.error((Object)e3, (Throwable)e3);
                Platform.runLater(() -> {
                    this.lbAlert.setText(e3.getMessage());
                    this.lbAlert.requestFocus();
                });
                return false;
            }
        }
        Platform.runLater(() -> {
            this.labSuccess.setVisible(true);
            this.lbAlert.requestFocus();
        });
        this.result.setValue(Boolean.valueOf(false));
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public ComboBox<Party> getCmbParty() {
        return this.cmbParty;
    }

    public void setCmbParty(ComboBox<Party> cmbParty) {
        this.cmbParty = cmbParty;
    }

    public TextArea getTxtMark() {
        return this.txtMark;
    }

    public void setTxtMark(TextArea txtMark) {
        this.txtMark = txtMark;
    }

    public String getNewRoleId() {
        return this.newRoleId;
    }

    public void setNewRoleId(String newRoleId) {
        this.newRoleId = newRoleId;
    }
}

