/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Party;
import cms.tmx.entity.Role;
import cms.tmx.manage.models.RoleMngModel;
import cms.tmx.manage.models.RoleMngServiceImpl;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddPublicRoleBasic
extends MxTabContent {
    @FXML
    private TextField txtName;
    @FXML
    private TextArea txtMark;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbAlert;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @Inject
    private RoleMngServiceImpl roleMng;
    @Inject
    private RoleMngModel roleModel;
    @Inject
    private MObjFactory of;
    private Party party;
    private Role role;
    private String newRoleId = "";
    private static final Logger logger = LogManager.getLogger(AddPublicRoleBasic.class);
    BooleanProperty result = new SimpleBooleanProperty(true);

    @FXML
    public void initialize() {
        this.role = (Role)this.of.create(Role.class);
        this.labSuccess.setVisible(false);
        this.party = this.roleModel.getParentParty();
        this.roleModel.setCommonRole(this.role);
        this.initValues();
        this.bind();
        this.addCheck();
    }

    private void bind() {
        this.txtName.textProperty().bindBidirectional((Property)this.role.nameProperty());
        this.txtMark.textProperty().bindBidirectional((Property)this.role.desProperty());
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
        this.txtMark.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.TAB == event.getCode()) {
                this.txtName.requestFocus();
                event.consume();
            }
        });
    }

    private void addCheck() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtMark.setTextFormatter((TextFormatter)new MxFormatter(100));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
    }

    private void initValues() {
        Platform.runLater(() -> this.txtName.requestFocus());
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        if (this.role.getId().isEmpty()) {
            try {
                this.role.setPartyId(this.getParty().getId());
                this.role.getRoleType().setRaw("1");
                this.newRoleId = this.roleMng.addRole(this.role);
                this.role.setId(this.newRoleId);
            }
            catch (MException e2) {
                logger.error((Object)e2, (Throwable)e2);
                Platform.runLater(() -> {
                    this.lbAlert.setText(e2.getMessage());
                    this.lbAlert.requestFocus();
                });
                return false;
            }
        }
        try {
            this.role.getRoleType().setRaw("1");
            this.roleMng.updateRole(this.role);
        }
        catch (MException e3) {
            logger.error((Object)e3, (Throwable)e3);
            Platform.runLater(() -> {
                this.lbAlert.setText(e3.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        Platform.runLater(() -> {
            this.labSuccess.setVisible(true);
            this.lbAlert.requestFocus();
        });
        this.result.setValue(Boolean.valueOf(false));
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public TextArea getTxtMark() {
        return this.txtMark;
    }

    public void setTxtMark(TextArea txtMark) {
        this.txtMark = txtMark;
    }

    public String getNewRoleId() {
        return this.newRoleId;
    }

    public void setNewRoleId(String newRoleId) {
        this.newRoleId = newRoleId;
    }
}

