/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Benchmark;
import cms.tmx.entity.Product;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.BenchSuggest;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.manage.models.ProductMngModel;
import cms.tmx.manage.models.ProductMngServiceImpl;
import cms.tmx.manage.parts.UpdatePortfolioBasic;
import cms.tmx.rights.IUiRightService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddProductBench
extends MxTabContent {
    @FXML
    private Label lbAlert;
    @FXML
    private Label lbBenName;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @FXML
    private ComboBox<MxNode> cmdBench;
    @FXML
    private TextField txtSingleSec;
    @FXML
    private ComboBox<Benchmark> cmbCalModel;
    @FXML
    private TableView<Benchmark> tableBench;
    @FXML
    private TableColumn<Benchmark, String> colCode;
    @FXML
    private TableColumn<Benchmark, String> colMarket;
    @FXML
    private TableColumn<Benchmark, String> colName;
    @FXML
    private TableColumn<Benchmark, HBox> colOpera;
    @FXML
    private Button btnAdd;
    @Inject
    private ExecutorService exe;
    @Inject
    private IUiRightService model;
    @Inject
    private MxAlert alert;
    @Inject
    private ProductMngModel productMngModel;
    @Inject
    private ProductMngServiceImpl productMng;
    @Inject
    private PortfolioMngServiceImpl portfolioMng;
    @Inject
    private MObjFactory of;
    private Product productUpdate;
    private BenchSuggest spCode = new BenchSuggest();
    private boolean deleteFlag = true;
    private static final Logger logger = LogManager.getLogger(UpdatePortfolioBasic.class);
    private List<Benchmark> singleList = new ArrayList<Benchmark>();
    private List<Benchmark> singleList2 = new ArrayList<Benchmark>();
    private ObservableList<Benchmark> list1 = FxUtils.newList();
    private ObservableList<Benchmark> list2 = FxUtils.newList();
    private ObservableList<Benchmark> list3 = FxUtils.newList();

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.productUpdate = (Product)this.of.create(Product.class);
        this.productUpdate.update((Object)this.productMngModel.getCommonProduct());
        this.model.registerCheck((Control)this.btnAdd, new String[]{"saveProductBench"});
        this.deleteFlag = this.model.registerCheck(new String[]{"saveProductBench"});
        this.initBenchmark();
        this.creatTableView();
        this.bind();
    }

    private void creatTableView() {
        TableUtils.initContextMenu(this.tableBench);
        this.colCode.setCellValueFactory(data -> ((Benchmark)data.getValue()).codeProperty());
        this.colName.setCellValueFactory(data -> ((Benchmark)data.getValue()).nameProperty());
        this.colMarket.setCellValueFactory(data -> ((Benchmark)data.getValue()).exchNameProperty());
        this.colOpera.setCellValueFactory(data -> this.setOperate((Benchmark)data.getValue()));
        this.tableBench.setPlaceholder((Node)new Label());
    }

    private ReadOnlyObjectWrapper<HBox> setOperate(Benchmark ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setTextFill((Paint)Color.ORANGERED);
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMouseClicked(event -> this.tableBench.getItems().remove((Object)ap));
        if (ap != null && this.deleteFlag) {
            hBox.getChildren().add(0, (Object)lbIn);
        }
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    private void initBenchmark() {
        this.lbBenName.setText("");
        this.exe.execute(() -> {
            try {
                this.singleList.addAll((Collection<Benchmark>)this.portfolioMng.getBenchmarkList(1));
                this.cmbCalModel.setItems(this.portfolioMng.getBenchmarkList(2));
                this.singleList2.addAll((Collection<Benchmark>)this.cmbCalModel.getItems());
            }
            catch (MException e) {
                this.lbAlert.setText(e.getMessage());
            }
            this.spCode.setAllSuggestions(this.singleList);
            List benchIds = this.productUpdate.getBenchmarkList();
            int benchType = this.productUpdate.getBenchmarkType();
            if (benchIds.size() <= 0) {
                return;
            }
            if (benchType == 1) {
                this.singleList.forEach(item -> {
                    for (String id : benchIds) {
                        if (!id.equals(item.getId())) continue;
                        this.deleteFlag = false;
                        this.list1.add(item);
                    }
                });
                if (this.list1.size() > 0) {
                    Platform.runLater(() -> {
                        this.btnAdd.setVisible(false);
                        this.deleteFlag = false;
                        this.cmdBench.getSelectionModel().selectFirst();
                    });
                    return;
                }
            } else if (benchType == 2) {
                this.cmbCalModel.getItems().forEach(item -> {
                    for (String id : benchIds) {
                        if (!id.equals(item.getId())) continue;
                        this.list2.add(item);
                    }
                });
                if (this.list2.size() > 0) {
                    Platform.runLater(() -> this.cmdBench.getSelectionModel().select(1));
                    return;
                }
            } else if (benchType == 3) {
                this.singleList.forEach(item -> {
                    for (String id : benchIds) {
                        if (!id.equals(item.getId())) continue;
                        this.list3.add(item);
                    }
                });
                if (this.list3.size() > 0) {
                    Platform.runLater(() -> this.cmdBench.getSelectionModel().selectLast());
                    return;
                }
            }
        });
    }

    private void bind() {
        Search.bindAutoCompletion((TextField)this.txtSingleSec, (Callback)this.spCode, (StringConverter)new StringConverter<Benchmark>(){

            public Benchmark fromString(String string) {
                return null;
            }

            public String toString(Benchmark info) {
                return String.valueOf(info.getCode()) + "  " + info.getName() + "\t" + info.getExchName();
            }
        }).changedProperty().addListener((ob, oldV, newV) -> this.onChange());
        this.txtSingleSec.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]+", 6)));
        this.txtSingleSec.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> this.txtSingleSec.selectAll());
        MxNode node = MxNodeFactory.create((String)"benchmark", (String)"1");
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
        this.cmdBench.setItems(node.getNodes());
        this.cmdBench.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                if ("1".equals(now.getRaw())) {
                    this.txtSingleSec.setVisible(true);
                    this.lbBenName.setVisible(true);
                    this.cmbCalModel.setVisible(false);
                    this.tableBench.setItems(this.list1);
                } else if ("2".equals(now.getRaw())) {
                    this.txtSingleSec.setVisible(false);
                    this.lbBenName.setVisible(false);
                    this.cmbCalModel.setVisible(true);
                    this.tableBench.setItems(this.list2);
                } else if ("3".equals(now.getRaw())) {
                    this.txtSingleSec.setVisible(true);
                    this.lbBenName.setVisible(true);
                    this.cmbCalModel.setVisible(false);
                    this.tableBench.setItems(this.list3);
                }
            }
        });
        this.cmdBench.getSelectionModel().selectFirst();
    }

    private void onChange() {
        Benchmark bench = (Benchmark)this.txtSingleSec.getUserData();
        if (bench != null) {
            this.txtSingleSec.textProperty().set((Object)bench.getCode());
            this.lbBenName.setText(bench.getName());
        } else {
            this.lbBenName.setText("");
        }
    }

    @FXML
    public void add() {
        String raw = ((MxNode)this.cmdBench.getSelectionModel().getSelectedItem()).getRaw();
        if (this.txtSingleSec.isVisible()) {
            Benchmark bench;
            if (this.txtSingleSec.getUserData() == null && !this.txtSingleSec.getText().isEmpty()) {
                this.lbAlert.setText("\u65e0\u6548\u57fa\u51c6");
                this.lbAlert.requestFocus();
            }
            if ((bench = (Benchmark)this.txtSingleSec.getUserData()) != null) {
                if ("1".equals(raw)) {
                    if (this.list1.size() <= 0) {
                        this.list1.add((Object)bench);
                    } else {
                        this.lbAlert.setText("\u53ea\u5141\u8bb8\u4e00\u4e2a\u57fa\u51c6");
                        this.lbAlert.requestFocus();
                    }
                } else if ("3".equals(raw)) {
                    if (!this.list3.contains((Object)bench)) {
                        if (this.list3.size() < 5) {
                            this.list3.add((Object)bench);
                        } else {
                            this.lbAlert.setText("\u6700\u591a\u4e94\u4e2a\u57fa\u51c6");
                            this.lbAlert.requestFocus();
                        }
                    } else {
                        this.lbAlert.setText("\u5df2\u5b58\u5728");
                        this.lbAlert.requestFocus();
                    }
                }
            }
        } else {
            Benchmark bench = (Benchmark)this.cmbCalModel.getSelectionModel().getSelectedItem();
            if (bench != null && "2".equals(raw)) {
                if (this.list2.size() <= 0) {
                    this.list2.add((Object)bench);
                } else {
                    this.lbAlert.setText("\u53ea\u5141\u8bb8\u4e00\u4e2a\u57fa\u51c6");
                    this.lbAlert.requestFocus();
                }
            }
        }
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        LinkedList<String> ids = new LinkedList<String>();
        if (this.tableBench.getItems().size() > 0) {
            if (!this.alert.alert(Alert.AlertType.CONFIRMATION, "\u57fa\u51c6\u6682\u4e0d\u652f\u6301\u4fee\u6539,\u662f\u5426\u7ee7\u7eed\u4fdd\u5b58")) {
                return false;
            }
            this.btnAdd.setVisible(false);
            this.deleteFlag = false;
            this.tableBench.refresh();
        }
        for (Benchmark b : this.tableBench.getItems()) {
            ids.add(b.getId());
        }
        this.productUpdate.update(this.productMngModel.getCommonProduct(), false);
        this.productUpdate.setBenchmarkList(ids);
        int benchType = Integer.valueOf(((MxNode)this.cmdBench.getSelectionModel().getSelectedItem()).getRaw());
        this.productUpdate.setBenchmarkType(benchType);
        try {
            this.productMng.updateProduct(this.productUpdate);
            this.productMngModel.getCommonProduct().update((Object)this.productUpdate);
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbAlert.setText(e2.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Product getProductUpdate() {
        return this.productUpdate;
    }

    public void setProductUpdate(Product productUpdate) {
        this.productUpdate = productUpdate;
    }
}

