/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Party;
import cms.tmx.entity.Product;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.ProductMngModel;
import cms.tmx.manage.models.ProductMngServiceImpl;
import java.time.LocalDate;
import java.util.Calendar;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class AddProductBasic
extends MxTabContent {
    @FXML
    private TextField txtProdName;
    @FXML
    private TextArea txtProdAttach;
    @FXML
    private Label lbProdNameErr;
    @FXML
    private Label lbTypeErr;
    @FXML
    private Label lbInstErr;
    @FXML
    private Label lbAlert;
    @FXML
    private DatePicker start_date;
    @FXML
    private DatePicker end_date;
    @FXML
    private TextField txtProdShare;
    @FXML
    private TextField txtProdMnger;
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private ComboBox<Party> cmbOrgId;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @Inject
    private ProductMngModel productMngModel;
    private Product product;
    @Inject
    private ProductMngServiceImpl productMng;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private MxAlert mAlert;
    @Inject
    private MObjFactory of;
    private static final Logger logger = LogManager.getLogger(AddProductBasic.class);
    private ObservableList<Party> listParty = FxUtils.newList();
    private Party party;
    private String productId = "";
    BooleanProperty result = new SimpleBooleanProperty(true);

    @FXML
    public void initialize() {
        this.party = this.productMngModel.getParentParty();
        this.product = (Product)this.of.create(Product.class);
        this.labSuccess.setVisible(false);
        this.productMngModel.setCommonProduct((Product)this.of.create(Product.class));
        this.bind();
        this.initialValues();
        this.addCheck();
    }

    private void addCheck() {
        this.txtProdName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtProdMnger.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtProdShare.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 15));
        this.txtProdAttach.setTextFormatter((TextFormatter)new MxFormatter(1000));
        this.registerCheck((Node)this.lbProdNameErr, (ObservableBooleanValue)TextFieldUtils.isNotEmpty((TextField)this.txtProdName));
        this.registerCheck((Node)this.lbInstErr, (ObservableBooleanValue)this.cmbOrgId.valueProperty().isNotNull());
        this.registerCheck((Node)this.lbTypeErr, (ObservableBooleanValue)this.cmbType.valueProperty().isNotNull());
    }

    private void initialValues() {
        try {
            this.listParty.addAll(this.partyMng.getPartyList(this.partyMng.getUserParty().getId(), PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING));
            this.listParty.addAll((Object[])new Party[]{this.partyMng.getParty(this.partyMng.getUserParty().getId())});
            this.cmbOrgId.setItems(this.listParty);
            this.cmbOrgId.getSelectionModel().select((Object)this.party);
            MxNode node = MxNodeFactory.create((String)"productType", (String)"1");
            this.cmbType.setItems(node.getNodes());
            this.cmbType.getSelectionModel().select(0);
            DatePickerUtils.setDateLimit((DatePicker)this.start_date, (DatePicker)this.end_date, (boolean)false);
            DatePickerUtils.setFormat((DatePicker)this.start_date, (String)"yyyy-MM-dd");
            DatePickerUtils.setFormat((DatePicker)this.end_date, (String)"yyyy-MM-dd");
            this.setDefTime(this.start_date);
            this.start_date.setEditable(false);
            this.end_date.setEditable(false);
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void setDefTime(DatePicker picker) {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        picker.setValue((Object)LocalDate.of(year, month, day));
    }

    private void bind() {
        this.cmbType.valueProperty().bindBidirectional((Property)this.product.typeProperty());
        this.txtProdName.textProperty().bindBidirectional((Property)this.product.nameProperty());
        this.txtProdMnger.textProperty().bindBidirectional((Property)this.product.managerProperty());
        this.txtProdAttach.textProperty().bindBidirectional((Property)this.product.desProperty());
        this.txtProdShare.textProperty().bindBidirectional((Property)this.product.sharesProperty());
        this.start_date.getEditor().textProperty().bindBidirectional((Property)this.product.beginDateProperty());
        this.end_date.getEditor().textProperty().bindBidirectional((Property)this.product.endDateProperty());
        this.cmbOrgId.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.product.setPartyId(now.getId());
            }
        });
        this.start_date.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.BACK_SPACE == event.getCode() || KeyCode.DELETE == event.getCode()) {
                this.start_date.getEditor().setText("");
                event.consume();
            }
        });
        this.end_date.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.BACK_SPACE == event.getCode() || KeyCode.DELETE == event.getCode()) {
                this.end_date.getEditor().setText("");
                event.consume();
            }
        });
        this.lbAlert.focusedProperty().addListener((Observable2, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        if (this.product.getId().isEmpty()) {
            try {
                this.productId = this.productMng.addProduct(this.product);
                this.product.setId(this.productId);
                this.productMngModel.getCommonProduct().update((Object)this.product);
                this.cmbType.setDisable(true);
                this.cmbOrgId.setDisable(true);
            }
            catch (MException e2) {
                logger.error((Object)e2, (Throwable)e2);
                Platform.runLater(() -> {
                    this.lbAlert.setText(e2.getMessage());
                    this.lbAlert.requestFocus();
                });
                return false;
            }
        }
        try {
            this.product.update(this.productMngModel.getCommonProduct(), true);
            this.productMng.updateProduct(this.product);
            this.productMngModel.getCommonProduct().update((Object)this.product);
        }
        catch (MException e3) {
            logger.error((Object)e3, (Throwable)e3);
            Platform.runLater(() -> {
                this.lbAlert.setText(e3.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        this.result.setValue(Boolean.valueOf(false));
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public TextArea getTxtProdAttach() {
        return this.txtProdAttach;
    }

    public void setTxtProdAttach(TextArea txtProdAttach) {
        this.txtProdAttach = txtProdAttach;
    }

    public ComboBox<MxNode> getCmbType() {
        return this.cmbType;
    }

    public void setCmbType(ComboBox<MxNode> cmbType) {
        this.cmbType = cmbType;
    }

    public String getProductId() {
        return this.productId;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public TextField getTxtProdName() {
        return this.txtProdName;
    }

    public void setTxtProdName(TextField txtProdName) {
        this.txtProdName = txtProdName;
    }
}

