/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Party;
import cms.tmx.entity.Post;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.PostMngModel;
import cms.tmx.manage.models.PostMngServiceImpl;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddPostBasic
extends MxTabContent {
    @FXML
    private ComboBox<Party> cmbParty;
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private TextField txtId;
    @FXML
    private TextField txtName;
    @FXML
    private TextArea txtMark;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbTypeErr;
    @FXML
    private Label lbPartyErr;
    @FXML
    private Label lbAlert;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @Inject
    private PostMngModel postModel;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private PostMngServiceImpl postMng;
    @Inject
    private MObjFactory of;
    private Party party;
    private Post postAdd;
    private String newPostId = "";
    private ObservableList<Party> listParty = FxUtils.newList();
    private static final Logger logger = LogManager.getLogger(AddPostBasic.class);
    BooleanProperty result = new SimpleBooleanProperty(true);

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.party = this.postModel.getParentParty();
        this.postAdd = (Post)this.of.create(Post.class);
        this.postModel.setCommonPost(this.postAdd);
        this.bind();
        this.initValues();
        this.addCheck();
    }

    private void bind() {
        this.txtName.textProperty().bindBidirectional((Property)this.postAdd.nameProperty());
        this.txtMark.textProperty().bindBidirectional((Property)this.postAdd.descProperty());
        this.cmbParty.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.postAdd.setPartyId(now.getId());
            }
        });
        this.postAdd.typeProperty().bind((ObservableValue)this.cmbType.valueProperty());
    }

    private void addCheck() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtMark.setTextFormatter((TextFormatter)new MxFormatter(100));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbPartyErr, (ObservableBooleanValue)this.cmbParty.getSelectionModel().selectedItemProperty().isNotNull());
        this.registerCheck((Node)this.lbTypeErr, (ObservableBooleanValue)this.cmbType.getSelectionModel().selectedItemProperty().isNotNull());
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
        this.txtMark.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (KeyCode.TAB == event.getCode()) {
                this.txtName.requestFocus();
                event.consume();
            }
        });
    }

    private void initValues() {
        try {
            this.listParty.addAll(this.partyMng.getPartyList(this.partyMng.getUserParty().getId(), PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING));
            this.listParty.addAll((Object[])new Party[]{this.partyMng.getParty(this.partyMng.getUserParty().getId())});
            this.cmbParty.setItems(this.listParty);
            this.cmbParty.getSelectionModel().select((Object)this.party);
            MxNode node = MxNodeFactory.create((String)"post_type", (String)"2");
            this.cmbType.setItems(node.getNodes());
            Platform.runLater(() -> this.txtName.requestFocus());
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        if (this.postAdd.getId().isEmpty()) {
            try {
                this.newPostId = this.postMng.addPost(this.postAdd);
                this.postAdd.setId(this.newPostId);
            }
            catch (MException e2) {
                logger.error((Object)e2, (Throwable)e2);
                Platform.runLater(() -> {
                    this.lbAlert.setText(e2.getMessage());
                    this.lbAlert.requestFocus();
                });
                return false;
            }
            this.cmbParty.setDisable(true);
        } else {
            try {
                this.postMng.updatePost(this.postAdd);
            }
            catch (MException e3) {
                logger.error((Object)e3, (Throwable)e3);
                Platform.runLater(() -> {
                    this.lbAlert.setText(e3.getMessage());
                    this.lbAlert.requestFocus();
                });
                return false;
            }
        }
        Platform.runLater(() -> {
            this.labSuccess.setVisible(true);
            this.lbAlert.requestFocus();
        });
        this.result.setValue(Boolean.valueOf(false));
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public TextArea getTxtMark() {
        return this.txtMark;
    }

    public void setTxtMark(TextArea txtMark) {
        this.txtMark = txtMark;
    }

    public String getNewPostId() {
        return this.newPostId;
    }

    public void setNewPostId(String newPostId) {
        this.newPostId = newPostId;
    }
}

