/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.api.mng.IFundAccountApi;
import cms.tmx.api.mng.ISecAccountApi;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.ExternalAsset;
import cms.tmx.entity.Party;
import cms.tmx.entity.Portfolio;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxNodePwf;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.ClearingModel;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.PortfolioMngModel;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddPortfolioBasic
extends MxTabContent {
    @FXML
    private ComboBox<Party> cmbParty;
    @FXML
    private ComboBox<MxNodePwf> cmbCarryType;
    @FXML
    private TextField txtName;
    @FXML
    private TextArea txtMark;
    @FXML
    private TextField txtYears;
    @FXML
    private DatePicker txtCarryDay;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbPartyErr;
    @FXML
    private Label lbAlert;
    @FXML
    private Label labSuccess;
    @FXML
    private Label lbYears;
    @FXML
    private Label lbCarryDay;
    @FXML
    private CheckBox ckIsSecu;
    @FXML
    private CheckBox ckExportFW;
    @FXML
    private CheckBox cbExternalAsset;
    @FXML
    private Label lbNonTradableAsset;
    @FXML
    private ComboBox<MxNode> cmbNonTradableAsset;
    @FXML
    private Label lbDataSource;
    @FXML
    private ComboBox<MxNode> cmbDataSource;
    @FXML
    private Label lbAutoSyncConf;
    @FXML
    private ComboBox<String> cmbAutoSyncConf;
    @FXML
    private Label lbExternalPort;
    @FXML
    private ComboBox<ExternalAsset> cmbExternalPort;
    @FXML
    private Label lbExternalPortErr;
    @FXML
    private Label lbExternalId;
    @FXML
    private TextField txtExternalId;
    @FXML
    private Label lbExternalName;
    @FXML
    private TextField txtExternalName;
    @FXML
    public Button btnSaveBasic;
    @Inject
    private PortfolioMngModel portfolioMngModel;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private PortfolioMngServiceImpl portfolioMng;
    @Inject
    private IFundAccountApi fundAccountApi;
    @Inject
    private ISecAccountApi secAccountApi;
    @Inject
    private ClearingModel clearingModel;
    @Inject
    private MObjFactory of;
    @Inject
    private MxAlert mAlert;
    @FXML
    private CheckBox ckIsFun;
    private Party party;
    private Portfolio portfolio;
    private String newPortfolioId = "";
    private ObservableList<Party> listParty = FxUtils.newList();
    private static final Logger logger = LogManager.getLogger(AddPortfolioBasic.class);
    private String carryDate = "";
    private String lastTradingDay = "";
    public static SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
    private static final String FORMAT = "yyyy-MM-dd";
    private LocalDate defultDate;
    BooleanProperty result = new SimpleBooleanProperty(true);

    @FXML
    public void initialize() {
        this.portfolio = (Portfolio)this.of.create(Portfolio.class);
        this.labSuccess.setVisible(false);
        this.party = this.portfolioMngModel.getParentParty();
        this.portfolioMngModel.setCommonPortfolio((Portfolio)this.of.create(Portfolio.class));
        this.carryDate = AddPortfolioBasic.getCurrYearLast();
        this.bind();
        this.initValues();
        this.addCheck();
    }

    public static String getCurrYearLast() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        return AddPortfolioBasic.getYearLast(currentYear);
    }

    public static String getYearLast(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        Date currYearLast = calendar.getTime();
        String sDate = f.format(currYearLast);
        return sDate;
    }

    private void bind() {
        this.txtName.textProperty().bindBidirectional((Property)this.portfolio.nameProperty());
        this.txtMark.textProperty().bindBidirectional((Property)this.portfolio.desProperty());
        this.txtYears.textProperty().bindBidirectional((Property)this.portfolio.carryYearsProperty());
        this.txtYears.setTextFormatter((TextFormatter)new MxFormatter("[1-9]", 1));
        this.cmbParty.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.portfolio.setPartyId(now.getId());
            }
        });
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
        this.cmbCarryType.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.portfolio.setCarryCode(Integer.parseInt(now.getRaw()));
                if (!"3".equals(now.getRaw())) {
                    this.txtYears.clear();
                    this.txtYears.setEditable(false);
                    this.lbYears.setOpacity(0.0);
                    this.txtYears.setOpacity(0.0);
                } else {
                    this.txtYears.setEditable(true);
                    this.lbYears.setOpacity(1.0);
                    this.txtYears.setOpacity(1.0);
                    this.txtYears.textProperty().setValue("1");
                }
                if (!"1".equals(now.getRaw())) {
                    this.txtCarryDay.setValue((Object)this.defultDate);
                    this.lbCarryDay.setOpacity(1.0);
                    this.txtCarryDay.setOpacity(1.0);
                } else {
                    this.txtCarryDay.setValue(null);
                    this.lbCarryDay.setOpacity(0.0);
                    this.txtCarryDay.setOpacity(0.0);
                }
            }
        });
        this.ckIsFun.setSelected(true);
        this.ckIsSecu.setSelected(true);
        this.ckExportFW.setSelected(true);
        MxNode node = MxNodeFactory.create((String)"non_tradable_assets", (String)"0");
        this.cmbNonTradableAsset.setItems(node.getNodes());
        this.cmbNonTradableAsset.setValue((Object)node);
        node = MxNodeFactory.create((String)"accnt_data_source", (String)"1");
        this.cmbDataSource.setItems(node.getNodes());
        this.cmbDataSource.setValue((Object)node);
        this.cmbAutoSyncConf.setValue((Object)"\u6570\u636e\u4e2d\u53f0");
        this.cmbAutoSyncConf.setDisable(true);
        this.cmbNonTradableAsset.valueProperty().bindBidirectional((Property)this.portfolio.nonTradableAssetProperty());
        this.cbExternalAsset.selectedProperty().addListener((ob, old, now) -> this.externalAccntCheck((Boolean)now));
        this.cmbDataSource.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.dataSourceChanged((MxNode)now));
        this.cmbExternalPort.setConverter((StringConverter)new StringConverter<ExternalAsset>(){

            public String toString(ExternalAsset object) {
                if (object != null) {
                    return String.valueOf(object.getId()) + " " + object.getName() + " " + object.getInvestorId();
                }
                return "";
            }

            public ExternalAsset fromString(String string) {
                return null;
            }
        });
        try {
            this.cmbExternalPort.setItems(this.portfolioMng.getExternalAccounts());
        }
        catch (MException mException) {
            Platform.runLater(() -> this.lbAlert.requestFocus());
        }
        Tooltip tooltip = new Tooltip();
        this.cmbExternalPort.setTooltip(tooltip);
        this.cmbExternalPort.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            String txt = String.valueOf(now.getId()) + " " + now.getName() + " " + now.getInvestorId();
            tooltip.setText(txt);
        });
    }

    private void externalAccntCheck(Boolean now) {
        this.lbNonTradableAsset.setVisible(false);
        this.cmbNonTradableAsset.setVisible(false);
        this.lbDataSource.setVisible(false);
        this.cmbDataSource.setVisible(false);
        this.lbAutoSyncConf.setVisible(false);
        this.cmbAutoSyncConf.setVisible(false);
        this.lbExternalPort.setVisible(false);
        this.cmbExternalPort.setVisible(false);
        this.lbExternalId.setVisible(false);
        this.txtExternalId.setVisible(false);
        this.lbExternalName.setVisible(false);
        this.txtExternalName.setVisible(false);
        if (now.booleanValue()) {
            this.lbDataSource.setVisible(now.booleanValue());
            this.cmbDataSource.setVisible(now.booleanValue());
            this.lbExternalId.setVisible(now.booleanValue());
            this.txtExternalId.setVisible(now.booleanValue());
            this.lbExternalName.setVisible(now.booleanValue());
            this.txtExternalName.setVisible(now.booleanValue());
            this.dataSourceChanged((MxNode)this.cmbDataSource.getSelectionModel().getSelectedItem());
        } else {
            this.lbNonTradableAsset.setVisible(now == false);
            this.cmbNonTradableAsset.setVisible(now == false);
        }
    }

    private void dataSourceChanged(MxNode node) {
        this.portfolio.setDataSource(node);
        boolean isAuto = "1".equals(node.getRaw());
        this.lbAutoSyncConf.setVisible(isAuto);
        this.cmbAutoSyncConf.setVisible(isAuto);
        this.lbExternalPort.setVisible(isAuto);
        this.cmbExternalPort.setVisible(isAuto);
    }

    private void addCheck() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-\\(\\).]*", 20));
        this.txtMark.setTextFormatter((TextFormatter)new MxFormatter(100));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbPartyErr, (ObservableBooleanValue)this.cmbParty.getSelectionModel().selectedItemProperty().isNotNull());
        this.registerCheck((Node)this.lbExternalPortErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbExternalPort.isVisible() && this.cmbExternalPort.getSelectionModel().getSelectedItem() == null) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbExternalPort.getSelectionModel().selectedItemProperty(), this.cmbExternalPort.visibleProperty()}));
        this.cmbExternalPort.visibleProperty().addListener(ob -> this.lbExternalPortErr.setOpacity(0.0));
        this.txtExternalId.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9~!@#$%^&*:<>?,.=_]+$", 20));
        this.txtExternalName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-~!@#$%^&*()-+=\\[\\]{}\\:;'\"|,.<>/?\\(\\)]*", 100));
    }

    private void initValues() {
        try {
            this.listParty.addAll(this.partyMng.getPartyList(this.partyMng.getUserParty().getId(), PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING));
            this.listParty.addAll((Object[])new Party[]{this.partyMng.getParty(this.partyMng.getUserParty().getId())});
            this.cmbParty.setItems(this.listParty);
            this.cmbParty.getSelectionModel().select((Object)this.party);
            MxNodePwf nodePwf = MxNodeFactory.createPwf((String)"carry_type", (String)"1");
            ObservableList listCarry = nodePwf.getPwfNodes();
            this.cmbCarryType.setItems(listCarry);
            this.cmbCarryType.getSelectionModel().select(0);
            this.carryDate = AddPortfolioBasic.getCurrYearLast();
            this.lastTradingDay = this.clearingModel.getLastTradingDay();
            this.defultDate = LocalDate.parse(this.carryDate, DateTimeFormatter.ofPattern(FORMAT));
            this.txtCarryDay.setValue((Object)this.defultDate);
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                Date newDate = formatter.parse(this.lastTradingDay);
                DatePickerUtils.setDaysLaterTrading((DatePicker)this.txtCarryDay, (String)f.format(newDate));
            }
            catch (Exception e) {
                logger.error("\u8f6c\u5316\u6e05\u7b97\u65e5\u671f\u683c\u5f0f\u5f02\u5e38\uff1a " + this.lastTradingDay, (Throwable)e);
            }
            DatePickerUtils.setFormat((DatePicker)this.txtCarryDay, (String)FORMAT);
            Platform.runLater(() -> this.txtName.requestFocus());
        }
        catch (MException e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FXML
    public boolean saveBasic() {
        block19: {
            if (!this.valid()) {
                return false;
            }
            try {
                if (this.portfolio.getId().isEmpty()) {
                    this.portfolio.setIsVerifyFund(1);
                    this.portfolio.setIsVerifySecu(1);
                    if (this.ckIsFun.isSelected()) {
                        this.portfolio.setIsVerifyFund(2);
                    }
                    if (this.ckIsSecu.isSelected()) {
                        this.portfolio.setIsVerifySecu(2);
                    }
                    if (this.ckExportFW.isSelected()) {
                        this.portfolio.setExportSettlement(1);
                    }
                    if (this.txtCarryDay.getValue() != null) {
                        this.portfolio.setCarryDay(((LocalDate)this.txtCarryDay.getValue()).toString().replaceAll("-", ""));
                    }
                    if (this.txtYears.isEditable() && this.txtYears.getText().isEmpty()) {
                        Platform.runLater(() -> {
                            this.lbAlert.setText("\u5e74\u8f93\u5165\u6846\u4e0d\u80fd\u4e3a\u7a7a");
                            this.lbAlert.requestFocus();
                        });
                        return false;
                    }
                    if (this.cbExternalAsset.isSelected()) {
                        ExternalAsset acc;
                        this.portfolio.setExternalAsset(true);
                        MxNode node = (MxNode)this.cmbDataSource.getSelectionModel().getSelectedItem();
                        this.portfolio.setDataSource(node);
                        if ("1".equals(node.getRaw()) && (acc = (ExternalAsset)this.cmbExternalPort.getSelectionModel().getSelectedItem()) != null) {
                            this.portfolio.setExternalAccnt(acc.getId());
                        }
                        this.portfolio.setExternalId(this.txtExternalId.getText());
                        this.portfolio.setExternalName(this.txtExternalName.getText());
                    }
                    this.newPortfolioId = this.portfolioMng.addPortfolio(this.portfolio);
                    this.portfolio.setId(this.newPortfolioId);
                    this.portfolioMngModel.getCommonPortfolio().update((Object)this.portfolio);
                    this.portfolioMng.addExternalAssetChanged();
                    break block19;
                }
                boolean f = false;
                boolean s = false;
                if (this.ckIsFun.isSelected()) {
                    if (this.portfolio.getIsVerifyFund() == 1) {
                        this.portfolio.setIsVerifyFund(2);
                        f = true;
                    }
                } else if (this.portfolio.getIsVerifyFund() == 2) {
                    this.portfolio.setIsVerifyFund(1);
                    f = true;
                }
                if (this.ckIsSecu.isSelected()) {
                    if (this.portfolio.getIsVerifySecu() == 1) {
                        this.portfolio.setIsVerifySecu(2);
                        s = true;
                    }
                } else if (this.portfolio.getIsVerifySecu() == 2) {
                    this.portfolio.setIsVerifySecu(1);
                    s = true;
                }
                this.portfolio.setExportSettlement(this.ckExportFW.isSelected() ? 1 : 0);
                this.updateSubFund(f);
                this.updateSubSec(s);
                this.portfolio.update(this.portfolioMngModel.getCommonPortfolio(), true);
                this.portfolioMng.updatePortfolio(this.portfolio);
                this.portfolioMngModel.getCommonPortfolio().update((Object)this.portfolio);
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                Platform.runLater(() -> {
                    this.lbAlert.setText(e.getMessage());
                    this.lbAlert.requestFocus();
                });
                return false;
            }
        }
        this.toDisable();
        return true;
    }

    private void toDisable() {
        this.cbExternalAsset.setDisable(true);
        this.cmbDataSource.setDisable(true);
        this.cmbExternalPort.setDisable(true);
        this.result.setValue(Boolean.valueOf(false));
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
    }

    private void updateSubFund(boolean f) throws MException {
        PAccount.SubFundAccnt.Builder newBuilder = PAccount.SubFundAccnt.newBuilder();
        newBuilder.setPortfolioId(this.portfolio.getId());
        if (f) {
            List subFundAccountList = this.fundAccountApi.getSubFundAccountList("CCS", newBuilder.build());
            for (PAccount.SubFundAccnt item : subFundAccountList) {
                this.portfolioMng.updateSubFundAccnt(item, "CCS", item.getStatus(), this.portfolio.getIsVerifyFund());
            }
        }
    }

    private void updateSubSec(boolean s) throws MException {
        PAccount.SubSecAccnt.Builder newBuilder2 = PAccount.SubSecAccnt.newBuilder();
        newBuilder2.setPortfolioId(this.portfolio.getId());
        if (s) {
            List subSecAccounts = this.secAccountApi.getSubSecAccounts("CCS", newBuilder2.build());
            this.portfolioMng.updateSubSecAccnts(subSecAccounts, this.portfolio.getIsVerifySecu(), -1, "CCS");
        }
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public TextArea getTxtMark() {
        return this.txtMark;
    }

    public void setTxtMark(TextArea txtMark) {
        this.txtMark = txtMark;
    }

    public String getNewPortfolioId() {
        return this.newPortfolioId;
    }

    public void setNewPortfolioId(String newPortfolioId) {
        this.newPortfolioId = newPortfolioId;
    }
}

