/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.Search;
import cms.tmx.core.MException;
import cms.tmx.entity.FuncModule;
import cms.tmx.entity.Party;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.FuncMngServiceImpl;
import cms.tmx.manage.parts.MxConverter;
import cms.tmx.manage.parts.MxNodeSuggest;
import java.util.Collection;
import java.util.HashMap;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddFuncTwoDialog
extends DialogObj {
    @FXML
    private ComboBox<MxNode> cmbIdentify;
    @FXML
    private TextField txtParent;
    @FXML
    private TextField txtName;
    @FXML
    private TextField txtSort;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbSortErr;
    @FXML
    private Label lbIdentiErr;
    @FXML
    private Label lbAlert;
    @FXML
    private Label labSuccess;
    @FXML
    private Button btnSaveBasic;
    @FXML
    private TextField txtId;
    @FXML
    private Label lbIdErr;
    @Inject
    private FuncMngServiceImpl funcMng;
    @Inject
    private FuncModule funcAdd;
    private Party party;
    private String newFuncId = "";
    private static final Logger logger = LogManager.getLogger(AddFuncTwoDialog.class);

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.initValues();
        this.bind();
        this.addCheck();
    }

    private void initValues() {
        MxNode node = MxNodeFactory.create((String)"identifier", (String)"100001");
        this.cmbIdentify.setItems(node.getNodes());
        HashMap<String, MxNode> map = new HashMap<String, MxNode>();
        for (MxNode n : node.getNodes()) {
            map.put(n.getValue(), n);
        }
        MxConverter conver = new MxConverter(map);
        this.cmbIdentify.setConverter(conver);
        MxNodeSuggest suggest = MxNodeSuggest.getMxNodeSuggest();
        suggest.addPossibleSuggestions((Collection)node.getNodes());
        Search.bindAutoCompletion((TextField)this.cmbIdentify.getEditor(), (Callback)suggest, conver);
    }

    private void bind() {
        this.txtId.textProperty().bindBidirectional((Property)this.funcAdd.idProperty());
        this.txtName.textProperty().bindBidirectional((Property)this.funcAdd.nameProperty());
        MxBindings.bindSI((Property)this.txtSort.textProperty(), (Property)this.funcAdd.sortProperty());
        this.txtParent.textProperty().bindBidirectional((Property)this.funcAdd.parentNameProperty());
        this.funcAdd.identifierProperty().bind((ObservableValue)this.cmbIdentify.valueProperty());
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
    }

    private void addCheck() {
        this.txtId.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 6));
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtSort.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 3));
        this.registerCheck((Node)this.lbIdErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtId.getText().length() == 6) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.txtId.textProperty()}));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbSortErr, (ObservableBooleanValue)this.txtSort.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbIdentiErr, (ObservableBooleanValue)this.cmbIdentify.getSelectionModel().selectedItemProperty().isNotNull());
    }

    public ButtonType[] getTypes() {
        return new ButtonType[]{ButtonType.CANCEL};
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        try {
            if (!this.newFuncId.isEmpty()) {
                if (this.newFuncId.equals(this.funcAdd.getId())) {
                    this.funcMng.updateFunc(this.funcAdd);
                } else {
                    this.funcMng.addFunc(this.funcAdd);
                    this.funcMng.delFuc(this.newFuncId);
                    this.newFuncId = this.funcAdd.getId();
                }
            } else if (this.newFuncId.isEmpty()) {
                this.funcMng.addFunc(this.funcAdd);
                this.newFuncId = this.funcAdd.getId();
            }
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbAlert.setText(e2.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public String getNewFuncId() {
        return this.newFuncId;
    }

    public void setNewFuncId(String newFuncId) {
        this.newFuncId = newFuncId;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public FuncModule getFuncAdd() {
        return this.funcAdd;
    }

    public void setFuncAdd(FuncModule funcAdd) {
        this.funcAdd = funcAdd;
    }

    public ComboBox<MxNode> getCmbIdentify() {
        return this.cmbIdentify;
    }

    public void setCmbIdentify(ComboBox<MxNode> cmbIdentify) {
        this.cmbIdentify = cmbIdentify;
    }
}

