/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.Search;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FuncModule;
import cms.tmx.entity.Party;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.FuncMngServiceImpl;
import cms.tmx.manage.parts.MxConverter;
import cms.tmx.manage.parts.MxNodeSuggest;
import cms.tmx.manage.parts.SetInterfaceDialog;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddFuncThreeDialog
extends DialogObj {
    @FXML
    private ComboBox<MxNode> cmbIdentify;
    @FXML
    private ComboBox<MxNode> cmbFunc;
    @FXML
    private TextField txtParent;
    @FXML
    private TextField txtName;
    @FXML
    private TextField txtSort;
    @FXML
    private TextField txtPri;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbSortErr;
    @FXML
    private Label lbIdentiErr;
    @FXML
    private Label lbFuncErr;
    @FXML
    private Label lbAlert;
    @FXML
    private Label lbPrIErr;
    @FXML
    private Button btnSet;
    @FXML
    private Label labSuccess;
    @FXML
    private Button btnSaveBasic;
    @FXML
    private TextField txtId;
    @FXML
    private Label lbIdErr;
    @Inject
    private FuncMngServiceImpl funcMng;
    @Inject
    private FuncModule funcAdd;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MxAlert mAlert;
    private Party party;
    private String newFuncId = "";
    private static final Logger logger = LogManager.getLogger(AddFuncThreeDialog.class);
    private static final String UNDEFINED = "unDefined";
    private List<String> interfaceList = new LinkedList<String>();

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.initValues();
        this.bind();
        this.addCheck();
    }

    private void initValues() {
        MxNode node = MxNodeFactory.create((String)"identifier", (String)"100001");
        this.cmbIdentify.setItems(node.getNodes());
        try {
            MxNode node2 = MxNodeFactory.create((String)this.funcAdd.getIdentifier().getRaw(), (String)UNDEFINED);
            this.cmbFunc.setItems(node2.getNodes());
            HashMap<String, MxNode> map = new HashMap<String, MxNode>();
            for (MxNode n : node2.getNodes()) {
                map.put(n.getValue(), n);
            }
            MxConverter conver = new MxConverter(map);
            this.cmbFunc.setConverter(conver);
            MxNodeSuggest suggest = MxNodeSuggest.getMxNodeSuggest();
            suggest.addPossibleSuggestions((Collection)node2.getNodes());
            Search.bindAutoCompletion((TextField)this.cmbFunc.getEditor(), (Callback)suggest, conver);
        }
        catch (Exception e) {
            MxNode node3 = MxNodeFactory.create((String)"", (String)"");
            this.cmbFunc.setItems(node3.getNodes());
            logger.error((Object)e, (Throwable)e);
        }
        this.btnSet.getStyleClass().add((Object)"btnOperation");
        this.cmbIdentify.setDisable(true);
        this.txtPri.setEditable(false);
    }

    private void bind() {
        this.txtId.textProperty().bindBidirectional((Property)this.funcAdd.idProperty());
        this.txtName.textProperty().bindBidirectional((Property)this.funcAdd.nameProperty());
        MxBindings.bindSI((Property)this.txtSort.textProperty(), (Property)this.funcAdd.sortProperty());
        this.txtParent.textProperty().bindBidirectional((Property)this.funcAdd.parentNameProperty());
        this.cmbIdentify.valueProperty().bindBidirectional((Property)this.funcAdd.identifierProperty());
        this.cmbFunc.valueProperty().bindBidirectional((Property)this.funcAdd.controlIdProperty());
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
    }

    private void addCheck() {
        this.txtId.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 6));
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 20));
        this.txtSort.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))$", 3));
        this.registerCheck((Node)this.lbIdErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.txtId.getText().length() == 6) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.txtId.textProperty()}));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbSortErr, (ObservableBooleanValue)this.txtSort.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbPrIErr, (ObservableBooleanValue)this.txtPri.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbFuncErr, (ObservableBooleanValue)this.cmbFunc.getSelectionModel().selectedItemProperty().isNotNull());
        this.registerCheck((Node)this.lbIdentiErr, (ObservableBooleanValue)this.cmbIdentify.getSelectionModel().selectedItemProperty().isNotNull());
    }

    @FXML
    private void setInteface() {
        SetInterfaceDialog obj = (SetInterfaceDialog)((Object)this.of.create(SetInterfaceDialog.class));
        obj.setInitList(this.interfaceList);
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u9009\u62e9\u63a5\u53e3\u6743\u9650");
            dialog.launch();
            this.interfaceList.clear();
            this.interfaceList = obj.getInterfaceNumberList();
            if (this.interfaceList.size() > 0) {
                this.txtPri.setText(this.interfaceList.toString());
            } else {
                this.txtPri.setText("");
            }
        }
        catch (Exception e) {
            this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    public ButtonType[] getTypes() {
        return new ButtonType[]{ButtonType.CANCEL};
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        try {
            if (!this.newFuncId.isEmpty()) {
                if (this.newFuncId.equals(this.funcAdd.getId())) {
                    this.funcMng.updateFunc(this.funcAdd);
                } else {
                    this.funcMng.addFunc(this.funcAdd);
                    this.funcMng.delFuc(this.newFuncId);
                    this.newFuncId = this.funcAdd.getId();
                }
            } else if (this.newFuncId.isEmpty()) {
                this.funcMng.addFunc(this.funcAdd);
                this.newFuncId = this.funcAdd.getId();
            }
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbAlert.setText(e2.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        this.labSuccess.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
        return true;
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public String getNewFuncId() {
        return this.newFuncId;
    }

    public void setNewFuncId(String newFuncId) {
        this.newFuncId = newFuncId;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public FuncModule getFuncAdd() {
        return this.funcAdd;
    }

    public void setFuncAdd(FuncModule funcAdd) {
        this.funcAdd = funcAdd;
    }

    public ComboBox<MxNode> getCmbIdentify() {
        return this.cmbIdentify;
    }

    public void setCmbIdentify(ComboBox<MxNode> cmbIdentify) {
        this.cmbIdentify = cmbIdentify;
    }
}

