/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.ExtraAsset;
import cms.tmx.entity.Product;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.ExtraAssetMngServiceImpl;
import cms.tmx.manage.models.ProductMngModel;
import cms.tmx.rights.IUiRightService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddExtraAssetTabContent
extends MxTabContent {
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private TextField txtName;
    @FXML
    private ComboBox<MxNode> cmbCurrency;
    @FXML
    private TextField txtValue;
    @FXML
    private DatePicker dateTime;
    @FXML
    private Button btnAdd;
    @FXML
    private TableColumn<ExtraAsset, HBox> colOperate;
    @FXML
    private TableColumn<ExtraAsset, String> id;
    @FXML
    private TableColumn<ExtraAsset, MxNode> type;
    @FXML
    private TableColumn<ExtraAsset, String> name;
    @FXML
    private TableColumn<ExtraAsset, MxNode> currency;
    @FXML
    private TableColumn<ExtraAsset, String> netValue;
    @FXML
    private TableColumn<ExtraAsset, String> index;
    @FXML
    private TableColumn<ExtraAsset, String> effectiveTime;
    @FXML
    private TableColumn<ExtraAsset, String> lastUpdateTime;
    @Inject
    private MObjFactory of;
    @FXML
    private TableView<ExtraAsset> tableAsset;
    @Inject
    private ExtraAssetMngServiceImpl assetMng;
    private Product product;
    @FXML
    private Label lbMessage;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSave;
    @Inject
    private ProductMngModel productMngModel;
    @Inject
    private ExecutorService exe;
    @Inject
    private IUiRightService model;
    private ExtraAsset asset;
    private MxList<ExtraAsset> mlist = new MxList();
    private List<ExtraAsset> assetList = new ArrayList<ExtraAsset>();
    private List<ExtraAsset> assetOldList = new ArrayList<ExtraAsset>();
    private static final Logger logger = LogManager.getLogger(AddExtraAssetTabContent.class);
    private boolean deleteFlag = true;

    @FXML
    public void initialize() throws MException {
        this.product = this.productMngModel.getCommonProduct();
        this.labSuccess.setVisible(false);
        this.asset = (ExtraAsset)this.of.create(ExtraAsset.class);
        this.model.registerCheck((Control)this.btnAdd, new String[]{"updateProductExtraAssetControl"});
        this.deleteFlag = this.model.registerCheck(new String[]{"updateProductExtraAssetControl"});
        this.createTableView();
        this.exe.execute(() -> this.initDefaultValues());
        this.initValues();
        this.bind();
    }

    private void initDefaultValues() {
        try {
            ObservableList<ExtraAsset> assets = this.assetMng.getExtraAssetList(this.product.getId());
            this.assetList.addAll((Collection<ExtraAsset>)assets);
            this.assetOldList.addAll((Collection<ExtraAsset>)assets);
            this.mlist.getList().addAll(assets);
        }
        catch (MException e) {
            this.lbMessage.setText(e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void bind() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtValue.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,})?$", 15));
        this.asset.nameProperty().bind((ObservableValue)this.txtName.textProperty());
        this.asset.valueProperty().bind((ObservableValue)this.txtValue.textProperty());
        this.asset.typeProperty().bind((ObservableValue)this.cmbType.valueProperty());
        this.asset.currencyProperty().bind((ObservableValue)this.cmbCurrency.valueProperty());
        this.asset.effectiveTimeProperty().bind((ObservableValue)this.dateTime.valueProperty().asString());
    }

    private void initValues() {
        MxNode node = MxNodeFactory.create((String)"currency_type", (String)"CNY");
        ObservableList listCur = node.getNodes();
        this.cmbCurrency.setItems(listCur);
        this.cmbCurrency.getSelectionModel().select(0);
        this.dateTime.setValue((Object)LocalDate.now());
        node = MxNodeFactory.create((String)"asset_type", (String)"1");
        ObservableList listExc = node.getNodes();
        this.cmbType.setItems(listExc);
        this.cmbType.getSelectionModel().select(0);
    }

    private void createTableView() {
        TableUtils.initContextMenu(this.tableAsset);
        this.index.setCellValueFactory(data -> new ReadOnlyStringWrapper(String.valueOf(this.tableAsset.getItems().indexOf(data.getValue()) + 1)));
        this.type.setCellValueFactory(data -> ((ExtraAsset)data.getValue()).typeProperty());
        this.name.setCellValueFactory(data -> ((ExtraAsset)data.getValue()).nameProperty());
        this.currency.setCellValueFactory(data -> ((ExtraAsset)data.getValue()).currencyProperty());
        this.netValue.setCellValueFactory(m -> {
            String netVal = ((ExtraAsset)m.getValue()).getValue();
            String decimal = new BigDecimal(netVal).toPlainString();
            return new SimpleStringProperty(decimal);
        });
        this.effectiveTime.setCellValueFactory(data -> ((ExtraAsset)data.getValue()).effectiveTimeProperty());
        this.lastUpdateTime.setCellValueFactory(data -> ((ExtraAsset)data.getValue()).lastUpdateTimeProperty());
        this.colOperate.setCellValueFactory(data -> this.setOperate((ExtraAsset)data.getValue()));
        this.tableAsset.setPlaceholder((Node)new Label());
        this.tableAsset.setItems(this.mlist.getList());
    }

    public void refreshTable() {
        ExtraAsset extraAsset = (ExtraAsset)this.of.create(ExtraAsset.class);
        extraAsset.update((Object)this.asset);
        extraAsset.setId(UUID.randomUUID().toString());
        if (!extraAsset.getValue().contains(".")) {
            extraAsset.setValue(String.valueOf(extraAsset.getValue()) + ".0");
        } else {
            extraAsset.setValue(extraAsset.getValue());
        }
        this.mlist.getList().add((Object)extraAsset);
        this.assetList.add(extraAsset);
    }

    @FXML
    private void add() throws MException {
        if (this.txtName.getText().isEmpty()) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u6743\u76ca\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (this.txtValue.getText().isEmpty()) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u6743\u76ca\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (this.dateTime.getValue() == null) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (((LocalDate)this.dateTime.getValue()).isAfter(LocalDate.now())) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u65e5\u671f\u9009\u62e9\u4eca\u5929\u53ca\u4ee5\u524d");
            return;
        }
        this.lbMessage.setText("\u589e\u52a0" + this.txtName.getText() + ": \u6210\u529f");
        this.refreshTable();
    }

    private ReadOnlyObjectWrapper<HBox> setOperate(ExtraAsset ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setTextFill((Paint)Color.ORANGERED);
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMouseClicked(event -> {
            this.mlist.getList().remove((Object)ap);
            this.assetList.remove(ap);
            this.lbMessage.setText("\u5220\u9664" + ap.getName() + ": \u6210\u529f");
        });
        if (ap != null && this.deleteFlag) {
            hBox.getChildren().add(0, (Object)lbIn);
        }
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    @FXML
    public boolean save() {
        try {
            LinkedList<ExtraAsset> needAdd = new LinkedList<ExtraAsset>();
            LinkedList<ExtraAsset> needDel = new LinkedList<ExtraAsset>();
            for (ExtraAsset obj : this.assetList) {
                if (this.assetOldList.contains(obj)) continue;
                needAdd.add(obj);
            }
            for (ExtraAsset old : this.assetOldList) {
                if (this.assetList.contains(old)) continue;
                needDel.add(old);
            }
            if (needAdd.size() > 0) {
                for (ExtraAsset ext : needAdd) {
                    ext.setProductId(this.product.getId());
                    this.assetMng.addExtraAsset(ext);
                }
            }
            if (needDel.size() > 0) {
                for (ExtraAsset ext : needDel) {
                    ext.setProductId(this.product.getId());
                    this.assetMng.deleteExtraAsset(ext.getId());
                }
            }
            this.labSuccess.setVisible(true);
            Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)2000.0), e -> this.labSuccess.setVisible(false), new KeyValue[0])});
            animation.setCycleCount(1);
            animation.setAutoReverse(false);
            animation.play();
            this.refresh();
        }
        catch (MException e2) {
            logger.error((Object)e2, (Throwable)e2);
            Platform.runLater(() -> {
                this.lbMessage.setText(e2.getMessage());
                this.lbMessage.setStyle("-fx-text-fill:red");
                this.lbMessage.requestFocus();
            });
            return false;
        }
        return true;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    private void refresh() {
        try {
            ObservableList<ExtraAsset> assets = this.assetMng.getExtraAssetList(this.product.getId());
            this.assetList.clear();
            this.assetOldList.clear();
            this.mlist.getList().clear();
            this.assetList.addAll((Collection<ExtraAsset>)assets);
            this.assetOldList.addAll((Collection<ExtraAsset>)assets);
            this.mlist.getList().addAll(assets);
        }
        catch (MException e) {
            this.lbMessage.setText(e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }
}

