/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.entity.TradeCounter;
import cms.tmx.entity.data.CtpContract;
import cms.tmx.javafx.MxList;
import cms.tmx.manage.models.AccountMngModel;
import cms.tmx.manage.models.TradeCounterServiceImpl;
import cms.tmx.utils.MarketUtils;
import cmx.tmx.data.IContractService;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddCtpCommissionTabContent
extends MxTabContent {
    @FXML
    private TableView<CtpContract> tableSet;
    @FXML
    private TableColumn<CtpContract, String> colMarket;
    @FXML
    private TableColumn<CtpContract, String> colProduct;
    @FXML
    private TableColumn<CtpContract, String> colContractId;
    @FXML
    private TableColumn<CtpContract, String> colContractName;
    @FXML
    private TableColumn<CtpContract, String> colAccntId;
    @FXML
    private TableColumn<CtpContract, String> colBroker;
    @FXML
    private TableColumn<CtpContract, Number> colLongMarginRatio;
    @FXML
    private TableColumn<CtpContract, Number> colShortMarginRatio;
    @FXML
    private TableColumn<CtpContract, Number> colLongMarginRatioHand;
    @FXML
    private TableColumn<CtpContract, Number> colShortMarginRatioHand;
    @FXML
    private TableColumn<CtpContract, Number> colCloseVolume;
    @FXML
    private TableColumn<CtpContract, Number> colOpenVolume;
    @FXML
    private TableColumn<CtpContract, Number> colCloseTodayVolume;
    @FXML
    private TableColumn<CtpContract, Number> colClosePercent;
    @FXML
    private TableColumn<CtpContract, Number> colOpenPercent;
    @FXML
    private TableColumn<CtpContract, Number> colCloseTodayPercent;
    @FXML
    private Label lbMessage;
    @Inject
    private AccountMngModel accntModel;
    @Inject
    private TradeCounterServiceImpl counterMng;
    @Inject
    private ExecutorService exe;
    @Inject
    private IContractService service;
    private static final Logger logger = LogManager.getLogger(AddCtpCommissionTabContent.class);
    private MxList<CtpContract> mlist = new MxList();
    private Account account;

    @FXML
    public void initialize() {
        this.account = this.accntModel.getCommonAccount();
        this.exe.execute(() -> this.query());
        this.createTableView();
    }

    @FXML
    private void save() {
    }

    @FXML
    private void cancel() {
    }

    private void query() {
        try {
            List query = this.service.query("FUTURES", this.account.getBrokerId(), this.account.getInvestorId());
            this.mlist.update(query);
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> this.lbMessage.setText("\u671f\u8d27\u624b\u7eed\u8d39\u8bbe\u7f6e\u67e5\u8be2\u5931\u8d25:" + e.getMessage()));
        }
    }

    private void createTableView() {
        this.colProduct.setCellValueFactory(data -> ((CtpContract)data.getValue()).productNameProperty());
        this.colMarket.setCellValueFactory(cellData -> {
            String market = ((CtpContract)cellData.getValue()).getMarket();
            String name = MarketUtils.getMarketNameById((String)market);
            SimpleStringProperty flage = new SimpleStringProperty(name);
            return flage;
        });
        this.colBroker.setCellValueFactory(data -> {
            SimpleStringProperty name = new SimpleStringProperty("");
            String id = ((CtpContract)data.getValue()).getBrokerId();
            for (TradeCounter item : this.counterMng.getBroker()) {
                if (!item.getBrokerId().equals(id)) continue;
                name.setValue(item.getBrokerName());
                break;
            }
            return name;
        });
        this.colContractId.setCellValueFactory(data -> ((CtpContract)data.getValue()).contractIdProperty());
        this.colContractName.setCellValueFactory(data -> ((CtpContract)data.getValue()).contractNameProperty());
        this.colAccntId.setCellValueFactory(data -> ((CtpContract)data.getValue()).investorIdProperty());
        this.colLongMarginRatio.setCellValueFactory(data -> ((CtpContract)data.getValue()).longMarginRatioProperty());
        this.colShortMarginRatio.setCellValueFactory(data -> ((CtpContract)data.getValue()).shortMarginRatioProperty());
        this.colCloseVolume.setCellValueFactory(data -> ((CtpContract)data.getValue()).closeVolumeProperty());
        this.colOpenVolume.setCellValueFactory(data -> ((CtpContract)data.getValue()).openVolumeProperty());
        this.colCloseTodayVolume.setCellValueFactory(data -> ((CtpContract)data.getValue()).closeTodayVolumeProperty());
        this.colLongMarginRatioHand.setCellValueFactory(data -> ((CtpContract)data.getValue()).longMarginVolumeProperty());
        this.colShortMarginRatioHand.setCellValueFactory(data -> ((CtpContract)data.getValue()).shortMarginVolumeProperty());
        this.colClosePercent.setCellValueFactory(data -> ((CtpContract)data.getValue()).closeRatioProperty());
        this.colOpenPercent.setCellValueFactory(data -> ((CtpContract)data.getValue()).openRatioProperty());
        this.colCloseTodayPercent.setCellValueFactory(data -> ((CtpContract)data.getValue()).closeTodayRatioProperty());
        this.colLongMarginRatio.setCellFactory(p -> new EditTableCell(3));
        this.colShortMarginRatio.setCellFactory(p -> new EditTableCell(3));
        this.colCloseVolume.setCellFactory(p -> new EditTableCell(3));
        this.colOpenVolume.setCellFactory(p -> new EditTableCell(3));
        this.colCloseTodayVolume.setCellFactory(p -> new EditTableCell(3));
        this.tableSet.setPlaceholder((Node)new Label());
        this.tableSet.setItems(this.mlist.getList());
    }
}

