/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.BaseAutoCompletion;
import cms.tmx.control.search.BaseSuggestion;
import cms.tmx.control.search.Search;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.unify_risk.PRiskConstants;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsCommission;
import cms.tmx.entity.SecClassify;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.models.AccountGrpMngServiceImpl;
import cms.tmx.manage.models.AccountMngModel;
import cms.tmx.rights.IUiRightService;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddCcsCommissionTabContent
extends MxTabContent {
    @FXML
    private TextField txtAcctId;
    @FXML
    private TextField txtBuyCommissionRate;
    @FXML
    private TextField txtSellCommissionRate;
    @FXML
    private TextField txtMinCommission;
    @FXML
    private TextField txtTransferFeeRate;
    @FXML
    private TextField txtMinTransferFee;
    @FXML
    private TextField txtBuyStampTaxRate;
    @FXML
    private TextField txtSellStampTaxRate;
    @FXML
    private ComboBox<SecClassify> cmbType;
    @FXML
    private TableView<CcsCommission> tableCommission;
    @FXML
    private Label lbMessage;
    @FXML
    private TableColumn<CcsCommission, String> colAcctId;
    @FXML
    private TableColumn<CcsCommission, String> colCurrency;
    @FXML
    private TableColumn<CcsCommission, String> colType;
    @FXML
    private TableColumn<CcsCommission, String> colTime;
    @FXML
    private TableColumn<CcsCommission, Number> colCommissionRate;
    @FXML
    private TableColumn<CcsCommission, Number> colCommissionRateSell;
    @FXML
    private TableColumn<CcsCommission, Number> colMinCommission;
    @FXML
    private TableColumn<CcsCommission, Number> colTransferFeeRate;
    @FXML
    private TableColumn<CcsCommission, Number> colMinTransferFee;
    @FXML
    private TableColumn<CcsCommission, Number> colBuyStampTaxRate;
    @FXML
    private TableColumn<CcsCommission, Number> colSellStampTaxRate;
    @FXML
    private TableColumn<CcsCommission, HBox> colOperate;
    @FXML
    private Button btnAdd;
    @FXML
    private Button btnQuery;
    @Inject
    private AccountMngModel accntModel;
    @Inject
    private IUiRightService model;
    @Inject
    private AccountGrpMngServiceImpl ags;
    @Inject
    private ExecutorService exe;
    @Inject
    private IAccountService ias;
    @Inject
    private MObjFactory of;
    @Inject
    private MxAlert mAlert;
    private Account account;
    private CcsCommission commission;
    private boolean deleteFlag = true;
    private static final Logger logger = LogManager.getLogger(AddCcsCommissionTabContent.class);
    private MxList<CcsCommission> mlist = new MxList();
    private Map<Integer, SecClassify> map = new HashMap<Integer, SecClassify>();
    private Map<String, SecClassify> nameMap = new HashMap<String, SecClassify>();
    private BaseSuggestion<SecClassify> suggestSecClassify = new BaseSuggestion<SecClassify>(){
        private Comparator<SecClassify> cp = new Comparator<SecClassify>(){

            @Override
            public int compare(SecClassify o1, SecClassify o2) {
                if (o1.getSecClassifyId() < o2.getSecClassifyId()) {
                    return -1;
                }
                if (o1.getSecClassifyId() == o2.getSecClassifyId()) {
                    return 0;
                }
                if (o1.getSecClassifyId() > o2.getSecClassifyId()) {
                    return 1;
                }
                return 0;
            }
        };

        protected Comparator<SecClassify> getComparator() {
            return this.cp;
        }

        protected boolean isMatch(SecClassify si, BaseAutoCompletion.ISuggestionRequest req) {
            return si.getSecClassifyName().indexOf(req.getUserText()) != -1;
        }
    };

    @FXML
    public void initialize() {
        this.account = this.accntModel.getCommonAccount();
        this.commission = (CcsCommission)this.of.create(CcsCommission.class);
        this.txtAcctId.setText(this.account.getInvestorId());
        this.exe.execute(() -> {
            this.initValues();
            this.query();
        });
        this.createTableView();
        this.bind();
        this.model.registerCheck((Control)this.btnAdd, new String[]{"addAccountCommissionControl"});
        this.deleteFlag = this.model.registerCheck(new String[]{"delAccountCommissionControl"});
    }

    private void bind() {
        this.txtMinCommission.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$", 10));
        this.txtMinTransferFee.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$", 10));
        this.txtBuyCommissionRate.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?$", 10));
        this.txtSellCommissionRate.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?$", 10));
        this.txtTransferFeeRate.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?$", 10));
        this.txtBuyStampTaxRate.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?$", 10));
        this.txtSellStampTaxRate.setTextFormatter((TextFormatter)new MxFormatter("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,4})?$", 10));
        this.commission.ext_accnt_idProperty().bind((ObservableValue)this.txtAcctId.textProperty());
        MxBindings.bindSD((Property)this.txtBuyCommissionRate.textProperty(), (Property)this.commission.buy_commission_rateProperty());
        MxBindings.bindSD((Property)this.txtSellCommissionRate.textProperty(), (Property)this.commission.sell_commission_rateProperty());
        MxBindings.bindSD((Property)this.txtMinCommission.textProperty(), (Property)this.commission.min_buy_commissionProperty());
        MxBindings.bindSD((Property)this.txtTransferFeeRate.textProperty(), (Property)this.commission.buy_transfer_fee_rateProperty());
        MxBindings.bindSD((Property)this.txtMinTransferFee.textProperty(), (Property)this.commission.min_buy_transfer_feeProperty());
        MxBindings.bindSD((Property)this.txtBuyStampTaxRate.textProperty(), (Property)this.commission.buy_stamp_tax_rateProperty());
        MxBindings.bindSD((Property)this.txtSellStampTaxRate.textProperty(), (Property)this.commission.sell_stamp_tax_rateProperty());
        Search.bindAutoCompletion((TextField)this.cmbType.getEditor(), this.suggestSecClassify, (StringConverter)new SecClassifyConverter()).setPrefWidth(this.cmbType.getPrefWidth());
        this.cmbType.setConverter((StringConverter)new SecClassifyConverter());
        this.cmbType.setEditable(true);
    }

    @FXML
    private void add() {
        if (this.txtBuyCommissionRate.getText().isEmpty()) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u4e70\u5165\u4f63\u91d1\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            this.showLable(this.lbMessage);
            return;
        }
        if (this.txtSellCommissionRate.getText().isEmpty()) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u5356\u51fa\u4f63\u91d1\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            this.showLable(this.lbMessage);
            return;
        }
        if (this.txtMinCommission.getText().isEmpty()) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u6700\u5c0f\u4f63\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
            this.showLable(this.lbMessage);
            return;
        }
        if (this.txtTransferFeeRate.getText().isEmpty()) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u8fc7\u6237\u8d39\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            this.showLable(this.lbMessage);
            return;
        }
        if (this.txtMinTransferFee.getText().isEmpty()) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u6700\u4f4e\u8fc7\u6237\u8d39\u4e0d\u80fd\u4e3a\u7a7a");
            this.showLable(this.lbMessage);
            return;
        }
        if (this.txtBuyStampTaxRate.getText().isEmpty()) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u4e70\u5165\u5370\u82b1\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            this.showLable(this.lbMessage);
            return;
        }
        if (this.txtSellStampTaxRate.getText().isEmpty()) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u5356\u51fa\u5370\u82b1\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a");
            this.showLable(this.lbMessage);
            return;
        }
        if (this.cmbType.getSelectionModel().getSelectedItem() == null) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            this.showLable(this.lbMessage);
            return;
        }
        CcsCommission ccsCommission = (CcsCommission)this.of.create(CcsCommission.class);
        this.commission.setCurrency((String)this.account.getCurrency().get(0));
        this.commission.setType(Integer.toString(((SecClassify)this.cmbType.getSelectionModel().getSelectedItem()).getSecClassifyId()));
        ccsCommission.update((Object)this.commission);
        LinkedList<CcsCommission> linkedList = new LinkedList<CcsCommission>();
        linkedList.add(ccsCommission);
        try {
            this.ias.addCommissions(linkedList, "CCS");
            this.query();
            this.lbMessage.setText("\u65b0\u589e \u6210\u529f");
            this.showLable(this.lbMessage);
        }
        catch (MException e) {
            this.lbMessage.setText("\u65b0\u589e\u5931\u8d25" + e.getMessage());
            this.showLable(this.lbMessage);
        }
    }

    @FXML
    private void query() {
        try {
            CcsCommission ccsCommission = new CcsCommission();
            ccsCommission.setExt_accnt_id(this.account.getInvestorId());
            LinkedList<CcsCommission> linkedList = new LinkedList<CcsCommission>();
            linkedList.add(ccsCommission);
            this.mlist.clear();
            this.mlist.addAll(this.ias.getCommissions(linkedList, "CCS"));
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void initValues() {
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(this.account.getPartyId());
            List<SecClassify> secClassifyList = this.ags.getSecClassifyList(linkedList, PRiskConstants.ClassifyType.CLASSIFY_TYPE_SYSTEM);
            ObservableList newList = FxUtils.newList();
            for (SecClassify secClassify : secClassifyList) {
                if (secClassify.getRangeType() != 1) continue;
                newList.add((Object)secClassify);
            }
            Collections.sort(newList, (o1, o2) -> {
                if (o1.getSecClassifyId() < o2.getSecClassifyId()) {
                    return -1;
                }
                if (o1.getSecClassifyId() == o2.getSecClassifyId()) {
                    return 0;
                }
                if (o1.getSecClassifyId() > o2.getSecClassifyId()) {
                    return 1;
                }
                return 0;
            });
            this.suggestSecClassify.setAllSuggestions((Collection)newList);
            for (SecClassify cla : secClassifyList) {
                this.map.put(cla.getSecClassifyId(), cla);
                this.nameMap.put(cla.getSecClassifyName(), cla);
            }
            this.cmbType.setItems(newList);
            Platform.runLater(() -> this.cmbType.getSelectionModel().select(0));
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void createTableView() {
        this.colAcctId.setCellValueFactory(data -> ((CcsCommission)data.getValue()).ext_accnt_idProperty());
        this.colCurrency.setCellValueFactory(data -> ((CcsCommission)data.getValue()).curStrProperty());
        this.colTime.setCellValueFactory(data -> ((CcsCommission)data.getValue()).timeProperty());
        this.colType.setCellValueFactory(cellData -> {
            String typeId = ((CcsCommission)cellData.getValue()).getType();
            if (this.map.get(Integer.parseInt(typeId)) == null) {
                return new SimpleStringProperty();
            }
            SimpleStringProperty flage = new SimpleStringProperty(this.map.get(Integer.parseInt(typeId)).getSecClassifyName());
            return flage;
        });
        this.colCommissionRate.setCellValueFactory(data -> ((CcsCommission)data.getValue()).buy_commission_rateProperty());
        this.colCommissionRateSell.setCellValueFactory(data -> ((CcsCommission)data.getValue()).sell_commission_rateProperty());
        this.colMinCommission.setCellValueFactory(data -> ((CcsCommission)data.getValue()).min_buy_commissionProperty());
        this.colTransferFeeRate.setCellValueFactory(data -> ((CcsCommission)data.getValue()).buy_transfer_fee_rateProperty());
        this.colMinTransferFee.setCellValueFactory(data -> ((CcsCommission)data.getValue()).min_buy_transfer_feeProperty());
        this.colBuyStampTaxRate.setCellValueFactory(data -> ((CcsCommission)data.getValue()).buy_stamp_tax_rateProperty());
        this.colSellStampTaxRate.setCellValueFactory(data -> ((CcsCommission)data.getValue()).sell_stamp_tax_rateProperty());
        this.colOperate.setCellValueFactory(data -> this.setOperate((CcsCommission)data.getValue()));
        this.tableCommission.setPlaceholder((Node)new Label());
        this.tableCommission.setItems(this.mlist.getList());
    }

    private ReadOnlyObjectWrapper<HBox> setOperate(CcsCommission ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMouseClicked(event -> {
            try {
                if (this.mAlert.alert(Alert.AlertType.CONFIRMATION, "\u786e\u8ba4\u5220\u9664?")) {
                    this.delete(ap);
                    this.query();
                }
            }
            catch (MException e) {
                this.lbMessage.setText(e.getMessage());
                this.lbMessage.setStyle("-fx-text-fill:red");
                this.showLable(this.lbMessage);
                logger.error((Object)e, (Throwable)e);
            }
        });
        if (this.deleteFlag) {
            hBox.getChildren().add(0, (Object)lbIn);
        }
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    private void delete(CcsCommission secAcc) throws MException {
        CcsCommission ccsCommission = (CcsCommission)this.tableCommission.getSelectionModel().getSelectedItem();
        LinkedList<CcsCommission> linkedList = new LinkedList<CcsCommission>();
        linkedList.add(ccsCommission);
        try {
            this.ias.delCommissions(linkedList, "CCS");
            this.lbMessage.setText("\u5220\u9664 \u6210\u529f");
            this.showLable(this.lbMessage);
        }
        catch (MException e) {
            this.lbMessage.setText("\u5220\u9664 \u5931\u8d25" + e.getMessage());
            this.showLable(this.lbMessage);
        }
    }

    public void setAccount(Account acc) {
        this.account = acc;
    }

    private void showLable(Label lable) {
        lable.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> lable.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
    }

    class SecClassifyConverter
    extends StringConverter<SecClassify> {
        SecClassifyConverter() {
        }

        public String toString(SecClassify info) {
            if (info == null) {
                return "";
            }
            return info.toString();
        }

        public SecClassify fromString(String string) {
            SecClassify e = (SecClassify)AddCcsCommissionTabContent.this.nameMap.get(string);
            if (e != null) {
                return e;
            }
            return null;
        }
    }
}

