/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Broker;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.BrokerMngServiceImpl;
import java.util.Collection;
import java.util.LinkedList;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class AddBrokerDialog
extends DialogObj {
    @FXML
    private TextField txtName;
    @FXML
    private TextField txtFullName;
    @FXML
    private TextField txtCode;
    @FXML
    private CheckComboBox<MxNode> ckCmbType;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbFullErr;
    @FXML
    private Label lbCodeErr;
    @FXML
    private Label lbTypeErr;
    @Inject
    private MObjFactory of;
    private Broker broker;
    @FXML
    private Label lbAlert;
    @Inject
    private BrokerMngServiceImpl brokerMng;
    private String brokerId;
    private static final Logger logger = LogManager.getLogger(AddBrokerDialog.class);

    @FXML
    public void initialize() {
        this.broker = (Broker)this.of.create(Broker.class);
        this.initialValues();
        this.bind();
        this.addCheck();
    }

    private void initialValues() {
        MxNode node = MxNodeFactory.create((String)"business_type", (String)"Futures");
        ObservableList list = node.getNodes();
        this.ckCmbType.getItems().setAll((Collection)list);
    }

    private void addCheck() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtFullName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtCode.setTextFormatter((TextFormatter)new MxFormatter("[0-9]*", 20));
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbFullErr, (ObservableBooleanValue)this.txtFullName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbCodeErr, (ObservableBooleanValue)this.txtCode.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbTypeErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> !this.ckCmbType.getCheckModel().getCheckedItems().isEmpty(), (Observable[])new Observable[]{this.ckCmbType.getCheckModel().getCheckedItems()}));
    }

    private void bind() {
        this.txtName.textProperty().bindBidirectional((Property)this.broker.nameProperty());
        this.txtFullName.textProperty().bindBidirectional((Property)this.broker.fullNameProperty());
        this.txtCode.textProperty().bindBidirectional((Property)this.broker.codeProperty());
    }

    public boolean isOK(ButtonType bt) {
        try {
            LinkedList listType = new LinkedList();
            this.ckCmbType.getCheckModel().getCheckedItems().forEach(node -> {
                boolean bl = listType.add(node.getRaw());
            });
            this.broker.setTypes(listType);
            this.brokerId = this.brokerMng.addBroker(this.broker);
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> {
                this.lbAlert.setText(e.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        return true;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public TextField getTxtCode() {
        return this.txtCode;
    }

    public void setTxtCode(TextField txtCode) {
        this.txtCode = txtCode;
    }

    public String getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(String brokerId) {
        this.brokerId = brokerId;
    }
}

