/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.Blacklist;
import cms.tmx.manage.IBlacklistService;
import cms.tmx.utils.StringUtils;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddBlacklistDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(AddBlacklistDialog.class);
    @FXML
    private TextField txtIP;
    @FXML
    private TextField txtSource;
    @FXML
    private TextField txtDesc;
    @FXML
    private Label lbAlert;
    @FXML
    private Label lbIPErr;
    @Inject
    private MObjFactory of;
    private Blacklist blacklist;
    @Inject
    private IBlacklistService iBlacklist;
    private int type;
    private static final int IP_EXIST_ERROR = 3119;
    private static final int ADD_IP_BLACKLIST = 1;

    @FXML
    public void initialize() {
        this.blacklist = (Blacklist)this.of.create(Blacklist.class);
        this.bind();
        this.addListener();
        this.addCheck();
    }

    private void bind() {
        this.txtIP.textProperty().bindBidirectional((Property)this.blacklist.ipProperty());
        this.txtSource.textProperty().bindBidirectional((Property)this.blacklist.sourceProperty());
        this.txtDesc.textProperty().bindBidirectional((Property)this.blacklist.descProperty());
    }

    private void addListener() {
        this.txtIP.focusedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue()) {
                this.lbIPErr.setOpacity(0.0);
                this.lbIPErr.setText("");
            } else if (!this.txtIP.getText().isEmpty() && !StringUtils.isIp((String)this.txtIP.getText())) {
                this.lbIPErr.setText("\u8bf7\u8f93\u5165\u6b63\u786eIP");
                this.lbIPErr.setOpacity(1.0);
            }
        });
    }

    private void addCheck() {
        this.txtIP.setTextFormatter((TextFormatter)new MxFormatter("^([0-9]{1,3})((\\.[0-9]{0,3}){0,3})$", 15));
        this.txtSource.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 50));
        this.txtDesc.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 50));
    }

    public boolean isOK(ButtonType bt) {
        if (!this.lbIPErr.getText().isEmpty()) {
            return false;
        }
        try {
            this.type = 1;
            this.iBlacklist.addBlacklist(this.blacklist, this.type);
        }
        catch (MException e) {
            if (e.getCode() == 3119) {
                this.lbAlert.setText("\u6dfb\u52a0\u5931\u8d25\uff0c\u6b64IP\u5df2\u5b58\u5728\u9ed1\u540d\u5355");
            } else {
                this.lbAlert.setText(e.getMessage());
            }
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> {
                this.lbAlert.requestFocus();
                this.showTips(this.lbAlert);
            });
            return false;
        }
        return true;
    }

    private void showTips(Label lb) {
        lb.requestFocus();
        lb.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> lb.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
    }

    public Blacklist getBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(Blacklist blacklist) {
        this.blacklist = blacklist;
    }
}

