/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.search.BaseAutoCompletion;
import cms.tmx.control.search.BaseSuggestion;
import cms.tmx.control.search.Search;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Account;
import cms.tmx.entity.AccountGroup;
import cms.tmx.entity.Party;
import cms.tmx.entity.SecClassify;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxListUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.AccountGrpMngServiceImpl;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.PartyMngServiceImpl;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddAccountGrpDialog
extends DialogObj {
    @FXML
    private TextField txtName;
    @FXML
    private ComboBox<Party> cmbParty;
    @FXML
    private ComboBox<Account> cmbAccnt;
    @FXML
    private TableView<Account> tableAccnt;
    @FXML
    private Label lbMessage;
    @FXML
    private Label lbNameErr;
    @FXML
    private Label lbPartyErr;
    @FXML
    private TableColumn<Account, String> account;
    @FXML
    private TableColumn<Account, HBox> colOperate;
    @FXML
    private AccountGrpMngServiceImpl accntService;
    @FXML
    private Button btnAdd;
    @FXML
    private ComboBox<MxNode> cmbType;
    @FXML
    private CheckBox cboxClassifyType;
    @FXML
    private TextField txtClassifyId;
    @FXML
    private Label lbClassifyErr;
    @Inject
    private PartyMngServiceImpl partyMng;
    private Party party;
    @Inject
    private AccountMngServiceImpl accountMng;
    @Inject
    private AccountGrpMngServiceImpl accountGrpMng;
    @Inject
    private MObjFactory of;
    @Inject
    private ExecutorService exe;
    private AccountGroup accountGroup;
    private Map<String, Party> mapParty = new HashMap<String, Party>();
    private Map<String, Account> mapAccnt = new HashMap<String, Account>();
    private MxList<Account> mlist = new MxList();
    private ObservableList<Party> listParty = FxUtils.newList();
    private static final Logger logger = LogManager.getLogger(AddAccountGrpDialog.class);
    private BaseSuggestion<Party> suggestParty = new BaseSuggestion<Party>(){
        private Comparator<Party> cp = new Comparator<Party>(){

            @Override
            public int compare(Party o1, Party o2) {
                return o1.getId().compareTo(o2.getId());
            }
        };

        protected Comparator<Party> getComparator() {
            return this.cp;
        }

        protected boolean isMatch(Party si, BaseAutoCompletion.ISuggestionRequest req) {
            return si.getName().indexOf(req.getUserText()) != -1;
        }
    };
    private BaseSuggestion<SecClassify> suggestSecClassify = new BaseSuggestion<SecClassify>(){
        private Comparator<SecClassify> cp = new Comparator<SecClassify>(){

            @Override
            public int compare(SecClassify o1, SecClassify o2) {
                if (o1.getSecClassifyId() < o2.getSecClassifyId()) {
                    return -1;
                }
                if (o1.getSecClassifyId() == o2.getSecClassifyId()) {
                    return 0;
                }
                if (o1.getSecClassifyId() > o2.getSecClassifyId()) {
                    return 1;
                }
                return 0;
            }
        };

        protected Comparator<SecClassify> getComparator() {
            return this.cp;
        }

        protected boolean isMatch(SecClassify si, BaseAutoCompletion.ISuggestionRequest req) {
            return si.getSecClassifyName().indexOf(req.getUserText()) != -1;
        }
    };
    private BaseSuggestion<Account> suggestAccnt = new BaseSuggestion<Account>(){
        private Comparator<Account> cp = new Comparator<Account>(){

            @Override
            public int compare(Account o1, Account o2) {
                return o1.getInvestorId().compareTo(o2.getInvestorId());
            }
        };

        protected Comparator<Account> getComparator() {
            return this.cp;
        }

        protected boolean isMatch(Account si, BaseAutoCompletion.ISuggestionRequest req) {
            return si.getInvestorId().indexOf(req.getUserText()) != -1;
        }
    };

    @FXML
    public void initialize() throws MException {
        this.accountGroup = (AccountGroup)this.of.create(AccountGroup.class);
        this.initValues();
        this.bind();
        this.createTableView();
        this.exe.execute(() -> this.initDefaultValues());
    }

    private void initDefaultValues() {
        try {
            this.listParty.addAll(this.partyMng.getPartyList(this.partyMng.getUserParty().getId(), PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING));
            this.listParty.addAll((Object[])new Party[]{this.partyMng.getParty(this.partyMng.getUserParty().getId())});
            for (Party p : this.listParty) {
                this.mapParty.put(p.getName(), p);
            }
            this.suggestParty.addPossibleSuggestions(this.listParty);
            Platform.runLater(() -> this.cmbParty.getSelectionModel().select((Object)this.party));
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void bind() {
        this.txtName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.txtName.textProperty().bindBidirectional((Property)this.accountGroup.nameProperty());
        this.accountGroup.partyIdProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.cmbParty.getSelectionModel().selectedItemProperty().getValue() == null ? "" : ((Party)this.cmbParty.getSelectionModel().selectedItemProperty().getValue()).getId(), (Observable[])new Observable[]{this.cmbParty.getSelectionModel().selectedItemProperty()}));
        this.cmbType.valueProperty().bindBidirectional((Property)this.accountGroup.grpTypeProperty());
        this.cboxClassifyType.selectedProperty().bindBidirectional((Property)this.accountGroup.classifyTypeProperty());
        this.registerCheck((Node)this.lbNameErr, (ObservableBooleanValue)this.txtName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbPartyErr, (ObservableBooleanValue)this.cmbParty.getSelectionModel().selectedItemProperty().isNotNull());
        this.registerCheck((Node)this.lbClassifyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.cboxClassifyType.selectedProperty().get() && !this.txtClassifyId.focusedProperty().get() && this.txtClassifyId.getUserData() == null) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtClassifyId.focusedProperty(), this.txtClassifyId.textProperty(), this.cboxClassifyType.selectedProperty()}));
    }

    private void initValues() {
        this.cmbParty.setItems(this.listParty);
        this.cmbParty.setConverter((StringConverter)new PartyConverter());
        Search.bindAutoCompletion((TextField)this.cmbParty.getEditor(), this.suggestParty, (StringConverter)new PartyConverter()).setPrefWidth(this.cmbParty.getPrefWidth());
        Search.bindAutoCompletion((TextField)this.txtClassifyId, this.suggestSecClassify).setPrefWidth(this.txtClassifyId.getPrefWidth());
        Search.bindAutoCompletion((TextField)this.cmbAccnt.getEditor(), this.suggestAccnt, (StringConverter)new AccountConverter()).setPrefWidth(this.cmbAccnt.getPrefWidth());
        MxNode node = MxNodeFactory.create((String)"grp_type", (String)"2");
        this.cmbType.setItems(node.getNodes());
        this.cmbParty.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9\u4e00-\u9fa5]*", 20));
        this.cmbAccnt.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]+", 16));
        this.cmbAccnt.setConverter((StringConverter)new AccountConverter());
        this.cmbParty.getEditor().textProperty().addListener((ob, old, now) -> {
            if (now != null && now.isEmpty()) {
                this.cmbParty.getSelectionModel().clearSelection();
            }
        });
        this.cmbParty.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            try {
                if (newValue != null) {
                    SecClassify s;
                    this.cmbAccnt.requestFocus();
                    Party party = newValue;
                    String partyId = party.getId();
                    ObservableList<Account> listAccount = this.accountMng.getAccountListByParty(partyId, PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_OFFSPRING);
                    listAccount.addAll((Collection<Account>)this.accountMng.getAccountListByParty(partyId, PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_ONE));
                    ObservableList accntList = FXCollections.observableList(new LinkedList());
                    for (Account ext : listAccount) {
                        accntList.add((Object)ext);
                        this.mapAccnt.put(ext.getInvestorId(), ext);
                    }
                    for (Account a : this.mlist.getList()) {
                        if (MxListUtils.has((List)accntList, (Object)a)) continue;
                        this.mlist.remove((MxObject)a);
                    }
                    this.cmbAccnt.setItems(accntList);
                    this.suggestAccnt.setAllSuggestions((Collection)accntList);
                    LinkedList<String> partyIds = new LinkedList<String>();
                    this.partyMng.getPartyList(partyId, PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING).forEach(item -> partyIds.add(item.getId()));
                    partyIds.add(partyId);
                    LinkedList<SecClassify> classifyList = new LinkedList<SecClassify>();
                    classifyList.addAll(this.accountGrpMng.getSecClassifyList(partyIds));
                    if (this.txtClassifyId.getUserData() != null && this.txtClassifyId.getUserData() instanceof SecClassify && !classifyList.contains(s = (SecClassify)SecClassify.class.cast(this.txtClassifyId.getUserData()))) {
                        this.txtClassifyId.setUserData(null);
                        this.txtClassifyId.setText("");
                    }
                    this.suggestSecClassify.clearSuggestions();
                    this.suggestSecClassify.addPossibleSuggestions(classifyList);
                } else {
                    this.cmbAccnt.getSelectionModel().clearSelection();
                    ObservableList accntList = FXCollections.observableList(new LinkedList());
                    this.cmbAccnt.setItems(accntList);
                    this.suggestAccnt.clearSuggestions();
                    this.suggestAccnt.addPossibleSuggestions((Collection)accntList);
                    this.suggestSecClassify.clearSuggestions();
                    LinkedList classifyList = new LinkedList();
                    this.suggestSecClassify.addPossibleSuggestions(classifyList);
                }
            }
            catch (MException e) {
                this.lbMessage.setText(e.getMessage());
                this.lbMessage.setStyle("-fx-text-fill:red");
                logger.error((Object)e, (Throwable)e);
            }
        });
        this.cboxClassifyType.selectedProperty().addListener((ob, old, now) -> {
            if (now != null && now.booleanValue()) {
                this.txtClassifyId.setDisable(false);
            } else {
                this.txtClassifyId.setDisable(true);
            }
        });
    }

    private void createTableView() {
        this.account.setCellValueFactory(data -> ((Account)data.getValue()).investorIdProperty());
        this.colOperate.setCellValueFactory(data -> this.setOperate((Account)data.getValue()));
        this.tableAccnt.setPlaceholder((Node)new Label());
        this.tableAccnt.setItems(this.mlist.getList());
    }

    public void refreshTable() throws MException {
        Account account = (Account)this.cmbAccnt.getSelectionModel().getSelectedItem();
        if (account != null && !MxListUtils.has((List)this.mlist.getList(), (Object)account)) {
            this.mlist.add((MxObject)account);
            this.lbMessage.setText("");
        } else {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u8be5\u8d26\u6237\u5df2\u5b58\u5728");
        }
    }

    @FXML
    private void add() throws MException {
        if (this.cmbAccnt.getValue() == null) {
            this.lbMessage.setStyle("-fx-text-fill:red");
            this.lbMessage.setText("\u8bf7\u6dfb\u52a0\u6b63\u786e\u7684\u8d26\u6237");
            return;
        }
        this.refreshTable();
    }

    private ReadOnlyObjectWrapper<HBox> setOperate(Account ap) {
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER);
        Label lbIn = new Label("\u5220\u9664");
        lbIn.setTextFill((Paint)Color.ORANGERED);
        lbIn.setStyle("-fx-cursor:hand;-fx-font-size: 12px;-fx-alignment: center;-fx-pref-width: 45px; -fx-min-width:45px;");
        lbIn.setOnMouseClicked(event -> this.mlist.remove((MxObject)ap));
        hBox.getChildren().add(0, (Object)lbIn);
        return new ReadOnlyObjectWrapper((Object)hBox);
    }

    public boolean isOK(ButtonType bt) {
        try {
            if (this.cboxClassifyType.isSelected() && this.txtClassifyId.getUserData() != null && this.txtClassifyId.getUserData() instanceof SecClassify) {
                SecClassify s = (SecClassify)SecClassify.class.cast(this.txtClassifyId.getUserData());
                this.accountGroup.setClassifyId(String.valueOf(s.getSecClassifyId()));
            }
            String grpId = this.accountGrpMng.addAccountGrp(this.accountGroup);
            this.accountGroup.setId(grpId);
            this.accountGrpMng.AssignAccountsToGroup(grpId, this.accountGroup.getGrpType().getRaw(), (Collection<Account>)this.mlist.getList(), PCommon.Operation.OP_ADD);
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> {
                this.lbMessage.setText(e.getMessage());
                this.lbMessage.requestFocus();
            });
            return false;
        }
        return true;
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public TextField getTxtName() {
        return this.txtName;
    }

    public void setTxtName(TextField txtName) {
        this.txtName = txtName;
    }

    public ComboBox<Party> getCmbParty() {
        return this.cmbParty;
    }

    public void setCmbParty(ComboBox<Party> cmbParty) {
        this.cmbParty = cmbParty;
    }

    public AccountGroup getAccountGroup() {
        return this.accountGroup;
    }

    public void setAccountGroup(AccountGroup accountGroup) {
        this.accountGroup = accountGroup;
    }

    class AccountConverter
    extends StringConverter<Account> {
        AccountConverter() {
        }

        public String toString(Account info) {
            if (info == null) {
                return "";
            }
            return String.format("%s", info.getInvestorId());
        }

        public Account fromString(String string) {
            Account e = (Account)AddAccountGrpDialog.this.mapAccnt.get(string);
            if (e != null) {
                return e;
            }
            return null;
        }
    }

    class PartyConverter
    extends StringConverter<Party> {
        PartyConverter() {
        }

        public String toString(Party info) {
            if (info == null) {
                return "";
            }
            return String.format("%s", info.getName());
        }

        public Party fromString(String string) {
            Party e = (Party)AddAccountGrpDialog.this.mapParty.get(string);
            if (e != null) {
                return e;
            }
            return null;
        }
    }
}

