/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.DatePickerUtils;
import cms.tmx.core.MConfService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.define.BsDict;
import cms.tmx.entity.Account;
import cms.tmx.entity.ExternalAsset;
import cms.tmx.entity.Party;
import cms.tmx.entity.SubAccount;
import cms.tmx.entity.SubFundAccount;
import cms.tmx.entity.TradeCounter;
import cms.tmx.entity.factory.AccountFactory;
import cms.tmx.http.accnt.AccountServiceApi;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxNodePwf;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.models.AccountMngModel;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.ClearingModel;
import cms.tmx.manage.models.CurCmbModel;
import cms.tmx.manage.models.ExcCmbModelSp;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.PartyMngServiceImpl;
import cms.tmx.manage.models.SubAccountMngServiceImpl;
import cms.tmx.manage.models.SubFundAccountMngSerivceImpl;
import cms.tmx.manage.models.TradeCounterServiceImpl;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.util.Duration;
import javafx.util.StringConverter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AddAccountBasic
extends MxTabContent {
    @FXML
    private TextField txtAccount;
    @FXML
    private TextField txtAcctName;
    @FXML
    private TextField txtAcctPwd;
    @FXML
    private TextField txtCfmPwd;
    @FXML
    private TextField txtYears;
    @FXML
    private DatePicker txtCarryDay;
    @FXML
    private Label lbTradeNameErr;
    @FXML
    private Label lbEchangeErr;
    @FXML
    private Label lbCurrencyErr;
    @FXML
    private Label lbAccountErr;
    @FXML
    private Label lbAcctNameErr;
    @FXML
    private Label lbCmfPwdErr;
    @FXML
    private Label lbPwdErr;
    @FXML
    private Label lbCur;
    @FXML
    private Label lbExc;
    @FXML
    private Label lbYears;
    @FXML
    private Label lbCarryDay;
    @FXML
    private ComboBox<TradeCounter> cmbBrokerName;
    @FXML
    private ComboBox<TradeCounter> cmbTradeName;
    @FXML
    private ComboBox<MxNodePwf> cmbExchange;
    @FXML
    private ComboBox<Party> cmbPartyName;
    @FXML
    private ComboBox<MxNodePwf> cmbCurrency;
    @FXML
    private ComboBox<MxNodePwf> cmbCarryType;
    @FXML
    private CheckBox cbAuthNeeq;
    @FXML
    private CheckBox cbMultiCenter;
    @FXML
    private CheckBox cbAuthOtc;
    @FXML
    private CheckBox cbAuthFileOrder;
    @FXML
    private Label lbNonTradableAsset;
    @FXML
    private ComboBox<MxNode> cmbNonTradableAsset;
    @FXML
    private CheckBox cbExternalAsset;
    @FXML
    private Label lbDataSource;
    @FXML
    private ComboBox<MxNode> cmbDataSource;
    @FXML
    private Label lbAutoSyncConf;
    @FXML
    private ComboBox<String> cmbAutoSyncConf;
    @FXML
    private Label lbExternalAcc;
    @FXML
    private ComboBox<ExternalAsset> cmbExternalAcc;
    @FXML
    private Label lbExternalAccErr;
    @FXML
    private Label lbExternalAccWarn;
    @FXML
    private Label labSuccess;
    @FXML
    public Button btnSaveBasic;
    @Inject
    private AccountMngModel accntModel;
    @Inject
    private MObjFactory of;
    @Inject
    private AccountFactory af;
    @Inject
    private AccountMngServiceImpl accountMng;
    @Inject
    private PartyMngServiceImpl partyMng;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    private SubAccountMngServiceImpl subMng;
    @Inject
    private SubFundAccountMngSerivceImpl subFundMng;
    @Inject
    private TradeCounterServiceImpl counterMng;
    @Inject
    private AccountServiceApi accntApi;
    @FXML
    private Label lbAlert;
    @Inject
    private MConfService cs;
    @Inject
    private ClearingModel clearingModel;
    private Account account;
    private Party party;
    private String accountId = "";
    private static final Logger logger = LogManager.getLogger(AddAccountBasic.class);
    private static final int ISZERO = 1;
    private ObservableList<Party> listParty = FxUtils.newList();
    private CurCmbModel curModel = new CurCmbModel();
    private ExcCmbModelSp excModel = new ExcCmbModelSp();
    private String carryDate = "";
    private String lastTradingDay = "";
    public static SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
    private static final String FORMAT = "yyyy-MM-dd";
    private LocalDate defultDate;
    private MxNodePwf neeqMarket;
    private MxNodePwf otcMarket;
    boolean flag = false;
    BooleanProperty result = new SimpleBooleanProperty(true);

    @FXML
    public void initialize() {
        this.labSuccess.setVisible(false);
        this.cbMultiCenter.setVisible(false);
        this.party = this.accntModel.getParentParty();
        this.account = this.af.create();
        this.accntModel.setCommonAccount(this.account);
        this.initialValues();
        this.bindUIs();
        this.addCheck();
    }

    private void initialValues() {
        try {
            this.counterMng.getTradeCounterList();
            this.cmbBrokerName.setItems(this.counterMng.getBroker());
            this.cmbBrokerName.setConverter((StringConverter)new StringConverter<TradeCounter>(){

                public String toString(TradeCounter object) {
                    return object.getBrokerName();
                }

                public TradeCounter fromString(String string) {
                    return null;
                }
            });
            this.listParty.addAll(this.partyMng.getPartyList(this.partyMng.getUserParty().getId(), PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING));
            this.listParty.addAll((Object[])new Party[]{this.partyMng.getParty(this.partyMng.getUserParty().getId())});
            this.cmbPartyName.setItems(this.listParty);
            this.curModel.initCellFactory(this.cmbCurrency, this.lbCur);
            MxNodePwf nodePwf = MxNodeFactory.createPwf((String)"currency_type", (String)"CNY");
            ObservableList listCur = nodePwf.getPwfNodes();
            this.cmbCurrency.setItems(listCur);
            this.excModel.getCheckItems().addListener(ob -> {
                block4: {
                    ObservableList<MxNodePwf> checkCur;
                    ObservableList<MxNodePwf> checkExc;
                    block3: {
                        checkExc = this.excModel.getCheckItems();
                        checkCur = this.curModel.getCheckItems();
                        if (checkExc.size() != 1 || !((MxNodePwf)checkExc.get(0)).getRaw().equals("XCFE")) break block3;
                        checkCur.clear();
                        this.curModel.initCellFactory(this.cmbCurrency, this.lbCur);
                        this.flag = true;
                        for (MxNodePwf mn : listCur) {
                            if (mn.getRaw().equals("CNY")) {
                                mn.setSelected(true);
                                this.curModel.getCheckItems().add((Object)mn);
                                mn.setDisable(false);
                                continue;
                            }
                            mn.setDisable(true);
                            mn.setSelected(false);
                        }
                        break block4;
                    }
                    if (!this.flag || checkExc.size() != 0) break block4;
                    checkCur.clear();
                    this.curModel.initCellFactory(this.cmbCurrency, this.lbCur);
                    this.flag = false;
                    for (MxNodePwf mn : listCur) {
                        mn.setDisable(false);
                        if (!mn.isSelected()) continue;
                        this.curModel.getCheckItems().add((Object)mn);
                    }
                }
            });
            this.excModel.initCellFactory(this.cmbExchange, this.lbExc, null);
            nodePwf = MxNodeFactory.createPwf((String)"market_code", (String)"XSHG");
            ObservableList listExc = nodePwf.getPwfNodes();
            for (MxNodePwf mxNodePwf : listExc) {
                if ("NEEQ".equals(mxNodePwf.getRaw())) {
                    this.neeqMarket = mxNodePwf;
                    continue;
                }
                if (!"XOTC".equals(mxNodePwf.getRaw())) continue;
                this.otcMarket = mxNodePwf;
            }
            this.cmbExchange.setItems(listExc);
            nodePwf = MxNodeFactory.createPwf((String)"carry_type", (String)"1");
            ObservableList listCarry = nodePwf.getPwfNodes();
            this.cmbCarryType.setItems(listCarry);
            this.carryDate = AddAccountBasic.getCurrYearLast();
            this.defultDate = LocalDate.parse(this.carryDate, DateTimeFormatter.ofPattern(FORMAT));
            this.txtCarryDay.setValue((Object)this.defultDate);
            this.lastTradingDay = this.clearingModel.getLastTradingDay();
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                Date newDate = formatter.parse(this.lastTradingDay);
                DatePickerUtils.setDaysLaterTrading((DatePicker)this.txtCarryDay, (String)f.format(newDate));
            }
            catch (Exception e) {
                logger.error("\u8f6c\u5316\u6e05\u7b97\u65e5\u671f\u683c\u5f0f\u5f02\u5e38\uff1a " + this.lastTradingDay, (Throwable)e);
            }
            DatePickerUtils.setFormat((DatePicker)this.txtCarryDay, (String)FORMAT);
        }
        catch (MException e) {
            Platform.runLater(() -> {
                this.lbAlert.setText(e.getMessage());
                this.lbAlert.requestFocus();
            });
            logger.error((Object)e, (Throwable)e);
        }
        MxNode node = MxNodeFactory.create((String)"non_tradable_assets", (String)"0");
        this.cmbNonTradableAsset.setItems(node.getNodes());
        this.cmbNonTradableAsset.setValue((Object)node);
        node = MxNodeFactory.create((String)"accnt_data_source", (String)"1");
        this.cmbDataSource.setItems(node.getNodes());
        this.cmbDataSource.setValue((Object)node);
        this.cmbAutoSyncConf.setValue((Object)"\u6570\u636e\u4e2d\u53f0");
        this.cmbAutoSyncConf.setDisable(true);
        this.cmbExternalAcc.setConverter((StringConverter)new StringConverter<ExternalAsset>(){

            public String toString(ExternalAsset object) {
                if (object != null) {
                    return String.valueOf(object.getId()) + " " + object.getName() + " " + object.getInvestorId();
                }
                return "";
            }

            public ExternalAsset fromString(String string) {
                return null;
            }
        });
        try {
            this.cmbExternalAcc.setItems(this.accountMng.getExternalAccounts());
        }
        catch (MException e) {
            Platform.runLater(() -> {
                this.lbAlert.setText(e.getMessage());
                this.lbAlert.requestFocus();
            });
        }
        Tooltip tooltip = new Tooltip();
        this.cmbExternalAcc.setTooltip(tooltip);
        this.cmbExternalAcc.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            String txt = String.valueOf(now.getId()) + " " + now.getName() + " " + now.getInvestorId();
            tooltip.setText(txt);
            if (!this.txtAccount.getText().isEmpty() && !this.txtAccount.getText().equals(now.getInvestorId())) {
                this.lbExternalAccWarn.setOpacity(1.0);
            } else {
                this.lbExternalAccWarn.setOpacity(0.0);
            }
        });
        this.txtAccount.textProperty().addListener((ob, old, now) -> {
            if (now.isEmpty()) {
                this.lbExternalAccWarn.setOpacity(0.0);
            } else {
                ExternalAsset exter = (ExternalAsset)this.cmbExternalAcc.getSelectionModel().getSelectedItem();
                if (exter != null && !this.txtAccount.getText().equals(exter.getInvestorId())) {
                    this.lbExternalAccWarn.setOpacity(1.0);
                }
            }
        });
        this.txtAccount.focusedProperty().addListener((ob, oldV, newV) -> {
            if (newV.booleanValue()) {
                return;
            }
            this.checkSuffix();
        });
    }

    private void checkSuffix() {
        String oriInvestorId = "";
        oriInvestorId = this.txtAccount.getText().contains("@") ? this.txtAccount.getText().split("@")[0] : this.txtAccount.getText();
        if (this.cbMultiCenter.isSelected()) {
            String suffix = (String)BsDict.PLATFORM_ID_SUFFIX_MAP.get(((TradeCounter)this.cmbTradeName.getSelectionModel().getSelectedItem()).getCounterId());
            if (!StringUtils.isEmpty((String)this.txtAccount.getText())) {
                this.txtAccount.setText(String.valueOf(oriInvestorId) + suffix);
            }
        } else if (this.txtAccount.getText().contains("@")) {
            this.txtAccount.setText(oriInvestorId);
        }
    }

    public static String getCurrYearLast() {
        Calendar currCal = Calendar.getInstance();
        int currentYear = currCal.get(1);
        return AddAccountBasic.getYearLast(currentYear);
    }

    public static String getYearLast(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        Date currYearLast = calendar.getTime();
        String sDate = f.format(currYearLast);
        return sDate;
    }

    private void addCheck() {
        this.registerCheck((Node)this.lbTradeNameErr, (ObservableBooleanValue)this.cmbTradeName.getSelectionModel().selectedItemProperty().isNotNull());
        this.registerCheck((Node)this.lbAccountErr, (ObservableBooleanValue)this.txtAccount.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbAcctNameErr, (ObservableBooleanValue)this.txtAcctName.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbCurrencyErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> !this.curModel.getCheckItems().isEmpty(), (Observable[])new Observable[]{this.curModel.getCheckItems()}));
        this.registerCheck((Node)this.lbCmfPwdErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.txtCfmPwd.focusedProperty().get() && !this.txtCfmPwd.getText().equals(this.txtAcctPwd.getText())) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.txtCfmPwd.focusedProperty()}));
        this.registerCheck((Node)this.lbExternalAccErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (this.cmbExternalAcc.isVisible() && this.cmbExternalAcc.getSelectionModel().getSelectedItem() == null) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbExternalAcc.getSelectionModel().selectedItemProperty(), this.cmbExternalAcc.visibleProperty()}));
        this.cmbExternalAcc.visibleProperty().addListener(ob -> this.lbExternalAccErr.setOpacity(0.0));
    }

    private boolean check() {
        if (!this.txtCfmPwd.getText().equals(this.txtAcctPwd.getText())) {
            this.lbCmfPwdErr.setOpacity(1.0);
            return false;
        }
        return true;
    }

    private void bindUIs() {
        this.txtAccount.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9@]*", 32));
        this.txtAcctName.setTextFormatter((TextFormatter)new MxFormatter("[A-Za-z0-9_\u4e00-\u9fa5\\-]*", 32));
        this.txtCfmPwd.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9~!@#$%^&*:<>?,.=_]+$", 32));
        this.txtAcctPwd.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9~!@#$%^&*:<>?,.=_]+$", 32));
        this.cmbPartyName.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.account.setPartyId(now.getId());
            }
        });
        this.cmbPartyName.getSelectionModel().select((Object)this.party);
        this.cmbBrokerName.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.account.setBrokerId(now.getBrokerId());
                this.cmbTradeName.getSelectionModel().clearSelection();
                this.cmbTradeName.setItems(this.counterMng.getTradeCounterList(now.getBrokerId()));
                if ("99999".equals(now.getBrokerId())) {
                    this.cbMultiCenter.setVisible(true);
                } else {
                    this.cbMultiCenter.setVisible(false);
                    this.cbMultiCenter.setSelected(false);
                }
            }
        });
        this.cbAuthFileOrder.setSelected(true);
        this.cmbTradeName.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.account.setTradePlatformId(now.getId());
                if ("99999-01-01".equals(now.getId())) {
                    this.cbAuthNeeq.setVisible(true);
                    this.cbAuthOtc.setVisible(true);
                } else {
                    this.cbAuthNeeq.setVisible(false);
                    this.cbAuthOtc.setVisible(false);
                }
                if ("99999-01-01".equals(now.getId()) || "77777-01-01".equals(now.getId()) || "77777-01-02".equals(now.getId()) || "99999-02-02".equals(now.getId()) || "88888-01-01".equals(now.getId()) || "88888-01-02".equals(now.getId()) || "99999-02-01".equals(now.getId()) || "99999-02-02".equals(now.getId()) || "99999-02-03".equals(now.getId())) {
                    this.cbAuthFileOrder.setVisible(true);
                } else {
                    this.cbAuthFileOrder.setVisible(false);
                }
                for (MxNodePwf item : this.cmbExchange.getItems()) {
                    if (now.getSecExchange().contains(item.getValue())) {
                        this.excModel.check(item, false);
                        continue;
                    }
                    this.excModel.clearCheck(item, false);
                }
                this.checkSuffix();
            } else {
                for (MxNodePwf item : this.cmbExchange.getItems()) {
                    this.excModel.clearCheck(item, false);
                }
            }
        });
        this.cbAuthNeeq.selectedProperty().addListener((ob, oldV, newV) -> {
            if ("99999-01-01".equals(((TradeCounter)this.cmbTradeName.getValue()).getCounterId()) && newV.booleanValue()) {
                this.excModel.check(this.neeqMarket, false);
            } else {
                this.excModel.clearCheck(this.neeqMarket, false);
            }
        });
        this.cbAuthOtc.selectedProperty().addListener((ob, oldV, newV) -> {
            if ("99999-01-01".equals(((TradeCounter)this.cmbTradeName.getValue()).getCounterId()) && newV.booleanValue()) {
                this.excModel.check(this.otcMarket, false);
            } else {
                this.excModel.clearCheck(this.otcMarket, false);
            }
        });
        this.cbMultiCenter.selectedProperty().addListener((ob, oldV, newV) -> {
            if (newV.booleanValue()) {
                if (!StringUtils.isEmpty((String)this.txtAccount.getText()) && !this.txtAccount.getText().contains("@")) {
                    String suffix = (String)BsDict.PLATFORM_ID_SUFFIX_MAP.get(((TradeCounter)this.cmbTradeName.getSelectionModel().getSelectedItem()).getCounterId());
                    this.txtAccount.setText(String.valueOf(this.txtAccount.getText()) + suffix);
                }
            } else if (this.txtAccount.getText().contains("@")) {
                this.txtAccount.setText(this.txtAccount.getText().split("@")[0]);
            }
        });
        this.cmbNonTradableAsset.valueProperty().bindBidirectional((Property)this.account.nonTradableAssetProperty());
        this.cbExternalAsset.selectedProperty().addListener((ob, old, now) -> this.externalAccntCheck((Boolean)now));
        this.cmbDataSource.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.dataSourceChanged((MxNode)now));
        this.txtCfmPwd.editableProperty().bind((ObservableValue)this.txtAcctPwd.textProperty().isNotEmpty());
        this.txtAccount.textProperty().bindBidirectional((Property)this.account.investorIdProperty());
        this.txtAcctName.textProperty().bindBidirectional((Property)this.account.nameProperty());
        this.txtAcctPwd.textProperty().bindBidirectional((Property)this.account.pwdProperty());
        this.txtYears.textProperty().bindBidirectional((Property)this.account.carryYearsProperty());
        this.txtYears.setTextFormatter((TextFormatter)new MxFormatter("[1-9]", 1));
        this.lbAlert.focusedProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        });
        this.cmbBrokerName.getSelectionModel().select(0);
        this.cmbCarryType.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.account.setCarryCode(Integer.parseInt(now.getRaw()));
                if (!"3".equals(now.getRaw())) {
                    this.txtYears.clear();
                    this.txtYears.setEditable(false);
                    this.lbYears.setOpacity(0.0);
                    this.txtYears.setOpacity(0.0);
                } else {
                    this.txtYears.setEditable(true);
                    this.lbYears.setOpacity(1.0);
                    this.txtYears.setOpacity(1.0);
                    this.txtYears.textProperty().setValue("1");
                }
                if (!"1".equals(now.getRaw())) {
                    this.txtCarryDay.setValue((Object)this.defultDate);
                    this.lbCarryDay.setOpacity(1.0);
                    this.txtCarryDay.setOpacity(1.0);
                } else {
                    this.txtCarryDay.setValue(null);
                    this.lbCarryDay.setOpacity(0.0);
                    this.txtCarryDay.setOpacity(0.0);
                }
            }
        });
        this.cmbCarryType.getSelectionModel().select(0);
    }

    private void externalAccntCheck(Boolean now) {
        this.lbNonTradableAsset.setVisible(false);
        this.cmbNonTradableAsset.setVisible(false);
        this.lbDataSource.setVisible(false);
        this.cmbDataSource.setVisible(false);
        this.lbAutoSyncConf.setVisible(false);
        this.cmbAutoSyncConf.setVisible(false);
        this.lbExternalAcc.setVisible(false);
        this.cmbExternalAcc.setVisible(false);
        if (now.booleanValue()) {
            this.lbDataSource.setVisible(now.booleanValue());
            this.cmbDataSource.setVisible(now.booleanValue());
            this.dataSourceChanged((MxNode)this.cmbDataSource.getSelectionModel().getSelectedItem());
        } else {
            this.lbNonTradableAsset.setVisible(now == false);
            this.cmbNonTradableAsset.setVisible(now == false);
        }
    }

    private void dataSourceChanged(MxNode node) {
        this.account.setDataSource(node);
        boolean isAuto = "1".equals(node.getRaw());
        this.lbAutoSyncConf.setVisible(isAuto);
        this.cmbAutoSyncConf.setVisible(isAuto);
        this.lbExternalAcc.setVisible(isAuto);
        this.cmbExternalAcc.setVisible(isAuto);
    }

    @FXML
    public boolean saveBasic() {
        if (!this.valid()) {
            return false;
        }
        if (this.account.getId().isEmpty()) {
            block32: {
                block31: {
                    if (this.check()) break block31;
                    return false;
                }
                if (this.txtCarryDay.getValue() != null) {
                    this.account.setCarryDay(((LocalDate)this.txtCarryDay.getValue()).toString().replaceAll("-", ""));
                }
                if (!this.txtYears.isEditable() || !this.txtYears.getText().isEmpty()) break block32;
                Platform.runLater(() -> {
                    this.lbAlert.setText("\u5e74\u8f93\u5165\u6846\u4e0d\u80fd\u4e3a\u7a7a");
                    this.lbAlert.requestFocus();
                });
                return false;
            }
            try {
                LinkedList listExc = new LinkedList();
                LinkedList<Integer> listStatus = new LinkedList<Integer>();
                LinkedList<Integer> listFund = new LinkedList<Integer>();
                this.excModel.getCheckItems().forEach(node -> {
                    boolean bl = listExc.add(node.getRaw());
                });
                this.account.setSecExc(listExc);
                LinkedList listCur = new LinkedList();
                this.curModel.getCheckItems().forEach(node -> {
                    boolean bl = listCur.add(node.getRaw());
                });
                this.account.setCurrency(listCur);
                if (this.cbAuthNeeq.isVisible() && this.cbAuthNeeq.isSelected()) {
                    this.account.setNeeqEnable(true);
                } else {
                    this.account.setNeeqEnable(false);
                }
                if (this.cbAuthOtc.isVisible() && this.cbAuthOtc.isSelected()) {
                    this.account.setOtcEnable(true);
                } else {
                    this.account.setOtcEnable(false);
                }
                if (this.cbMultiCenter.isVisible() && this.cbMultiCenter.isSelected()) {
                    this.account.setMultiCenter(true);
                } else {
                    this.account.setMultiCenter(false);
                }
                if (this.cbAuthFileOrder.isVisible() && this.cbAuthFileOrder.isSelected()) {
                    this.account.setFileOrderManualConfirmation(true);
                } else {
                    this.account.setFileOrderManualConfirmation(false);
                }
                if (this.cbExternalAsset.isSelected()) {
                    ExternalAsset acc;
                    this.account.setExternalAsset(true);
                    MxNode node2 = (MxNode)this.cmbDataSource.getSelectionModel().getSelectedItem();
                    this.account.setDataSource(node2);
                    if ("1".equals(node2.getRaw()) && (acc = (ExternalAsset)this.cmbExternalAcc.getSelectionModel().getSelectedItem()) != null) {
                        this.account.setExternalAccnt(acc.getId());
                    }
                }
                this.accountId = this.accountMng.addAccount(this.account);
                this.account.setId(this.accountId);
                if (this.accountId.length() > 0) {
                    Account accountNew;
                    for (String currency : listCur) {
                        this.account.setCurCode(currency);
                        this.fundMng.addFundAccount(this.account);
                        listFund.add(0);
                    }
                    String subAccntId = "";
                    if (listFund.size() == listCur.size()) {
                        subAccntId = this.addSubAccount(this.account);
                    }
                    if (listFund.size() == listCur.size() && !subAccntId.isEmpty()) {
                        for (String currency : listCur) {
                            this.addSubFundAccount(this.account, subAccntId, currency);
                            listStatus.add(0);
                        }
                    }
                    if (listStatus.size() == listCur.size() && !this.txtAcctPwd.getText().isEmpty() && (accountNew = this.accountMng.getAccountById(this.account.getId())) != null) {
                        try {
                            this.accountMng.loginAccntReq(accountNew, MarketUtils.findMarketGrp((List)accountNew.getSecExc()));
                        }
                        catch (MException | Exception e) {
                            logger.error("\u65b0\u5efa\u8d26\u53f7\u540e\u81ea\u52a8\u767b\u5f55\u5931\u8d25", e);
                        }
                    }
                }
                this.toDisable();
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
                Platform.runLater(() -> {
                    this.lbAlert.setText(e.getMessage());
                    this.lbAlert.requestFocus();
                });
                return false;
            }
        }
        try {
            this.result.setValue(Boolean.valueOf(true));
            LinkedList listExc = new LinkedList();
            this.excModel.getCheckItems().forEach(node -> {
                boolean bl = listExc.add(node.getRaw());
            });
            this.account.setSecExc(listExc);
            if (this.cbAuthNeeq.isVisible() && this.cbAuthNeeq.isSelected()) {
                this.account.setNeeqEnable(true);
            } else {
                this.account.setNeeqEnable(false);
            }
            if (this.cbAuthOtc.isVisible() && this.cbAuthOtc.isSelected()) {
                this.account.setOtcEnable(true);
            } else {
                this.account.setOtcEnable(false);
            }
            String excStr = ((Object)listExc).toString();
            excStr = excStr.substring(1, excStr.length() - 1);
            this.account.setSecExchange(excStr);
            LinkedList listCur = new LinkedList();
            this.curModel.getCheckItems().forEach(node -> {
                boolean bl = listCur.add(node.getRaw());
            });
            this.account.setCurrency(listCur);
            this.accountMng.updateAccount(this.account);
            this.toDisable();
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> {
                this.lbAlert.setText(e.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        return true;
    }

    private void addZeroSubFundAccount(Account accnt, String subAccntId) throws MException {
    }

    private void toDisable() {
        this.cmbBrokerName.setDisable(true);
        this.cmbTradeName.setDisable(true);
        this.cmbPartyName.setDisable(true);
        this.txtAccount.setDisable(true);
        this.cmbCurrency.setDisable(true);
        this.txtAcctPwd.setDisable(true);
        this.txtCfmPwd.setDisable(true);
        this.cmbBrokerName.setDisable(true);
        this.cmbTradeName.setDisable(true);
        this.labSuccess.setVisible(true);
        this.btnSaveBasic.setDisable(true);
        this.cbExternalAsset.setDisable(true);
        this.cmbDataSource.setDisable(true);
        this.cmbExternalAcc.setDisable(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)4000.0), e -> {
            this.labSuccess.setVisible(false);
            this.result.setValue(Boolean.valueOf(false));
            this.btnSaveBasic.setDisable(false);
        }, new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
    }

    private String addSubAccount(Account accnt) throws MException {
        SubAccount subAccount = new SubAccount();
        subAccount.setExtAccntId(this.accountId);
        subAccount.setIsZero(1);
        return this.subMng.newSubAccount(subAccount);
    }

    private void addSubFundAccount(Account accnt, String subId, String cur) throws MException {
        SubFundAccount subFund = new SubFundAccount();
        subFund.setExtAccntId(String.valueOf(accnt.getInvestorId()) + "_" + cur);
        subFund.setSubAccntName(accnt.getName());
        subFund.setCurrencyId(cur);
        subFund.setParentAccntId(this.accountId);
        subFund.setParentSubAccntId(subId);
        subFund.setIsZeroAccnt(1);
        subFund.setInvestorId(accnt.getInvestorId());
        if ("FUTURES".equals(MarketUtils.findMarketGrp((List)accnt.getSecExc()))) {
            return;
        }
        this.subFundMng.newSubFundAccnt(subFund, MarketUtils.findMarketGrp((List)accnt.getSecExc()));
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public TextField getTxtCfmPwd() {
        return this.txtCfmPwd;
    }

    public void setTxtCfmPwd(TextField txtCfmPwd) {
        this.txtCfmPwd = txtCfmPwd;
    }

    public ComboBox<TradeCounter> getCmbBrokerName() {
        return this.cmbBrokerName;
    }

    public void setCmbBrokerName(ComboBox<TradeCounter> cmbBrokerName) {
        this.cmbBrokerName = cmbBrokerName;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public Account getAccount() {
        return this.account;
    }
}

