/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.entity.notice.ModifyPasswdReport;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.parts.SetNewPwdDialog;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Duration;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AccountPwdUpdateTabContent
extends MxTabContent {
    @FXML
    private Label info;
    @FXML
    private PasswordField pwdOldPwd;
    @FXML
    private Label lbOldPwdErr;
    @FXML
    private PasswordField pwdPwd;
    @FXML
    private Label lbPwdErr;
    @FXML
    private PasswordField pwdPwdConfirm;
    @FXML
    private Label lbPwdConfirmErr;
    @FXML
    private Label lbPwdRepeatErr;
    @FXML
    public Button btnSavePwd;
    private BooleanProperty save = new SimpleBooleanProperty(false);
    @Inject
    private MxAlert mAlert;
    private static final Logger logger = LogManager.getLogger(SetNewPwdDialog.class);
    private static final int ERROR_ACCT_PWD_OLD = 1045;
    private static final int ERROR_ACCT_PWD_LOGINOUT = 1047;
    private String newPwd;
    private String oldPwd;
    private Account account;
    @Inject
    private AccountMngServiceImpl accountMng;
    private String reason = "";

    @FXML
    public void initialize() {
        this.addCheck();
        this.es.subscribe("server.sub", event -> this.onPush(event));
    }

    private void addCheck() {
        this.pwdOldPwd.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9~!@#$%^&*:<>?,.=_]+$", 32));
        this.pwdPwd.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9~!@#$%^&*:<>?,.=_]+$", 32));
        this.pwdPwdConfirm.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9~!@#$%^&*:<>?,.=_]+$", 32));
        this.registerCheck((Node)this.lbOldPwdErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> true, (Observable[])new Observable[]{this.pwdOldPwd.focusedProperty()}));
        this.registerCheck((Node)this.lbPwdErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.pwdPwd.focusedProperty().get() && !TextFieldUtils.isAccntPwd((TextField)this.pwdPwd).get()) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.pwdPwd.focusedProperty(), TextFieldUtils.isAccntPwd((TextField)this.pwdPwd)}));
        this.registerCheck((Node)this.lbPwdConfirmErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.pwdPwdConfirm.focusedProperty().get() && !this.pwdPwdConfirm.getText().equals(this.pwdPwd.getText())) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.pwdPwdConfirm.focusedProperty()}));
    }

    private void onPush(MEvent event) {
        Object obj = event.getObj();
        String type = event.getStr("push_type");
        if ("412".equals(type)) {
            Platform.runLater(() -> {
                ModifyPasswdReport report = (ModifyPasswdReport)ModifyPasswdReport.class.cast(obj);
                int status = report.getReport().getStatus();
                this.reason = report.getReport().getRespMessage();
                if (status == 1) {
                    this.lbPwdRepeatErr.setText("\u5bc6\u7801\u5df2\u4fee\u6539\u6210\u529f\uff01");
                } else if (status == 1033) {
                    this.lbPwdRepeatErr.setText("\u65e7\u5bc6\u7801\u9519\u8bef\uff01");
                } else {
                    this.lbPwdRepeatErr.setText(this.reason);
                    logger.debug("modify password faild->  status:" + status + " reason:" + this.reason);
                }
                this.showErrorInfo(this.lbPwdRepeatErr);
            });
        }
    }

    public boolean savePwd() throws Exception {
        block5: {
            try {
                if (this.check()) break block5;
                return false;
            }
            catch (MException ex) {
                if (ex.getCode() == 1047) {
                    this.lbPwdRepeatErr.setText("\u8d26\u53f7\u672a\u767b\u5f55\u4e0d\u80fd\u4fee\u6539\u5bc6\u7801");
                    this.showErrorInfo(this.lbPwdRepeatErr);
                } else {
                    logger.error((Object)ex, (Throwable)ex);
                    this.mAlert.alert(Alert.AlertType.ERROR, String.valueOf(ex.getCode()) + ex.getMessage());
                }
                return false;
            }
        }
        this.oldPwd = this.pwdOldPwd.getText();
        this.newPwd = this.pwdPwdConfirm.getText();
        this.accountMng.resetAccontPwd(this.account, MarketUtils.findMarketGrp((List)this.account.getSecExc()), this.oldPwd, this.newPwd);
        return true;
    }

    public void showErrorInfo(Label errInfo) {
        errInfo.requestFocus();
        errInfo.setVisible(true);
        Timeline animation = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)3000.0), e -> errInfo.setVisible(false), new KeyValue[0])});
        animation.setCycleCount(1);
        animation.setAutoReverse(false);
        animation.play();
    }

    private boolean check() {
        if (this.pwdOldPwd.getText().isEmpty()) {
            this.lbOldPwdErr.setOpacity(1.0);
            return false;
        }
        if (!StringUtils.isAccntPwd((String)this.pwdPwd.getText()).booleanValue()) {
            this.lbPwdErr.setOpacity(1.0);
            this.lbPwdConfirmErr.setOpacity(1.0);
            return false;
        }
        if (!this.pwdPwd.getText().equals(this.pwdPwdConfirm.getText())) {
            this.lbPwdConfirmErr.setOpacity(1.0);
            return false;
        }
        return true;
    }

    public final BooleanProperty saveProperty() {
        return this.save;
    }

    public final boolean isSave() {
        return this.saveProperty().get();
    }

    public final void setSave(boolean save) {
        this.saveProperty().set(save);
    }

    public Label getInfo() {
        return this.info;
    }

    public void setInfo(Label info) {
        this.info = info;
    }

    public String getNewPwd() {
        return this.newPwd;
    }

    public void setNewPwd(String newPwd) {
        this.newPwd = newPwd;
    }

    public PasswordField getPwdOldPwd() {
        return this.pwdOldPwd;
    }

    public void setPwdOldPwd(PasswordField pwdOldPwd) {
        this.pwdOldPwd = pwdOldPwd;
    }

    public PasswordField getPwdPwd() {
        return this.pwdPwd;
    }

    public void setPwdPwd(PasswordField pwdPwd) {
        this.pwdPwd = pwdPwd;
    }

    public PasswordField getPwdPwdConfirm() {
        return this.pwdPwdConfirm;
    }

    public void setPwdPwdConfirm(PasswordField pwdPwdConfirm) {
        this.pwdPwdConfirm = pwdPwdConfirm;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }
}

