/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.MxTabContent;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.manage.models.AccountMngModel;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.parts.AccountMngPart;
import cms.tmx.utils.MarketUtils;
import java.util.LinkedList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.WeakChangeListener;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextFormatter;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AccountPwdCheckTabContent
extends MxTabContent {
    @FXML
    private Label lbAccount;
    @FXML
    private Label lbAcctName;
    @FXML
    private PasswordField pfAcctPwd;
    @FXML
    private PasswordField pfCfmPwd;
    private static final Logger logger = LogManager.getLogger(AccountMngPart.class);
    @Inject
    private AccountMngServiceImpl accountMng;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    private Account account;
    private List<Account> accounts;
    @FXML
    private Label lbPwdErr;
    @FXML
    private Label lbAlert;
    @FXML
    private Label lbCmfPwdErr;
    @FXML
    public Button btnCheckPwd;
    @FXML
    public Button btnClose;
    @Inject
    private AccountMngModel accntModel;

    @FXML
    public void initialize() {
        this.initialValues();
        this.bindUIs();
    }

    private void initialValues() {
        this.lbAccount.setText(this.accntModel.getCommonAccount().getInvestorId());
        this.lbAcctName.setText(this.accntModel.getCommonAccount().getName());
    }

    private void bindUIs() {
        this.pfAcctPwd.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9~!@#$%^&*:<>?,.=_]+$", 32));
        this.pfCfmPwd.setTextFormatter((TextFormatter)new MxFormatter("^[A-Za-z0-9~!@#$%^&*:<>?,.=_]+$", 32));
        this.registerCheck((Node)this.lbPwdErr, (ObservableBooleanValue)this.pfAcctPwd.textProperty().isNotEmpty());
        this.registerCheck((Node)this.lbCmfPwdErr, (ObservableBooleanValue)Bindings.createBooleanBinding(() -> {
            if (!this.pfCfmPwd.focusedProperty().get() && !this.pfCfmPwd.getText().equals(this.pfAcctPwd.getText())) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.pfCfmPwd.focusedProperty()}));
        this.lbAlert.focusedProperty().addListener((ChangeListener)new WeakChangeListener((observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.lbAlert.setText("");
            }
        }));
    }

    private boolean check() {
        if (!this.pfCfmPwd.getText().equals(this.pfAcctPwd.getText())) {
            this.lbCmfPwdErr.setOpacity(1.0);
            return false;
        }
        return true;
    }

    public boolean checkPwd() {
        block5: {
            if (this.check()) break block5;
            return false;
        }
        try {
            this.updatePwd(this.account);
            if (this.accounts != null) {
                for (Account account : this.accounts) {
                    this.updatePwd(account);
                }
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            Platform.runLater(() -> {
                this.lbAlert.setText(e.getMessage());
                this.lbAlert.requestFocus();
            });
            return false;
        }
        this.btnClose.fire();
        return true;
    }

    private void updatePwd(Account acc) throws MException {
        LinkedList<Integer> listStatus = new LinkedList<Integer>();
        int id = this.accountMng.checkAccontPwd(this.pfAcctPwd.getText(), acc);
        if (id == 1) {
            Account accountNew;
            for (String curCode : acc.getCurrency()) {
                Account newAccnt = new Account();
                newAccnt.setId(acc.getId());
                newAccnt.setCurCode(curCode);
                newAccnt.setPwd(this.pfAcctPwd.getText());
                newAccnt.setInvestorId(acc.getInvestorId());
                newAccnt.setSecExc(acc.getSecExc());
                newAccnt.setSecExchange(acc.getSecExchange());
                newAccnt.setBrokerId(acc.getBrokerId());
                newAccnt.setCurrency(acc.getCurrency());
                newAccnt.setCurStr(acc.getCurStr());
                newAccnt.setStatus(acc.getStatus());
                newAccnt.setTradePlatformId(acc.getTradePlatformId());
                this.fundMng.updateFundAccount(newAccnt);
                listStatus.add(0);
            }
            if (listStatus.size() == acc.getCurrency().size() && !this.pfAcctPwd.getText().isEmpty() && (accountNew = this.accountMng.getAccountById(acc.getId())) != null) {
                acc.setPwd(accountNew.getPwd());
                this.accountMng.loginAccntReq(acc, MarketUtils.findMarketGrp((List)acc.getSecExc()));
            }
        }
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public PasswordField getPfAcctPwd() {
        return this.pfAcctPwd;
    }

    public void setPfAcctPwd(PasswordField pfAcctPwd) {
        this.pfAcctPwd = pfAcctPwd;
    }

    public PasswordField getPfCfmPwd() {
        return this.pfCfmPwd;
    }

    public void setPfCfmPwd(PasswordField pfCfmPwd) {
        this.pfCfmPwd = pfCfmPwd;
    }

    public Button getBtnClose() {
        return this.btnClose;
    }

    public void setBtnClose(Button btnClose) {
        this.btnClose = btnClose;
    }

    public List<Account> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }
}

