/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Account;
import cms.tmx.entity.Party;
import cms.tmx.entity.TradeCounter;
import cms.tmx.entity.factory.AccountFactory;
import cms.tmx.entity.notice.SynExtFundAccntResp;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.SyncFundAccntServiceImpl;
import cms.tmx.manage.models.TradeCounterServiceImpl;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.AccountPwdDialog;
import cms.tmx.manage.parts.AddAccountDialog;
import cms.tmx.manage.parts.SynHisDialog;
import cms.tmx.manage.parts.UpdateAccountDialog;
import cms.tmx.rights.IUiRightService;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AccountMngPart
extends MxPart {
    @Inject
    private PartyTreeModel partyTree;
    @FXML
    private Button btnQuery;
    @FXML
    private Button btnAdd;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<Account> tableAccount;
    @FXML
    private TableColumn<Account, String> brokerId;
    @FXML
    private TableColumn<Account, String> tradePlatformId;
    @FXML
    private TableColumn<Account, MxNode> flag;
    @FXML
    private TableColumn<Account, MxNode> neeqFlag;
    @FXML
    private TableColumn<Account, MxNode> otcFlag;
    @FXML
    private TextField txtSearch;
    @Inject
    private DialogFactory df;
    @Inject
    private AccountMngServiceImpl accountMng;
    @Inject
    private MObjFactory of;
    @Inject
    private AccountFactory af;
    @Inject
    private MxAlert alert;
    @Inject
    private ExecutorService exe;
    @Inject
    private IUiRightService model;
    @Inject
    private FundAccountMngServiceImpl fundMng;
    @Inject
    protected IFundAccountService fundAccntService;
    @Inject
    private SyncFundAccntServiceImpl syncFundAccntImpl;
    @FXML
    private TableColumn<Account, String> creator;
    @FXML
    private TableColumn<Account, String> updater;
    @FXML
    private TableColumn<Account, String> colOpera;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private TradeCounterServiceImpl counterMng;
    private TreeItem<Party> selectTreeParty;
    private static final Logger logger = LogManager.getLogger(AccountMngPart.class);
    private MxList<Account> mlist = new MxList();
    private ObservableList<Account> filterList = FxUtils.newList();
    private List randomNumList = new ArrayList();
    private ReentrantLock lock = new ReentrantLock();
    private Condition cond = this.lock.newCondition();
    private static final String IS_ENABLE_PARTY = "\u662f\u5426\u542f\u7528\u8be5\u8d26\u53f7";
    private static final String IS_DISABLE_PARTY = "\u662f\u5426\u505c\u7528\u8be5\u8d26\u53f7";
    private static final String IS_OPEN_ORDER = "\u662f\u5426\u5f00\u542f\u8865\u5355";
    private static final String IS_CLOSE_ORDER = "\u662f\u5426\u5173\u95ed\u8865\u5355";
    private static final String IS_CONNECT = "1";
    private static final String IS_STOP = "3";
    private static final String ROUTER_STOP = "4";
    private static final String LOGIN_ERROR_33 = "1033";
    private static final String LOGIN_ERROR_43 = "1043";
    private static final String LOGINING = "1036";
    private static final String LOGIN_TIMEOUT = "1037";
    private static final String UNLOGIN = "1038";
    private static final String LOGOUT = "1039";
    private static final String LOGIN_ERROR_1522 = "1522";
    private static final String LOGIN_ERROR_1523 = "1523";
    private static final String LOGIN_ERROR_1048 = "1048";
    private static final String LOGINING_X002 = "X002";
    private static final String LOGIN_X003 = "X003";
    private static final List<String> UNCONNECT_LIST = Arrays.asList("1033", "1043", "1037", "1038", "1039", "4", "X000", "X001", "X004", "X005", "X006", "1523", "1522", "1048");
    private static final List<String> DISABLE_CHECK_PWD_LIST = Arrays.asList("1", "1036", "3", "X002", "X003");
    private static final List<String> ERROR_MSG_LIST = Arrays.asList("1033", "1043", "1037", "4", "1038", "1039", "1523", "1522", "X006");
    private static final String BTNTXT_IS_CONNECT = "\u767b\u5f55";
    private static final String BTNTXT_IS_NOTCONNECT = "\u65ad\u5f00";
    private static final String ALERT = "\u63d0\u793a";
    private Predicate<Account> pd = account -> {
        String idName = this.txtSearch.getText().trim();
        return account.getInvestorId().contains(idName) || account.getName().contains(idName);
    };
    private InvalidationListener loginLinster = ob -> this.reloadStatus(this.filterList);
    private InvalidationListener accModel = ob -> Platform.runLater(() -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableAccount.refresh();
        this.tableAccount.sort();
    });
    private boolean settingFlag = true;
    private boolean statusFlag = true;
    private boolean pwdFlag = true;
    private boolean loginFlag = true;
    private boolean synCouponFlag = false;
    private boolean extOrderFlag = true;
    private String id = "";
    private int randomNum;

    @FXML
    public void initialize() {
        this.accountMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.loginLinster));
        this.createTableView();
        this.bingUI();
        this.initTree();
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.exe.execute(() -> {
            if (this.treeParty.getRoot() == null) {
                return;
            }
            try {
                this.counterMng.getTradeCounterList();
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
            }
            this.treeParty.getSelectionModel().select(0);
            this.selectTreeParty = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
            this.query(((Party)this.selectTreeParty.getValue()).getId());
        });
        this.checkRights();
    }

    private void checkRights() {
        this.model.registerCheck((Control)this.btnQuery, new String[]{"queryAccountControl"});
        this.model.registerCheckAll((Control)this.btnAdd, new String[]{"addAccountControl", "saveAccountBasic"});
        this.statusFlag = this.model.registerCheck(new String[]{"enableAccountControl"});
        this.settingFlag = this.model.registerCheck(new String[]{"saveAccountBasic", "lookAccountBasic", "querySecAccountControl", "addSecAccountControl", "delSecAccountControl"});
        this.settingFlag = this.settingFlag && this.model.registerCheck(new String[]{"updateAccountControl"});
        this.pwdFlag = this.model.registerCheck(new String[]{"checkPwdControl"});
    }

    private void initTree() {
        try {
            TreeItem<Party> root = this.partyTree.getRoot();
            this.treeParty.setRoot(root);
        }
        catch (MException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void bingUI() {
        this.txtSearch.textProperty().addListener(this.accModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter(32));
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue(), (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.btnAdd.disableProperty().bind((ObservableValue)this.treeParty.getSelectionModel().selectedItemProperty().isNull());
        this.treeParty.setOnMouseClicked(event -> {
            if (this.treeParty.getSelectionModel().getSelectedItem() == null || this.selectTreeParty == this.treeParty.getSelectionModel().getSelectedItem()) {
                return;
            }
            this.onItemClicked((TreeItem<Party>)((TreeItem)this.treeParty.getSelectionModel().getSelectedItem()));
        });
    }

    @FXML
    private void rightRefresh() {
        try {
            this.refreshTree();
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableAccount);
    }

    private void onItemClicked(TreeItem<Party> item) {
        this.selectTreeParty = item;
        this.query(((Party)this.selectTreeParty.getValue()).getId());
    }

    private void query(String partyId) {
        try {
            Party party = (Party)((TreeItem)this.treeParty.getSelectionModel().getSelectedItem()).getValue();
            if (party == null) {
                return;
            }
            ArrayList<Account> list = new ArrayList<Account>();
            list.addAll((Collection<Account>)this.accountMng.getAccountListByParty(party.getId(), PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_ONE));
            list.addAll((Collection<Account>)this.accountMng.getAccountListByParty(party.getId(), PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_OFFSPRING));
            this.filterList.clear();
            LinkedList<String> listIds = new LinkedList<String>();
            list.forEach(item -> {
                this.filterList.add(item);
                listIds.add(item.getCreator());
                listIds.add(item.getUpdater());
            });
            this.userMng.queryUserNameMap(listIds);
            this.reloadStatus(this.filterList);
            this.mlist.clear();
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> {
                if (Integer.parseInt(o1.getId().substring(1)) < Integer.parseInt(o2.getId().substring(1))) {
                    return 1;
                }
                return -1;
            });
            this.tableAccount.sort();
            this.tableAccount.refresh();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private synchronized void reloadStatus(ObservableList<Account> filterList) {
        try {
            this.accountMng.queryLoginStatus(filterList);
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
        Platform.runLater(() -> this.tableAccount.refresh());
    }

    private void rebuildFlagBtn(Account selectTableAccount, Label loginFlag, Label pwdFlag, Label synCouponLab, HBox paddedLabel, Label orderFlagLab) {
        if (IS_CONNECT.equals(selectTableAccount.getFlag().getRaw()) || UNCONNECT_LIST.contains(selectTableAccount.getFlag().getRaw()) || LOGINING_X002.equals(selectTableAccount.getFlag().getRaw()) || LOGIN_X003.equals(selectTableAccount.getFlag().getRaw())) {
            loginFlag.setDisable(false);
        } else if (LOGINING.equals(selectTableAccount.getFlag().getRaw())) {
            loginFlag.setDisable(true);
        }
        if (IS_CONNECT.equals(selectTableAccount.getFlag().getRaw()) && IS_CONNECT.equals(selectTableAccount.getFlag().getRaw()) && "CCS".equals(MarketUtils.findMarketGrp((List)selectTableAccount.getSecExc()))) {
            synCouponLab.setDisable(false);
        } else {
            synCouponLab.setDisable(true);
        }
        if (IS_CONNECT.equals(selectTableAccount.getFlag().getRaw()) || LOGIN_X003.equals(selectTableAccount.getFlag().getRaw())) {
            loginFlag.setText(BTNTXT_IS_NOTCONNECT);
        } else if (UNCONNECT_LIST.contains(selectTableAccount.getFlag().getRaw()) || LOGINING.equals(selectTableAccount.getFlag().getRaw()) || LOGINING_X002.equals(selectTableAccount.getFlag().getRaw())) {
            loginFlag.setText(BTNTXT_IS_CONNECT);
        } else {
            loginFlag.setText("      ");
        }
    }

    private void createTableView() {
        this.addViwer(this.tableAccount);
        this.tableAccount.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableAccount);
        this.brokerId.setCellValueFactory(data -> {
            SimpleStringProperty name = new SimpleStringProperty("");
            Account account = (Account)data.getValue();
            for (TradeCounter item : this.counterMng.getBroker()) {
                if (!item.getBrokerId().equals(account.getBrokerId())) continue;
                name.setValue(item.getBrokerName());
                break;
            }
            return name;
        });
        this.tradePlatformId.setCellValueFactory(data -> {
            SimpleStringProperty name = new SimpleStringProperty("");
            Account account = (Account)data.getValue();
            for (TradeCounter item : this.counterMng.getTradeCounterList(account.getBrokerId())) {
                if (!item.getId().equals(account.getTradePlatformId())) continue;
                name.setValue(item.getName());
                break;
            }
            return name;
        });
        this.flag.setCellValueFactory(data -> ((Account)data.getValue()).flagProperty());
        this.flag.setCellFactory(data -> new FlagTableCell());
        this.neeqFlag.setCellValueFactory(data -> ((Account)data.getValue()).neeqFlagProperty());
        this.neeqFlag.setCellFactory(data -> new NeeqFlagTableCell());
        this.otcFlag.setCellValueFactory(data -> ((Account)data.getValue()).otcFlagProperty());
        this.otcFlag.setCellFactory(data -> new OtcFlagTableCell());
        this.creator.setCellValueFactory(data -> this.userMng.getUserName(((Account)data.getValue()).getCreator()));
        this.updater.setCellValueFactory(data -> this.userMng.getUserName(((Account)data.getValue()).getUpdater()));
        this.colOpera.setCellFactory(data -> new OperaCell(this.stage, this.tableAccount));
        this.tableAccount.setItems(this.mlist.getList());
    }

    @FXML
    private void add() {
        AddAccountDialog obj = (AddAccountDialog)((Object)this.of.create(AddAccountDialog.class));
        TreeItem treeItem = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        obj.setParty(treeItem == null ? (Party)this.treeParty.getRoot().getValue() : (Party)treeItem.getValue());
        MxDialog dialog = this.df.create((DialogObj)obj, "\u65b0\u589e\u8d26\u53f7");
        dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
        dialog.getButton(ButtonType.CANCEL).setVisible(false);
        dialog.launch();
        if (!obj.getAccountId().isEmpty()) {
            String accountId;
            if (this.selectTreeParty != null) {
                this.query(((Party)this.selectTreeParty.getValue()).getId());
            }
            if ((accountId = obj.getAccountId()) != null) {
                this.tableAccount.getSelectionModel().select((Object)((Account)this.tableAccount.getItems().parallelStream().filter(item -> item.getId().equals(accountId)).collect(Collectors.toList()).get(0)));
            }
        }
    }

    private void update() {
        Account item = (Account)this.tableAccount.getSelectionModel().getSelectedItem();
        Account account = this.af.create();
        account.update((Object)item);
        UpdateAccountDialog obj = (UpdateAccountDialog)((Object)this.of.create(UpdateAccountDialog.class));
        obj.setAccountUpdate(account);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u8d26\u53f7");
        dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
        dialog.getButton(ButtonType.CANCEL).setVisible(false);
        dialog.launch();
        this.query(((Party)this.selectTreeParty.getValue()).getId());
    }

    @FXML
    private void refreshTree() throws MException {
        try {
            TreeItem<Party> root = this.partyTree.refresh();
            this.treeParty.setRoot(root);
            root.setExpanded(true);
            if (this.selectTreeParty == null) {
                return;
            }
            this.treeParty.getSelectionModel().select(this.selectTreeParty);
            this.query(((Party)this.selectTreeParty.getValue()).getId());
            this.tableAccount.refresh();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void close() {
        try {
            if (this.alert.alert(Alert.AlertType.CONFIRMATION, IS_DISABLE_PARTY, ALERT)) {
                Account account = (Account)this.tableAccount.getSelectionModel().getSelectedItem();
                int status = this.accountMng.enableAccount(false, account.getId());
                if (status == 1) {
                    this.updateFundAccnt(account, false);
                }
                this.accountMng.logOutAccntReq(account, MarketUtils.findMarketGrp((List)account.getSecExc()));
            }
            if (this.selectTreeParty != null) {
                this.query(((Party)this.selectTreeParty.getValue()).getId());
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void open() {
        int status = 0;
        try {
            if (this.alert.alert(Alert.AlertType.CONFIRMATION, IS_ENABLE_PARTY, ALERT)) {
                Account account = (Account)this.tableAccount.getSelectionModel().getSelectedItem();
                status = this.accountMng.enableAccount(true, account.getId());
                if (status == 1) {
                    this.updateFundAccnt(account, true);
                }
                if (!StringUtils.isEmpty((String)account.getPwd())) {
                    this.accountMng.loginAccntReq(account, MarketUtils.findMarketGrp((List)account.getSecExc()));
                }
            }
            if (this.selectTreeParty != null) {
                this.query(((Party)this.selectTreeParty.getValue()).getId());
            }
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void updateFundAccnt(Account account, boolean type) throws MException {
        MxNode node = MxNodeFactory.create((String)"accnt_status", (String)IS_CONNECT);
        MxNode neeqFlagNode = new MxNode();
        MxNode otcFlagNode = new MxNode();
        MxNode flagNode = new MxNode();
        for (String curCode : account.getCurrency()) {
            Account newAccnt = new Account();
            newAccnt.setId(account.getId());
            newAccnt.setCurCode(curCode);
            newAccnt.setInvestorId(account.getInvestorId());
            newAccnt.setSecExc(account.getSecExc());
            newAccnt.setSecExchange(account.getSecExchange());
            newAccnt.setBrokerId(account.getBrokerId());
            newAccnt.setCurrency(account.getCurrency());
            newAccnt.setCurStr(account.getCurStr());
            flagNode.setRaw(account.getFlag().getRaw());
            newAccnt.setFlag(flagNode);
            neeqFlagNode.setRaw(account.getNeeqFlag().getRaw());
            otcFlagNode.setRaw(account.getOtcFlag().getRaw());
            newAccnt.setNeeqFlag(neeqFlagNode);
            newAccnt.setOtcFlag(otcFlagNode);
            if (!type) {
                node.setRaw(IS_STOP);
                newAccnt.setStatus(node);
            } else if (type) {
                node.setRaw(IS_CONNECT);
                newAccnt.setStatus(node);
            }
            this.fundMng.updateFundAccount(newAccnt);
        }
    }

    private void pwdCheck() {
        Account item = (Account)this.tableAccount.getSelectionModel().getSelectedItem();
        Account account = this.af.create();
        account.update((Object)item);
        AccountPwdDialog obj = (AccountPwdDialog)((Object)this.of.create(AccountPwdDialog.class));
        obj.setAccount(account);
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (Account acc : this.mlist.getList()) {
            if (!acc.getInvestorId().split("@")[0].equals(account.getInvestorId().split("@")[0]) || account == acc) continue;
            accounts.add(acc);
        }
        if (!accounts.isEmpty()) {
            obj.setAccounts(accounts);
        }
        MxDialog dialog = this.df.create((DialogObj)obj, "\u5bc6\u7801\u6821\u9a8c");
        Button button = dialog.getButton(ButtonType.CANCEL);
        button.setVisible(false);
        obj.setBtnTab(button);
        dialog.getButton(ButtonType.OK).setVisible(false);
        dialog.launch();
        this.query(((Party)this.selectTreeParty.getValue()).getId());
    }

    private void loginAccnt() {
        Account account = (Account)this.tableAccount.getSelectionModel().getSelectedItem();
        if (account == null) {
            return;
        }
        if (account.getPwd().isEmpty()) {
            this.alert.alert(Alert.AlertType.ERROR, "\u5bc6\u7801\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8fdb\u884c\u5bc6\u7801\u6821\u9a8c\uff01");
            return;
        }
        if (account.getStatus().getRaw().equals(IS_STOP)) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8be5\u8d26\u6237\u5df2\u505c\u7528");
            return;
        }
        try {
            String flag = account.getFlag().getRaw();
            this.accountMng.queryAfterOpt();
            if (IS_CONNECT.equals(flag) || LOGIN_X003.equals(flag)) {
                this.accountMng.logOutAccntReq(account, MarketUtils.findMarketGrp((List)account.getSecExc()));
            } else {
                this.accountMng.loginAccntReq(account, MarketUtils.findMarketGrp((List)account.getSecExc()));
            }
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            if (e.getCode() == 998) {
                this.alert.alert(Alert.AlertType.ERROR, "\u8d26\u6237\u672a\u542f\u7528");
            }
            if (e.getCode() == 997) {
                this.alert.alert(Alert.AlertType.ERROR, "\u4ea4\u6613\u5e73\u53f0\u4e0d\u5b58\u5728");
            }
            if (e.getCode() == 999) {
                this.alert.alert(Alert.AlertType.ERROR, "\u8d26\u6237\u4e0d\u9700\u8981\u767b\u9646");
            }
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void synCoupon() {
        Account account = (Account)this.tableAccount.getSelectionModel().getSelectedItem();
        String marketGrp = MarketUtils.findMarketGrp((List)account.getSecExc());
        this.id = account.getId();
        this.randomNum = new Random().nextInt(999999999);
        this.randomNumList.add(String.valueOf(this.randomNum));
        System.out.println(this.randomNumList.toString());
        try {
            this.syncFundAccntImpl.syncExtFundAccnt(marketGrp, this.id, this.randomNum);
        }
        catch (MException e) {
            System.err.println("\u624b\u52a8\u540c\u6b65\u8d44\u5238err" + (Object)((Object)e));
            e.printStackTrace();
        }
    }

    private void synHis() {
        Account account = (Account)this.tableAccount.getSelectionModel().getSelectedItem();
        SynHisDialog obj = (SynHisDialog)((Object)this.of.create(SynHisDialog.class));
        obj.setAccount(account);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u540c\u6b65\u5386\u53f2 " + account.getId());
        dialog.getButton(ButtonType.CLOSE).setVisible(false);
        dialog.launch();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void flagUpdate(boolean orderFlag) {
        try {
            Account account = (Account)this.tableAccount.getSelectionModel().getSelectedItem();
            if (account == null) {
                return;
            }
            if (orderFlag) {
                if (!this.alert.alert(Alert.AlertType.CONFIRMATION, IS_OPEN_ORDER, ALERT)) return;
                account.setExternalOrderFlags(true);
                this.accountMng.updateAccount(account);
            } else {
                if (!this.alert.alert(Alert.AlertType.CONFIRMATION, IS_CLOSE_ORDER, ALERT)) return;
                account.setExternalOrderFlags(false);
                this.accountMng.updateAccount(account);
            }
            if (this.selectTreeParty == null) return;
            this.query(((Party)this.selectTreeParty.getValue()).getId());
            return;
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void onPush(MEvent event) {
        Object obj = event.getObj();
        String type = event.getStr("push_type");
        if ("411".equals(type)) {
            SynExtFundAccntResp report = (SynExtFundAccntResp)SynExtFundAccntResp.class.cast(obj);
            int status = report.getReport().getStatus().getStatus();
            String reason = report.getReport().getStatus().getReason();
            if (this.randomNumList.contains(String.valueOf(report.getReport().getSeq())) && status == 1) {
                System.err.println("success local:" + this.randomNum + ",receive:" + report.getReport().getSeq());
                System.out.println(this.randomNumList.toString());
                this.randomNumList.remove(String.valueOf(report.getReport().getSeq()));
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.INFORMATION, "\u540c\u6b65\u8d44\u5238\u6210\u529f"));
            } else {
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u540c\u6b65\u8d44\u5238\u5931\u8d25   \u539f\u56e0\uff1a" + reason));
                System.err.println("faild local:" + this.randomNum + ",receive:" + report.getReport().getSeq());
                logger.debug(" faild->  status:" + status + " reason:" + reason);
            }
            return;
        }
    }

    private class FlagTableCell<S, T>
    extends TableCell<Account, T> {
        Account accnt;

        private FlagTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                this.accnt = (Account)Account.class.cast(this.getTableRow().getItem());
                if (this.accnt == null) {
                    return;
                }
                if (this.accnt.getInvestorId().endsWith("4708")) {
                    System.out.println("");
                }
                Tooltip tooltip = new Tooltip();
                if (this.accnt.getFlag() != null) {
                    if (ERROR_MSG_LIST.contains(this.accnt.getFlag().getRaw()) && !StringUtils.isEmpty((String)this.accnt.getLoginErrorInfo())) {
                        tooltip.setText(String.valueOf(this.accnt.getFlag().getValue()) + "(" + this.accnt.getLoginErrorInfo() + ")");
                    } else {
                        tooltip.setText(this.accnt.getFlag().getValue());
                    }
                    this.setTooltip(tooltip);
                    this.setText(tooltip.getText());
                } else {
                    tooltip = null;
                    this.setTooltip(tooltip);
                    this.setText("");
                }
            }
        }
    }

    private class NeeqFlagTableCell<S, T>
    extends TableCell<Account, T> {
        Account accnt;

        private NeeqFlagTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                this.accnt = (Account)Account.class.cast(this.getTableRow().getItem());
                if (this.accnt == null) {
                    return;
                }
                Tooltip tooltip = new Tooltip();
                if (!this.accnt.isNeeqEnable()) {
                    tooltip = null;
                    this.setTooltip(tooltip);
                    this.setText("");
                    return;
                }
                if (this.accnt.getNeeqFlag() != null) {
                    if ("X006".equals(this.accnt.getNeeqFlag().getRaw()) && !StringUtils.isEmpty((String)this.accnt.getNewLoginErrorInfo())) {
                        tooltip.setText(String.valueOf(this.accnt.getNeeqFlag().getValue()) + "(" + this.accnt.getNewLoginErrorInfo() + ")");
                    } else {
                        tooltip.setText(this.accnt.getNeeqFlag().getValue());
                    }
                    this.setTooltip(tooltip);
                    this.setText(tooltip.getText());
                } else {
                    tooltip = null;
                    this.setTooltip(tooltip);
                    this.setText("");
                }
            }
        }
    }

    private class OperaCell
    extends TableCell<Account, String> {
        final HBox paddedLabel = new HBox();
        final Label updateLab = new Label("\u8bbe\u7f6e");
        final Label statusLab = new Label("\u65e0");
        final Label pwdLab = new Label("\u5bc6\u7801\u6821\u9a8c");
        final Label loginLab = new Label("\u65e0");
        final Label synCouponLab = new Label("\u540c\u6b65\u8d44\u5238");
        final Label orderFlagLab = new Label("\u5173\u95ed\u8865\u5355");

        OperaCell(Stage stage, final TableView table) {
            this.paddedLabel.setSpacing(20.0);
            this.updateLab.setStyle("-fx-cursor:hand;");
            this.statusLab.setStyle("-fx-cursor:hand;");
            this.pwdLab.setStyle("-fx-cursor:hand;");
            this.loginLab.setStyle("-fx-cursor:hand;");
            this.synCouponLab.setStyle("-fx-cursor:hand;");
            this.orderFlagLab.setStyle("-fx-cursor:hand;");
            this.updateLab.getStyleClass().add((Object)"text-blue");
            this.statusLab.getStyleClass().add((Object)"text-blue");
            this.pwdLab.getStyleClass().add((Object)"text-blue");
            this.loginLab.getStyleClass().add((Object)"text-blue");
            this.synCouponLab.getStyleClass().add((Object)"text-blue");
            this.orderFlagLab.getStyleClass().add((Object)"text-blue");
            if (AccountMngPart.this.settingFlag) {
                this.paddedLabel.getChildren().add((Object)this.updateLab);
            }
            if (AccountMngPart.this.statusFlag) {
                this.paddedLabel.getChildren().add((Object)this.statusLab);
            }
            if (AccountMngPart.this.pwdFlag) {
                this.paddedLabel.getChildren().add((Object)this.pwdLab);
            }
            if (AccountMngPart.this.loginFlag) {
                this.paddedLabel.getChildren().add((Object)this.loginLab);
            }
            this.paddedLabel.getChildren().add((Object)this.synCouponLab);
            if (AccountMngPart.this.extOrderFlag) {
                this.paddedLabel.getChildren().add((Object)this.orderFlagLab);
            }
            this.updateLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    AccountMngPart.this.update();
                }
            });
            this.statusLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    if (OperaCell.this.getTableRow().getItem() instanceof Account) {
                        Account p = (Account)OperaCell.this.getTableRow().getItem();
                        if ("\u505c\u7528".equals(p.getStatus().getValue())) {
                            OperaCell.this.statusLab.setText("\u542f\u7528");
                            AccountMngPart.this.open();
                        } else {
                            OperaCell.this.statusLab.setText("\u505c\u7528");
                            AccountMngPart.this.close();
                        }
                    }
                }
            });
            this.pwdLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    AccountMngPart.this.pwdCheck();
                }
            });
            this.loginLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    AccountMngPart.this.loginAccnt();
                }
            });
            this.synCouponLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    AccountMngPart.this.synCoupon();
                }
            });
            this.orderFlagLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    if (OperaCell.this.getTableRow().getItem() instanceof Account) {
                        Account p = (Account)OperaCell.this.getTableRow().getItem();
                        if (p.isExternalOrderFlags()) {
                            OperaCell.this.orderFlagLab.setText("\u5173\u95ed\u8865\u5355");
                            AccountMngPart.this.flagUpdate(false);
                        } else {
                            OperaCell.this.orderFlagLab.setText("\u5f00\u542f\u8865\u5355");
                            AccountMngPart.this.flagUpdate(true);
                        }
                    }
                }
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                if (this.getTableRow() != null && this.getTableRow().getItem() instanceof Account) {
                    Account p = (Account)this.getTableRow().getItem();
                    if ("\u505c\u7528".equals(p.getStatus().getValue())) {
                        this.statusLab.setText("\u542f\u7528");
                        this.pwdLab.setDisable(true);
                        this.orderFlagLab.setDisable(true);
                    } else {
                        this.statusLab.setText("\u505c\u7528");
                        this.pwdLab.setDisable(false);
                        this.orderFlagLab.setDisable(false);
                    }
                    if (p.isExternalOrderFlags()) {
                        this.orderFlagLab.setText("\u5173\u95ed\u8865\u5355");
                    } else {
                        this.orderFlagLab.setText("\u5f00\u542f\u8865\u5355");
                    }
                    if ("99999-02-01".equals(p.getTradePlatformId()) || "99999-02-02".equals(p.getTradePlatformId()) || "99999-02-03".equals(p.getTradePlatformId())) {
                        this.orderFlagLab.setDisable(true);
                    }
                    AccountMngPart.this.rebuildFlagBtn(p, this.loginLab, this.pwdLab, this.synCouponLab, this.paddedLabel, this.orderFlagLab);
                }
                this.setGraphic((Node)this.paddedLabel);
            } else {
                this.setGraphic(null);
            }
        }
    }

    private class OtcFlagTableCell<S, T>
    extends TableCell<Account, T> {
        Account accnt;

        private OtcFlagTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                this.accnt = (Account)Account.class.cast(this.getTableRow().getItem());
                if (this.accnt == null) {
                    return;
                }
                Tooltip tooltip = new Tooltip();
                if (!this.accnt.isOtcEnable()) {
                    tooltip = null;
                    this.setTooltip(tooltip);
                    this.setText("");
                    return;
                }
                if (this.accnt.getOtcFlag() != null) {
                    if ("X006".equals(this.accnt.getOtcFlag().getRaw()) && !StringUtils.isEmpty((String)this.accnt.getOtcLoginErrorInfo())) {
                        tooltip.setText(String.valueOf(this.accnt.getOtcFlag().getValue()) + "(" + this.accnt.getOtcLoginErrorInfo() + ")");
                    } else {
                        tooltip.setText(this.accnt.getOtcFlag().getValue());
                    }
                    this.setTooltip(tooltip);
                    this.setText(tooltip.getText());
                } else {
                    tooltip = null;
                    this.setTooltip(tooltip);
                    this.setText("");
                }
            }
        }
    }
}

