/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.api.mng.IAccountGrpApi;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.AccountGroup;
import cms.tmx.entity.Party;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.AccountGrpMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.AddAccountGrpDialog;
import cms.tmx.manage.parts.UpdateAccountGrpDialog;
import cms.tmx.rights.IUiRightService;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AccountGrpMngPart
extends MxPart {
    @Inject
    private PartyTreeModel partyTree;
    @FXML
    private Button btnQuery;
    @FXML
    private Button btnUpdate;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnAdd;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<AccountGroup> tableAccountGrp;
    @FXML
    private TextField txtSearch;
    @Inject
    private DialogFactory df;
    @Inject
    private AccountGrpMngServiceImpl accountGrpMng;
    @Inject
    private IAccountGrpApi accountGrpApi;
    @Inject
    private MObjFactory of;
    @Inject
    private MxAlert alert;
    @Inject
    private ExecutorService exe;
    @Inject
    private IUiRightService model;
    @FXML
    private TableColumn<AccountGroup, String> creator;
    @FXML
    private TableColumn<AccountGroup, String> lastUpdater;
    @Inject
    private UserMngServiceImpl userMng;
    private AccountGroup selectTableAccountGroup;
    private TreeItem<Party> selectTreeParty;
    private static final String IS_DELETE = "\u662f\u5426\u786e\u8ba4\u5220\u9664\u8be5\u8d26\u6237\u7ec4";
    private static final Logger logger = LogManager.getLogger(AccountGrpMngPart.class);
    private MxList<AccountGroup> mlist = new MxList();
    private ObservableList<AccountGroup> filterList = FxUtils.newList();
    private Predicate<AccountGroup> pd = account -> {
        String idName = this.txtSearch.getText().trim();
        return account.getName().contains(idName);
    };
    private InvalidationListener accModel = ob -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableAccountGrp.sort();
    };

    @FXML
    public void initialize() {
        this.createTableView();
        this.bingUI();
        this.initTree();
        this.exe.execute(() -> {
            if (this.treeParty.getRoot() == null) {
                return;
            }
            this.treeParty.getSelectionModel().select(0);
            this.selectTreeParty = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
            this.query(((Party)this.selectTreeParty.getValue()).getId());
        });
        this.checkRights();
    }

    private void checkRights() {
        this.model.registerCheck((Control)this.btnAdd, new String[]{"addAccountGrpControl"});
        this.model.registerCheck((Control)this.btnUpdate, new String[]{"updateAccountGrpControl"});
        this.model.registerCheck((Control)this.btnDelete, new String[]{"deleteAccountGrpControl"});
        this.model.registerCheck((Control)this.btnQuery, new String[]{"queryAccountGrpControl"});
    }

    private void initTree() {
        try {
            TreeItem<Party> root = this.partyTree.getRoot();
            this.treeParty.setRoot(root);
        }
        catch (MException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void bingUI() {
        this.txtSearch.textProperty().addListener(this.accModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter(32));
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue(), (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.btnUpdate.disableProperty().bind((ObservableValue)this.tableAccountGrp.getSelectionModel().selectedItemProperty().isNull());
        this.btnDelete.disableProperty().bind((ObservableValue)this.tableAccountGrp.getSelectionModel().selectedItemProperty().isNull());
        this.btnAdd.disableProperty().bind((ObservableValue)this.treeParty.getSelectionModel().selectedItemProperty().isNull());
        this.treeParty.setOnMouseClicked(event -> {
            if (this.treeParty.getSelectionModel().getSelectedItem() == null || this.selectTreeParty == this.treeParty.getSelectionModel().getSelectedItem()) {
                return;
            }
            this.selectTableAccountGroup = null;
            this.onItemClicked((TreeItem<Party>)((TreeItem)this.treeParty.getSelectionModel().getSelectedItem()));
        });
        this.tableAccountGrp.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> {
            if (now != null) {
                this.selectTableAccountGroup = (AccountGroup)this.tableAccountGrp.getSelectionModel().getSelectedItem();
            }
        });
    }

    @FXML
    private void rightRefresh() {
        try {
            this.refreshTree();
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableAccountGrp);
    }

    private void onItemClicked(TreeItem<Party> item) {
        this.selectTreeParty = item;
        this.query(((Party)this.selectTreeParty.getValue()).getId());
    }

    private void query(String partyId) {
        try {
            Party party = (Party)((TreeItem)this.treeParty.getSelectionModel().getSelectedItem()).getValue();
            if (party == null) {
                return;
            }
            List<AccountGroup> listGrp = this.accountGrpMng.getAccountGrpListByParty(party.getId());
            this.filterList.clear();
            LinkedList<String> listIds = new LinkedList<String>();
            listGrp.forEach(item -> {
                this.filterList.add(item);
                listIds.add(item.getCreator());
                listIds.add(item.getLastUpdater());
            });
            this.userMng.queryUserNameMap(listIds);
            this.mlist.clear();
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> {
                if (Integer.parseInt(o1.getId().substring(2)) < Integer.parseInt(o2.getId().substring(2))) {
                    return 1;
                }
                return -1;
            });
            this.tableAccountGrp.refresh();
            if (this.selectTableAccountGroup != null) {
                this.tableAccountGrp.getSelectionModel().select((Object)this.selectTableAccountGroup);
            }
        }
        catch (MException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void createTableView() {
        this.addViwer(this.tableAccountGrp);
        this.tableAccountGrp.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableAccountGrp);
        this.creator.setCellValueFactory(data -> this.userMng.getUserName(((AccountGroup)data.getValue()).getCreator()));
        this.lastUpdater.setCellValueFactory(data -> this.userMng.getUserName(((AccountGroup)data.getValue()).getLastUpdater()));
        this.tableAccountGrp.setItems(this.mlist.getList());
    }

    @FXML
    private void add() {
        AddAccountGrpDialog obj = (AddAccountGrpDialog)((Object)this.of.create(AddAccountGrpDialog.class));
        TreeItem treeItem = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
        obj.setParty(treeItem == null ? (Party)this.treeParty.getRoot().getValue() : (Party)treeItem.getValue());
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u6dfb\u52a0\u8d26\u53f7\u7ec4");
            dialog.setBtnText(ButtonType.OK, "\u4fdd\u5b58");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.setFirstNode((Node)obj.getTxtName());
            if (dialog.launch().equals(ButtonType.OK)) {
                this.selectTableAccountGroup = obj.getAccountGroup();
                this.refreshTable();
            }
        }
        catch (Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void refreshTable() {
        if (this.selectTreeParty == null) {
            return;
        }
        this.query(((Party)this.selectTreeParty.getValue()).getId());
        this.tableAccountGrp.getSelectionModel().select((Object)this.selectTableAccountGroup);
        this.tableAccountGrp.scrollTo((Object)this.selectTableAccountGroup);
    }

    @FXML
    private void update() {
        UpdateAccountGrpDialog obj = (UpdateAccountGrpDialog)((Object)this.of.create(UpdateAccountGrpDialog.class));
        AccountGroup ag = (AccountGroup)this.of.create(AccountGroup.class);
        ag.update(this.tableAccountGrp.getSelectionModel().getSelectedItem());
        obj.setAccountGroup(ag);
        try {
            MxDialog dialog = this.df.create((DialogObj)obj, "\u4fee\u6539\u8d26\u6237\u7ec4");
            dialog.setBtnText(ButtonType.OK, "\u4fdd\u5b58");
            dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
            dialog.setFirstNode((Node)obj.getTxtName());
            if (dialog.launch().equals(ButtonType.OK)) {
                this.selectTableAccountGroup = obj.getAccountGroup();
                this.refreshTable();
            }
        }
        catch (Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    private void delete() {
        try {
            if (this.alert.alert(Alert.AlertType.CONFIRMATION, IS_DELETE, "")) {
                this.accountGrpApi.deleteAccountGrp(this.selectTableAccountGroup.getId());
                this.selectTableAccountGroup = null;
                if (this.selectTreeParty == null) {
                    return;
                }
                this.treeParty.getSelectionModel().select(this.selectTreeParty);
                this.query(((Party)this.selectTreeParty.getValue()).getId());
            }
        }
        catch (MException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    private void refreshTree() throws MException {
        try {
            TreeItem<Party> root = this.partyTree.refresh();
            this.treeParty.setRoot(root);
            root.setExpanded(true);
            if (this.selectTreeParty == null) {
                return;
            }
            this.treeParty.getSelectionModel().select(this.selectTreeParty);
            this.query(((Party)this.selectTreeParty.getValue()).getId());
        }
        catch (MException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }
}

