/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.table.TableUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Account;
import cms.tmx.entity.Party;
import cms.tmx.entity.TradeCounter;
import cms.tmx.entity.factory.AccountFactory;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.PartyTreeModel;
import cms.tmx.manage.models.TradeCounterServiceImpl;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.manage.parts.AccountChangeHistoryDialog;
import cms.tmx.manage.parts.ChangeAccountDialog;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javax.inject.Inject;

public class AccountChangeMngPart
extends MxPart {
    @FXML
    private Button btnQuery;
    @FXML
    private TreeView<Party> treeParty;
    @FXML
    private TableView<Account> tableAccount;
    @FXML
    private TableColumn<Account, String> brokerId;
    @FXML
    private TableColumn<Account, String> tradePlatformId;
    @FXML
    private TableColumn<Account, MxNode> flag;
    @FXML
    private TableColumn<Account, MxNode> neeqFlag;
    @FXML
    private TableColumn<Account, MxNode> otcFlag;
    @FXML
    private TextField txtSearch;
    @FXML
    private TableColumn<Account, String> creator;
    @FXML
    private TableColumn<Account, String> updater;
    @FXML
    private TableColumn<Account, String> colOpera;
    @Inject
    private PartyTreeModel partyTree;
    @Inject
    private DialogFactory df;
    @Inject
    private AccountMngServiceImpl accountMng;
    @Inject
    private MObjFactory of;
    @Inject
    private AccountFactory af;
    @Inject
    private MxAlert alert;
    @Inject
    private ExecutorService exe;
    @Inject
    protected IFundAccountService fundAccntService;
    @Inject
    private UserMngServiceImpl userMng;
    @Inject
    private TradeCounterServiceImpl counterMng;
    private TreeItem<Party> selectTreeParty;
    private MxList<Account> mlist = new MxList();
    private ObservableList<Account> filterList = FxUtils.newList();
    private static final String ROUTER_STOP = "4";
    private static final String LOGIN_ERROR_33 = "1033";
    private static final String LOGIN_ERROR_43 = "1043";
    private static final String LOGIN_TIMEOUT = "1037";
    private static final String UNLOGIN = "1038";
    private static final String LOGOUT = "1039";
    private static final String LOGIN_ERROR_1522 = "1522";
    private static final String LOGIN_ERROR_1523 = "1523";
    private static final List<String> ERROR_MSG_LIST = Arrays.asList("1033", "1043", "1037", "4", "1038", "1039", "1523", "1522", "X006");
    private Predicate<Account> pd = account -> {
        String idName = this.txtSearch.getText().trim();
        return account.getInvestorId().contains(idName) || account.getName().contains(idName);
    };
    private InvalidationListener loginLinster = ob -> this.reloadStatus(this.filterList);
    private InvalidationListener accModel = ob -> Platform.runLater(() -> {
        this.mlist.update(this.filterList, this.pd);
        this.tableAccount.refresh();
        this.tableAccount.sort();
    });

    @FXML
    public void initialize() {
        this.accountMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.loginLinster));
        this.createTableView();
        this.bingUI();
        this.initTree();
        this.exe.execute(() -> {
            if (this.treeParty.getRoot() == null) {
                return;
            }
            try {
                this.counterMng.getTradeCounterList();
            }
            catch (MException e) {
                this.logger.error((Object)e, (Throwable)e);
            }
            this.treeParty.getSelectionModel().select(0);
            this.selectTreeParty = (TreeItem)this.treeParty.getSelectionModel().getSelectedItem();
            this.query(((Party)this.selectTreeParty.getValue()).getId());
        });
        this.checkRights();
    }

    private void checkRights() {
    }

    private void initTree() {
        try {
            TreeItem<Party> root = this.partyTree.getRoot();
            this.treeParty.setRoot(root);
        }
        catch (MException e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    private void bingUI() {
        this.txtSearch.textProperty().addListener(this.accModel);
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue().booleanValue()) {
                return true;
            }
            return false;
        }, (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.txtSearch.setTextFormatter((TextFormatter)new MxFormatter(32));
        this.txtSearch.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.treeParty.getSelectionModel().selectedItemProperty().isNull().getValue(), (Observable[])new Observable[]{this.treeParty.getSelectionModel().selectedItemProperty()}));
        this.treeParty.setOnMouseClicked(event -> {
            if (this.treeParty.getSelectionModel().getSelectedItem() == null || this.selectTreeParty == this.treeParty.getSelectionModel().getSelectedItem()) {
                return;
            }
            this.onItemClicked((TreeItem<Party>)((TreeItem)this.treeParty.getSelectionModel().getSelectedItem()));
        });
    }

    @FXML
    private void rightRefresh() {
        try {
            this.refreshTree();
        }
        catch (MException e) {
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    @FXML
    private void copy() {
        TableUtils.copyContentWithHead(this.tableAccount);
    }

    private void onItemClicked(TreeItem<Party> item) {
        this.selectTreeParty = item;
        this.query(((Party)this.selectTreeParty.getValue()).getId());
    }

    private void query(String partyId) {
        try {
            Party party = (Party)((TreeItem)this.treeParty.getSelectionModel().getSelectedItem()).getValue();
            if (party == null) {
                return;
            }
            ArrayList<Account> list = new ArrayList<Account>();
            list.addAll((Collection<Account>)this.accountMng.getAccountListByParty(party.getId(), PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_ONE));
            list.addAll((Collection<Account>)this.accountMng.getAccountListByParty(party.getId(), PCommon.AssignType.ALL, PHierarchy.GetExtAccntIdsViaPartyReq.Option.GET_OFFSPRING));
            this.filterList.clear();
            LinkedList<String> listIds = new LinkedList<String>();
            list.forEach(item -> {
                this.filterList.add(item);
                listIds.add(item.getCreator());
                listIds.add(item.getUpdater());
            });
            this.userMng.queryUserNameMap(listIds);
            this.reloadStatus(this.filterList);
            this.mlist.clear();
            this.mlist.update(this.filterList, this.pd);
            Collections.sort(this.mlist.getList(), (o1, o2) -> {
                if (Integer.parseInt(o1.getId().substring(1)) < Integer.parseInt(o2.getId().substring(1))) {
                    return 1;
                }
                return -1;
            });
            this.tableAccount.sort();
            this.tableAccount.refresh();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    private synchronized void reloadStatus(ObservableList<Account> filterList) {
        try {
            this.accountMng.queryLoginStatus(filterList);
        }
        catch (MException e) {
            this.logger.error((Object)e, (Throwable)e);
        }
        Platform.runLater(() -> this.tableAccount.refresh());
    }

    private void rebuildFlagBtn(Account selectTableAccount, Label updateFlag, Label historyFlag) {
        if (Objects.equals("CCS", MarketUtils.findMarketGrp((List)selectTableAccount.getSecExc()))) {
            updateFlag.setDisable(false);
            historyFlag.setDisable(false);
        } else {
            updateFlag.setDisable(true);
            historyFlag.setDisable(true);
        }
    }

    private void createTableView() {
        this.tableAccount.setPlaceholder((Node)new Label());
        TableUtils.initValueFactory(this.tableAccount);
        this.brokerId.setCellValueFactory(data -> {
            SimpleStringProperty name = new SimpleStringProperty("");
            Account account = (Account)data.getValue();
            for (TradeCounter item : this.counterMng.getBroker()) {
                if (!item.getBrokerId().equals(account.getBrokerId())) continue;
                name.setValue(item.getBrokerName());
                break;
            }
            return name;
        });
        this.tradePlatformId.setCellValueFactory(data -> {
            SimpleStringProperty name = new SimpleStringProperty("");
            Account account = (Account)data.getValue();
            for (TradeCounter item : this.counterMng.getTradeCounterList(account.getBrokerId())) {
                if (!item.getId().equals(account.getTradePlatformId())) continue;
                name.setValue(item.getName());
                break;
            }
            return name;
        });
        this.flag.setCellValueFactory(data -> ((Account)data.getValue()).flagProperty());
        this.flag.setCellFactory(data -> new FlagTableCell());
        this.neeqFlag.setCellValueFactory(data -> ((Account)data.getValue()).neeqFlagProperty());
        this.neeqFlag.setCellFactory(data -> new NeeqFlagTableCell());
        this.otcFlag.setCellValueFactory(data -> ((Account)data.getValue()).otcFlagProperty());
        this.otcFlag.setCellFactory(data -> new OtcFlagTableCell());
        this.creator.setCellValueFactory(data -> this.userMng.getUserName(((Account)data.getValue()).getCreator()));
        this.updater.setCellValueFactory(data -> this.userMng.getUserName(((Account)data.getValue()).getUpdater()));
        this.colOpera.setCellFactory(data -> new OperaCell(this.stage, this.tableAccount));
        this.tableAccount.setItems(this.mlist.getList());
    }

    private void history() {
        Account item = (Account)this.tableAccount.getSelectionModel().getSelectedItem();
        Account account = this.af.create();
        account.update((Object)item);
        AccountChangeHistoryDialog obj = (AccountChangeHistoryDialog)((Object)this.of.create(AccountChangeHistoryDialog.class));
        obj.setAccount(account);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u53d8\u66f4\u5386\u53f2");
        dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
        dialog.launch();
    }

    private void update() {
        Account item = (Account)this.tableAccount.getSelectionModel().getSelectedItem();
        Account account = this.af.create();
        account.update((Object)item);
        ChangeAccountDialog obj = (ChangeAccountDialog)((Object)this.of.create(ChangeAccountDialog.class));
        obj.setAccountUpdate(account);
        MxDialog dialog = this.df.create((DialogObj)obj, "\u53d1\u8d77\u53d8\u66f4");
        dialog.setBtnText(ButtonType.CANCEL, "\u5173\u95ed");
        dialog.getButton(ButtonType.CANCEL).setVisible(false);
        dialog.launch();
        this.query(((Party)this.selectTreeParty.getValue()).getId());
    }

    @FXML
    private void refreshTree() throws MException {
        try {
            TreeItem<Party> root = this.partyTree.refresh();
            this.treeParty.setRoot(root);
            root.setExpanded(true);
            if (this.selectTreeParty == null) {
                return;
            }
            this.treeParty.getSelectionModel().select(this.selectTreeParty);
            this.query(((Party)this.selectTreeParty.getValue()).getId());
            this.tableAccount.refresh();
        }
        catch (MException e) {
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    private class FlagTableCell<S, T>
    extends TableCell<Account, T> {
        Account accnt;

        private FlagTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                this.accnt = (Account)Account.class.cast(this.getTableRow().getItem());
                if (this.accnt == null) {
                    return;
                }
                Tooltip tooltip = new Tooltip();
                if (this.accnt.getFlag() != null) {
                    if (ERROR_MSG_LIST.contains(this.accnt.getFlag().getRaw()) && !StringUtils.isEmpty((String)this.accnt.getLoginErrorInfo())) {
                        tooltip.setText(String.valueOf(this.accnt.getFlag().getValue()) + "(" + this.accnt.getLoginErrorInfo() + ")");
                    } else {
                        tooltip.setText(this.accnt.getFlag().getValue());
                    }
                    this.setTooltip(tooltip);
                    this.setText(tooltip.getText());
                } else {
                    tooltip = null;
                    this.setTooltip(tooltip);
                    this.setText("");
                }
            }
        }
    }

    private class NeeqFlagTableCell<S, T>
    extends TableCell<Account, T> {
        Account accnt;

        private NeeqFlagTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                this.accnt = (Account)Account.class.cast(this.getTableRow().getItem());
                if (this.accnt == null) {
                    return;
                }
                Tooltip tooltip = new Tooltip();
                if (!this.accnt.isNeeqEnable()) {
                    tooltip = null;
                    this.setTooltip(tooltip);
                    this.setText("");
                    return;
                }
                if (this.accnt.getNeeqFlag() != null) {
                    if ("X006".equals(this.accnt.getNeeqFlag().getRaw()) && !StringUtils.isEmpty((String)this.accnt.getNewLoginErrorInfo())) {
                        tooltip.setText(String.valueOf(this.accnt.getNeeqFlag().getValue()) + "(" + this.accnt.getNewLoginErrorInfo() + ")");
                    } else {
                        tooltip.setText(this.accnt.getNeeqFlag().getValue());
                    }
                    this.setTooltip(tooltip);
                    this.setText(tooltip.getText());
                } else {
                    tooltip = null;
                    this.setTooltip(tooltip);
                    this.setText("");
                }
            }
        }
    }

    private class OperaCell
    extends TableCell<Account, String> {
        final HBox paddedLabel = new HBox();
        final Label updateLab = new Label("\u53d1\u8d77\u53d8\u66f4");
        final Label historyLab = new Label("\u53d8\u66f4\u5386\u53f2");

        OperaCell(Stage stage, final TableView table) {
            this.paddedLabel.setSpacing(20.0);
            this.updateLab.setStyle("-fx-cursor:hand;");
            this.updateLab.getStyleClass().add((Object)"text-blue");
            this.historyLab.setStyle("-fx-cursor:hand;");
            this.historyLab.getStyleClass().add((Object)"text-blue");
            this.paddedLabel.getChildren().add((Object)this.updateLab);
            this.paddedLabel.getChildren().add((Object)this.historyLab);
            this.updateLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    AccountChangeMngPart.this.update();
                }
            });
            this.historyLab.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    table.getSelectionModel().select(OperaCell.this.getTableRow().getIndex());
                    AccountChangeMngPart.this.history();
                }
            });
        }

        protected void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                if (this.getTableRow() != null && this.getTableRow().getItem() instanceof Account) {
                    Account p = (Account)this.getTableRow().getItem();
                    AccountChangeMngPart.this.rebuildFlagBtn(p, this.updateLab, this.historyLab);
                }
                this.setGraphic((Node)this.paddedLabel);
            } else {
                this.setGraphic(null);
            }
        }
    }

    private class OtcFlagTableCell<S, T>
    extends TableCell<Account, T> {
        Account accnt;

        private OtcFlagTableCell() {
        }

        protected void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
                this.setTooltip(null);
            } else {
                this.accnt = (Account)Account.class.cast(this.getTableRow().getItem());
                if (this.accnt == null) {
                    return;
                }
                Tooltip tooltip = new Tooltip();
                if (!this.accnt.isOtcEnable()) {
                    tooltip = null;
                    this.setTooltip(tooltip);
                    this.setText("");
                    return;
                }
                if (this.accnt.getOtcFlag() != null) {
                    if ("X006".equals(this.accnt.getOtcFlag().getRaw()) && !StringUtils.isEmpty((String)this.accnt.getOtcLoginErrorInfo())) {
                        tooltip.setText(String.valueOf(this.accnt.getOtcFlag().getValue()) + "(" + this.accnt.getOtcLoginErrorInfo() + ")");
                    } else {
                        tooltip.setText(this.accnt.getOtcFlag().getValue());
                    }
                    this.setTooltip(tooltip);
                    this.setText(tooltip.getText());
                } else {
                    tooltip = null;
                    this.setTooltip(tooltip);
                    this.setText("");
                }
            }
        }
    }
}

