/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.parts;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.core.MException;
import cms.tmx.entity.Account;
import cms.tmx.entity.AccountChangeRecord;
import cms.tmx.entity.TradeCounter;
import cms.tmx.javafx.MxList;
import cms.tmx.manage.IAccountService;
import cms.tmx.manage.models.TradeCounterServiceImpl;
import java.util.concurrent.ExecutorService;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AccountChangeHistoryDialog
extends DialogObj {
    private static final Logger logger = LogManager.getLogger(AccountChangeHistoryDialog.class);
    @FXML
    private TableView<AccountChangeRecord> table;
    @FXML
    private TableColumn<AccountChangeRecord, String> id;
    @FXML
    private TableColumn<AccountChangeRecord, String> oldName;
    @FXML
    private TableColumn<AccountChangeRecord, String> newName;
    @FXML
    private TableColumn<AccountChangeRecord, String> time;
    @FXML
    private TableColumn<AccountChangeRecord, String> user;
    @Inject
    private ExecutorService exe;
    @Inject
    private IAccountService api;
    @Inject
    private TradeCounterServiceImpl counterMng;
    private MxList<AccountChangeRecord> mlist = new MxList();
    private Account account;

    @FXML
    private void initialize() {
        this.exe.execute(() -> this.query());
        this.createTableView();
    }

    @FXML
    private void query() {
        try {
            ObservableList<AccountChangeRecord> list = this.api.getAccountChangeHistory(this.account.getId());
            this.mlist.clear();
            this.mlist.addAll(list);
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void createTableView() {
        this.id.setCellValueFactory(data -> ((AccountChangeRecord)data.getValue()).idProperty());
        this.time.setCellValueFactory(data -> ((AccountChangeRecord)data.getValue()).timeProperty());
        this.user.setCellValueFactory(data -> ((AccountChangeRecord)data.getValue()).userProperty());
        this.oldName.setCellValueFactory(data -> {
            SimpleStringProperty name = new SimpleStringProperty("");
            AccountChangeRecord account = (AccountChangeRecord)data.getValue();
            try {
                for (TradeCounter item : this.counterMng.getTradeCounterList()) {
                    if (!item.getId().equals(account.getOldId())) continue;
                    name.setValue(item.getName());
                    break;
                }
            }
            catch (MException mException) {
                return name;
            }
            return name;
        });
        this.newName.setCellValueFactory(data -> {
            SimpleStringProperty name = new SimpleStringProperty("");
            AccountChangeRecord account = (AccountChangeRecord)data.getValue();
            try {
                for (TradeCounter item : this.counterMng.getTradeCounterList()) {
                    if (!item.getId().equals(account.getNewId())) continue;
                    name.setValue(item.getName());
                    break;
                }
            }
            catch (MException mException) {
                return name;
            }
            return name;
        });
        this.table.setPlaceholder((Node)new Label());
        this.table.setItems(this.mlist.getList());
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }
}

