/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IWorkFlowApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.proto.workflow.PWorkflow;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.WorkFlowDescriptor;
import cms.tmx.entity.factory.AccountStepAttributeFactory;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.manage.IWorkFlowService;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class WorkFlowMngServiceImpl
implements IWorkFlowService {
    @Inject
    private IWorkFlowApi workApi;
    @Inject
    private AccountStepAttributeFactory af;

    @Override
    public WorkFlowDescriptor getFlowAssignInfoViaAccntId(String id, int type) throws MException {
        WorkFlowDescriptor w = new WorkFlowDescriptor();
        w.setAf(this.af);
        List flows = this.workApi.getWorkflowAttrs(id, type);
        if (flows.size() > 0) {
            PWorkflow.WorkflowAttr flowAttr = (PWorkflow.WorkflowAttr)flows.get(0);
            w.update((Object)flowAttr);
        }
        return w;
    }

    public String assignAccntToFlow(WorkFlowDescriptor workflow) throws MException {
        List list = workflow.getSteps();
        if (list.size() <= 0) {
            return "";
        }
        PWorkflow.WorkflowAttr.Builder w = PWorkflow.WorkflowAttr.newBuilder();
        w.setWorkflowDescId(workflow.getId());
        w.setPermitOrder(workflow.isPermitOrder() ? 1 : 3);
        if (!workflow.getPortfolioId().isEmpty()) {
            w.setPortfolioId(workflow.getPortfolioId());
        } else if (!workflow.getAccntId().isEmpty()) {
            w.setAccntId(workflow.getAccntId());
        } else {
            return "";
        }
        for (AccntStepAttribute item : list) {
            PWorkflow.StepAttr.Builder s = PWorkflow.StepAttr.newBuilder();
            s.setStepDescId(item.getStepId());
            s.setOffFlag(Integer.parseInt(item.getOffFlag().getRaw()));
            s.setFrozenCapital(item.isFrozenCapital());
            s.setFrozenCoupons(item.isFrozenCoupons());
            s.setOwnerTypeValue(Integer.parseInt(item.getTarget().getRaw()));
            s.setInstructionType(Integer.parseInt(item.getInstructType().getRaw()));
            s.setEnableAction(item.getEnableAction());
            s.setSameLevelAction(Integer.parseInt(item.getSameLevelAction().getRaw()));
            s.setDistributeFlag(item.isDistributeFlag());
            s.setHasQuickApprovalPermit(item.isFastApr());
            s.setOrderAmount(item.getOrderAmount());
            s.addAllOwner((Iterable)item.getObjIds());
            if (item.getClassifyIds().size() > 0) {
                s.setClassifyId((String)item.getClassifyIds().get(0));
            }
            for (Integer side : item.getSides()) {
                if (side == 0) continue;
                s.addSide(PField.Side.forNumber((int)side));
            }
            for (String sponsorId : item.getSponsorIds()) {
                s.addSponsor(sponsorId);
            }
            w.addStep(s.build());
        }
        return this.workApi.setWorkFlowAttr(w.build());
    }

    public void updateAssignAccntToFlow(WorkFlowDescriptor workflow) throws MException {
        List list = workflow.getSteps();
        PWorkflow.WorkflowAttr.Builder w = PWorkflow.WorkflowAttr.newBuilder();
        w.setWorkflowDescId(workflow.getId());
        w.setWorkflowAttrId(workflow.getWorkflowAttrId());
        w.setPermitOrder(workflow.isPermitOrder() ? 1 : 3);
        if (!workflow.getPortfolioId().isEmpty()) {
            w.setPortfolioId(workflow.getPortfolioId());
        } else if (!workflow.getAccntId().isEmpty()) {
            w.setAccntId(workflow.getAccntId());
        }
        for (AccntStepAttribute item : list) {
            PWorkflow.StepAttr.Builder s = PWorkflow.StepAttr.newBuilder();
            s.setStepDescId(item.getStepId());
            s.setWorkflowAttrId(item.getFlowAttriId());
            s.setStepAttrId(item.getStepAttriId());
            s.setOffFlag(Integer.parseInt(item.getOffFlag().getRaw()));
            s.setFrozenCapital(item.isFrozenCapital());
            s.setFrozenCoupons(item.isFrozenCapital());
            s.setOwnerTypeValue(Integer.parseInt(item.getTarget().getRaw()));
            s.setInstructionType(Integer.parseInt(item.getInstructType().getRaw()));
            s.setEnableAction(item.getEnableAction());
            s.setSameLevelAction(Integer.parseInt(item.getSameLevelAction().getRaw()));
            s.setDistributeFlag(item.isDistributeFlag());
            s.setHasQuickApprovalPermit(item.isFastApr());
            s.addAllOwner((Iterable)item.getObjIds());
            s.setOrderAmount(item.getOrderAmount());
            if (item.getClassifyIds().size() > 0) {
                s.setClassifyId((String)item.getClassifyIds().get(0));
            }
            for (Integer side : item.getSides()) {
                if (side == 0) continue;
                s.addSide(PField.Side.forNumber((int)side));
            }
            for (String sponsorId : item.getSponsorIds()) {
                s.addSponsor(sponsorId);
            }
            w.addStep(s.build());
        }
        this.workApi.updateWorkFlowAttr(w.build());
    }

    public void deleteWorkflowAttr(String flowAttriId) throws MException {
        this.workApi.deleteWorkFlowAttr(flowAttriId);
    }

    @Override
    public List<WorkFlowDescriptor> getDescriptors(List<Integer> flowIds) throws MException {
        LinkedList<WorkFlowDescriptor> list = new LinkedList<WorkFlowDescriptor>();
        this.workApi.getDescriptors(flowIds).forEach(item -> {
            WorkFlowDescriptor w = new WorkFlowDescriptor();
            w.setAf(this.af);
            w.update(item);
            list.add(w);
        });
        WorkFlowDescriptor w = new WorkFlowDescriptor();
        w.setName("\u65e0");
        list.add(w);
        return list;
    }

    @Override
    public void doAction(Instruction instruction, int actionId, String remark) throws MException {
        this.workApi.doAction(instruction.getEntryId(), actionId, instruction.getPortfolioName(), remark);
    }

    public boolean checkInsStatus(String id, int type) throws MException {
        boolean status = true;
        this.workApi.checkInstructionStatus(id, type, "");
        return status;
    }

    public boolean checkInsStatus(String id, int type, String postId) throws MException {
        boolean status = true;
        this.workApi.checkInstructionStatus(id, type, postId);
        return status;
    }

    @Override
    public void doDistribute(Instruction instruction, int actionId, String userId, String remark) throws MException {
        this.workApi.doDistribute(instruction.getEntryId(), actionId, instruction.getPortfolioName(), userId, remark);
    }
}

