/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.core.MConfService;
import cms.tmx.entity.UserPreference;
import cms.tmx.manage.IUserPreferService;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class UserPreferServiceImpl
implements IUserPreferService {
    @Inject
    private MConfService cs;
    @Inject
    private IBaseApi baseApi;
    private static final Logger logger = LogManager.getLogger(UserPreferServiceImpl.class);
    private List<UserPreference> userPreList = new LinkedList<UserPreference>();

    @PostConstruct
    public void init() {
        this.load();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void load() {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                FileInputStream in = new FileInputStream(this.cs.getFile("set_conf.txt"));
                try {
                    try (InputStreamReader reader = new InputStreamReader((InputStream)in, "utf-8");){
                        JsonElement element = new JsonParser().parse((Reader)reader);
                        if (!element.isJsonNull()) {
                            element.getAsJsonArray().forEach(each -> {
                                UserPreference userPre = new UserPreference();
                                userPre.setJsonObj(each.getAsJsonObject());
                                this.userPreList.add(userPre);
                            });
                        }
                    }
                    if (in == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (in == null) throw throwable;
                    in.close();
                    throw throwable;
                }
                in.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.error("read json file failed", (Throwable)e);
        }
    }

    @Override
    public UserPreference getUserPre(String type) {
        if (type.isEmpty()) {
            return null;
        }
        for (UserPreference userPre : this.userPreList) {
            if (!userPre.get("funcPanelType").equals(type)) continue;
            if (this.baseApi.getUserId() != null) {
                if (this.baseApi.getUserId().equals(userPre.get("userId"))) {
                    return userPre;
                }
                return new UserPreference();
            }
            return userPre;
        }
        return null;
    }
}

