/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.ISystemApi;
import cms.tmx.api.mng.IUserApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.utils.DesEncrypt;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.datatype.proto.misc.PMisc;
import cms.tmx.datatype.proto.user.PUser;
import cms.tmx.datatype.proto.user.PUserControl;
import cms.tmx.entity.LoggerMessage;
import cms.tmx.entity.LoggerMsgPage;
import cms.tmx.entity.Opinions;
import cms.tmx.entity.PwdExpiredCtrl;
import cms.tmx.entity.User;
import cms.tmx.entity.UserControl;
import cms.tmx.entity.UserControlResp;
import cms.tmx.entity.UserLock;
import cms.tmx.entity.UserLockInfo;
import cms.tmx.entity.factory.UserFactory;
import cms.tmx.manage.IUserService;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.core.HttpClientService;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UserMngServiceImpl
implements IUserService {
    private static final Logger logger = LogManager.getLogger(UserMngServiceImpl.class);
    @Inject
    private MObjFactory of;
    @Inject
    private IUserApi userApi;
    @Inject
    private ISystemApi sysApi;
    @Inject
    private IBaseApi bmi;
    @Inject
    private UserFactory uf;
    @Inject
    private MConfService cs;
    @Inject
    private HttpClientService httpClient;
    private User user;
    private Map<String, StringProperty> userNameMap = new HashMap<String, StringProperty>();
    private Map<String, StringProperty> creditUserNameMap = new HashMap<String, StringProperty>();
    private Map<String, User> userMap = new HashMap<String, User>();

    @Override
    public User getActiveUser() throws MException {
        if (this.user == null) {
            this.user = this.getUserDetail(this.bmi.getUserId());
        } else if (!this.user.getId().equals(this.bmi.getUserId())) {
            this.user = this.getUserDetail(this.bmi.getUserId());
        }
        return this.user;
    }

    public String getUserId() {
        return this.bmi.getUserId();
    }

    @Override
    public User getUserDetail(String userId) throws MException {
        User user = (User)this.of.create(User.class);
        user.update((Object)this.userApi.getUserDetail(userId));
        return user;
    }

    @Override
    public User getCachedUser(String userId) throws MException {
        User user = null;
        if (this.userMap.get(userId) == null) {
            user = this.getUserDetail(userId);
            this.userMap.put(userId, user);
        }
        return this.userMap.get(userId);
    }

    @Override
    public List<User> getUserList(List<String> userIds) throws MException {
        LinkedList<User> users = new LinkedList<User>();
        if (userIds.size() == 0) {
            return users;
        }
        int m = userIds.size() / 200;
        int n = userIds.size() % 200;
        int i = 0;
        while (i < m + 1) {
            List<Object> list = new LinkedList();
            list = i == m ? userIds.subList(m * 200, m * 200 + n) : userIds.subList(i * 200, (i + 1) * 200);
            if (list == null || !list.isEmpty()) {
                this.userApi.getUserList(list).forEach(item -> {
                    User user = this.uf.create();
                    user.update(item);
                    users.add(user);
                    this.updateUserNameMap(user);
                });
            }
            ++i;
        }
        return users;
    }

    private void updateUserNameMap(User user) {
        if (this.userNameMap.get(user.getId()) == null) {
            this.userNameMap.put(user.getId(), (StringProperty)new SimpleStringProperty(user.getName()));
        } else {
            this.userNameMap.get(user.getId()).setValue(user.getName());
        }
        if (this.creditUserNameMap.get(user.getId()) == null) {
            this.creditUserNameMap.put(user.getId(), (StringProperty)new SimpleStringProperty(user.getUseCreditName()));
        } else {
            this.creditUserNameMap.get(user.getId()).setValue(user.getUseCreditName());
        }
    }

    @Override
    public List<String> getUserIds(String partyId, PHierarchy.GetUserIdsViaPartyReq.GetOption option) throws MException {
        return this.userApi.getUserIds(partyId, option);
    }

    @Override
    public List<String> getUserIds(String partyId) throws MException {
        return this.getUserIds(partyId, PHierarchy.GetUserIdsViaPartyReq.GetOption.GET_OFFSPRING);
    }

    public String addUser(User user) throws MException {
        PUser.User.Builder uBuilder = PUser.User.newBuilder();
        uBuilder.setUserId(user.getId());
        uBuilder.setUserName(user.getName());
        uBuilder.setAddress(user.getAddress());
        uBuilder.setTelephone(user.getPhone());
        uBuilder.setMobile(user.getMobile());
        uBuilder.setEmail(user.getEmail());
        uBuilder.setCreditCode(user.getCode());
        try {
            String decrypt = DesEncrypt.encrypt((String)user.getPwd(), (String)"ficc2018");
            uBuilder.setPassword(decrypt);
        }
        catch (Exception e) {
            logger.error("\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new MException(-1, "\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        uBuilder.setCreditName(user.getUseCreditName());
        if (!user.getUserCreditType().getRaw().isEmpty()) {
            uBuilder.setCreditTypeValue(Integer.parseInt(user.getUserCreditType().getRaw()));
        }
        return this.userApi.addUser(uBuilder.build());
    }

    public void updateUser(User user) throws MException {
        PUser.User.Builder uBuilder = PUser.User.newBuilder();
        uBuilder.setUserId(user.getId());
        uBuilder.setUserName(user.getName());
        uBuilder.setAddress(user.getAddress());
        uBuilder.setTelephone(user.getPhone());
        uBuilder.setMobile(user.getMobile());
        uBuilder.setPassword(user.getPwd());
        uBuilder.setEmail(user.getEmail());
        uBuilder.setCreditCode(user.getCode());
        uBuilder.setCreditName(user.getUseCreditName());
        if (!user.getUserCreditType().getRaw().isEmpty()) {
            uBuilder.setCreditTypeValue(Integer.parseInt(user.getUserCreditType().getRaw()));
        }
        uBuilder.setStatus(Integer.parseInt(user.getStatus().getRaw()));
        this.userApi.updateUser(uBuilder.build());
    }

    public void enableUser(Boolean isEnable, User user) throws MException {
        PUser.User.Builder uBuilder = PUser.User.newBuilder();
        uBuilder.setUserId(user.getId());
        uBuilder.setUserName(user.getName());
        uBuilder.setAddress(user.getAddress());
        uBuilder.setTelephone(user.getPhone());
        uBuilder.setMobile(user.getMobile());
        uBuilder.setPassword(user.getPwd());
        uBuilder.setEmail(user.getEmail());
        uBuilder.setCreditCode(user.getCode());
        uBuilder.setCreditName(user.getUseCreditName());
        if (!user.getUserCreditType().getRaw().isEmpty()) {
            uBuilder.setCreditTypeValue(Integer.parseInt(user.getUserCreditType().getRaw()));
        }
        if (isEnable.booleanValue()) {
            uBuilder.setStatus(1);
        } else {
            uBuilder.setStatus(3);
        }
        this.userApi.updateUser(uBuilder.build());
    }

    public void assignUserToParty(String partyId, String userId) throws MException {
        this.userApi.assignUserToParty(partyId, userId);
    }

    public void resetPwd(String userId, String pwd) throws MException {
        this.userApi.resetPwd(userId, pwd);
    }

    public void assignUserToPostReq(String userId, Collection<String> postIds) throws MException {
        this.userApi.assignUserToPost(userId, postIds);
    }

    public void updateUserControl(List<UserControl> usercontrols, String userId, boolean macFlag, boolean ipFlag, PwdExpiredCtrl pwd) throws MException {
        PUserControl.UpdateUserControlReq.Builder uBuilder = PUserControl.UpdateUserControlReq.newBuilder();
        uBuilder.setUserId(userId);
        uBuilder.setOpUser(this.bmi.getOpUser());
        for (UserControl userControl : usercontrols) {
            PUserControl.UserControl.Builder control = PUserControl.UserControl.newBuilder();
            control.setOptionValue(userControl.getType());
            control.setValue(userControl.getValue());
            control.setFlag(userControl.getType() == 1 ? macFlag : ipFlag);
            uBuilder.addUserControl(control.build());
        }
        PUserControl.PwdExpiredCtrl.Builder builder = PUserControl.PwdExpiredCtrl.newBuilder();
        builder.setPwdExpiredDuration(pwd.getPwd_expired_duration());
        uBuilder.setPwdControl(builder.build());
        this.userApi.updateUserControl(uBuilder.build());
    }

    public UserControlResp getUserControl(String userId) throws MException {
        LinkedList userControls = new LinkedList();
        UserControlResp userControlResp = new UserControlResp();
        if (!userId.isEmpty()) {
            HashMap map = this.userApi.getUserControl(userId);
            if (map.get("list") != null) {
                List list = (List)map.get("list");
                list.forEach(item -> {
                    UserControl userControl = new UserControl();
                    userControl.update(item);
                    userControls.add(userControl);
                });
                userControlResp.setList(userControls);
            }
            if (map.get("user") != null) {
                PUserControl.PwdExpiredCtrl pwd = (PUserControl.PwdExpiredCtrl)map.get("user");
                PwdExpiredCtrl p = new PwdExpiredCtrl();
                p.update((Object)pwd);
                userControlResp.setPwd(p);
            }
        }
        return userControlResp;
    }

    public UserLock getUserLock() throws MException {
        PUser.GetUserLockInfoResp resp;
        UserLock userLock = new UserLock();
        boolean hasMore = false;
        int startRow = 1;
        do {
            PBase.Pager.Builder pBuilder = PBase.Pager.newBuilder();
            pBuilder.setPageSize(150);
            pBuilder.setStartRow(startRow);
            startRow += 150;
            resp = this.userApi.getUserLockInfo(pBuilder.build());
            userLock.setLockDuration(resp.getCurrentLockDuration());
            userLock.setMaxCount(resp.getCurrentMaxCount());
            for (PUser.UserLockInfo info : resp.getInfoList()) {
                UserLockInfo userLockInfo = new UserLockInfo();
                userLockInfo.update((Object)info);
                userLock.getList().add(userLockInfo);
            }
        } while (hasMore = resp.getPagination().getHasMore());
        return userLock;
    }

    public void setUserLock(int lockDuration, int maxCount) throws MException {
        this.userApi.setUserLockInfo(PUser.SetUserLockInfoReq.Option.SETTING, (long)lockDuration, maxCount, null);
    }

    public void unLockUser(String userId) throws MException {
        LinkedList<String> userIds = new LinkedList<String>();
        userIds.add(userId);
        this.userApi.setUserLockInfo(PUser.SetUserLockInfoReq.Option.UNLOCK, 0L, 0, userIds);
    }

    @Override
    public StringProperty getUserName(String userId) {
        if (StringUtils.isEmpty((String)userId)) {
            return new SimpleStringProperty("");
        }
        StringProperty userName = this.userNameMap.get(userId);
        if (userName == null) {
            try {
                userName = new SimpleStringProperty(this.getCachedUser(userId).getName());
                this.userNameMap.put(userId, userName);
            }
            catch (MException | Exception e) {
                logger.error("\u6839\u636e\u7528\u6237id\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25,userId=" + userId, e);
            }
        }
        if (userName == null) {
            userName = new SimpleStringProperty(userId);
            this.userNameMap.put(userId, userName);
        }
        return userName;
    }

    @Override
    public StringProperty getCreditUserName(String userId) {
        if (StringUtils.isEmpty((String)userId)) {
            return new SimpleStringProperty("");
        }
        StringProperty userName = this.creditUserNameMap.get(userId);
        if (userName == null) {
            try {
                userName = new SimpleStringProperty(this.getCachedUser(userId).getUseCreditName());
                this.creditUserNameMap.put(userId, userName);
            }
            catch (MException | Exception e) {
                logger.error("\u6839\u636e\u7528\u6237id\u67e5\u8be2\u7528\u6237\u4fe1\u606f\u5931\u8d25,userId=" + userId, e);
            }
        }
        if (userName == null) {
            userName = new SimpleStringProperty(userId);
            this.creditUserNameMap.put(userId, userName);
        }
        return userName;
    }

    @Override
    public void queryUserNameMap(List<String> userIds) throws MException {
        if (userIds == null || userIds.isEmpty()) {
            return;
        }
        this.getUserList(userIds.stream().filter(item -> this.userNameMap.get(item) == null || this.creditUserNameMap.get(item) == null).distinct().collect(Collectors.toList()));
    }

    @Override
    public void query(LoggerMsgPage<LoggerMessage> info) throws MException {
        LinkedList<LoggerMessage> list = new LinkedList<LoggerMessage>();
        info.getDataList().clear();
        PMisc.GetUserLogReq.Builder builder = PMisc.GetUserLogReq.newBuilder();
        builder.setUser(this.bmi.getOpUser());
        builder.setDateFrom(info.getBeginDate());
        builder.setDateTo(info.getEndDate());
        if (info.getUserId() != null && !info.getUserId().isEmpty()) {
            builder.setUserId(info.getUserId());
        }
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        LinkedList<String> listIds = new LinkedList<String>();
        PMisc.GetUserLogResp resp = null;
        info.initParam();
        do {
            info.updatePage(pageBuilder);
            builder.setPage(pageBuilder.build());
            resp = this.userApi.getUserLogReq(builder.build());
            for (PMisc.LogMsg logMsg : resp.getLogList()) {
                LoggerMessage lg = new LoggerMessage();
                lg.update((Object)logMsg);
                list.add(lg);
                listIds.add(lg.getUserId());
            }
        } while (info.hasNext(resp.getPage().getTotalRow()));
        this.queryUserNameMap(listIds);
        for (LoggerMessage loggerMessage : list) {
            loggerMessage.setUserName((String)this.getUserName(loggerMessage.getUserId()).get());
        }
        info.updateData(list);
    }

    public List<LoggerMessage> queryAllLogger(LoggerMsgPage<LoggerMessage> info) throws MException {
        LinkedList<LoggerMessage> list = new LinkedList<LoggerMessage>();
        PMisc.GetUserLogReq.Builder builder = PMisc.GetUserLogReq.newBuilder();
        builder.setUser(this.bmi.getOpUser());
        builder.setDateFrom(info.getBeginDate());
        builder.setDateTo(info.getEndDate());
        if (info.getUserId() != null && !info.getUserId().isEmpty()) {
            builder.setUserId(info.getUserId());
        }
        PBase.Page.Builder pageBuilder = PBase.Page.newBuilder();
        LinkedList<String> listIds = new LinkedList<String>();
        PMisc.GetUserLogResp resp = null;
        int i = 0;
        do {
            pageBuilder.setStartRow(1 + 200 * i);
            pageBuilder.setPageSize(200);
            builder.setPage(pageBuilder.build());
            resp = this.userApi.getUserLogReq(builder.build());
            for (PMisc.LogMsg logMsg : resp.getLogList()) {
                LoggerMessage lg = new LoggerMessage();
                lg.update((Object)logMsg);
                list.add(lg);
                listIds.add(lg.getUserId());
            }
        } while (1 + 200 * ++i <= resp.getPage().getTotalRow());
        this.queryUserNameMap(listIds);
        for (LoggerMessage loggerMessage : list) {
            loggerMessage.setUserName((String)this.getUserName(loggerMessage.getUserId()).get());
        }
        return list;
    }

    @Override
    public void setOpinion(String content, File file) throws MException {
        JsonPrimitive jsonPara;
        JsonObject jsonObject;
        String clientType = this.cs.getValue("client_version");
        String productId = "PB210";
        String productAbbr = "TM";
        String userId = this.bmi.getOpUser().getUserId();
        String msgId = UUID.randomUUID().toString().replaceAll("-", "");
        String timestamp = String.valueOf(new Date().getTime());
        String input = String.valueOf(timestamp) + "_" + msgId + "_" + productId + "_" + productAbbr + "_" + userId + "_" + content + "_" + clientType + "_" + "x7xbNAWGwIDAQAB";
        String sign = UserMngServiceImpl.getSHA256StrJava(input);
        try {
            this.pbReq(content, clientType, productId, productAbbr, userId, msgId, timestamp, sign);
        }
        catch (MException e) {
            throw new MException(1800, e.getCode() == 19 ? "\u9009\u62e9\u83dc\u5355\u8fc7\u591a" : e.getDesc());
        }
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("productId", productId);
        param.put("productAbbr", productAbbr);
        param.put("userID", userId);
        param.put("content", content);
        param.put("clientType", clientType);
        param.put("signatrue", sign);
        param.put("timestamp", timestamp);
        param.put("msgId", msgId);
        if (file != null) {
            if (file.length() > 0x100000L) {
                throw new MException(1802, "\u56fe\u7247\u5927\u5c0f\u8d85\u51fa1M");
            }
            try {
                String url = this.cs.getValue("feedback.upload");
                String resp = this.httpClient.doPostJson(url, "pic", file);
                jsonObject = new JsonParser().parse(resp).getAsJsonObject();
                jsonPara = jsonObject.getAsJsonPrimitive("success");
                if ("true".equals(jsonPara.getAsString())) {
                    JsonObject jsonData = jsonObject.getAsJsonObject("data");
                    param.put("pic", jsonData.getAsJsonPrimitive("result").getAsString());
                }
            }
            catch (MException | Exception throwable) {
                throw new MException(1801, "\u63d0\u4ea4\u5931\u8d25,\u4e0a\u4f20\u56fe\u7247\u5f02\u5e38");
            }
        }
        try {
            String url = this.cs.getValue("feedback");
            String resp = this.httpClient.doPostJson(url, param);
            jsonObject = new JsonParser().parse(resp).getAsJsonObject();
            jsonPara = jsonObject.getAsJsonPrimitive("success");
            if (!"true".equals(jsonPara.getAsString())) {
                throw new MException(1802, "\u63d0\u4ea4\u5931\u8d25,http\u610f\u89c1\u53cd\u9988\u5f02\u5e38");
            }
        }
        catch (MException | Exception throwable) {
            throw new MException(1802, "\u63d0\u4ea4\u5931\u8d25,http\u610f\u89c1\u53cd\u9988\u5f02\u5e38");
        }
    }

    private void pbReq(String content, String clientType, String productId, String productAbbr, String userId, String msgId, String timestamp, String sign) throws MException {
        PMisc.SetOpinionsReq.Builder builder = PMisc.SetOpinionsReq.newBuilder();
        PMisc.Opinion.Builder ob = PMisc.Opinion.newBuilder();
        ob.setProductId(productId);
        ob.setProductAbbr(productAbbr);
        ob.setUserId(userId);
        ob.setContent(content);
        ob.setClientType(clientType);
        ob.setSignature(sign);
        ob.setTimestamp(timestamp);
        ob.setMsgId(msgId);
        builder.setOpUser(this.bmi.getOpUser());
        builder.setOpinion(ob.build());
        this.userApi.setOpinionsReq(builder.build());
    }

    public static String getSHA256StrJava(String str) {
        String encodeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodeStr = UserMngServiceImpl.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encodeStr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        int i = 0;
        while (i < bytes.length) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
            ++i;
        }
        return stringBuffer.toString();
    }

    @Override
    public PwdExpiredCtrl getPwdCtrl() throws MException {
        PwdExpiredCtrl pec = new PwdExpiredCtrl();
        PUserControl.PwdExpiredCtrl getPwdCtrlReq = this.sysApi.GetPwdCtrlReq();
        pec.update((Object)getPwdCtrlReq);
        return pec;
    }

    @Override
    public void updatePwdCtrl(PwdExpiredCtrl pwdCtrl) throws MException {
        PUserControl.PwdExpiredCtrl.Builder builder = PUserControl.PwdExpiredCtrl.newBuilder();
        builder.setPwdExpiredDuration(pwdCtrl.getPwd_expired_duration());
        this.sysApi.UpdatePwdCtrlReq(builder.build());
    }

    @Override
    public List<Opinions> queryOpinion(String page, String size) throws MException {
        LinkedList<Opinions> opList = new LinkedList<Opinions>();
        String productId = "PB210";
        String userId = this.bmi.getOpUser().getUserId();
        String msgId = UUID.randomUUID().toString().replaceAll("-", "");
        String timestamp = String.valueOf(new Date().getTime());
        String input = String.valueOf(msgId) + "_" + timestamp + "_x7xbNAWGwIDAQAB";
        String sign = UserMngServiceImpl.getSHA256StrJava(input);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("productId", productId);
        param.put("userID", userId);
        param.put("signatrue", sign);
        param.put("timestamp", timestamp);
        param.put("msgId", msgId);
        param.put("page", page);
        param.put("size", size);
        String content = "";
        String createDate = "";
        String response = "";
        JsonElement respContent = null;
        try {
            JsonArray dataList = null;
            String url = this.cs.getValue("feedback.down");
            String respUrl = this.httpClient.doPostJson(url, param);
            JsonObject jsonObject = new JsonParser().parse(respUrl).getAsJsonObject();
            JsonPrimitive jsonPara = jsonObject.getAsJsonPrimitive("success");
            JsonObject jsonData = jsonObject.getAsJsonObject("data");
            dataList = jsonData.getAsJsonArray("list");
            for (JsonElement item : dataList) {
                JsonElement contentJs = item.getAsJsonObject().get("content");
                JsonElement createDateJs = item.getAsJsonObject().get("createDate");
                JsonElement responseJs = item.getAsJsonObject().get("response");
                if (!responseJs.isJsonNull()) {
                    respContent = responseJs.getAsJsonArray().get(0).getAsJsonObject().get("content");
                }
                content = contentJs.isJsonNull() ? "" : contentJs.getAsString();
                createDate = createDateJs.isJsonNull() ? "" : createDateJs.getAsString();
                response = respContent == null ? "" : respContent.getAsString();
                Opinions op = new Opinions();
                op.setContent(content);
                op.setCreateDate(createDate);
                op.setResponse(response);
                opList.add(op);
            }
            if (!"true".equals(jsonPara.getAsString())) {
                throw new MException(1802, "\u67e5\u8be2\u6211\u7684\u5386\u53f2\u53cd\u9988\u5f02\u5e38");
            }
            return opList;
        }
        catch (MException | Exception throwable) {
            throw new MException(1802, "\u67e5\u8be2\u6211\u7684\u5386\u53f2\u53cd\u9988\u5f02\u5e38");
        }
    }
}

