/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.UpdateInfo;
import cms.tmx.http.update.api.UpdateApi;
import cms.tmx.http.update.dto.GetVersionInfosReq;
import cms.tmx.http.update.dto.VersionInfo;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class UpdateMngServiceImpl
extends MxModel {
    @Inject
    private MScheduler ms;
    @Inject
    private MxAlert alert;
    @Inject
    private UpdateApi updateApi;
    private ObservableList<UpdateInfo> obList = FxUtils.newList();
    private StringProperty beginDate = new SimpleStringProperty("");
    private StringProperty endDate = new SimpleStringProperty("");

    @PostConstruct
    private void initialize() {
        this.ms.setInterval(3000);
    }

    public void query() {
        this.ms.schedule(event -> {
            ArrayList<UpdateInfo> arrayList = new ArrayList<UpdateInfo>();
            GetVersionInfosReq req = new GetVersionInfosReq();
            req.setBeginDate((String)this.beginDate.get());
            req.setEndDate((String)this.endDate.get());
            try {
                List versionInfos = this.updateApi.getVersionInfos(req);
                for (VersionInfo versionInfo : versionInfos) {
                    UpdateInfo info = new UpdateInfo();
                    info.update(versionInfo);
                    arrayList.add(info);
                }
                this.obList.setAll(arrayList);
            }
            catch (MException | Exception e) {
                this.logger.error("\u67e5\u8be2\u7248\u672c\u4fe1\u606f\u51fa\u9519", e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7248\u672c\u4fe1\u606f\u51fa\u9519"));
            }
            this.changed();
        });
    }

    public void delete(String versionId) throws MException {
        this.updateApi.deleteVersionInfos(versionId);
    }

    public ObservableList<UpdateInfo> getObList() {
        return this.obList;
    }

    public void setObList(ObservableList<UpdateInfo> obList) {
        this.obList = obList;
    }

    public StringProperty beginDateProperty() {
        return this.beginDate;
    }

    public String getBeginDate() {
        return (String)this.beginDateProperty().get();
    }

    public void setBeginDate(String beginDate) {
        this.beginDateProperty().set((Object)beginDate);
    }

    public StringProperty endDateProperty() {
        return this.endDate;
    }

    public String getEndDate() {
        return (String)this.endDateProperty().get();
    }

    public void setEndDate(String endDate) {
        this.endDateProperty().set((Object)endDate);
    }
}

