/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.manage.api.CounterPartyServiceApi;
import cms.tmx.http.manage.dto.GetTraderReq;
import cms.tmx.http.manage.dto.GetTraderResp;
import cms.tmx.http.manage.dto.UserTrader;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class TraderModel {
    protected transient Logger logger = LogManager.getLogger(TraderModel.class);
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private CounterPartyServiceApi api;
    @Inject
    private MEventService es;
    public static String traderId = "";

    @PostConstruct
    private void init() {
        this.es.subscribe("stage.after.login", event -> {
            GetTraderReq req = new GetTraderReq();
            req.setOpUser(this.baseApi.getHttpOpUser());
            req.setPage(this.baseApi.getHttpDefPage());
            req.getUserId().add(req.getOpUser().getUserId());
            try {
                GetTraderResp resp = this.api.getTraderIdByUserId(req);
                if (resp.getUserTrader().size() > 0) {
                    traderId = ((UserTrader)resp.getUserTrader().get(0)).getTrader().getId();
                }
            }
            catch (MException | IOException e) {
                e.printStackTrace();
                this.logger.error("\u6839\u636euserId\u67e5\u4ea4\u6613\u5458ID\u5f02\u5e38\uff1a" + e.getMessage());
            }
        });
    }
}

