/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.ITradeCounterApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.TradeCounter;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.ITradeCounterService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class TradeCounterServiceImpl
implements ITradeCounterService {
    @Inject
    private ITradeCounterApi api;
    @Inject
    private MObjFactory of;
    private ObservableList<TradeCounter> listCounter = FxUtils.newList();
    private ObservableList<TradeCounter> brokerList = FxUtils.newList();
    private ObservableList<TradeCounter> counterList = FxUtils.newList();
    private Map<String, List<TradeCounter>> counterListMap = new HashMap<String, List<TradeCounter>>();
    private Map<String, List<TradeCounter>> counterIdListMap = new HashMap<String, List<TradeCounter>>();

    private void queryTradeCounter() throws MException {
        this.listCounter.clear();
        List list = this.api.queryTradeCounter();
        HashSet brokerIds = new HashSet();
        HashSet counterIds = new HashSet();
        this.brokerList.clear();
        this.counterList.clear();
        list.forEach(item -> {
            TradeCounter counter = (TradeCounter)this.of.create(TradeCounter.class);
            counter.update(item);
            this.listCounter.add((Object)counter);
            if (!brokerIds.contains(counter.getBrokerId())) {
                this.brokerList.add((Object)counter);
                brokerIds.add(counter.getBrokerId());
            }
            if (!counterIds.contains(counter.getCounterId())) {
                this.counterList.add((Object)counter);
                counterIds.add(counter.getCounterId());
            }
            List<TradeCounter> l = this.counterListMap.get(counter.getBrokerId());
            String counterId = counter.getCounterId();
            List<TradeCounter> c = this.counterIdListMap.get(counterId);
            if (l == null) {
                l = new LinkedList<TradeCounter>();
                this.counterListMap.put(counter.getBrokerId(), l);
            }
            if (c == null) {
                c = new LinkedList<TradeCounter>();
                this.counterIdListMap.put(counterId, c);
            }
            l.add(counter);
            c.add(counter);
        });
    }

    @Override
    public ObservableList<TradeCounter> getTradeCounterList() throws MException {
        if (this.listCounter.isEmpty()) {
            this.queryTradeCounter();
        }
        return this.listCounter;
    }

    @Override
    public ObservableList<TradeCounter> getBroker() {
        return this.brokerList;
    }

    @Override
    public ObservableList<TradeCounter> getTradeCounterList(String brokerId) {
        List<TradeCounter> l = this.counterListMap.get(brokerId);
        if (l == null) {
            l = new LinkedList<TradeCounter>();
        }
        return FXCollections.observableList(l);
    }

    @Override
    public ObservableList<TradeCounter> getTradeCounterIdList(String counterId) {
        List<TradeCounter> c = this.counterIdListMap.get(counterId);
        if (c == null) {
            c = new LinkedList<TradeCounter>();
        }
        return FXCollections.observableList(c);
    }
}

