/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.ISecAccountApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.entity.Account;
import cms.tmx.entity.CtpSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.http.accnt.AccountServiceApi;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.secaccnt.dto.GetExtSecAccntsReq;
import cms.tmx.http.secaccnt.dto.SecAccnt;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.ISecAccountService;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.utils.MarketUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class SecAccountMngServiceImpl
implements ISecAccountService {
    private static final Logger logger = LogManager.getLogger(SecAccountMngServiceImpl.class);
    private AtomicBoolean bInit = new AtomicBoolean(false);
    private AtomicBoolean allInit = new AtomicBoolean(false);
    private AtomicBoolean marginInit = new AtomicBoolean(false);
    @Inject
    private FundAccountMngServiceImpl fundService;
    @Inject
    private ISecAccountApi secApi;
    @Inject
    private MObjFactory of;
    @Inject
    private MConfService cs;
    private Map<FundAccount, List<SecAccount>> mapSecAccount = FxUtils.newMap();
    private Map<FundAccount, List<SecAccount>> allMapSecAccount = FxUtils.newMap();
    private Map<FundAccount, List<SecAccount>> allMapMarginSecAccount = FxUtils.newMap();
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private AccountServiceApi newAccntApi;

    @Override
    public List<SecAccount> querySecAccountList(FundAccount fund) throws MException {
        PAccount.ExtFundAccnt.Builder fundBuilder = PAccount.ExtFundAccnt.newBuilder();
        fundBuilder.setMarketGrp(fund.getMarketGrp());
        fundBuilder.setExtAccntId(fund.getExtAccntId());
        List secList = this.secApi.getSecAccountList(fundBuilder.build());
        ObservableList list = FxUtils.newList();
        List extSecAccnts = null;
        GetExtSecAccntsReq getSecAccReq = new GetExtSecAccntsReq();
        getSecAccReq.setExtAccntId(fund.getParentId());
        getSecAccReq.setMarketGroup(fund.getMarketGrp());
        if (!"FUTURES".equals(fund.getMarketGrp())) {
            try {
                extSecAccnts = this.newAccntApi.getExtSecAccnts(getSecAccReq);
            }
            catch (MException e2) {
                logger.error("\u67e5\u8be2\u65b0\u6846\u67b6\u8bc1\u5238\u8d26\u53f7\u5931\u8d25", (Throwable)e2);
            }
        }
        for (PAccount.ExtSecAccnt ext : secList) {
            if (ext.getMarketGrp().equals("CCS") || ext.getMarketGrp().equals("IB") || ext.getMarketGrp().equals("OTC")) {
                SecAccount account = (SecAccount)this.of.create(SecAccount.class);
                account.update((Object)ext);
                if ((FundAccount.isNewFrame((FundAccount)fund) || fund.isNeeqEnable()) && extSecAccnts != null && !extSecAccnts.isEmpty()) {
                    for (SecAccnt secAcc : extSecAccnts) {
                        if (fund.isNeeqEnable() && !"NEEQ".equals(secAcc.getMarket())) continue;
                        if (fund.isNeeqEnable()) {
                            if (!"NEEQ".equals(account.getExchange().getRaw()) || !account.getInverstorSecId().equals(secAcc.getInvestorSecId())) continue;
                            account.update((Object)secAcc);
                            continue;
                        }
                        if (!account.getInverstorSecId().equals(secAcc.getInvestorSecId())) continue;
                        account.update((Object)secAcc);
                    }
                }
                if (extSecAccnts != null && !extSecAccnts.isEmpty()) {
                    for (SecAccnt secAcc : extSecAccnts) {
                        if (!secAcc.getMarket().equals(account.getExchange().getRaw()) || !account.getInverstorSecId().equals(secAcc.getInvestorSecId())) continue;
                        account.setNewSecAccntId(secAcc.getSecAccntId());
                    }
                }
                list.add((Object)account);
                continue;
            }
            if (!ext.getMarketGrp().equals("FUTURES")) continue;
            CtpSecAccount ctpSecAcc = (CtpSecAccount)this.of.create(CtpSecAccount.class);
            ctpSecAcc.update((Object)ext);
            list.add((Object)ctpSecAcc);
        }
        logger.error(String.valueOf(fund.getInvestId()) + "\u5bf9\u5e94\u7684\u8bc1\u5238\u8d26\u6237\u6709\uff1a" + list);
        if ("FUTURES".equals(fund.getMarketGrp())) {
            return list;
        }
        FilteredList filterList = list.filtered(e -> "CCS".equals(e.getMarketGrp()) && (e.getCategory().getRaw().equals("A") || e.getCategory().getRaw().equals("H")) || "IB".equals(e.getMarketGrp()) || "OTC".equals(e.getMarketGrp()));
        logger.error(String.valueOf(fund.getInvestId()) + "\u5bf9\u5e94\u7684\u8fc7\u6ee4\u540e\u7684\u8bc1\u5238\u8d26\u6237\u6709\uff1a" + filterList);
        return filterList;
    }

    public String getNewFrameSecAccntId(String parentId, String marketGrp, String investorSecId) {
        GetExtSecAccntsReq getSecAccReq = new GetExtSecAccntsReq();
        getSecAccReq.setExtAccntId(parentId);
        getSecAccReq.setMarketGroup(marketGrp);
        List extSecAccnts = null;
        try {
            extSecAccnts = this.newAccntApi.getExtSecAccnts(getSecAccReq);
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u65b0\u6846\u67b6\u8bc1\u5238\u8d26\u53f7\u5931\u8d25", (Throwable)e);
        }
        if (extSecAccnts != null && !extSecAccnts.isEmpty()) {
            for (SecAccnt secAcc : extSecAccnts) {
                if (!investorSecId.equals(secAcc.getInvestorSecId())) continue;
                return secAcc.getSecAccntId();
            }
        }
        return "";
    }

    @Override
    public synchronized Map<FundAccount, List<SecAccount>> getSecAccountMap() throws MException {
        if (!this.allInit.get()) {
            this.queryAllSecAccountMap();
            this.allInit.getAndSet(true);
        }
        return this.mapSecAccount;
    }

    @Override
    public synchronized Map<FundAccount, List<SecAccount>> getAllSecAccountMap() throws MException {
        if (!this.allInit.get()) {
            this.queryAllSecAccountMap();
            this.allInit.getAndSet(true);
        }
        logger.error("\u6240\u6709\u8d44\u91d1\u8bc1\u5238\u8d26\u6237\uff1a" + this.allMapSecAccount);
        return this.allMapSecAccount;
    }

    private synchronized void queryAllSecAccountMap() throws MException {
        this.allMapSecAccount.clear();
        ObservableList<FundAccount> fundList = this.fundService.getExtAssetFundAccs();
        logger.error("\u6240\u6709\u8d44\u91d1\u8d26\u6237\uff1a" + fundList);
        for (FundAccount fund : fundList) {
            this.allMapSecAccount.put(fund, this.querySecAccountList(fund));
        }
        this.mapSecAccount.clear();
        ObservableList<FundAccount> ccsFundList = this.fundService.getFundAccountList();
        for (FundAccount fund : ccsFundList) {
            this.mapSecAccount.put(fund, this.allMapSecAccount.get(fund));
        }
    }

    @Override
    public synchronized Map<FundAccount, List<SecAccount>> getMarginSecAccountMap() throws MException {
        if (!this.marginInit.get()) {
            this.queryMarginSecAccountMap();
            this.marginInit.getAndSet(true);
        }
        return this.allMapMarginSecAccount;
    }

    private synchronized Map<FundAccount, List<SecAccount>> queryMarginSecAccountMap() throws MException {
        this.allMapMarginSecAccount.clear();
        List<FundAccount> fundList = this.fundService.getMarginFundAccountList();
        for (FundAccount fund : fundList) {
            logger.info("\u67e5\u8be2\u878d\u8d44\u878d\u5238\u7684\u8bc1\u5238\u8d26\u53f7\uff1a" + fund);
            this.allMapMarginSecAccount.put(fund, this.querySecAccountList(fund));
        }
        return this.allMapMarginSecAccount;
    }

    @Override
    public PBase.OpStatus addSecAccount(SecAccount sec, Account account) throws MException {
        PAccount.SecAccnt.Builder secAccnt = PAccount.SecAccnt.newBuilder();
        secAccnt.setOpenTime("");
        secAccnt.setCloseTime("");
        secAccnt.setCloseReason("");
        secAccnt.setStatus(1);
        PAccount.ExtSecAccnt.Builder extSecAccnt = PAccount.ExtSecAccnt.newBuilder();
        extSecAccnt.setExtAccntId(sec.getExtAccntId());
        extSecAccnt.setExtSecAccntId(sec.getExtSecAccntId());
        if ("H".equals(sec.getCategory().getRaw())) {
            if ("XSHG".equals(sec.getExchange().getRaw())) {
                extSecAccnt.setMarket("SHSC");
            } else if ("XSHE".equals(sec.getExchange().getRaw())) {
                extSecAccnt.setMarket("SZSC");
            } else {
                extSecAccnt.setMarket(sec.getExchange().getRaw());
            }
            extSecAccnt.setCurrencyId("HKD");
        } else {
            extSecAccnt.setMarket(sec.getExchange().getRaw());
            extSecAccnt.setCurrencyId(sec.getCurrency().getRaw());
        }
        extSecAccnt.setInvestorSecId(sec.getInverstorSecId());
        extSecAccnt.setInvestorId(sec.getInverstorId());
        extSecAccnt.setExtSecAccntName(sec.getExtSecAccntId());
        String type = MarketUtils.getMarketGroup((String)sec.getExchange().getRaw());
        if ("XOTC".equals(sec.getExchange().getRaw()) && "99999-01-01".equals(account.getTradePlatformId())) {
            type = "CCS";
        }
        if (type.equals("CCS")) {
            extSecAccnt.setSubMarket(sec.getCategory().getRaw());
        } else if (type.equals("FUTURES")) {
            CtpSecAccount ctpSec = (CtpSecAccount)CtpSecAccount.class.cast(sec);
            extSecAccnt.setMemberId(ctpSec.getMemberId());
            extSecAccnt.setClientId(ctpSec.getClientId());
            extSecAccnt.setPurpose(ctpSec.getHedgeFlag());
        } else if (type.equals("IB")) {
            extSecAccnt.setCustodianInstitutionName(sec.getCustodianInstitutionName().getValue());
            extSecAccnt.setSecuritiesAccountName(sec.getSecuritiesAccountName());
            extSecAccnt.setCustodianEntityCode(sec.getCustodianInstitutionName().getRaw());
        }
        extSecAccnt.setMarketGrp(type);
        extSecAccnt.setSecAccnt(secAccnt);
        PBase.OpStatus status = this.secApi.addSecAccount(extSecAccnt.build(), type, sec.getExchange().getRaw());
        return status;
    }

    @Override
    public PBase.OpStatus delSecAccount(SecAccount sec, Account account) throws MException {
        PAccount.ExtSecAccnt.Builder extSecAccnt = PAccount.ExtSecAccnt.newBuilder();
        extSecAccnt.setMarket(sec.getExchange().getRaw());
        extSecAccnt.setExtSecAccntId(sec.getOldExtSecAccntId());
        extSecAccnt.setMarketGrp(sec.getMarketGrp());
        if ("XOTC".equals(sec.getExchange().getRaw()) && "99999-01-01".equals(account.getTradePlatformId())) {
            extSecAccnt.setMarketGrp("CCS");
        }
        PBase.OpStatus status = this.secApi.delSecAccount(extSecAccnt.build());
        return status;
    }
}

