/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IRoleApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.hierarchy.PRbac;
import cms.tmx.entity.Role;
import cms.tmx.entity.factory.RoleFactory;
import cms.tmx.manage.IRoleService;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class RoleMngServiceImpl
implements IRoleService {
    @Inject
    private IRoleApi ira;
    @Inject
    private MObjFactory of;
    @Inject
    private RoleFactory rf;

    @Override
    public List<Role> getRoleListByParty(String partyId) throws MException {
        LinkedList<Role> rolies = new LinkedList<Role>();
        if (partyId.isEmpty()) {
            return rolies;
        }
        List rList = this.ira.getRoleListByParty(partyId);
        ArrayList postList = new ArrayList();
        rList.forEach(item -> {
            postList.clear();
            Role role = this.rf.create();
            role.update((Object)item.getRole());
            item.getPostList().forEach(post -> postList.add(post.getPostName()));
            role.setPostName(String.join((CharSequence)",", postList));
            rolies.add(role);
        });
        return rolies;
    }

    @Override
    public List<String> getRoleIdListByPost(String postId) throws MException {
        LinkedList<String> ids = new LinkedList<String>();
        if (postId.isEmpty()) {
            return ids;
        }
        List rList = this.ira.getRoleIdListByPost(postId);
        rList.forEach(item -> ids.add((String)item));
        return ids;
    }

    public String addRole(Role role) throws MException {
        PRbac.Role.Builder rBuilder = PRbac.Role.newBuilder();
        rBuilder.setRoleName(role.getName());
        rBuilder.setPartyId(role.getPartyId());
        rBuilder.setDescription(role.getDes());
        rBuilder.setRoleType(Integer.parseInt(role.getRoleType().getRaw()));
        return this.ira.addRole(rBuilder.build());
    }

    public void updateRole(Role role) throws MException {
        PRbac.Role.Builder rBuilder = PRbac.Role.newBuilder();
        rBuilder.setRoleName(role.getName());
        rBuilder.setPartyId(role.getPartyId());
        rBuilder.setDescription(role.getDes());
        rBuilder.setRoleId(role.getId());
        rBuilder.setRoleType(Integer.parseInt(role.getRoleType().getRaw()));
        if (!role.getStatus().getRaw().isEmpty()) {
            rBuilder.setStatus(Integer.parseInt(role.getStatus().getRaw()));
        } else {
            rBuilder.setStatus(1);
        }
        this.ira.updateRole(rBuilder.build());
    }

    @Override
    public Role getRoleDetail(String roleId) throws MException {
        PRbac.Role pRole = this.ira.getRoleDetail(roleId);
        Role role = (Role)this.of.create(Role.class);
        role.update((Object)pRole);
        return role;
    }

    public void enableRole(Role role, boolean enable) throws MException {
        PRbac.Role.Builder rBuilder = PRbac.Role.newBuilder();
        rBuilder.setRoleName(role.getName());
        rBuilder.setPartyId(role.getPartyId());
        rBuilder.setDescription(role.getDes());
        rBuilder.setRoleId(role.getId());
        rBuilder.setRoleType(Integer.valueOf(role.getRoleType().getRaw()).intValue());
        if (enable) {
            rBuilder.setStatus(1);
        } else {
            rBuilder.setStatus(3);
        }
        this.ira.updateRole(rBuilder.build());
    }

    public void assignFuncToRole(String roleId, List<String> funcIds) throws MException {
        this.ira.assignFuncToRole(roleId, funcIds);
    }
}

