/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IProductApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.datatype.proto.product.PProduct;
import cms.tmx.entity.Product;
import cms.tmx.entity.factory.ProductFactory;
import cms.tmx.manage.IProductService;
import cms.tmx.utils.StringUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class ProductMngServiceImpl
implements IProductService {
    @Inject
    private IProductApi productApi;
    @Inject
    private MObjFactory of;
    @Inject
    private ProductFactory pf;
    private Map<String, Product> cacheMap = new HashMap<String, Product>();

    @Override
    public String addProduct(Product product) throws MException {
        PProduct.Product.Builder pBuilder = PProduct.Product.newBuilder();
        pBuilder.setName(product.getName());
        pBuilder.setDescription(product.getDes());
        pBuilder.setManager(product.getManager());
        pBuilder.setNetValue(product.getNetValue());
        pBuilder.setShares(StringUtils.parseDouble((String)product.getShares()));
        pBuilder.setBeginDate(product.getBeginDate());
        pBuilder.setEndDate(product.getEndDate());
        if (!product.getType().getRaw().isEmpty()) {
            pBuilder.setType(Integer.parseInt(product.getType().getRaw()));
        }
        return this.productApi.addProduct(pBuilder.build(), product.getPartyId());
    }

    @Override
    public void updateProduct(Product product) throws MException {
        PProduct.Product.Builder pBuilder = PProduct.Product.newBuilder();
        pBuilder.setProductId(product.getId());
        pBuilder.setName(product.getName());
        pBuilder.setDescription(product.getDes());
        pBuilder.setManager(product.getManager());
        pBuilder.setNetValue(product.getNetValue());
        pBuilder.setShares(StringUtils.parseDouble((String)product.getShares()));
        pBuilder.setBeginDate(product.getBeginDate());
        pBuilder.setEndDate(product.getEndDate());
        pBuilder.setStatus(Integer.parseInt(product.getStatus().getRaw()));
        if (!product.getType().getRaw().isEmpty()) {
            pBuilder.setType(Integer.parseInt(product.getType().getRaw()));
        }
        pBuilder.setBenchmarkType(product.getBenchmarkType());
        pBuilder.addAllBenchmarkId((Iterable)product.getBenchmarkList());
        this.productApi.updateProduct(pBuilder.build());
    }

    @Override
    public void delProduct(String id) throws MException {
        this.productApi.delProduct(id);
    }

    @Override
    public List<Product> getProducts(String partyId) throws MException {
        LinkedList<Product> list = new LinkedList<Product>();
        List pds = this.productApi.getProducts(partyId);
        pds.forEach(item -> {
            Product product = this.pf.create();
            product.update(item);
            list.add(product);
        });
        return list;
    }

    @Override
    public List<Product> getProductsByPartyId(String partyId, PCommon.AssignType type, PHierarchy.GetProductIdsViaPartyReq.Option option) throws MException {
        List ids = this.productApi.getProductsByPartyId(partyId, type, option);
        LinkedList<Product> list = new LinkedList<Product>();
        ids.forEach(item -> {
            Product product = this.pf.create();
            product.update(item);
            list.add(product);
        });
        return list;
    }

    @Override
    public List<String> getProductIdsByPartyId(String partyId, PCommon.AssignType type, PHierarchy.GetProductIdsViaPartyReq.Option option) throws MException {
        LinkedList<String> list = new LinkedList<String>();
        this.productApi.getProductIdsByPartyId(partyId, type, option).forEach(item -> list.add((String)item));
        return list;
    }

    @Override
    public Product getProductDetail(String id) throws MException {
        PProduct.ProductDetails pd = this.productApi.getProductDetail(id);
        Product product = (Product)this.of.create(Product.class);
        product.update((Object)pd);
        return product;
    }

    @Override
    public Product getProductDetailFromCache(String id) throws MException {
        if (this.cacheMap.get(id) == null) {
            PProduct.ProductDetails pd = this.productApi.getProductDetail(id);
            Product product = (Product)this.of.create(Product.class);
            product.update((Object)pd);
            this.cacheMap.put(id, product);
        }
        return this.cacheMap.get(id);
    }

    @Override
    public List<String> getProductIdsByPostId(String postId) throws MException {
        LinkedList<String> productIds = new LinkedList<String>();
        this.productApi.getProductIdsByPostId(postId).forEach(item -> productIds.add((String)item));
        return productIds;
    }

    @Override
    public void assignAccountToProduct(List<String> accountIds, String productId, PCommon.Operation operation) throws MException {
        this.productApi.assignAccountToProduct(accountIds, productId, operation, 1);
    }

    @Override
    public void enableProduct(Product product, boolean enable) throws MException {
        PProduct.Product.Builder pBuilder = PProduct.Product.newBuilder();
        pBuilder.setProductId(product.getId());
        pBuilder.setName(product.getName());
        pBuilder.setDescription(product.getDes());
        pBuilder.setManager(product.getManager());
        pBuilder.setNetValue(product.getNetValue());
        pBuilder.setShares(StringUtils.parseDouble((String)product.getShares()));
        pBuilder.setBeginDate(product.getBeginDate());
        pBuilder.setEndDate(product.getEndDate());
        pBuilder.setStatus(enable ? 1 : 3);
        if (!product.getType().getRaw().isEmpty()) {
            pBuilder.setType(Integer.parseInt(product.getType().getRaw()));
        }
        this.productApi.updateProduct(pBuilder.build());
    }
}

