/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IPostApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PPost;
import cms.tmx.entity.Post;
import cms.tmx.entity.PostControl;
import cms.tmx.entity.User;
import cms.tmx.entity.factory.PostFactory;
import cms.tmx.entity.factory.UserFactory;
import cms.tmx.javafx.LoggerInterface;
import cms.tmx.manage.IPostService;
import cms.tmx.manage.models.UserMngServiceImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PostMngServiceImpl
extends LoggerInterface
implements IPostService {
    @Inject
    private IPostApi ipa;
    @Inject
    private IBaseApi iba;
    @Inject
    private PostFactory pf;
    @Inject
    private UserFactory uf;
    @Inject
    private UserMngServiceImpl userMng;

    @Override
    public List<Post> getPostDetailList(String userId) throws MException {
        List list = this.ipa.getPostList(userId);
        LinkedList<Post> posts = new LinkedList<Post>();
        list.forEach(item -> {
            Post post = this.pf.create();
            post.update(item);
            posts.add(post);
        });
        return posts;
    }

    @Override
    public List<Post> getPostList(String partyId, Boolean all) throws MException {
        LinkedList<Post> posts = new LinkedList<Post>();
        if (partyId.isEmpty()) {
            return posts;
        }
        List list = this.ipa.getPostList(partyId, all);
        ArrayList userIdList = new ArrayList();
        list.forEach(item -> item.getUserList().forEach(userItem -> userIdList.add(userItem.getUserId())));
        this.userMng.getUserList(userIdList.stream().distinct().collect(Collectors.toList()));
        list.forEach(item -> {
            Post post = this.pf.create();
            post.update((Object)item.getPost());
            ArrayList userIds = new ArrayList();
            item.getUserList().forEach(userItem -> userIds.add(userItem.getUserId()));
            ArrayList userNameList = new ArrayList();
            userIds.forEach(userId -> userNameList.add((String)this.userMng.getUserName((String)userId).get()));
            post.setAuthUser(String.join((CharSequence)",", userNameList));
            posts.add(post);
        });
        return posts;
    }

    @Override
    public List<User> getUserList(List<String> postIds, String partyId, boolean all) throws MException {
        LinkedList<User> users = new LinkedList<User>();
        if (partyId.isEmpty()) {
            return users;
        }
        List list = this.ipa.getPostList(partyId, Boolean.valueOf(all));
        HashSet userIds = new HashSet();
        list.forEach(item -> {
            if (postIds.contains(item.getPost().getPostId())) {
                item.getUserList().forEach(userItem -> userIds.add(userItem.getUserId()));
            }
        });
        this.userMng.getUserList(new ArrayList<String>(userIds));
        userIds.forEach(userId -> {
            User user = this.uf.create();
            user.setId(userId);
            user.setName((String)this.userMng.getUserName((String)userId).get());
            users.add(user);
        });
        return users;
    }

    public String addPost(Post post) throws MException {
        PPost.Post.Builder p = PPost.Post.newBuilder();
        p.setPartyId(post.getPartyId());
        p.setPostName(post.getName());
        if (!post.getType().getRaw().isEmpty()) {
            p.setPostTypeValue(Integer.parseInt(post.getType().getRaw()));
        }
        if (!post.getStatus().getRaw().isEmpty()) {
            p.setStatus(Integer.parseInt(post.getStatus().getRaw()));
        }
        p.setDescription(post.getDesc());
        return this.ipa.addPost(p.build());
    }

    public void enablePost(Post post, boolean enable) throws MException {
        PPost.Post.Builder p = PPost.Post.newBuilder();
        p.setPostId(post.getId());
        p.setPartyId(post.getPartyId());
        p.setPostName(post.getName());
        p.setStatus(enable ? 1 : 3);
        if (!post.getType().getRaw().isEmpty()) {
            p.setPostTypeValue(Integer.parseInt(post.getType().getRaw()));
        }
        p.setDescription(post.getDesc());
        this.ipa.updatePost(p.build());
    }

    public void updatePost(Post post) throws MException {
        PPost.Post.Builder p = PPost.Post.newBuilder();
        p.setPostId(post.getId());
        p.setPartyId(post.getPartyId());
        p.setPostName(post.getName());
        if (!post.getType().getRaw().isEmpty()) {
            p.setPostTypeValue(Integer.parseInt(post.getType().getRaw()));
        }
        if (!post.getStatus().getRaw().isEmpty()) {
            p.setStatus(Integer.parseInt(post.getStatus().getRaw()));
        }
        p.setDescription(post.getDesc());
        p.setIsAutoAssocaite(post.isAutoAssocaite() ? 1 : 0);
        this.ipa.updatePost(p.build());
    }

    @Override
    public Post getPostDetail(String postId) throws MException {
        PPost.Post pPost = this.ipa.getPostDetail(postId);
        Post post = this.pf.create();
        post.update((Object)pPost);
        return post;
    }

    @Override
    public Post getUserPost() throws MException {
        return this.getPostDetail(this.iba.getPostId());
    }

    public String getPostId() {
        return this.iba.getPostId();
    }

    public void assignRoleToPost(String roleId, String postId, PCommon.Operation option) throws MException {
        this.ipa.assignRoleToPost(roleId, postId, option);
    }

    public void assignAccountToPost(String accntId, String postId, PCommon.Operation option) throws MException {
        this.ipa.assignAccountToPost(accntId, postId, option);
    }

    public void assignProductToPost(String productId, String postId, PCommon.Operation option) throws MException {
        this.ipa.assignProductToPost(productId, postId, option);
    }

    public void assignPortfolioToPost(String portfolioId, String postId, PCommon.Operation option) throws MException {
        this.ipa.assignPortfolioToPost(portfolioId, postId, option);
    }

    @Override
    public List<String> getPostIdsByUser(String userId) throws MException {
        if (userId.isEmpty()) {
            return new LinkedList<String>();
        }
        return this.ipa.getPostIdList(userId);
    }

    public List<String> getPostIdViaPortfolio(String portfolioId) throws MException {
        if (portfolioId.isEmpty()) {
            return new LinkedList<String>();
        }
        return this.ipa.getPostIdViaPortfolio(portfolioId);
    }

    public List<String> getPostIdViaExtAccnt(String accntId) throws MException {
        if (accntId.isEmpty()) {
            return new LinkedList<String>();
        }
        return this.ipa.getPostIdViaExtAccnt(accntId);
    }

    public List<Post> getPosts(List<String> postIds) throws MException {
        LinkedList<Post> l = new LinkedList<Post>();
        if (postIds.size() <= 0) {
            return l;
        }
        this.ipa.getPosts(postIds).forEach(item -> {
            Post post = this.pf.create();
            post.update(item);
            l.add(post);
        });
        return l;
    }

    public List<PostControl> getPostControl(String postId) throws MException {
        LinkedList<PostControl> postControls = new LinkedList<PostControl>();
        if (!postId.isEmpty()) {
            this.ipa.getPostControl(postId).forEach(item -> {
                PostControl postControl = new PostControl();
                postControl.update(item);
                postControls.add(postControl);
            });
        }
        return postControls;
    }

    public void updatePostControl(List<PostControl> postControls, int type, String postId, String partyId, boolean macFlag, boolean ipFlag) throws MException {
        LinkedList<PPost.PostControl> list = new LinkedList<PPost.PostControl>();
        for (PostControl userControl : postControls) {
            PPost.PostControl.Builder control = PPost.PostControl.newBuilder();
            control.setOptionValue(userControl.getType());
            control.setValue(userControl.getValue());
            control.setPartyControlId(userControl.getPartyControlId());
            control.setFlag(userControl.getType() == 1 ? macFlag : ipFlag);
            list.add(control.build());
        }
        this.ipa.updatePostControl(list, type, postId, partyId, macFlag, ipFlag);
    }

    public void operatePostControl(PostControl control, int type, String postId, String partyId, boolean macFlag, boolean ipFlag) throws MException {
        PPost.PostControl.Builder pControl = PPost.PostControl.newBuilder();
        pControl.setOptionValue(control.getType());
        pControl.setValue(control.getValue());
        pControl.setPartyControlId(control.getPartyControlId());
        pControl.setFlag(control.getType() == 1 ? macFlag : ipFlag);
        this.ipa.operatePostControl(pControl.build(), type, postId, partyId, macFlag, ipFlag);
    }

    public List<String> getUserIdsViaPostId(String postId) {
        try {
            return this.ipa.getUserIdsViaPostId(postId);
        }
        catch (MException mException) {
            this.logger.error("\u6839\u636e\u804c\u4f4did\uff0c\u83b7\u53d6\u7528\u6237id\u5931\u8d25");
            return new ArrayList<String>();
        }
    }
}

