/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IAccountApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.AccountAssignDetail;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.factory.AccountFactory;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PortfolioWorkFlowModel {
    @Inject
    private PortfolioMngServiceImpl portfolioMng;
    @Inject
    private IAccountApi api;
    @Inject
    private AccountFactory af;

    private List<AccountAssignDetail> getAccountList(List<String> ids) throws MException {
        List accntList = this.api.getAccountList(ids);
        LinkedList<AccountAssignDetail> list = new LinkedList<AccountAssignDetail>();
        accntList.forEach(item -> {
            AccountAssignDetail accnt = this.af.createAccountAssignDetail();
            accnt.update(item);
            list.add(accnt);
        });
        return list;
    }

    public List<AccountAssignDetail> getAccountList(Portfolio selectPortfolio) throws MException {
        LinkedList<AccountAssignDetail> list = new LinkedList<AccountAssignDetail>();
        LinkedList<String> listAccnts = new LinkedList<String>();
        HashMap<String, PPortfolio.PortAccntAssignDetails> assMap = new HashMap<String, PPortfolio.PortAccntAssignDetails>();
        for (PPortfolio.PortAccntAssignDetails detail : this.portfolioMng.getAccntIdoByPortfolio(selectPortfolio.getId())) {
            if (detail.getAccntType() == 2 && detail.getAssignStatus() == 1) {
                listAccnts.add(detail.getParentId());
            }
            assMap.put(detail.getParentId(), detail);
        }
        this.getAccountList(listAccnts).forEach(item -> {
            item.setSubAccountId(((PPortfolio.PortAccntAssignDetails)assMap.get(item.getId())).getAccountId());
            list.add((AccountAssignDetail)item);
        });
        return list;
    }
}

