/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IFundAccountApi;
import cms.tmx.api.mng.ISecAccountApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MException;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.Account;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.SecAccount;
import cms.tmx.http.accnt.AccountServiceApi;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.manage.models.PortfolioMngServiceImpl;
import cms.tmx.manage.models.SecAccountMngServiceImpl;
import cms.tmx.utils.MarketUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PortfolioRelateAccntModel {
    @Inject
    private PortfolioMngServiceImpl portfolioMng;
    @Inject
    private IFundAccountApi fundAccountApi;
    @Inject
    private FundAccountMngServiceImpl fundService;
    @Inject
    private SecAccountMngServiceImpl secAccountMng;
    @Inject
    private AccountServiceApi newAccApi;
    @Inject
    private ISecAccountApi secAccountApi;
    @Inject
    private MConfService cs;
    private static final Logger logger = LogManager.getLogger(PortfolioRelateAccntModel.class);
    private Portfolio selectPortfolio;
    private Map<String, PPortfolio.PortAccntAssignDetails> oldAssMap = new HashMap<String, PPortfolio.PortAccntAssignDetails>();
    private Map<String, Account> map = new HashMap<String, Account>();
    private ObservableSet<String> oldAccnts = FXCollections.observableSet(new HashSet());
    private Map<String, PAccount.ExtFundAccnt> extFundMap = new HashMap<String, PAccount.ExtFundAccnt>();
    private Map<String, List<PAccount.ExtSecAccnt>> extSecMap = new HashMap<String, List<PAccount.ExtSecAccnt>>();
    private Map<String, PAccount.SubFundAccnt> subFundMap = new HashMap<String, PAccount.SubFundAccnt>();
    private Map<String, List<PAccount.SubSecAccnt>> subSecMap = new HashMap<String, List<PAccount.SubSecAccnt>>();

    @Deprecated
    public void submit() throws MException {
    }

    public void resetOldAssetMap() throws MException {
        this.oldAccnts.clear();
        this.oldAssMap.clear();
        for (PPortfolio.PortAccntAssignDetails detail : this.portfolioMng.getAccntIdoByPortfolio(this.selectPortfolio.getId())) {
            if (detail.getAccntType() == 2 && detail.getAssignStatus() == 1) {
                this.oldAccnts.add((Object)detail.getParentId());
            }
            this.oldAssMap.put(detail.getParentId(), detail);
        }
    }

    public Portfolio getSelectPortfolio() {
        return this.selectPortfolio;
    }

    public void setSelectPortfolio(Portfolio selectPortfolio) {
        this.selectPortfolio = selectPortfolio;
    }

    public Map<String, PPortfolio.PortAccntAssignDetails> getOldAssMap() {
        return this.oldAssMap;
    }

    public void setOldAssMap(Map<String, PPortfolio.PortAccntAssignDetails> oldAssMap) {
        this.oldAssMap = oldAssMap;
    }

    public Map<String, Account> getMap() {
        return this.map;
    }

    public void setMap(Map<String, Account> map) {
        this.map = map;
    }

    public ObservableSet<String> getOldAccnts() {
        return this.oldAccnts;
    }

    public void setOldAccnts(ObservableSet<String> oldAccnts) {
        this.oldAccnts = oldAccnts;
    }

    private void addOrUpdateSubFund(Account accnt, String subAccntId, int status) throws MException {
        String marketGrp = MarketUtils.getMarketGroup((String)((String)accnt.getSecExc().get(0)));
        this.fillSubMap(accnt, subAccntId);
        for (String cur : accnt.getCurrency()) {
            PAccount.ExtFundAccnt extFund = this.extFundMap.get(String.valueOf(accnt.getId()) + cur + marketGrp + accnt.getInvestorId());
            if (extFund == null) continue;
            List<PAccount.ExtSecAccnt> extSecList = this.extSecMap.get(String.valueOf(extFund.getParentAccntId()) + extFund.getCurrencyId() + extFund.getMarketGrp() + extFund.getInvestorId());
            PAccount.SubFundAccnt subFund = this.subFundMap.get(String.valueOf(extFund.getExtAccntId()) + this.selectPortfolio.getId() + cur + accnt.getId() + subAccntId + accnt.getInvestorId());
            if (subFund != null) {
                this.addOrUpdateSubSec(accnt, subAccntId, cur, extFund, extSecList, subFund.getSubAccntId(), status);
                this.portfolioMng.updateSubFundAccnt(subFund, marketGrp, status, this.selectPortfolio.getIsVerifyFund());
                continue;
            }
            String subFundId = this.portfolioMng.addSubFundAccnt(extFund.getExtAccntId(), this.selectPortfolio.getId(), accnt.getId(), accnt.getInvestorId(), subAccntId, cur, marketGrp, this.selectPortfolio.getIsVerifyFund());
            this.addOrUpdateSubSec(accnt, subAccntId, cur, extFund, extSecList, subFundId, status);
        }
    }

    private void addOrUpdateSubSec(Account accnt, String subAccntId, String cur, PAccount.ExtFundAccnt extFund, List<PAccount.ExtSecAccnt> extSecList, String subFundId, int status) throws MException {
        List<PAccount.SubSecAccnt> subSecAccounts = this.subSecMap.get(String.valueOf(extFund.getExtAccntId()) + this.selectPortfolio.getId() + cur + accnt.getId() + subAccntId + accnt.getInvestorId());
        if (extSecList != null) {
            if (subSecAccounts == null) {
                this.portfolioMng.addSubSecAccnt(accnt, extSecList, subAccntId, subFundId, this.selectPortfolio.getId(), this.selectPortfolio.getIsVerifySecu(), status);
            } else {
                HashMap<String, PAccount.SubSecAccnt> subMap = new HashMap<String, PAccount.SubSecAccnt>();
                for (PAccount.SubSecAccnt subSec : subSecAccounts) {
                    subMap.put(String.valueOf(subSec.getExtSecAccntId()) + subSec.getPortfolioId(), subSec);
                }
                LinkedList<PAccount.SubSecAccnt> list = new LinkedList<PAccount.SubSecAccnt>();
                LinkedList<PAccount.ExtSecAccnt> list2 = new LinkedList<PAccount.ExtSecAccnt>();
                String m = "";
                for (PAccount.ExtSecAccnt extSec : extSecList) {
                    PAccount.SubSecAccnt subSec = (PAccount.SubSecAccnt)subMap.get(String.valueOf(extSec.getExtSecAccntId()) + this.selectPortfolio.getId());
                    if (subSec != null) {
                        list.add(subSec);
                        m = MarketUtils.getMarketGroup((String)extSec.getMarket());
                        continue;
                    }
                    list2.add(extSec);
                }
                this.portfolioMng.updateSubSecAccnts(list, this.selectPortfolio.getIsVerifySecu(), status, m);
                this.portfolioMng.addSubSecAccnt(accnt, list2, subAccntId, subFundId, this.selectPortfolio.getId(), this.selectPortfolio.getIsVerifySecu(), status);
            }
        }
    }

    private void fillExtMap(Account accnt, List<SecAccount> secAccounts) throws MException {
        this.extFundMap.clear();
        this.extSecMap.clear();
        LinkedList<String> filterList = new LinkedList<String>();
        for (SecAccount sec : secAccounts) {
            filterList.add(String.valueOf(sec.getInverstorSecId()) + sec.getExchange().getRaw());
        }
        String marketGrp = MarketUtils.getMarketGroup((String)((String)accnt.getSecExc().get(0)));
        List extFundList = this.fundAccountApi.getFundAccountList(accnt.getId(), marketGrp);
        for (PAccount.ExtFundAccnt extFund : extFundList) {
            this.extFundMap.put(String.valueOf(extFund.getParentAccntId()) + extFund.getCurrencyId() + extFund.getMarketGrp() + extFund.getInvestorId(), extFund);
            List extSecList = this.secAccountApi.getSecAccountList(extFund);
            LinkedList<PAccount.ExtSecAccnt> secAccnts = new LinkedList<PAccount.ExtSecAccnt>();
            for (PAccount.ExtSecAccnt extSecAccnt : extSecList) {
                if (!filterList.contains(String.valueOf(extSecAccnt.getInvestorSecId()) + extSecAccnt.getMarket())) continue;
                secAccnts.add(extSecAccnt);
            }
            this.extSecMap.put(String.valueOf(extFund.getParentAccntId()) + extFund.getCurrencyId() + extFund.getMarketGrp() + extFund.getInvestorId(), secAccnts);
        }
    }

    public void fillSubMap(Account accnt, String subAccntId) throws MException {
        this.subFundMap.clear();
        this.subSecMap.clear();
        String marketGrp = MarketUtils.getMarketGroup((String)((String)accnt.getSecExc().get(0)));
        PAccount.SubFundAccnt.Builder newBuilder = PAccount.SubFundAccnt.newBuilder();
        newBuilder.setPortfolioId(this.selectPortfolio.getId());
        newBuilder.setParentExtAccntId(accnt.getId());
        newBuilder.setParentSubAccntId(subAccntId);
        List subFundAccountList = this.fundAccountApi.getSubFundAccountList(marketGrp, newBuilder.build());
        for (PAccount.SubFundAccnt subFundAccnt : subFundAccountList) {
            PAccount.SubSecAccnt.Builder newBuilder2 = PAccount.SubSecAccnt.newBuilder();
            newBuilder2.setSubAccntId(subFundAccnt.getSubAccntId());
            List subSecAccounts = this.secAccountApi.getSubSecAccounts(marketGrp, newBuilder2.build());
            this.subFundMap.put(String.valueOf(subFundAccnt.getExtAccntId()) + subFundAccnt.getPortfolioId() + subFundAccnt.getCurrencyId() + subFundAccnt.getParentExtAccntId() + subFundAccnt.getParentSubAccntId() + subFundAccnt.getInvestorId(), subFundAccnt);
            this.subSecMap.put(String.valueOf(subFundAccnt.getExtAccntId()) + subFundAccnt.getPortfolioId() + subFundAccnt.getCurrencyId() + subFundAccnt.getParentExtAccntId() + subFundAccnt.getParentSubAccntId() + subFundAccnt.getInvestorId(), subSecAccounts);
        }
    }

    public List<SecAccount> getSecAccounts(Account account) throws MException, Exception {
        ObservableList secList = FxUtils.newList();
        ObservableList subSecList = FxUtils.newList();
        List<FundAccount> fundList = this.fundService.queryFundAccountList(account.getId(), account.getSecExc());
        for (FundAccount fund : fundList) {
            secList.addAll(this.secAccountMng.querySecAccountList(fund));
        }
        if (!this.oldAccnts.contains((Object)account.getId())) {
            return secList;
        }
        PPortfolio.PortAccntAssignDetails ass = this.oldAssMap.get(account.getId());
        if (ass == null) {
            return secList;
        }
        if (ass.getParentId().equals(account.getId())) {
            String marketGrp = MarketUtils.getMarketGroup((String)((String)account.getSecExc().get(0)));
            PAccount.SubFundAccnt.Builder newBuilder = PAccount.SubFundAccnt.newBuilder();
            newBuilder.setPortfolioId(this.selectPortfolio.getId());
            newBuilder.setParentExtAccntId(account.getId());
            newBuilder.setParentSubAccntId(ass.getAccountId());
            List subFundAccountList = this.fundAccountApi.getSubFundAccountList(marketGrp, newBuilder.build());
            for (PAccount.SubFundAccnt subFundAccnt : subFundAccountList) {
                PAccount.SubSecAccnt.Builder newBuilder2 = PAccount.SubSecAccnt.newBuilder();
                newBuilder2.setSubAccntId(subFundAccnt.getSubAccntId());
                List subSecAccounts = this.secAccountApi.getSubSecAccounts(marketGrp, newBuilder2.build());
                if (subSecAccounts == null) continue;
                subSecList.addAll(subSecAccounts);
            }
        }
        HashMap<String, PAccount.SubSecAccnt> hashMap = new HashMap<String, PAccount.SubSecAccnt>();
        for (PAccount.SubSecAccnt sub : subSecList) {
            hashMap.put(String.valueOf(sub.getInvestorSecId()) + sub.getMarket(), sub);
        }
        for (SecAccount sAccount : secList) {
            if (hashMap.get(String.valueOf(sAccount.getInverstorSecId()) + sAccount.getExchange().getRaw()) == null || ((PAccount.SubSecAccnt)hashMap.get(String.valueOf(sAccount.getInverstorSecId()) + sAccount.getExchange().getRaw())).getStatus() != 1) continue;
            sAccount.setSelected(true);
        }
        return secList;
    }

    public void submitNew(Account account, List<SecAccount> oldSecAccounts, List<SecAccount> nowSecAccounts, int totalSecSize) throws MException {
        MEvent event;
        boolean haveException;
        block17: {
            haveException = false;
            event = new MEvent(1999, "");
            LinkedList<SecAccount> listAdd = new LinkedList<SecAccount>();
            LinkedList<SecAccount> listDelete = new LinkedList<SecAccount>();
            for (SecAccount sec : nowSecAccounts) {
                if (oldSecAccounts.contains(sec)) continue;
                listAdd.add(sec);
            }
            for (SecAccount sec : oldSecAccounts) {
                if (nowSecAccounts.contains(sec)) continue;
                listDelete.add(sec);
            }
            if (totalSecSize == listDelete.size() && listAdd.size() == 0) {
                PPortfolio.PortAccntAssignDetails ass = this.oldAssMap.get(account.getId());
                if (ass != null && ass.getAccntType() == 2 && ass.getAssignStatus() == 1) {
                    try {
                        this.fillExtMap(this.map.get(account.getId()), listDelete);
                        this.addOrUpdateSubFund(this.map.get(account.getId()), ass.getAccountId(), 0);
                        this.portfolioMng.AssignAccntToPortfolio(this.selectPortfolio.getId(), this.map.get(account.getId()), ass.getAccountId(), PCommon.Operation.OP_DELETE);
                    }
                    catch (MException e) {
                        logger.error((Object)e, (Throwable)e);
                        event.setDesc(String.valueOf(event.getDesc()) + this.map.get(account.getId()).getInvestorId() + e.getDesc() + "\n");
                        haveException = true;
                    }
                }
                this.resetOldAssetMap();
                if (haveException) {
                    throw new MException(event);
                }
                return;
            }
            if (this.oldAssMap.get(account.getId()) != null) {
                if (!listAdd.isEmpty()) {
                    haveException = this.addOrUpdate(account, listAdd, event, 1, haveException, false);
                }
                if (!listDelete.isEmpty()) {
                    boolean isDeleteAll = false;
                    if (nowSecAccounts.size() == 0 && oldSecAccounts.size() == 1) {
                        isDeleteAll = true;
                    }
                    haveException = this.addOrUpdate(account, listDelete, event, 0, haveException, isDeleteAll);
                }
            } else {
                try {
                    this.fillExtMap(account, listAdd);
                    String grp = MarketUtils.getMarketGroup((String)((String)this.map.get(account.getId()).getSecExc().get(0)));
                    boolean haveExtSecAccnt = false;
                    for (String cur : this.map.get(account.getId()).getCurrency()) {
                        List<PAccount.ExtSecAccnt> secAccounts = this.extSecMap.get(String.valueOf(this.map.get(account.getId()).getId()) + cur + grp + this.map.get(account.getId()).getInvestorId());
                        if (secAccounts == null || secAccounts.size() <= 0) continue;
                        haveExtSecAccnt = true;
                    }
                    if (haveExtSecAccnt) {
                        String subId = this.portfolioMng.addSubAccnt(account.getId(), 2);
                        this.addOrUpdateSubFund(this.map.get(account.getId()), subId, 1);
                        this.portfolioMng.AssignAccntToPortfolio(this.selectPortfolio.getId(), this.map.get(account.getId()), subId, PCommon.Operation.OP_ADD);
                        this.oldAccnts.add((Object)account.getId());
                        break block17;
                    }
                    throw new MException(1998, "\u9009\u62e9\u7684\u8d44\u91d1\u8d26\u53f7\uff1a" + this.map.get(account.getId()).getInvestorId() + "\u4e0b\u65e0\u8bc1\u5238\u8d26\u53f7");
                }
                catch (MException e) {
                    logger.error((Object)e, (Throwable)e);
                    event.setDesc(String.valueOf(event.getDesc()) + this.map.get(account.getId()).getInvestorId() + e.getDesc() + "\n");
                    haveException = true;
                }
            }
        }
        this.resetOldAssetMap();
        if (haveException) {
            throw new MException(event);
        }
    }

    private boolean addOrUpdate(Account account, List<SecAccount> list, MEvent event, int status, boolean haveException, boolean isDeleteAll) {
        try {
            PPortfolio.PortAccntAssignDetails ass = this.oldAssMap.get(account.getId());
            this.fillExtMap(this.map.get(account.getId()), list);
            this.addOrUpdateSubFund(this.map.get(account.getId()), ass.getAccountId(), status);
            if (isDeleteAll && status == 0 && ass.getAssignStatus() == 1) {
                this.portfolioMng.AssignAccntToPortfolio(this.selectPortfolio.getId(), this.map.get(account.getId()), ass.getAccountId(), PCommon.Operation.OP_DELETE);
                this.oldAccnts.remove((Object)ass.getParentId());
            }
            if (status == 1 && ass.getAssignStatus() == 2) {
                this.portfolioMng.AssignAccntToPortfolio(this.selectPortfolio.getId(), this.map.get(account.getId()), ass.getAccountId(), PCommon.Operation.OP_ADD);
                this.oldAccnts.add((Object)ass.getParentId());
            }
            return haveException;
        }
        catch (MException e) {
            logger.error((Object)e, (Throwable)e);
            event.setDesc(String.valueOf(event.getDesc()) + this.map.get(account.getId()).getInvestorId() + e.getDesc() + "\n");
            haveException = true;
            return haveException;
        }
    }
}

