/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IAccountApi;
import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.api.mng.ISecAccountApi;
import cms.tmx.api.mng.ISubAccntApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.proto.account.PSubAccnt;
import cms.tmx.datatype.proto.common.PCommon;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.Account;
import cms.tmx.entity.Benchmark;
import cms.tmx.entity.ExternalAsset;
import cms.tmx.entity.Portfolio;
import cms.tmx.entity.factory.PortfolioFactory;
import cms.tmx.http.accnt.AccountServiceApi;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IPortfolioService;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PortfolioMngServiceImpl
implements IPortfolioService {
    @Inject
    private IPortfolioApi portfolioApi;
    @Inject
    private ISubAccntApi subAccntApi;
    @Inject
    private ISecAccountApi oldSecAccntApi;
    @Inject
    private MObjFactory of;
    @Inject
    private PortfolioFactory pfac;
    @Inject
    private AccountServiceApi accntApi;
    @Inject
    private MConfService cs;
    @Inject
    private IAccountApi accApi;
    private Map<String, StringProperty> benchmarkNameMap = new HashMap<String, StringProperty>();
    private Map<String, Portfolio> cacheMap = new HashMap<String, Portfolio>();
    private BooleanProperty addExternalAssetChanged = new SimpleBooleanProperty();

    public String addPortfolio(Portfolio portfolio) throws MException {
        String type;
        PPortfolio.Portfolio.Builder rBuilder = PPortfolio.Portfolio.newBuilder();
        rBuilder.setPortfolioName(portfolio.getName());
        if (portfolio.getType() != null && !(type = portfolio.getType().getRaw()).isEmpty()) {
            rBuilder.setType(Integer.parseInt(type));
        }
        rBuilder.setIsVerifyFund(portfolio.getIsVerifyFund());
        rBuilder.setIsVerifySecu(portfolio.getIsVerifySecu());
        rBuilder.setExportSettlementFlag(portfolio.getExportSettlement());
        rBuilder.setDescription(portfolio.getDes());
        PCommon.CarryOver.Builder cBuilder = PCommon.CarryOver.newBuilder();
        cBuilder.setCarryTypeValue(portfolio.getCarryCode());
        if (portfolio.getCarryCode() == 3) {
            cBuilder.setCarryYears(Double.valueOf(portfolio.getCarryYears()).doubleValue());
        }
        if (portfolio.getCarryCode() != 1) {
            cBuilder.setFirstCarryDay(portfolio.getCarryDay());
        }
        rBuilder.setCarryOver(cBuilder.build());
        if (portfolio.isExternalAsset()) {
            rBuilder.setIsExternalPortfolio(true);
            PPortfolio.ExternalPortfolio.Builder externalPort = PPortfolio.ExternalPortfolio.newBuilder();
            String dataSource = portfolio.getDataSource().getRaw();
            externalPort.setDataSourceValue(Integer.parseInt(dataSource));
            if ("1".equals(dataSource)) {
                externalPort.setAutoSyncConf(PPortfolio.ExternalPortfolio.AutoSyncConfig.AUTO_SYNC_DATA_CENTER);
            }
            externalPort.setExternalPortfolioId(portfolio.getExternalAccnt());
            externalPort.setManualPortfolioId(portfolio.getExternalId());
            externalPort.setManualPortfolioName(portfolio.getExternalName());
            rBuilder.setExtPortfolio(externalPort);
        } else {
            rBuilder.setIsExternalPortfolio(false);
            String nonTraAsset = portfolio.getNonTradableAsset().getRaw();
            if (!"0".equals(nonTraAsset)) {
                rBuilder.addNonTradableAssets(nonTraAsset);
            }
        }
        return this.portfolioApi.addPortfolio(rBuilder.build(), portfolio.getPartyId());
    }

    public void updatePortfolio(Portfolio portfolio) throws MException {
        String status;
        String type;
        PPortfolio.Portfolio.Builder rBuilder = PPortfolio.Portfolio.newBuilder();
        rBuilder.setPortfolioId(portfolio.getId());
        rBuilder.setPortfolioName(portfolio.getName());
        if (portfolio.getType() != null && !(type = portfolio.getType().getRaw()).isEmpty()) {
            rBuilder.setType(Integer.parseInt(type));
        }
        if (portfolio.getStatus() != null && !(status = portfolio.getStatus().getRaw()).isEmpty()) {
            rBuilder.setStatus(Integer.parseInt(status));
        }
        rBuilder.setBenchmarkType(portfolio.getBenchmarkType());
        rBuilder.addAllBenchmark((Iterable)portfolio.getBenchmarkList());
        if (portfolio.getTotalPeriod().isEmpty()) {
            rBuilder.setTotalPeriod(0);
        } else if (portfolio.getTotalPeriod().equals("-1")) {
            rBuilder.setTotalPeriod(-1);
            rBuilder.setValidityPeriod(0);
        } else {
            rBuilder.setTotalPeriod(Integer.valueOf(portfolio.getTotalPeriod()).intValue());
            rBuilder.setValidityPeriod(Integer.valueOf(portfolio.getValPeriod()).intValue());
        }
        rBuilder.setIsVerifyFund(portfolio.getIsVerifyFund());
        rBuilder.setIsVerifySecu(portfolio.getIsVerifySecu());
        rBuilder.setExportSettlementFlag(portfolio.getExportSettlement());
        rBuilder.setDescription(portfolio.getDes());
        PCommon.CarryOver.Builder cBuilder = PCommon.CarryOver.newBuilder();
        cBuilder.setCarryTypeValue(portfolio.getCarryCode());
        if (portfolio.getCarryCode() == 3) {
            cBuilder.setCarryYears(Double.valueOf(portfolio.getCarryYears()).doubleValue());
        }
        if (portfolio.getCarryCode() != 1) {
            cBuilder.setFirstCarryDay(portfolio.getCarryDay());
        }
        rBuilder.setCarryOver(cBuilder.build());
        if (portfolio.isExternalAsset()) {
            rBuilder.setIsExternalPortfolio(true);
            PPortfolio.ExternalPortfolio.Builder externalPort = PPortfolio.ExternalPortfolio.newBuilder();
            String dataSource = portfolio.getDataSource().getRaw();
            externalPort.setDataSourceValue(Integer.parseInt(dataSource));
            if ("1".equals(dataSource)) {
                externalPort.setAutoSyncConf(PPortfolio.ExternalPortfolio.AutoSyncConfig.AUTO_SYNC_DATA_CENTER);
            }
            externalPort.setExternalPortfolioId(portfolio.getExternalAccnt());
            externalPort.setManualPortfolioId(portfolio.getExternalId());
            externalPort.setManualPortfolioName(portfolio.getExternalName());
            rBuilder.setExtPortfolio(externalPort);
        } else {
            rBuilder.setIsExternalPortfolio(false);
            String nonTraAsset = portfolio.getNonTradableAsset().getRaw();
            if (!"0".equals(nonTraAsset)) {
                rBuilder.addNonTradableAssets(nonTraAsset);
            }
        }
        this.portfolioApi.updatePortfolio(rBuilder.build(), portfolio.getPartyId());
    }

    public void enablePortfolio(boolean enable, Portfolio portfolio) throws MException {
        this.portfolioApi.enablePortfolio(portfolio.getId(), enable);
    }

    @Override
    public List<Portfolio> getPortfoliosByParty(String id) throws MException {
        LinkedList<Portfolio> portfolios = new LinkedList<Portfolio>();
        if (id.isEmpty()) {
            return portfolios;
        }
        this.portfolioApi.getPortfoliosByParty(id).forEach(item -> {
            Portfolio portfolio = this.pfac.create();
            portfolio.update(item);
            this.cacheMap.put(id, portfolio);
            portfolios.add(portfolio);
        });
        return portfolios;
    }

    public Portfolio getPortfolioFromCache(String portfId) throws MException {
        if (this.cacheMap.get(portfId) == null) {
            LinkedList<String> ids = new LinkedList<String>();
            ids.add(portfId);
            this.portfolioApi.getPortfoliosByIds(ids).forEach(item -> {
                if (item.getPortfolio().getPortfolioId().equals(portfId)) {
                    Portfolio portfolio = (Portfolio)this.of.create(Portfolio.class);
                    portfolio.update(item);
                    this.cacheMap.put(portfId, portfolio);
                }
            });
        }
        return this.cacheMap.get(portfId);
    }

    @Override
    public Portfolio getPortfolioById(String id) throws MException {
        Portfolio portfolio = (Portfolio)this.of.create(Portfolio.class);
        LinkedList<String> ids = new LinkedList<String>();
        ids.add(id);
        this.portfolioApi.getPortfoliosByIds(ids).forEach(item -> {
            if (item.getPortfolio().getPortfolioId().equals(id)) {
                portfolio.update(item);
            }
        });
        return portfolio;
    }

    @Override
    public List<PPortfolio.PortAccntAssignDetails> getAccntIdoByPortfolio(String id) throws MException {
        List<Object> assignDetails = new LinkedList<PPortfolio.PortAccntAssignDetails>();
        if (!id.isEmpty()) {
            assignDetails = this.portfolioApi.getAccntsByPortfolioIds(id);
        }
        return assignDetails;
    }

    @Override
    public void AssignAccntToPortfolio(String portfolioId, Account accnt, PCommon.Operation op) throws MException {
        this.AssignAccntToPortfolio(portfolioId, accnt, null, op);
    }

    @Override
    public void AssignAccntToPortfolio(String portfolioId, Account accnt, String subAccntId, PCommon.Operation op) throws MException {
        if (PCommon.Operation.OP_ADD == op) {
            PPortfolio.AssignAccntToPortfolioReq.Builder abuild = PPortfolio.AssignAccntToPortfolioReq.newBuilder();
            abuild.setOperation(op);
            abuild.setAccountId(subAccntId);
            abuild.setAccntType(2);
            abuild.setParentId(accnt.getId());
            abuild.setPortfolioId(portfolioId);
            this.portfolioApi.AssignAccntToPortfolio(abuild);
        } else {
            PPortfolio.AssignAccntToPortfolioReq.Builder abuild = PPortfolio.AssignAccntToPortfolioReq.newBuilder();
            abuild.setOperation(op);
            abuild.setAccountId(accnt.getId());
            abuild.setAccntType(1);
            abuild.setPortfolioId(portfolioId);
            this.portfolioApi.AssignAccntToPortfolio(abuild);
        }
    }

    @Override
    public String addSubFundAccnt(String extFundId, String portfolioId, String extAccntId, String invId, String subAccntId, String cur, String marketGrp, int flag) throws MException {
        PAccount.SubFundAccnt.Builder newSub = PAccount.SubFundAccnt.newBuilder();
        newSub.setCurrencyId(cur);
        newSub.setPortfolioId(portfolioId);
        newSub.setExtAccntId(extFundId);
        newSub.setParentSubAccntId(subAccntId);
        newSub.setParentExtAccntId(extAccntId);
        newSub.setInvestorId(invId);
        newSub.setFlags(flag);
        return this.subAccntApi.newSubFundAccnt(newSub.build(), marketGrp);
    }

    @Override
    public void updateSubFundAccnt(PAccount.SubFundAccnt subFund, String marketGrp, int status, int flag) throws MException {
        PAccount.SubFundAccnt.Builder newSub = PAccount.SubFundAccnt.newBuilder();
        newSub.setSubAccntId(subFund.getSubAccntId());
        newSub.setCurrencyId(subFund.getCurrencyId());
        newSub.setPortfolioId(subFund.getPortfolioId());
        newSub.setExtAccntId(subFund.getExtAccntId());
        newSub.setParentSubAccntId(subFund.getParentSubAccntId());
        newSub.setParentExtAccntId(subFund.getParentExtAccntId());
        newSub.setInvestorId(subFund.getInvestorId());
        newSub.setFlags(flag);
        newSub.setStatus(status);
        this.subAccntApi.updateSubFundAccnt(newSub.build(), marketGrp);
    }

    @Override
    public String addSubAccnt(String extAccntId, int isZero) throws MException {
        PSubAccnt.SubAccnt.Builder sub = PSubAccnt.SubAccnt.newBuilder();
        sub.setExtAccntId(extAccntId);
        sub.setIsZero(isZero);
        return this.subAccntApi.newSubAccnt(sub.build());
    }

    @Override
    public void addSubSecAccnt(Account accnt, List<PAccount.ExtSecAccnt> extSecList, String subAccntId, String subFundId, String portfolioId, int flag, int status) throws MException {
        if (extSecList.size() == 0) {
            return;
        }
        String marketGrp = "";
        int m = extSecList.size() / 200;
        int n = extSecList.size() % 200;
        int i = 0;
        while (i < m + 1) {
            List<Object> list = new LinkedList();
            list = i == m ? extSecList.subList(m * 200, m * 200 + n) : extSecList.subList(i * 200, (i + 1) * 200);
            LinkedList<PAccount.SubSecAccnt> subList = new LinkedList<PAccount.SubSecAccnt>();
            LinkedList<String> newExtSecAccntIds = new LinkedList<String>();
            for (PAccount.ExtSecAccnt extSecAccnt : list) {
                PAccount.SubSecAccnt.Builder newSub = PAccount.SubSecAccnt.newBuilder();
                newSub.setSubAccntId(subFundId);
                newSub.setExtSecAccntId(extSecAccnt.getExtSecAccntId());
                newSub.setMarket(extSecAccnt.getMarket());
                newExtSecAccntIds.add(extSecAccnt.getExtSecAccntId());
                newSub.setExtAccntId(extSecAccnt.getExtAccntId());
                newSub.setPortfolioId(portfolioId);
                newSub.setFlags(flag);
                newSub.setStatus(status);
                subList.add(newSub.build());
                marketGrp = extSecAccnt.getMarketGrp();
            }
            this.subAccntApi.newSubSecAccnt(subList, marketGrp);
            ++i;
        }
    }

    @Override
    public void updateSubSecAccnts(List<PAccount.SubSecAccnt> seclist, int flag, int status, String marketGrp) throws MException {
        if (seclist.size() == 0) {
            return;
        }
        int m = seclist.size() / 200;
        int n = seclist.size() % 200;
        int i = 0;
        while (i < m + 1) {
            List<Object> list = new LinkedList();
            LinkedList<PAccount.SubSecAccnt> list2 = new LinkedList<PAccount.SubSecAccnt>();
            list = i == m ? seclist.subList(m * 200, m * 200 + n) : seclist.subList(i * 200, (i + 1) * 200);
            for (PAccount.SubSecAccnt subSecAccnt : list) {
                PAccount.SubSecAccnt.Builder newSub = subSecAccnt.toBuilder();
                newSub.setFlags(flag);
                if (status != -1) {
                    newSub.setStatus(status);
                }
                list2.add(newSub.build());
            }
            this.subAccntApi.updateSubSecAccnt(list2, marketGrp);
            ++i;
        }
    }

    @Override
    public ObservableList<Benchmark> getBenchmarkList(int type) throws MException {
        List listProto = this.portfolioApi.getBenchmarkList(type);
        ObservableList list = FxUtils.newList();
        listProto.forEach(item -> {
            Benchmark bench = new Benchmark();
            bench.update(item);
            list.add((Object)bench);
            this.updateBenchmarkNameMap(bench);
        });
        return list;
    }

    private void updateBenchmarkNameMap(Benchmark benchmark) {
        if (this.benchmarkNameMap.get(benchmark.getId()) == null) {
            this.benchmarkNameMap.put(benchmark.getId(), (StringProperty)new SimpleStringProperty(benchmark.getName()));
        } else {
            this.benchmarkNameMap.get(benchmark.getId()).setValue(benchmark.getName());
        }
    }

    public StringProperty getBenchmarkName(String benchmarkId) {
        StringProperty benchmarkName = this.benchmarkNameMap.get(benchmarkId);
        if (benchmarkName == null) {
            benchmarkName = new SimpleStringProperty(benchmarkId);
            this.benchmarkNameMap.put(benchmarkId, benchmarkName);
        }
        return benchmarkName;
    }

    public void queryBenchmarkMap() throws MException {
        this.benchmarkNameMap.clear();
        this.getBenchmarkList(0);
    }

    public ObservableList<ExternalAsset> getExternalAccounts() throws MException {
        List listResp = this.accApi.getExternalAssets(PHierarchy.ExtAssetType.EXT_ASSET_PORTFOLIO);
        ObservableList list = FxUtils.newList();
        listResp.forEach(asset -> {
            ExternalAsset exter = new ExternalAsset();
            exter.update(asset);
            list.add((Object)exter);
        });
        return list;
    }

    public final BooleanProperty addExternalAssetChangedProperty() {
        return this.addExternalAssetChanged;
    }

    public void addExternalAssetChanged() {
        this.addExternalAssetChanged.set(!this.addExternalAssetChanged.get());
    }
}

