/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IPersonalFuncApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.hierarchy.PRbac;
import cms.tmx.entity.FuncModule;
import cms.tmx.entity.User;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.models.UserMngServiceImpl;
import cms.tmx.rights.IRightService;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.scene.control.TreeItem;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PersonalFuncModel
extends MxModel {
    @Inject
    private IRightService irs;
    @Inject
    private IBaseApi base;
    @Inject
    private IPersonalFuncApi pfa;
    @Inject
    private UserMngServiceImpl userMng;
    private List<String> listAssign = new LinkedList<String>();
    private Map<String, String> mapAssign = new HashMap<String, String>();
    private Map<String, TreeItem<FuncModule>> mapCache = new HashMap<String, TreeItem<FuncModule>>();
    private MxTreeList<FuncModule> mTreeList = new MxTreeList(FxUtils.newList());
    Comparator<TreeItem<FuncModule>> compare = new Comparator<TreeItem<FuncModule>>(){

        @Override
        public int compare(TreeItem<FuncModule> o1, TreeItem<FuncModule> o2) {
            if (((FuncModule)o1.getValue()).isSelected()) {
                if (((FuncModule)o2.getValue()).isSelected()) {
                    return ((FuncModule)o1.getValue()).getSort() > ((FuncModule)o2.getValue()).getSort() ? 1 : -1;
                }
                return -1;
            }
            if (((FuncModule)o2.getValue()).isSelected()) {
                return 1;
            }
            return ((FuncModule)o1.getValue()).getSort() > ((FuncModule)o2.getValue()).getSort() ? 1 : -1;
        }
    };

    @PostConstruct
    public void init() {
        try {
            this.query();
        }
        catch (MException e) {
            this.logger.error((Object)e, (Throwable)e);
        }
    }

    private void query() throws MException {
        List listFunc = this.irs.getFuncListByUserPost(this.base.getPostId());
        FuncModule root = new FuncModule();
        root.setId("F00000");
        root.setName("\u529f\u80fd\u6811");
        listFunc.add(root);
        listFunc.forEach(func -> {
            TreeItem item = new TreeItem(func);
            this.mapCache.put(func.getId(), (TreeItem<FuncModule>)item);
        });
        HashMap map = new HashMap();
        Collection<TreeItem<FuncModule>> listTree = this.mapCache.values();
        listTree.forEach(item -> {
            TreeItem treeItem = map.put(((FuncModule)item.getValue()).getId(), item);
        });
        for (TreeItem<FuncModule> item2 : listTree) {
            FuncModule func2 = (FuncModule)item2.getValue();
            TreeItem parent = (TreeItem)map.get(func2.getParentId());
            if (parent == null) continue;
            parent.getChildren().add(item2);
        }
    }

    private void getAllParent(String funcId, List<String> list) {
        TreeItem<FuncModule> item = this.mapCache.get(funcId);
        if (item != null) {
            list.add(((FuncModule)item.getValue()).getId());
            this.getAllParent(((FuncModule)item.getValue()).getParentId(), list);
        }
    }

    private void getAllChildren(String funcId, List<String> list) {
        ObservableList listItem;
        TreeItem<FuncModule> item = this.mapCache.get(funcId);
        if (item != null && !(listItem = item.getChildren()).isEmpty()) {
            listItem.forEach(ch -> {
                list.add(((FuncModule)ch.getValue()).getId());
                this.getAllChildren(((FuncModule)ch.getValue()).getId(), list);
            });
        }
    }

    public TreeItem<FuncModule> getStatisticRoot(TreeItem<FuncModule> root) throws MException {
        this.queryStatisticMenu();
        this.initStatisticValue(root);
        return root;
    }

    public TreeItem<FuncModule> getRoot() throws MException {
        TreeItem<FuncModule> root = this.initRoot();
        this.queryStatisticMenu();
        this.initValue(root);
        return root;
    }

    private TreeItem<FuncModule> initRoot() {
        FuncModule fModule = new FuncModule();
        fModule.setId("F00000");
        fModule.setName("\u529f\u80fd\u6811");
        TreeItem root = new TreeItem((Object)fModule);
        return root;
    }

    public void initStatisticValue(TreeItem<FuncModule> root) throws MException {
        List listFunc = this.irs.getFuncListByUserPost(this.base.getPostId());
        if (listFunc.isEmpty()) {
            return;
        }
        this.mTreeList.update(listFunc, item -> !"F00000".equals(item.getId()) && this.mapAssign.containsKey(item.getId()));
        this.mTreeList.getObList().forEach(item -> item.getChildren().clear());
        this.buildTree(root, (List<TreeItem<FuncModule>>)this.mTreeList.getObList());
    }

    public void initValue(TreeItem<FuncModule> root) throws MException {
        LinkedList<TreeItem<FuncModule>> allFunc = new LinkedList<TreeItem<FuncModule>>();
        root.getChildren().clear();
        List listFunc = this.irs.getFuncListByUserPost(this.base.getPostId());
        if (listFunc.isEmpty()) {
            return;
        }
        if (this.mapAssign.containsKey(((FuncModule)root.getValue()).getId())) {
            ((FuncModule)root.getValue()).setSelected(true);
        }
        listFunc.forEach(item -> {
            if (!"F00000".equals(item.getId())) {
                allFunc.add(new TreeItem(item));
                if (this.mapAssign.containsKey(item.getId())) {
                    item.setSelected(true);
                }
            }
        });
        this.buildTree(root, allFunc);
    }

    private void buildTree(TreeItem<FuncModule> root, List<TreeItem<FuncModule>> listFunc) {
        HashMap<String, TreeItem<FuncModule>> map = new HashMap<String, TreeItem<FuncModule>>();
        map.put(((FuncModule)root.getValue()).getId(), root);
        listFunc.forEach(item -> {
            TreeItem treeItem = map.put(((FuncModule)item.getValue()).getId(), (TreeItem<FuncModule>)item);
        });
        for (TreeItem<FuncModule> item2 : listFunc) {
            FuncModule func = (FuncModule)item2.getValue();
            TreeItem parent = (TreeItem)map.get(func.getParentId());
            if (parent == null) continue;
            parent.getChildren().add(item2);
        }
        this.sort(root);
    }

    private void sort(TreeItem<FuncModule> root) {
        Collections.sort(root.getChildren(), this.compare);
        for (TreeItem one : root.getChildren()) {
            Collections.sort(one.getChildren(), this.compare);
            for (TreeItem two : one.getChildren()) {
                Collections.sort(two.getChildren(), this.compare);
                for (TreeItem three : two.getChildren()) {
                    Collections.sort(three.getChildren(), this.compare);
                }
            }
        }
    }

    private void checkAssign(TreeItem<FuncModule> item, List<String> list) {
        FuncModule func = (FuncModule)item.getValue();
        if (((FuncModule)item.getValue()).isSelected()) {
            list.add(func.getId());
        }
    }

    public void addStatisticMenuReq(TreeItem<FuncModule> root) throws MException {
        LinkedList<String> listFunc = new LinkedList<String>();
        this.checkAssign(root, listFunc);
        for (TreeItem one : root.getChildren()) {
            this.checkAssign((TreeItem<FuncModule>)one, listFunc);
            for (TreeItem two : one.getChildren()) {
                this.checkAssign((TreeItem<FuncModule>)two, listFunc);
                for (TreeItem three : two.getChildren()) {
                    this.checkAssign((TreeItem<FuncModule>)three, listFunc);
                }
            }
        }
        this.pfa.addStatisticMenuReq(this.base.getUserId(), this.base.getPostId(), listFunc);
        this.changed();
    }

    public void queryStatisticMenu() throws MException {
        PRbac.GetStatisticMenuResp resp = this.pfa.getStatisticMenuReq(this.base.getUserId(), this.base.getPostId());
        this.listAssign.clear();
        this.mapAssign.clear();
        this.listAssign.addAll((Collection<String>)resp.getMenuIdList());
        this.listAssign.forEach(funcId -> {
            String string = this.mapAssign.put((String)funcId, (String)funcId);
        });
    }

    public void queryMenuPermision(String funcId, List<User> listUser) throws MException {
        LinkedList listId = new LinkedList();
        HashMap map = new HashMap();
        listUser.forEach(user -> {
            listId.add(user.getId());
            map.put(user.getId(), user);
        });
        PRbac.GetMenuPermisionResp resp = this.pfa.getMenuPermisionReq(funcId, listId);
        List list = resp.getRoleViaUserList();
        list.forEach(rvu -> {
            User user = (User)map.get(rvu.getUserId());
            user.update(rvu);
        });
    }

    public List<User> queryAffectedUsers(List<String> listRole) throws MException {
        List listUserId = this.pfa.getAffectedUsersReq(listRole);
        List<User> listUser = this.userMng.getUserList(listUserId);
        return listUser;
    }

    public void assignMenuViaRoles(String userId, String funcId, List<String> listRole) throws MException {
        LinkedList<String> listFunc = new LinkedList<String>();
        this.getAllParent(funcId, listFunc);
        this.getAllChildren(funcId, listFunc);
        this.pfa.assignMenuViaRolesReq(userId, listFunc, listRole);
    }

    public void unassignMenuViaRoles(String userId, String funcId, List<String> listRole) throws MException {
        LinkedList<String> listFunc = new LinkedList<String>();
        this.getAllParent(funcId, listFunc);
        this.getAllChildren(funcId, listFunc);
        this.pfa.unassignMenuViaRolesReq(userId, listFunc, listRole);
    }
}

