/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.core.MException;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Party;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IPartyTreeModel;
import cms.tmx.manage.models.PartyMngServiceImpl;
import java.text.Collator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PartyTreeModel
implements IPartyTreeModel {
    @Inject
    private PartyMngServiceImpl partyMng;
    private TreeItem<Party> root;
    private Map<String, Party> map = new HashMap<String, Party>();
    private MxTreeList<Party> mTreeList = new MxTreeList(FxUtils.newList());

    @Override
    public Party getParty(String id) {
        return this.map.get(id);
    }

    @Override
    public synchronized TreeItem<Party> getRoot() throws MException {
        if (this.root == null) {
            this.root = new TreeItem((Object)this.partyMng.getUserParty());
            this.initTree(((Party)this.root.getValue()).getId());
        }
        return this.root;
    }

    @Override
    public synchronized TreeItem<Party> refresh() throws MException {
        TreeItem root = new TreeItem((Object)this.partyMng.getUserParty());
        this.refreshTree((TreeItem<Party>)root, ((Party)root.getValue()).getId());
        return root;
    }

    private void refreshTree(TreeItem<Party> root, String rootId) throws MException {
        this.map.clear();
        this.map.put(rootId, (Party)root.getValue());
        List<Party> list = this.partyMng.getPartyList(rootId, PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING);
        this.mTreeList.update(list);
        this.mTreeList.getObList().forEach(item -> {
            item.getChildren().clear();
            this.map.put(((Party)item.getValue()).getId(), (Party)item.getValue());
        });
        this.buildTree(root, rootId);
    }

    private void initTree(String rootId) throws MException {
        this.mTreeList.add((MxObject)((Party)this.root.getValue()));
        this.map.put(rootId, (Party)this.root.getValue());
        List<Party> list = this.partyMng.getPartyList(rootId, PHierarchy.GetHierarchyReq.Option.GET_OFFSPRING);
        this.buildTreeList(list);
        this.buildTree(this.root, rootId);
    }

    private void buildTreeList(List<Party> list) {
        for (Party party : list) {
            this.map.put(party.getId(), party);
            this.mTreeList.add((MxObject)party);
        }
    }

    private void buildTree(TreeItem<Party> root, String rootId) {
        Collections.sort(this.mTreeList.getObList(), (p1, p2) -> {
            Collator compare = Collator.getInstance(Locale.CHINA);
            return compare.compare(((Party)p1.getValue()).getName(), ((Party)p2.getValue()).getName());
        });
        block0: for (TreeItem itemI : this.mTreeList.getObList()) {
            String idI = ((Party)itemI.getValue()).getId();
            String parentIdI = ((Party)itemI.getValue()).getParentId();
            if (idI.isEmpty() || parentIdI.isEmpty()) continue;
            if (parentIdI.equals(rootId)) {
                root.getChildren().add((Object)itemI);
                continue;
            }
            for (TreeItem itemJ : this.mTreeList.getObList()) {
                String idJ = ((Party)itemJ.getValue()).getId();
                if (!idJ.equals(parentIdI)) continue;
                itemJ.getChildren().add((Object)itemI);
                continue block0;
            }
        }
    }

    @Override
    public MxTreeList<Party> getmTreeList() {
        return this.mTreeList;
    }

    @Override
    public void setmTreeList(MxTreeList<Party> mTreeList) {
        this.mTreeList = mTreeList;
    }

    @Override
    public Map<String, Party> getMap() {
        return this.map;
    }

    @Override
    public void setMap(Map<String, Party> map) {
        this.map = map;
    }
}

