/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IPartyApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.hierarchy.PHierarchy;
import cms.tmx.entity.Party;
import cms.tmx.entity.PartyControl;
import cms.tmx.entity.factory.PartyFactory;
import cms.tmx.manage.IPartyService;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class PartyMngServiceImpl
implements IPartyService {
    @Inject
    private IPartyApi ipa;
    @Inject
    private IBaseApi iba;
    @Inject
    private MObjFactory of;
    private static final int TYPE = 1;
    @Inject
    private Party userParty;
    @Inject
    private PartyFactory pf;

    public Party getPartyDetails(PBase.OpUser opUser) throws MException {
        PHierarchy.Party pParty = this.ipa.getPartyDetails(opUser);
        if (pParty != null) {
            Party party = (Party)this.of.create(Party.class);
            party.update((Object)pParty);
            return party;
        }
        return null;
    }

    public Party getParty(String partyID) throws MException {
        List<Party> list = this.getPartyList(partyID, PHierarchy.GetHierarchyReq.Option.GET_SINGEL_PARTY);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public Party getUserParty() throws MException {
        if (this.iba.getPartyId().equals(this.userParty.getId())) {
            return this.userParty;
        }
        PHierarchy.Party pParty = this.ipa.getUserParty();
        this.userParty.update((Object)pParty);
        return this.userParty;
    }

    public void enableParty(Party party, boolean enable) throws MException {
        PHierarchy.Party.Builder pBuilder = PHierarchy.Party.newBuilder();
        pBuilder.setPartyId(party.getId());
        pBuilder.setParentId(party.getParentId());
        pBuilder.setRootId(party.getRootId());
        pBuilder.setName(party.getFullName());
        pBuilder.setEnName(party.getName());
        pBuilder.setDescription(party.getDesc());
        pBuilder.setAddress(party.getAddress());
        pBuilder.setEmail(party.getEmail());
        pBuilder.setContact(party.getContactor());
        pBuilder.setContactNumber(party.getPhone());
        pBuilder.setCertificateCode(party.getCode());
        pBuilder.setPartyTypeValue(1);
        pBuilder.setStatus(enable ? 1 : 3);
        if (!party.getCreditType().getRaw().isEmpty()) {
            pBuilder.setCertificateTypeValue(Integer.parseInt(party.getCreditType().getRaw()));
        }
        PHierarchy.Party data = pBuilder.build();
        this.ipa.updateParty(data);
    }

    public String addParty(Party party) throws MException {
        PHierarchy.Party.Builder pBuilder = PHierarchy.Party.newBuilder();
        pBuilder.setPartyId(party.getId());
        pBuilder.setParentId(party.getParentId());
        pBuilder.setRootId(party.getRootId());
        pBuilder.setName(party.getFullName());
        pBuilder.setEnName(party.getName());
        pBuilder.setDescription(party.getDesc());
        pBuilder.setAddress(party.getAddress());
        pBuilder.setEmail(party.getEmail());
        pBuilder.setContact(party.getContactor());
        pBuilder.setContactNumber(party.getPhone());
        pBuilder.setCertificateCode(party.getCode());
        pBuilder.setPartyTypeValue(1);
        if (!party.getCreditType().getRaw().isEmpty()) {
            pBuilder.setCertificateTypeValue(Integer.parseInt(party.getCreditType().getRaw()));
        }
        return this.ipa.addParty(pBuilder.build());
    }

    public void updateParty(Party party) throws MException {
        PHierarchy.Party.Builder pBuilder = PHierarchy.Party.newBuilder();
        pBuilder.setPartyId(party.getId());
        pBuilder.setParentId(party.getParentId());
        pBuilder.setRootId(party.getRootId());
        pBuilder.setName(party.getFullName());
        pBuilder.setEnName(party.getName());
        pBuilder.setDescription(party.getDesc());
        pBuilder.setAddress(party.getAddress());
        pBuilder.setEmail(party.getEmail());
        pBuilder.setContact(party.getContactor());
        pBuilder.setContactNumber(party.getPhone());
        pBuilder.setCertificateCode(party.getCode());
        pBuilder.setPartyTypeValue(1);
        if (!party.getCreditType().getRaw().isEmpty()) {
            pBuilder.setCertificateTypeValue(Integer.parseInt(party.getCreditType().getRaw()));
        }
        if (!party.getStatus().getRaw().isEmpty()) {
            pBuilder.setStatus(Integer.parseInt(party.getStatus().getRaw()));
        }
        PHierarchy.Party data = pBuilder.build();
        this.ipa.updateParty(data);
    }

    @Override
    public List<Party> getPartyList(String partyId, PHierarchy.GetHierarchyReq.Option option) throws MException {
        List list = this.ipa.getPartyList(partyId, option);
        LinkedList<Party> parties = new LinkedList<Party>();
        list.forEach(item -> {
            Party party = this.pf.create();
            party.update(item);
            parties.add(party);
        });
        return parties;
    }

    @Override
    public List<Party> getPartyList(String partyId) throws MException {
        return this.getPartyList(partyId, PHierarchy.GetHierarchyReq.Option.GET_CHILDREN);
    }

    @Override
    public List<Party> getPartyListContainsOwner(String partyId) throws MException {
        List list = this.ipa.getPartyListContainOwn(partyId);
        LinkedList<Party> parties = new LinkedList<Party>();
        list.forEach(item -> {
            Party party = this.pf.create();
            party.update(item);
            parties.add(party);
        });
        return parties;
    }

    public void updatePartyControl(List<PartyControl> partycontrols, int type, String partyId, boolean macFlag, boolean ipFlag) throws MException {
        LinkedList<PHierarchy.PartyControl> list = new LinkedList<PHierarchy.PartyControl>();
        for (PartyControl userControl : partycontrols) {
            PHierarchy.PartyControl.Builder control = PHierarchy.PartyControl.newBuilder();
            control.setOptionValue(userControl.getType());
            control.setValue(userControl.getValue());
            control.setControlId(userControl.getControlId());
            control.setFlag(userControl.getType() == 1 ? macFlag : ipFlag);
            list.add(control.build());
        }
        this.ipa.updatePartyControl(list, type, partyId, macFlag, ipFlag);
    }

    public List<PartyControl> getPartyControl(String partyId) throws MException {
        LinkedList<PartyControl> partyControls = new LinkedList<PartyControl>();
        if (!partyId.isEmpty()) {
            this.ipa.getPartyControl(partyId).forEach(item -> {
                PartyControl partyControl = new PartyControl();
                partyControl.update(item);
                partyControls.add(partyControl);
            });
        }
        return partyControls;
    }

    public void operatePartyControl(PartyControl control, int type, String partyId, boolean macFlag, boolean ipFlag) throws MException {
        PHierarchy.PartyControl.Builder pControl = PHierarchy.PartyControl.newBuilder();
        pControl.setOptionValue(control.getType());
        pControl.setValue(control.getValue());
        pControl.setControlId(control.getControlId());
        pControl.setFlag(control.getType() == 1 ? macFlag : ipFlag);
        this.ipa.operatePartyControl(pControl.build(), type, partyId);
    }
}

