/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IMsgApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.datatype.proto.PBase;
import cms.tmx.datatype.proto.misc.PMisc;
import cms.tmx.entity.MsgSetting;
import cms.tmx.manage.IMsgSettingService;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class MsgSettingMngServiceImpl
implements IMsgSettingService {
    @Inject
    private IMsgApi msgApi;
    @Inject
    private IBaseApi bmi;
    @Inject
    private MObjFactory of;

    public String addMsgSetting(MsgSetting msg) throws MException {
        PMisc.NewMsgSettingReq.Builder builder = PMisc.NewMsgSettingReq.newBuilder();
        PMisc.MsgSetting.Builder ob = PMisc.MsgSetting.newBuilder();
        ob.setName(msg.getName());
        ob.setContent(msg.getContent());
        ob.setLevelValue(Integer.parseInt(msg.getLevel().getRaw()));
        ob.setInterval(Integer.parseInt(msg.getInterval()));
        ob.setTypeValue(Integer.parseInt(msg.getType().getRaw()));
        ob.setSubTypeValue(Integer.parseInt(msg.getSubType().getRaw()));
        ob.setNotifyWay(Integer.parseInt(msg.getNotifyWay().getRaw()));
        if (msg.isEmail()) {
            if (msg.isMsg()) {
                ob.setOtherPushWay(3);
            } else {
                ob.setOtherPushWay(1);
            }
        } else if (msg.isMsg()) {
            ob.setOtherPushWay(2);
        } else {
            ob.setOtherPushWay(0);
        }
        ob.setHasForcedPush(msg.isForcedPush());
        ob.setColor(msg.getColor().toString());
        ob.setRingingType(msg.isRing() ? 1 : 0);
        ob.setRingingName(msg.getRingName());
        ob.setHasCustomConfigPermit(msg.isCustom());
        ob.setHasAutoResetPermit(msg.isReset());
        builder.setOpUser(this.bmi.getOpUser());
        builder.setSetting(ob.build());
        return this.msgApi.addMsgSettingReq(builder.build());
    }

    public void updateMsgSetting(MsgSetting msg) throws MException {
        PMisc.UpdateMsgSettingReq.Builder builder = PMisc.UpdateMsgSettingReq.newBuilder();
        PMisc.MsgSetting.Builder ob = PMisc.MsgSetting.newBuilder();
        ob.setId(msg.getId());
        ob.setName(msg.getName());
        ob.setContent(msg.getContent());
        ob.setLevelValue(Integer.parseInt(msg.getLevel().getRaw()));
        ob.setInterval(Integer.parseInt(msg.getInterval()));
        ob.setTypeValue(Integer.parseInt(msg.getType().getRaw()));
        ob.setSubTypeValue(Integer.parseInt(msg.getSubType().getRaw()));
        ob.setNotifyWay(Integer.parseInt(msg.getNotifyWay().getRaw()));
        if (msg.isEmail()) {
            if (msg.isMsg()) {
                ob.setOtherPushWay(3);
            } else {
                ob.setOtherPushWay(1);
            }
        } else if (msg.isMsg()) {
            ob.setOtherPushWay(2);
        } else {
            ob.setOtherPushWay(0);
        }
        ob.setHasForcedPush(msg.isForcedPush());
        ob.setColor(msg.getColor().toString());
        ob.setRingingType(msg.isRing() ? 1 : 0);
        ob.setRingingName(msg.getRingName());
        ob.setHasCustomConfigPermit(msg.isCustom());
        ob.setHasAutoResetPermit(msg.isReset());
        builder.setOpUser(this.bmi.getOpUser());
        builder.setSetting(ob.build());
        this.msgApi.updateMsgSettingReq(builder.build());
    }

    public void deleteMsgSetting(MsgSetting msg) throws MException {
        PMisc.DeleteMsgSettingReq.Builder builder = PMisc.DeleteMsgSettingReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        builder.setId(msg.getId());
        this.msgApi.deleteMsgSettingReq(builder.build());
    }

    public List<MsgSetting> getMsgSetting() throws MException {
        PMisc.GetMsgSettingsResp resp;
        LinkedList<MsgSetting> list = new LinkedList<MsgSetting>();
        PMisc.GetMsgSettingsReq.Builder builder = PMisc.GetMsgSettingsReq.newBuilder();
        builder.setOpUser(this.bmi.getOpUser());
        this.msgApi.getMsgSettingReq(builder.build());
        boolean hasMore = false;
        int startRow = 1;
        do {
            PBase.Page.Builder pBuilder = PBase.Page.newBuilder();
            pBuilder.setPageSize(150);
            pBuilder.setStartRow(startRow);
            startRow += 150;
            builder.setPage(pBuilder.build());
            resp = this.msgApi.getMsgSettingReq(builder.build());
            for (PMisc.MsgSetting info : resp.getSettingList()) {
                MsgSetting setting = (MsgSetting)this.of.create(MsgSetting.class);
                setting.update((Object)info);
                list.add(setting);
            }
        } while (hasMore = resp.getPage().getTotalRow() - 200 > startRow);
        return list;
    }
}

