/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.core.IUIService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.FuncModule;
import cms.tmx.entity.factory.FuncFactory;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.SceneService;
import cms.tmx.manage.models.CustomPaneModel;
import cms.tmx.rights.IRightService;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.osgi.service.event.Event;

@Creatable
@Singleton
public class MenuTreeModel {
    private static final Logger logger = LogManager.getLogger(MenuTreeModel.class);
    @Inject
    private MxAlert mAlert;
    @Inject
    private MEventService es;
    @Inject
    private IRightService irs;
    @Inject
    private IUIService ius;
    @Inject
    private SceneService service;
    @Inject
    private MObjFactory of;
    @Inject
    private FuncFactory factory;
    private int firstType = 0;
    private VBox chooiceBox;
    private double rowHeight = 30.0;
    private List<TitledPane> paneList = new LinkedList<TitledPane>();
    private List<FuncModule> allFunctions = new LinkedList<FuncModule>();
    private VBox vBox = new VBox();
    private final String SHRINK = "shrink";
    private StringProperty select = new SimpleStringProperty("");
    private List<String> partIdList;
    private Map<String, TitledPane> map = new HashMap<String, TitledPane>();
    private Map<String, FuncModule> customMap = new HashMap<String, FuncModule>();
    private Map<Integer, List<TitledPane>> menuMap = new HashMap<Integer, List<TitledPane>>();
    private static final String CUSTOM_PANE_ID = "310000";
    private static final String MY_COLLECT_MENU = "420000";
    private List<Integer> hisList = new LinkedList<Integer>();
    @Inject
    private CustomPaneModel customModel;

    @PostConstruct
    public void init() {
        this.initVboxId();
        this.es.subscribe("shrink", event -> this.paneList.forEach(item -> {
            item.setExpanded(false);
            this.select.set((Object)"");
        }));
        this.es.subscribe("ADD_CUSTOM_PANE", event -> this.addCustomPane(event));
        this.es.subscribe("DEL_CUSTOM_PANE", event -> this.delCustomPane(event));
        this.es.subscribe("ADD_COLLECT_PANE", event -> this.addCollectPane(event));
        this.es.subscribe("DEL_COLLECT_PANE", event -> this.delCollectPane(event));
        this.partIdList = this.irs.getPartIdList();
    }

    @Inject
    @Optional
    private void activate(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/activate") Event event) {
        MPart part;
        Object element = event.getProperty("ChangedElement");
        if (element != null && element instanceof MPart && this.partIdList.contains((part = (MPart)element).getElementId())) {
            this.select.set((Object)this.irs.getPartIdentify(part.getElementId()));
        }
    }

    private void initVboxId() {
        this.vBox.setId("functionVBox");
    }

    public boolean checkModuleType(int type) {
        List firstFlowFunctions;
        if (this.allFunctions.isEmpty()) {
            this.allFunctions = this.irs.getUserFuncList();
        }
        return !(firstFlowFunctions = this.allFunctions.stream().filter(func -> "F00000".equals(func.getParentId())).filter(func -> Integer.toString(type).equals(func.getModuleType().getRaw())).sorted((o1, o2) -> o1.getSort() > o2.getSort() ? 1 : (o1.getSort() == o2.getSort() ? Integer.parseInt(o1.getId().substring(1)) - Integer.parseInt(o2.getId().substring(1)) : -1)).collect(Collectors.toList())).isEmpty();
    }

    public void getMenuByType(int type) {
        try {
            if (this.menuMap.get(type) != null) {
                this.vBox.getChildren().clear();
                this.vBox.getChildren().addAll((Collection)this.menuMap.get(type));
                return;
            }
            if (!this.hisList.contains(type)) {
                this.vBox.getChildren().clear();
            }
            List firstFlowFunctions = this.allFunctions.stream().filter(func -> "F00000".equals(func.getParentId())).filter(func -> Integer.toString(type).equals(func.getModuleType().getRaw())).sorted((o1, o2) -> o1.getSort() > o2.getSort() ? 1 : (o1.getSort() == o2.getSort() ? Integer.parseInt(o1.getId().substring(1)) - Integer.parseInt(o2.getId().substring(1)) : -1)).collect(Collectors.toList());
            int i = 0;
            while (i < firstFlowFunctions.size()) {
                this.hisList.add(type);
                TitledPane levelOnePane = new TitledPane();
                levelOnePane.setText(((FuncModule)firstFlowFunctions.get(i)).toString());
                ListView secondListView = new ListView();
                secondListView.setCellFactory(data -> new ColorCell());
                ObservableList levelTwoList = FxUtils.newList();
                for (FuncModule function : this.allFunctions) {
                    if (!((FuncModule)firstFlowFunctions.get(i)).getId().equals(function.getParentId())) continue;
                    levelTwoList.add((Object)function);
                }
                Collections.sort(levelTwoList, (o1, o2) -> o1.getSort() - o2.getSort());
                secondListView.setItems(levelTwoList);
                secondListView.prefHeightProperty().bind((ObservableValue)Bindings.size((ObservableList)levelTwoList).multiply(this.rowHeight));
                levelOnePane.setContent((Node)secondListView);
                levelOnePane.setExpanded(false);
                secondListView.setOnMousePressed(event -> this.menuOnSelected((MouseEvent)event, levelOnePane, (ListView<FuncModule>)secondListView));
                this.vBox.getChildren().add((Object)levelOnePane);
                List<TitledPane> list = this.menuMap.get(type);
                if (list == null) {
                    list = new LinkedList<TitledPane>();
                    list.add(levelOnePane);
                    this.menuMap.put(type, list);
                } else {
                    list.add(levelOnePane);
                }
                if (i == firstFlowFunctions.size() - 1) {
                    levelOnePane.setId("fct_last_pane");
                }
                this.paneList.add(levelOnePane);
                if (CUSTOM_PANE_ID.equals(((FuncModule)firstFlowFunctions.get(i)).getId())) {
                    this.map.put(CUSTOM_PANE_ID, levelOnePane);
                    MEvent event2 = new MEvent();
                    event2.setOK();
                    this.es.sendEvent("check", event2);
                }
                if (MY_COLLECT_MENU.equals(((FuncModule)firstFlowFunctions.get(i)).getId())) {
                    this.map.put(MY_COLLECT_MENU, levelOnePane);
                }
                ++i;
            }
            if (type == 1) {
                this.initCustomPane(this.customModel);
                this.initMyMenuPane();
            }
        }
        catch (Exception e) {
            Platform.runLater(() -> this.mAlert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void menuOnSelected(MouseEvent event, TitledPane selectedPane, ListView<FuncModule> listView) {
        MouseButton button = event.getButton();
        if (button != null && button.equals((Object)MouseButton.PRIMARY)) {
            long start = System.currentTimeMillis();
            logger.info("start click menutree");
            FuncModule funcNew = (FuncModule)listView.getSelectionModel().getSelectedItem();
            if (funcNew == null) {
                return;
            }
            MEvent mEvent = this.irs.getPartConf(funcNew.getIdentifier().getRaw());
            mEvent.put((Object)"part_name", (Object)funcNew.getName());
            this.select.set((Object)funcNew.getIdentifier().getRaw());
            this.ius.navigate(mEvent);
            if ("cms.tmx.diskless.part.disklessModelPart".equals(mEvent.getStr("id"))) {
                this.closeMenu();
            }
            logger.info("init " + funcNew.getName() + "\u9875\u9762  complete cost: " + (System.currentTimeMillis() - start) + ":ms");
        }
    }

    public VBox getvBox() {
        return this.vBox;
    }

    public void setvBox(VBox vBox) {
        this.vBox = vBox;
    }

    public int getFirstType() {
        return this.firstType;
    }

    public void setFirstType(int firstType) {
        this.firstType = firstType;
    }

    public VBox getChooiceBox() {
        return this.chooiceBox;
    }

    public void setChooiceBox(VBox chooiceBox) {
        this.chooiceBox = chooiceBox;
    }

    private void closeMenu() {
        Stage stage = this.of.getMainStage();
        MEvent event = new MEvent();
        event.put((Object)"close_part", (Object)true);
        stage.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
        stage.setFullScreenExitHint("\u6309F10\u9000\u51fa\u5168\u5c4f\u6a21\u5f0f");
        stage.setFullScreen(true);
        this.es.sendEvent("close_menu", event);
        if (stage.isFullScreen()) {
            this.service.disableCursor(stage);
            this.service.hideTopBottom(stage);
        } else {
            this.service.enableCursor(stage);
            this.service.showTopBottom(stage);
        }
    }

    private void addCustomPane(MEvent event) {
        TitledPane titledPane = this.map.get(CUSTOM_PANE_ID);
        Node content = titledPane.getContent();
        Platform.runLater(() -> {
            ListView secondListView = (ListView)ListView.class.cast(content);
            ObservableList levelTwoList = secondListView.getItems().isEmpty() ? FxUtils.newList() : secondListView.getItems();
            if (this.customMap.get(event.getStr("id")) == null) {
                FuncModule func = this.factory.create();
                func.setId(event.getStr("id"));
                func.setName(event.getStr("part_name"));
                levelTwoList.add((Object)func);
                this.customMap.put(event.getStr("id"), func);
            } else {
                for (FuncModule f : levelTwoList) {
                    if (!event.getStr("id").equals(f.getId())) continue;
                    f.setName(event.getStr("part_name"));
                    break;
                }
            }
            this.initCustomListView(titledPane, (ListView<FuncModule>)secondListView, (ObservableList<FuncModule>)levelTwoList);
        });
    }

    private void delCustomPane(MEvent event) {
        TitledPane titledPane = this.map.get(CUSTOM_PANE_ID);
        Node content = titledPane.getContent();
        Platform.runLater(() -> {
            ListView secondListView = (ListView)ListView.class.cast(content);
            this.customMap.remove(event.getStr("id"));
            ObservableList levelTwoList = secondListView.getItems();
            Iterator it = levelTwoList.iterator();
            while (it.hasNext()) {
                FuncModule old = (FuncModule)it.next();
                if (!event.getStr("id").equals(old.getId())) continue;
                it.remove();
            }
            secondListView.setItems(levelTwoList);
            titledPane.setContent((Node)secondListView);
        });
    }

    private void initCustomListView(TitledPane titledPane, ListView<FuncModule> secondListView, ObservableList<FuncModule> levelTwoList) {
        Collections.sort(levelTwoList, (o1, o2) -> o1.getSort() - o2.getSort());
        secondListView.setItems(levelTwoList);
        secondListView.prefHeightProperty().bind((ObservableValue)Bindings.size(levelTwoList).multiply(this.rowHeight));
        titledPane.setContent(secondListView);
        this.initContextMenu(secondListView);
        secondListView.setOnMousePressed(e -> {
            MouseButton button = e.getButton();
            if (button != null && button.equals((Object)MouseButton.PRIMARY)) {
                FuncModule funcNew = (FuncModule)secondListView.getSelectionModel().getSelectedItem();
                MEvent et = new MEvent();
                et.put((Object)"id", (Object)funcNew.getId());
                et.put((Object)"part_name", (Object)funcNew.getName());
                this.es.sendEvent("ui.navigate.custom_pane", et);
            }
        });
    }

    private void initCustomPane(CustomPaneModel model) {
        TitledPane titledPane = this.map.get(CUSTOM_PANE_ID);
        if (titledPane == null) {
            return;
        }
        Node content = titledPane.getContent();
        Platform.runLater(() -> {
            ListView secondListView = (ListView)ListView.class.cast(content);
            Collection<Object> all = model.queryAll();
            for (Object object : all) {
                String json = (String)String.class.cast(object);
                JsonObject obj = new JsonParser().parse(json).getAsJsonObject();
                String id = obj.get("id").getAsString();
                String name = obj.get("name").getAsString();
                ObservableList levelTwoList = secondListView.getItems().isEmpty() ? FxUtils.newList() : secondListView.getItems();
                if (this.customMap.get(id) == null) {
                    FuncModule func = this.factory.create();
                    func.setId(id);
                    func.setName(name);
                    levelTwoList.add((Object)func);
                    this.customMap.put(id, func);
                } else {
                    for (FuncModule f : levelTwoList) {
                        if (!id.equals(f.getId())) continue;
                        f.setName(name);
                        break;
                    }
                }
                this.initCustomListView(titledPane, (ListView<FuncModule>)secondListView, (ObservableList<FuncModule>)levelTwoList);
            }
        });
    }

    private void initMyMenuPane() {
        TitledPane titledPane = this.map.get(MY_COLLECT_MENU);
        if (titledPane == null) {
            return;
        }
        Node content = titledPane.getContent();
        Platform.runLater(() -> {
            ListView secondListView = (ListView)ListView.class.cast(content);
            try {
                List all = this.irs.getEnableUserCollectFuncListByUserPost();
                for (FuncModule func : all) {
                    this.irs.getUserCollectMenus().add(func.getId());
                    ObservableList levelTwoList = secondListView.getItems().isEmpty() ? FxUtils.newList() : secondListView.getItems();
                    levelTwoList.add((Object)func);
                    Collections.sort(levelTwoList, (o1, o2) -> o1.getSort() - o2.getSort());
                    secondListView.setItems(levelTwoList);
                    secondListView.prefHeightProperty().bind((ObservableValue)Bindings.size((ObservableList)levelTwoList).multiply(this.rowHeight));
                    titledPane.setContent((Node)secondListView);
                    secondListView.setOnMousePressed(event -> this.menuOnSelected((MouseEvent)event, null, (ListView<FuncModule>)secondListView));
                }
            }
            catch (MException e) {
                logger.error((Object)e, (Throwable)e);
            }
        });
    }

    private void addCollectPane(MEvent event) {
        TitledPane titledPane = this.map.get(MY_COLLECT_MENU);
        if (titledPane == null) {
            return;
        }
        Node content = titledPane.getContent();
        Platform.runLater(() -> {
            ListView secondListView = (ListView)ListView.class.cast(content);
            FuncModule func = this.factory.create();
            ObservableList levelTwoList = secondListView.getItems().isEmpty() ? FxUtils.newList() : secondListView.getItems();
            func.setId(this.irs.getModuleIdByPartId(event.getStr("menuId")));
            func.setName(event.getStr("part_name"));
            func.getIdentifier().setRaw(event.getStr("identify"));
            levelTwoList.add((Object)func);
            Collections.sort(levelTwoList, (o1, o2) -> o1.getSort() - o2.getSort());
            secondListView.setItems(levelTwoList);
            secondListView.prefHeightProperty().bind((ObservableValue)Bindings.size((ObservableList)levelTwoList).multiply(this.rowHeight));
            titledPane.setContent((Node)secondListView);
            secondListView.setOnMousePressed(e -> this.menuOnSelected((MouseEvent)e, null, (ListView<FuncModule>)secondListView));
        });
    }

    private void delCollectPane(MEvent event) {
        TitledPane titledPane = this.map.get(MY_COLLECT_MENU);
        if (titledPane == null) {
            return;
        }
        Node content = titledPane.getContent();
        Platform.runLater(() -> {
            ListView secondListView = (ListView)ListView.class.cast(content);
            ObservableList levelTwoList = secondListView.getItems();
            Iterator it = levelTwoList.iterator();
            while (it.hasNext()) {
                FuncModule old = (FuncModule)it.next();
                if (!this.irs.getModuleIdByPartId(event.getStr("menuId")).equals(old.getId())) continue;
                it.remove();
            }
            secondListView.setItems(levelTwoList);
            titledPane.setContent((Node)secondListView);
        });
    }

    private void initContextMenu(ListView<FuncModule> secondListView) {
        ContextMenu tabMenu = new ContextMenu();
        MenuItem itemOpen = new MenuItem("\u6253\u5f00");
        MenuItem itemClose = new MenuItem("\u5220\u9664");
        tabMenu.getItems().add((Object)itemOpen);
        tabMenu.getItems().add((Object)itemClose);
        secondListView.setContextMenu(tabMenu);
        itemOpen.setOnAction(event -> {
            FuncModule funcNew = (FuncModule)secondListView.getSelectionModel().getSelectedItem();
            MEvent et = new MEvent();
            et.put((Object)"id", (Object)funcNew.getId());
            et.put((Object)"part_name", (Object)funcNew.getName());
            this.es.sendEvent("ui.navigate.custom_pane", et);
        });
        itemClose.setOnAction(event -> {
            FuncModule funcNew = (FuncModule)secondListView.getSelectionModel().getSelectedItem();
            MEvent et = new MEvent();
            et.put((Object)"id", (Object)funcNew.getId());
            this.delCustomPane(et);
            this.customModel.delete(funcNew.getId());
        });
    }

    private class ColorCell
    extends ListCell<FuncModule> {
        private ColorCell() {
        }

        protected void updateItem(FuncModule item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else {
                FuncModule funcModule = (FuncModule)this.getItem();
                if (funcModule == null) {
                    return;
                }
                String identify = funcModule.getIdentifier().getRaw();
                this.setText(funcModule.getName());
                MenuTreeModel.this.select.addListener((observable, oldValue, newValue) -> {
                    if (newValue != null && !"".equals(newValue) && !identify.isEmpty() && identify.equals(newValue)) {
                        this.setFocused(true);
                    } else {
                        this.setFocused(false);
                    }
                });
            }
        }
    }

    public static enum ModuleType {
        HOME_PAGE(1),
        TRADE(2),
        NEWS(3),
        MARKET(4),
        MANAGEMENT(5),
        ANALYSIS(6);

        private int code;

        private ModuleType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

