/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MObjFactory;
import cms.tmx.manage.models.UserPreferServiceImpl;
import cms.tmx.manage.parts.TradeUnlockedDialog;
import cms.tmx.web.api.settings.UserPreLockSettings;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.control.ButtonType;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class LockModel {
    private static final int CHECK_INTERVAL = 1000;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    private MEventService es;
    private IntegerProperty time = new SimpleIntegerProperty(0);
    @Inject
    private ScheduledExecutorService ses;
    private BooleanProperty isLocked = new SimpleBooleanProperty(false);
    private Stage stage;
    private String user;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    protected UserPreferServiceImpl us;
    @Inject
    private UserPreLockSettings lockSet;

    @PostConstruct
    public void init() {
        this.es.subscribe("stage.after.login", event -> this.start());
        this.es.subscribe("window.active", event -> this.time.set(0));
        this.es.subscribe("manual.lock.system", event -> Platform.runLater(() -> this.lock()));
    }

    @PreDestroy
    public void close() {
    }

    public void start() {
        this.user = this.eCore.getStr("user_login");
        this.stage = (Stage)this.of.getContext().get(Stage.class);
        this.stage.addEventFilter(MouseEvent.ANY, event -> {
            if (event.getEventType().equals(MouseEvent.MOUSE_ENTERED) || event.getEventType().equals(MouseEvent.MOUSE_EXITED) || event.getEventType().equals(MouseEvent.MOUSE_ENTERED_TARGET) || event.getEventType().equals(MouseEvent.MOUSE_EXITED_TARGET)) {
                return;
            }
            this.time.set(0);
        });
        this.stage.addEventFilter(KeyEvent.ANY, event -> this.time.set(0));
        this.time.addListener(ob -> this.checkLock());
        this.ses.scheduleAtFixedRate(() -> this.time.set(this.time.get() + 1), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private void checkLock() {
        if (this.isLocked.get()) {
            return;
        }
        if (!this.lockSet.getAutoLock()) {
            return;
        }
        if (this.time.get() < this.lockSet.getLockTime()) {
            return;
        }
        Platform.runLater(() -> this.lock());
    }

    private synchronized void lock() {
        if (this.isLocked.get()) {
            return;
        }
        this.isLocked.set(true);
        if (this.stage.isIconified()) {
            this.stage.setIconified(false);
        }
        Stage.impl_getWindows().forEachRemaining(window -> window.setOpacity(0.0));
        TradeUnlockedDialog dlg = (TradeUnlockedDialog)((Object)this.of.create(TradeUnlockedDialog.class));
        dlg.setUserId(this.user);
        dlg.setPasswd(this.eCore.getStr("password"));
        MxDialog dialog = this.df.create((DialogObj)dlg, "\u7cfb\u7edf\u89e3\u9501");
        dialog.getCtrl().getCustomPane().removeEventHandler(KeyEvent.KEY_PRESSED, dialog.getCtrl().getHandler());
        dialog.setBtnText(ButtonType.OK, "\u89e3\u9501");
        dialog.getDialogPane().setVisible(true);
        dialog.getDialogPane().setOpacity(1.0);
        ButtonType type = dialog.launch();
        if (type == ButtonType.OK) {
            Stage.impl_getWindows().forEachRemaining(window -> window.setOpacity(1.0));
        } else {
            Platform.exit();
        }
        this.time.set(0);
        this.isLocked.set(false);
    }

    public final BooleanProperty isLockedProperty() {
        return this.isLocked;
    }

    public final boolean isIsLocked() {
        return this.isLockedProperty().get();
    }

    public final void setIsLocked(boolean isLocked) {
        this.isLockedProperty().set(isLocked);
    }
}

