/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxNodePwf;
import cms.tmx.javafx.utils.FxUtils;
import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javax.annotation.PostConstruct;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class HedgeFlagCmbModel {
    private ObservableList<MxNodePwf> listChecked = FxUtils.newList();
    boolean flag = false;
    private boolean bool = true;

    @PostConstruct
    public void init() {
    }

    public void initCellFactory(ComboBox<MxNodePwf> cmb, Label lbShow, ComboBox<MxNode> cmbExc) {
        this.listChecked.clear();
        this.setLabelTimely(lbShow, cmb, cmbExc);
        this.setCellFactory(cmb);
    }

    private void setCellFactory(ComboBox<MxNodePwf> cmb) {
        cmb.setCellFactory(value -> new ListCell<MxNodePwf>(){
            private HBox graphic = new HBox();
            CheckBox cBox = new CheckBox();
            Label label = new Label();
            private MxNodePwf item;
            {
                this.label.setMaxWidth(Double.POSITIVE_INFINITY);
                this.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
                    if (!this.cBox.isDisable()) {
                        this.cBox.setSelected(!this.cBox.isSelected());
                        if (this.cBox.isSelected()) {
                            HedgeFlagCmbModel.this.listChecked.add((Object)this.item);
                        } else {
                            HedgeFlagCmbModel.this.listChecked.remove((Object)this.item);
                            this.item.setDefaluted(false);
                        }
                    }
                    event.consume();
                });
                this.graphic.getChildren().setAll((Object[])new Node[]{this.cBox, this.label});
                HBox.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            }

            protected void updateItem(MxNodePwf item, boolean empty) {
                if (item != null) {
                    if (this.item == null) {
                        this.item = item;
                    }
                    if (this.label.getText().isEmpty()) {
                        this.label.setText(item.getValue());
                    }
                    if (item.isDefaluted()) {
                        this.cBox.setSelected(true);
                    }
                    this.cBox.setDisable(item.isDisable());
                    if (this.cBox.isSelected()) {
                        item.setSelected(true);
                    }
                }
                if (empty) {
                    this.setGraphic(null);
                } else {
                    this.setGraphic((Node)this.graphic);
                }
            }
        });
        cmb.setSkin((Skin)new ComboBoxListViewSkin<MxNodePwf>(cmb){

            protected boolean isHideOnClickEnabled() {
                return false;
            }
        });
    }

    private void setLabelTimely(Label label, ComboBox<MxNodePwf> cmb, ComboBox<MxNode> cmbExc) {
        label.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> {
            if (this.flag) {
                cmb.hide();
                this.flag = false;
            } else {
                cmb.show();
                this.flag = true;
            }
            event.consume();
        });
        label.focusedProperty().addListener((ob, old, now) -> {
            if (!now.booleanValue()) {
                this.flag = false;
            }
        });
        this.listChecked.addListener(ob -> {
            String str = this.listChecked.toString();
            label.setText(str.substring(1, str.length() - 1));
            if (this.listChecked.size() == 0) {
                cmb.getItems().forEach(node -> node.setDisable(false));
                this.bool = true;
            }
            if (this.bool && this.listChecked.size() == 1) {
                String type = HedgeFlagCmbModel.getExcTypeDesc(((MxNodePwf)this.listChecked.get(0)).getRaw(), ((MxNode)cmbExc.getValue()).getRaw());
                cmb.getItems().forEach(node -> node.setDisable(!type.contains(node.getRaw())));
                this.bool = false;
            }
        });
    }

    public void check(MxNodePwf defaultValue, boolean enable) {
        defaultValue.setDefaluted(true);
        defaultValue.setDisable(!enable);
        this.filter(defaultValue);
    }

    public ObservableList<MxNodePwf> getCheckItems() {
        return this.listChecked;
    }

    private void filter(MxNodePwf node) {
        if (!this.listChecked.contains((Object)node)) {
            this.listChecked.add((Object)node);
        }
    }

    private static String getExcTypeDesc(String hedge, String cmbExc) {
        if ("1".contains(hedge) && cmbExc.equals("CCFX")) {
            return "1";
        }
        if ("2".contains(hedge) && cmbExc.equals("CCFX")) {
            return "2";
        }
        if ("4".contains(hedge) && cmbExc.equals("CCFX")) {
            return "4";
        }
        if ("8".contains(hedge) && cmbExc.equals("CCFX")) {
            return "8";
        }
        return "1248";
    }
}

