/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IFundAccountApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MScheduler;
import cms.tmx.core.utils.DesEncrypt;
import cms.tmx.datatype.message.PAccount;
import cms.tmx.datatype.message.PAssetService;
import cms.tmx.datatype.message.PFundAccntService;
import cms.tmx.datatype.message.PMainTenance;
import cms.tmx.datatype.message.PPostTrade;
import cms.tmx.deepsupervise.IDeepSuperviseApi;
import cms.tmx.entity.Account;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.PersonalAccount;
import cms.tmx.entity.factory.FundAccountFactory;
import cms.tmx.entity.notice.AssetReport;
import cms.tmx.entity.notice.CashPushReport;
import cms.tmx.entity.notice.TradeCaptureReport;
import cms.tmx.entity.notice.UserAuthenticateReport;
import cms.tmx.entity.trade.DeepSuperviseInfo;
import cms.tmx.entity.trade.PreFrozenFundAccnt;
import cms.tmx.http.accnt.AccountServiceApi;
import cms.tmx.http.accnt.GetExtCashAccntsReq;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.position.dto.Assets;
import cms.tmx.http.api.position.dto.GetAccntAssetReq;
import cms.tmx.http.api.position.dto.GetAccntAssetResp;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.ExecutionReport;
import cms.tmx.http.api.strategy.dto.PosEvent;
import cms.tmx.http.api.strategy.dto.PosStatistic;
import cms.tmx.http.api.strategy.dto.Position;
import cms.tmx.http.api.strategy.dto.Positions;
import cms.tmx.http.api.strategy.dto.SOFPEvent;
import cms.tmx.http.api.strategy.dto.TradeType;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.datahub.api.PositionServiceApi;
import cms.tmx.http.fundaccnt.dto.CashAccnt;
import cms.tmx.http.instruction.dto.AccntSecInfo;
import cms.tmx.http.instruction.dto.SimpleDetail;
import cms.tmx.http.query.Sofp;
import cms.tmx.http.query.marginxt.CreditAccountEvent;
import cms.tmx.http.query.marginxt.XtGetBalanceReq;
import cms.tmx.http.query.marginxt.XtGetBalanceResp;
import cms.tmx.http.query.marginxt.XtSofp;
import cms.tmx.http.query.marginxt.api.XtRateServiceApi;
import cms.tmx.http.statement.api.StatementServiceApi;
import cms.tmx.http.workflow.dto.HttpInsPushMessage;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.jni.DeepSuperviseUserApi;
import cms.tmx.jni.struct.DeepSuperviseResp;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.manage.models.AccountMngServiceImpl;
import cms.tmx.manage.models.FuncMngServiceImpl;
import cms.tmx.utils.CounterNameUtils;
import cms.tmx.utils.LoggerUtils;
import cms.tmx.utils.MarketUtils;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LinkedTreeMap;
import com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class FundAccountMngServiceImpl
implements IFundAccountService {
    private volatile boolean bInit = false;
    @Inject
    private AccountMngServiceImpl accService;
    @Inject
    private AccountServiceApi newAccntApi;
    @Inject
    private IFundAccountApi fundApi;
    @Inject
    private IDeepSuperviseApi deepApi;
    public Map<String, String> accNameMap = new HashMap<String, String>();
    public Map<String, String> investorIdCounterMap = new HashMap<String, String>();
    private ObservableList<FundAccount> listActiveDetail = FxUtils.newList();
    private ObservableList<FundAccount> listAllDetail = FxUtils.newList();
    private ObservableList<FundAccount> listContainsExtAsset = FxUtils.newList();
    private ObservableList<FundAccount> listNewAccnt = FxUtils.newList();
    private Map<String, CcsFundAccount> investorMap = new HashMap<String, CcsFundAccount>();
    private Map<String, CcsFundAccount> cashAccntIdMap = new HashMap<String, CcsFundAccount>();
    private Map<String, CcsFundAccount> accntIdMap = new HashMap<String, CcsFundAccount>();
    private Map<String, Account> accountMap = new HashMap<String, Account>();
    private Map<String, FundAccount> allCashAccntIdMap = new HashMap<String, FundAccount>();
    private List<String> productIds = new ArrayList<String>();
    private static final Logger logger = LogManager.getLogger(FuncMngServiceImpl.class);
    @Inject
    protected MEventService es;
    @Inject
    protected MConfService cs;
    @Inject
    private MScheduler sdRefresh;
    @Inject
    private MScheduler sdQuery;
    @Inject
    private MScheduler sdChange;
    @Inject
    private ExecutorService exe;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private IBaseApi iBaseApi;
    @Inject
    private StatementServiceApi balanceApi;
    @Inject
    private XtRateServiceApi rateApi;
    @Inject
    private cms.tmx.http.api.strategy.api.PositionServiceApi positionServiceApi;
    @Inject
    private PositionServiceApi dataHubPositionService;
    private static final int ACCOUNT_QUERY_INTERVAL = 500;
    private static final int ACCOUNT_FULL_QUERY_INTERVAL = 1000;
    @Inject
    private FundAccountFactory fAcc;
    private ReentrantLock lockList = new ReentrantLock();
    private Set<FundAccount> setAccToBeQuery = new HashSet<FundAccount>();
    private ReentrantLock lockToBeQuery = new ReentrantLock();
    private ReentrantLock lockDeepSupervise = new ReentrantLock();
    private Condition condition = this.lockDeepSupervise.newCondition();
    private String registingAccount = "";
    private MEventHandler insHandler = event -> this.onInsPush(event);
    private HashMap<String, DeepSuperviseInfo> deepSuperviseMap = new HashMap();
    private Gson gson = new Gson();
    private BooleanProperty changed = new SimpleBooleanProperty(false);
    private List<String> accntIds = new ArrayList<String>();
    private Map<String, FundAccount> neeqAccntsMap = new HashMap<String, FundAccount>();

    @PostConstruct
    public void init() {
        this.sdRefresh.setInterval(500);
        this.sdQuery.setInterval(1000);
        this.sdChange.setInterval(1000);
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.es.subscribe("uap.push.ExecutionReport", e -> this.onPush(e));
        this.es.subscribe("uap.push.SOFPEvent", e -> this.onSofpPush(e));
        this.es.subscribe("uap.push.CreditAccountEvent", e -> this.onCreditAccountEventPush(e));
        this.es.subscribe("uap.push.PosEvent", e -> this.onPositionPush(e));
        this.es.subscribe("uap.push.InsEvent", this.insHandler);
        this.es.subscribe("pre_frozen_fund", event -> this.updatePreFrzFund(event));
        this.initBrokerMap();
    }

    private void onInsPush(MEvent event) {
        try {
            SimpleDetail otcDetail;
            Object detail;
            JsonObject pushMsg = (JsonObject)event.getObj(JsonObject.class);
            HttpInsPushMessage insPushMsg = (HttpInsPushMessage)this.gson.fromJson(pushMsg.toString(), HttpInsPushMessage.class);
            if (insPushMsg != null && insPushMsg.getInstruction() != null && "SimpleDetail".equals(insPushMsg.getInstruction().getType()) && (detail = Optional.ofNullable(insPushMsg).map(item -> item.getInstruction()).map(item -> item.getDetail()).orElseThrow(() -> new Exception("\u65b0\u6846\u67b6\u6307\u4ee4\u63a8\u9001\u66f4\u65b0\u53ef\u7528\u8d44\u91d1\u51fa\u9519"))) instanceof LinkedTreeMap && AccntLevel.ACCNT_LEVEL_EXT == (otcDetail = (SimpleDetail)this.gson.fromJson(this.gson.toJson(detail), SimpleDetail.class)).getAccntLevel()) {
                String extAccntId = Optional.ofNullable(otcDetail).map(item -> (AccntSecInfo)item.getAccntSecInfo().get(0)).map(item -> item.getAccountId()).map(item -> item.getCashAccntId()).orElseThrow(() -> new Exception("\u65b0\u6846\u67b6\u6307\u4ee4\u63a8\u9001\u66f4\u65b0\u53ef\u7528\u8d44\u91d1\u51fa\u9519"));
                if (StringUtils.isEmpty((String)extAccntId)) {
                    return;
                }
                FundAccount fundAccount = this.getFundAccountByNewCashAccntId(extAccntId, insPushMsg.getMarketGroup());
                if (fundAccount != null) {
                    this.addToBeQuery(fundAccount);
                }
                this.runQuerySpec(false);
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void initBrokerMap() {
        String[] brokers;
        String brokersStr = this.cs.getValue("ctp.broker");
        if (brokersStr == null) {
            return;
        }
        String[] stringArray = brokers = brokersStr.split(";");
        int n = brokers.length;
        int n2 = 0;
        while (n2 < n) {
            String brokerInfo = stringArray[n2];
            DeepSuperviseInfo deepInfo = new DeepSuperviseInfo(brokerInfo);
            this.deepSuperviseMap.put(deepInfo.getBrokerId(), deepInfo);
            ++n2;
        }
    }

    private void updatePreFrzFund(MEvent event) {
        Object obj = event.getObj();
        if (!(obj instanceof PreFrozenFundAccnt)) {
            return;
        }
        PreFrozenFundAccnt fundAccnts = (PreFrozenFundAccnt)PreFrozenFundAccnt.class.cast(obj);
        Set fundAccntsToUpdate = fundAccnts.getFundAccntsToUpdate();
        for (FundAccount fundAccount : fundAccntsToUpdate) {
            this.addToBeQuery(fundAccount);
        }
        this.runQuerySpec(false);
    }

    @Override
    public void queryFundAccountList() {
        this.sdQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException e) {
                logger.error("fund account full query failed", (Throwable)e);
            }
        });
    }

    private synchronized void fullQuery() throws MException {
        logger.info("\u5168\u91cf\u67e5\u8be2\u8d44\u91d1\u8d26\u53f7");
        LoggerUtils.logStackTrace();
        if (StringUtils.isEmpty((String)this.iBaseApi.getPostId())) {
            throw new MException(1, "\u804c\u4f4did\u4e3a\u7a7a");
        }
        LinkedList<FundAccount> listActice = new LinkedList<FundAccount>();
        LinkedList<FundAccount> listAll = new LinkedList<FundAccount>();
        LinkedList<FundAccount> listNew = new LinkedList<FundAccount>();
        LinkedList<FundAccount> listExternalAsset = new LinkedList<FundAccount>();
        this.clearToBeQuery();
        ObservableList<Account> accountList = this.getAllAccountList();
        for (Account account : accountList) {
            List<FundAccount> list;
            this.accountMap.put(account.getInvestorId(), account);
            this.productIds.add(account.getProductId());
            if ("99999-02-01".equals(account.getTradePlatformId()) || "99999-02-02".equals(account.getTradePlatformId()) || "99988-01-01".equals(account.getTradePlatformId()) || "99988-01-02".equals(account.getTradePlatformId()) || "55555-04-01".equals(account.getTradePlatformId()) || "66668-01-01".equals(account.getTradePlatformId()) || "99999-02-03".equals(account.getTradePlatformId())) {
                try {
                    list = this.queryFundAccountList(account.getId(), account.getSecExc());
                    this.accNameMap.put(account.getInvestorId(), account.getName());
                    this.investorIdCounterMap.put(account.getInvestorId(), CounterNameUtils.getCounterName((String)account.getInvestorId(), (String)account.getTradePlatformId()));
                    list.forEach(fundAccount -> {
                        fundAccount.setAccountName(account.getName());
                        fundAccount.setExternalAsset(account.isExternalAsset());
                        fundAccount.setNeeqEnable(account.isNeeqEnable());
                        fundAccount.setOtcEnable(account.isOtcEnable());
                        fundAccount.setFileOrderManualConfirm(account.isFileOrderManualConfirmation());
                    });
                    listExternalAsset.addAll(list);
                    if (account.isExternalAsset()) continue;
                    listNew.addAll(list);
                }
                catch (MException e) {
                    logger.error("query fund account list failed", (Throwable)e);
                }
                continue;
            }
            try {
                list = this.queryFundAccountList(account.getId(), account.getSecExc());
                this.accNameMap.put(account.getInvestorId(), account.getName());
                this.investorIdCounterMap.put(account.getInvestorId(), CounterNameUtils.getCounterName((String)account.getInvestorId(), (String)account.getTradePlatformId()));
                list.forEach(fundAccount -> {
                    fundAccount.setAccountName(account.getName());
                    fundAccount.setNeeqEnable(account.isNeeqEnable());
                    fundAccount.setOtcEnable(account.isOtcEnable());
                    fundAccount.setExternalAsset(account.isExternalAsset());
                    fundAccount.setFileOrderManualConfirm(account.isFileOrderManualConfirmation());
                });
                listExternalAsset.addAll(list);
                if (account.isExternalAsset()) continue;
                if (account.getStatus().getRaw().equals("1")) {
                    listActice.addAll(list);
                }
                if (account.isNeeqEnable()) {
                    listNew.addAll(list);
                }
                listAll.addAll(list);
            }
            catch (MException e) {
                logger.error("query fund account list failed", (Throwable)e);
            }
        }
        this.updateList(this.listContainsExtAsset, listExternalAsset);
        this.updateNewList(this.listNewAccnt, listNew);
        this.updateList(this.listActiveDetail, listActice);
        this.updateList(this.listAllDetail, listAll);
        this.exe.execute(() -> this.deepSupervise());
    }

    @Override
    public Map<String, Account> getAccountMap() {
        return this.accountMap;
    }

    @Override
    public synchronized ObservableList<FundAccount> getFundAccountList() {
        if (!this.bInit) {
            try {
                this.fullQuery();
                this.bInit = true;
            }
            catch (MException e) {
                logger.error("query fund account list failed", (Throwable)e);
            }
        }
        return this.listActiveDetail;
    }

    public synchronized ObservableList<FundAccount> getCcsFundAccountList() {
        this.getFundAccountList();
        ObservableList listCcs = FxUtils.newList();
        this.listAllDetail.forEach(fundaccount -> {
            if (fundaccount.getMarketGrp().equals("CCS") && fundaccount instanceof CcsFundAccount && !fundaccount.getCounterId().contains("99999")) {
                listCcs.add(fundaccount);
            }
        });
        if (!this.getMarginFundAccountList().isEmpty()) {
            this.getMarginFundAccountList().forEach(marginFund -> {
                if ("99999-02-02".equals(marginFund.getCounterId()) || "99999-02-03".equals(marginFund.getCounterId())) {
                    listCcs.add(marginFund);
                }
            });
        }
        return listCcs;
    }

    public synchronized ObservableList<FundAccount> getCcsTransferFundAccountList() {
        this.getFundAccountList();
        ObservableList listCcs = FxUtils.newList();
        this.listAllDetail.forEach(fundaccount -> {
            if (fundaccount.getMarketGrp().equals("CCS") && fundaccount instanceof CcsFundAccount && !fundaccount.getCounterId().contains("99999")) {
                listCcs.add(fundaccount);
            }
        });
        return listCcs;
    }

    public synchronized ObservableList<FundAccount> getCcsFocusAccountList() {
        this.getFundAccountList();
        ObservableList listCcs = FxUtils.newList();
        this.listAllDetail.forEach(fundaccount -> {
            if (fundaccount instanceof CcsFundAccount && fundaccount.getCounterId().contains("99999")) {
                listCcs.add(fundaccount);
            }
        });
        return listCcs;
    }

    @Override
    public synchronized ObservableList<FundAccount> getAllFundAccountList() {
        if (!this.bInit) {
            try {
                this.fullQuery();
                this.bInit = true;
            }
            catch (MException e) {
                logger.error("query all fund account list failed", (Throwable)e);
            }
        }
        return this.listAllDetail;
    }

    @Override
    public synchronized ObservableList<FundAccount> getExtAssetFundAccs() {
        if (!this.bInit) {
            try {
                this.fullQuery();
                this.bInit = true;
            }
            catch (MException e) {
                logger.error("query all fund account list failed", (Throwable)e);
            }
        }
        return this.listContainsExtAsset;
    }

    @Override
    public synchronized List<FundAccount> getMarginFundAccountList() {
        if (!this.bInit) {
            try {
                this.fullQuery();
                this.bInit = true;
            }
            catch (MException e) {
                logger.error("query all fund account list failed", (Throwable)e);
            }
        }
        List<FundAccount> collect = this.listNewAccnt.stream().filter(item -> "99999-02-01".equals(item.getCounterId()) || "99999-02-02".equals(item.getCounterId()) || "99999-02-03".equals(item.getCounterId())).collect(Collectors.toList());
        return collect;
    }

    @Override
    public synchronized List<FundAccount> getNeeqFundAccountList() {
        if (!this.bInit) {
            try {
                this.fullQuery();
                this.bInit = true;
            }
            catch (MException e) {
                logger.error("query all fund account list failed", (Throwable)e);
            }
        }
        List<FundAccount> collect = this.listActiveDetail.stream().filter(item -> item.isNeeqEnable()).collect(Collectors.toList());
        return collect;
    }

    @Override
    public List<FundAccount> getFundAccountList(String type) {
        ArrayList<FundAccount> accnts = new ArrayList<FundAccount>((Collection<FundAccount>)this.getFundAccountList());
        return accnts.stream().filter(each -> type.equals(each.getMarketGrp())).collect(Collectors.toList());
    }

    private boolean careReport(String type) {
        return type.equals("48") || type.equals("52") || type.equals("56") || type.equals("70");
    }

    private void onAssetPush(AssetReport report) {
        double available = 0.0;
        double posiCapital = 0.0;
        for (PAssetService.AssetField each : report.getReport().getAssetList()) {
            switch (each.getSecType()) {
                case "CASH": {
                    available = each.getAssetAmount();
                    break;
                }
                case "OTHERS": 
                case "BOND": 
                case "FUND": 
                case "STOCK": {
                    posiCapital += each.getAssetAmount();
                }
            }
        }
        this.udpateAsset(report, available, posiCapital -= report.getReport().getAccruedInterest());
    }

    private void addToBeQuery(FundAccount acc) {
        this.lockToBeQuery.lock();
        try {
            this.setAccToBeQuery.add(acc);
        }
        finally {
            this.lockToBeQuery.unlock();
        }
    }

    private void clearToBeQuery() {
        this.lockToBeQuery.lock();
        try {
            this.setAccToBeQuery.clear();
        }
        finally {
            this.lockToBeQuery.unlock();
        }
    }

    private void onSofpPush(MEvent event) {
        if (!(event.getObj() instanceof JsonPrimitive)) {
            return;
        }
        JsonPrimitive obj = (JsonPrimitive)event.getObj();
        SOFPEvent sofps = (SOFPEvent)this.gson.fromJson(obj.getAsString(), SOFPEvent.class);
        for (Sofp sofp : sofps.getSofps()) {
            for (FundAccount f : this.listNewAccnt) {
                if (!f.getNewCashAccntId().equals(sofp.getCashAccntId()) || !f.getMarketGrp().equals(sofps.getMarketGrp())) continue;
                f.update((Object)sofp);
            }
            this.changed();
        }
    }

    private void onCreditAccountEventPush(MEvent event) {
        if (!(event.getObj() instanceof JsonPrimitive)) {
            return;
        }
        JsonPrimitive obj = (JsonPrimitive)event.getObj();
        CreditAccountEvent sofps = (CreditAccountEvent)this.gson.fromJson(obj.getAsString(), CreditAccountEvent.class);
        for (XtSofp sofp : sofps.getCreditAccounts()) {
            for (FundAccount f : this.listNewAccnt) {
                if (!f.getNewCashAccntId().equals(sofp.getCashAccntId())) continue;
                logger.info("\u6536\u5230\u8fc5\u6295\u53ef\u7528\u8d44\u91d1\u63a8\u9001,\u53ef\u7528\u8d44\u91d1:{}   \u8d26\u53f7:{}   \u66f4\u65b0\u524d\u7684\u53ef\u7528\u8d44\u91d1\u4e3a:{}", (Object)StringUtils.toStr((double)sofp.getFundAvail(), (int)3), (Object)sofp.getCashAccntId(), (Object)StringUtils.toStr((double)f.getAvailableNewXt(), (int)3));
                f.update((Object)sofp);
                logger.info("\u6536\u5230\u8fc5\u6295\u53ef\u7528\u8d44\u91d1\u63a8\u9001,\u53ef\u7528\u8d44\u91d1:{}   \u8d26\u53f7:{}   \u66f4\u65b0\u540e\u7684\u53ef\u7528\u8d44\u91d1\u4e3a:{}", (Object)StringUtils.toStr((double)sofp.getFundAvail(), (int)3), (Object)sofp.getCashAccntId(), (Object)StringUtils.toStr((double)f.getAvailableNewXt(), (int)3));
            }
        }
        this.changed();
    }

    private void onPositionPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        PosEvent posEvent = (PosEvent)this.gson.fromJson((JsonElement)obj, PosEvent.class);
        if (posEvent.getTradeType() == null) {
            return;
        }
        if (!TradeType.kTradeTypeReset.getValue().equals(posEvent.getTradeType().getValue())) {
            return;
        }
        for (Positions position : posEvent.getPosition()) {
            if (!AccntType.ACCNT_TYPE_CASH.getValue().equals(position.getAccntType().getValue())) continue;
            Position realPosition = new Position();
            realPosition.setPosStatistic(new PosStatistic());
            realPosition.update((Object)position);
            realPosition.transformQty();
            for (FundAccount acc : this.listActiveDetail) {
                if (acc.isNeeqEnable() || !acc.getNewCashAccntId().equals(position.getPosAccnt().getCashAccntId())) continue;
                logger.info("\u6536\u5230\u63a8\u9001\u91cc\u9762\u7684\u53ef\u7528\u8d44\u91d1\uff1aAvailable" + StringUtils.toStr((double)realPosition.getCashAvail(), (int)3) + "\u8d26\u53f7:" + acc.getInvestId() + "\u66f4\u65b0\u524d\u7684\u53ef\u7528\u8d44\u91d1\u4e3a:" + StringUtils.toStr((double)acc.getAvailable(), (int)3));
                acc.update((Object)position);
                logger.info("\u8d26\u53f7:" + acc.getInvestId() + "\u66f4\u65b0\u540e\u7684\u53ef\u7528\u8d44\u91d1\u4e3a:" + StringUtils.toStr((double)acc.getAvailable(), (int)3));
                break;
            }
            this.changed();
        }
    }

    private void onPush(MEvent event) {
        PPostTrade.TradeCaptureReport pReport;
        cms.tmx.entity.notice.ExecutionReport report;
        if (event.getObj() instanceof AssetReport) {
            this.onAssetPush((AssetReport)AssetReport.class.cast(event.getObj()));
            return;
        }
        if (event.getObj() instanceof cms.tmx.entity.notice.ExecutionReport) {
            report = (cms.tmx.entity.notice.ExecutionReport)cms.tmx.entity.notice.ExecutionReport.class.cast(event.getObj());
            String type = Integer.toString(report.getType());
            if (!this.careReport(type)) {
                return;
            }
            String fundAccId = report.getReport().getExtAccntId();
            String marketGroup = MarketUtils.getMarketGroup((String)report.getReport().getInstrument().getMarket());
            this.updateFundAccount(fundAccId, marketGroup, false);
        }
        if (event.getObj() instanceof TradeCaptureReport) {
            report = (TradeCaptureReport)TradeCaptureReport.class.cast(event.getObj());
            pReport = report.getReport();
            String marketGroup = MarketUtils.getMarketGroup((String)pReport.getInstrument().getMarket());
            String fundAccId = pReport.getExtAccntId();
            this.updateFundAccount(fundAccId, marketGroup, false);
        }
        if (event.getObj() instanceof CashPushReport) {
            report = (CashPushReport)CashPushReport.class.cast(event.getObj());
            pReport = report.getReport();
            PAccount.ExtFundAccnt extFundAccnt = pReport.getExtFundAccnt();
            FundAccount fundAcc = this.fAcc.createFundAccount(extFundAccnt.getMarketGrp());
            if (fundAcc != null) {
                fundAcc.update((Object)extFundAccnt);
            }
            this.udpateCash(fundAcc);
        }
        if (event.getObj() instanceof UserAuthenticateReport) {
            this.femaPushHandle(event);
        }
        if (event.getObj() instanceof JsonElement) {
            JsonElement cast = (JsonElement)JsonElement.class.cast(event.getObj());
            ExecutionReport report2 = (ExecutionReport)this.gson.fromJson(cast.toString(), ExecutionReport.class);
            if (report2.getExecType() == null) {
                return;
            }
            String type = report2.getExecType().getValue();
            if (!this.careReport(type)) {
                return;
            }
            FundAccount fundAccount = this.getFundAccountByNewCashAccntId(report2.getExtCashAccntId(), report2.getInstrument().getMarketGroup());
            if (fundAccount != null) {
                this.addToBeQuery(fundAccount);
            }
            this.runQuerySpec(false);
        }
    }

    public void updateFundAccount(String fundAccId, String marketGroup, boolean isNewFrameWork) {
        FundAccount fundAcc = isNewFrameWork ? this.getFundAccountNew(fundAccId, marketGroup) : this.getFundAccount(fundAccId, marketGroup);
        if (fundAcc != null) {
            this.addToBeQuery(fundAcc);
        }
        this.runQuerySpec(isNewFrameWork);
    }

    private void runQuerySpec(boolean isNewFrameWork) {
        this.sdRefresh.schedule(event -> {
            try {
                this.queryToBeQuery(isNewFrameWork);
            }
            catch (MException e) {
                logger.error("query spec fund account failed", (Throwable)e);
            }
        });
    }

    private void queryToBeQuery(boolean isNewFrameWork) throws MException {
        this.lockToBeQuery.lock();
        LinkedList<FundAccount> listAcc = new LinkedList<FundAccount>();
        try {
            listAcc.addAll(this.setAccToBeQuery);
            this.setAccToBeQuery.clear();
        }
        finally {
            this.lockToBeQuery.unlock();
        }
        if (isNewFrameWork) {
            for (FundAccount acc : listAcc) {
                this.updateFundAccountNew(acc);
            }
        } else {
            for (FundAccount acc : listAcc) {
                this.updateFundAcc(acc);
            }
        }
    }

    private void updateFundAccountNew(FundAccount acc) {
        if ("99999-02-01".equals(acc.getCounterId()) || "99999-02-02".equals(acc.getCounterId()) || "99999-02-03".equals(acc.getCounterId())) {
            Sofp sofp = this.balanceApi.GetBalanceSheetReq(acc.getNewCashAccntId(), "CCS");
            if (sofp != null) {
                acc.update((Object)sofp);
            }
            try {
                XtGetBalanceReq req = new XtGetBalanceReq();
                Page httpDefPage = this.baseApi.getHttpDefPage();
                req.setAccntLevel(Integer.valueOf(AccntLevel.ACCNT_LEVEL_EXT.getValue()));
                req.setCashAccntId(Arrays.asList(acc.getNewCashAccntId()));
                req.setPageSize(httpDefPage.getPageSize());
                req.setPageNum(1);
                XtGetBalanceResp resp = this.rateApi.getBalanceSheetReq(req);
                if (!resp.getSofps().isEmpty()) {
                    acc.update(resp.getSofps().get(0));
                }
            }
            catch (MException | Exception e) {
                logger.error("\u67e5\u8be2\u8fc5\u6295\u8d26\u53f7\u8d44\u91d1\u5931\u8d25", e);
            }
        } else if (acc.isNeeqEnable()) {
            try {
                List extAccntCash = this.positionServiceApi.getExtAccntCash(acc.getExtAccntId());
                if (!extAccntCash.isEmpty()) {
                    acc.update(extAccntCash.get(0));
                }
            }
            catch (MException | Exception e) {
                logger.error((Object)e, e);
            }
        }
        this.changed();
    }

    private void updateFundAcc(FundAccount fundAcc) throws MException {
        double assetAmt = fundAcc.getAssetAmt();
        String accName = fundAcc.getAccountName();
        double capitalization = fundAcc.getCapitalization();
        double buyCostAmt = fundAcc.getBuyCostAmt();
        double realPl = fundAcc.getRealPl();
        double floatPl = fundAcc.getFloatPl();
        boolean extAsset = fundAcc.isExternalAsset();
        double totalPl = fundAcc.getTotalPl();
        boolean neeqEnable = fundAcc.isNeeqEnable();
        boolean otcEnable = fundAcc.isOtcEnable();
        boolean fileOrderManualConfirm = fundAcc.isFileOrderManualConfirm();
        String newCashAccntId = fundAcc.getNewCashAccntId();
        fundAcc.update((Object)this.queryFundAccount(fundAcc));
        fundAcc.setAssetAmt(assetAmt);
        fundAcc.setAccountName(accName);
        fundAcc.setExternalAsset(extAsset);
        fundAcc.setCapitalization(capitalization);
        fundAcc.setBuyCostAmt(buyCostAmt);
        fundAcc.setRealPl(realPl);
        fundAcc.setFloatPl(floatPl);
        fundAcc.setTotalPl(totalPl);
        fundAcc.setNeeqEnable(neeqEnable);
        fundAcc.setFileOrderManualConfirm(fileOrderManualConfirm);
        fundAcc.setOtcEnable(otcEnable);
        fundAcc.setNewCashAccntId(newCashAccntId);
        this.changed();
    }

    private double formatScale(double d, int scale) {
        return new BigDecimal(d).setScale(scale, 4).doubleValue();
    }

    private void udpateAsset(AssetReport report, double available, double posiCapital) {
        String marketGrp;
        String id = report.getReport().getExtAccntId();
        FundAccount acc = this.getFundAccount(id, marketGrp = report.getReport().getMarketGrp());
        if (acc == null) {
            return;
        }
        double assetAmt = report.getReport().getTotalAmount();
        double buyCostAmt = report.getReport().getBuyCostAmt();
        double realPl = report.getReport().getRealizedPl();
        acc.setAssetAmt(this.formatScale(assetAmt, 2));
        acc.setAvailable(this.formatScale(available, 2));
        acc.setCapitalization(this.formatScale(posiCapital, 2));
        acc.setBuyCostAmt(this.formatScale(buyCostAmt, 2));
        acc.setRealPl(this.formatScale(realPl, 2));
        acc.setFloatPl(posiCapital - buyCostAmt);
        acc.setTotalPl(acc.getFloatPl() + realPl);
        this.changed();
    }

    private void udpateCash(FundAccount fundAcc) {
        if ("FUTURES".equals(fundAcc.getMarketGrp())) {
            CtpFundAccount acc = (CtpFundAccount)this.getFundAccount(fundAcc.getExtAccntId(), fundAcc.getMarketGrp());
            if (acc == null) {
                return;
            }
            acc.update((Object)((CtpFundAccount)fundAcc));
        } else if ("CCS".equals(fundAcc.getMarketGrp())) {
            CcsFundAccount acc = (CcsFundAccount)this.getFundAccount(fundAcc.getExtAccntId(), fundAcc.getMarketGrp());
            if (acc == null) {
                return;
            }
            Platform.runLater(() -> {
                acc.setAvailable(fundAcc.getAvailable());
                acc.setHkAvailable(fundAcc.getHkAvailable());
                acc.setWithdrawQuota(fundAcc.getWithdrawQuota());
            });
        }
        this.changed();
    }

    private void updateNewList(ObservableList<FundAccount> listIsActive, List<FundAccount> list) {
        this.lockList.lock();
        try {
            list.forEach(item -> {
                this.replaceExtAccntId((FundAccount)item);
                Sofp sofp = this.balanceApi.GetBalanceSheetReq(item.getNewCashAccntId(), "CCS");
                if (sofp != null) {
                    item.update((Object)sofp);
                }
                try {
                    XtGetBalanceReq req = new XtGetBalanceReq();
                    Page httpDefPage = this.baseApi.getHttpDefPage();
                    req.setAccntLevel(Integer.valueOf(AccntLevel.ACCNT_LEVEL_EXT.getValue()));
                    req.setCashAccntId(Arrays.asList(item.getNewCashAccntId()));
                    req.setPageSize(httpDefPage.getPageSize());
                    req.setPageNum(1);
                    XtGetBalanceResp resp = this.rateApi.getBalanceSheetReq(req);
                    if (!resp.getSofps().isEmpty()) {
                        item.update(resp.getSofps().get(0));
                    }
                }
                catch (MException | Exception e) {
                    logger.error("\u67e5\u8be2\u8fc5\u6295\u8d26\u53f7\u8d44\u91d1\u5931\u8d25", e);
                }
            });
            listIsActive.setAll(list);
        }
        finally {
            this.lockList.unlock();
        }
        this.changed();
    }

    private void updateList(ObservableList<FundAccount> listIsActive, List<FundAccount> list) {
        this.lockList.lock();
        try {
            list.forEach(item -> this.replaceExtAccntId((FundAccount)item));
            HashMap assetMap = new HashMap();
            listIsActive.stream().forEach(each -> assetMap.put(each.getInvestId(), each));
            listIsActive.setAll(list);
            listIsActive.stream().forEach(each -> {
                FundAccount old;
                if (assetMap.get(each.getInvestId()) != null && (old = (FundAccount)assetMap.get(each.getInvestId())) != null) {
                    each.setAssetAmt(old.getAssetAmt());
                    each.setCapitalization(old.getCapitalization());
                    each.setBuyCostAmt(old.getBuyCostAmt());
                    each.setRealPl(old.getRealPl());
                    each.setFloatPl(old.getFloatPl());
                    each.setTotalPl(old.getTotalPl());
                }
            });
        }
        finally {
            this.lockList.unlock();
        }
        this.changed();
    }

    private void replaceExtAccntId(FundAccount item) {
        if (!StringUtils.isEmpty((String)item.getNewCashAccntId())) {
            return;
        }
        if ("FUTURES".equals(item.getMarketGrp())) {
            return;
        }
        GetExtCashAccntsReq getCashAccReq = new GetExtCashAccntsReq();
        getCashAccReq.setAccntId(item.getParentId());
        getCashAccReq.setMarketGroup(item.getMarketGrp());
        List extCashAccnts = null;
        try {
            extCashAccnts = this.newAccntApi.getExtCashAccnts(getCashAccReq);
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u65b0\u6846\u67b6\u8d44\u91d1\u8d26\u53f7\u5931\u8d25", (Throwable)e);
        }
        if (extCashAccnts != null && !extCashAccnts.isEmpty()) {
            item.update(extCashAccnts.get(0));
        }
    }

    public String getNewFrameExtAccntId(String parentId, String marketGrp) {
        GetExtCashAccntsReq getCashAccReq = new GetExtCashAccntsReq();
        getCashAccReq.setAccntId(parentId);
        getCashAccReq.setMarketGroup(marketGrp);
        List extCashAccnts = null;
        try {
            extCashAccnts = this.newAccntApi.getExtCashAccnts(getCashAccReq);
        }
        catch (MException e) {
            logger.error("\u67e5\u8be2\u65b0\u6846\u67b6\u8d44\u91d1\u8d26\u53f7\u5931\u8d25", (Throwable)e);
        }
        if (extCashAccnts != null && !extCashAccnts.isEmpty()) {
            return ((CashAccnt)extCashAccnts.get(0)).getCashAccntId();
        }
        return "";
    }

    private ObservableList<Account> getAllAccountList() throws MException {
        ObservableList<Account> accntList = this.accService.getAccountListByPost(this.baseApi.getBaseApi().getPostId());
        return accntList;
    }

    private FundAccount queryFundAccount(FundAccount fundAcc) throws MException {
        PAccount.ExtFundAccnt.Builder builderFundAcc = PAccount.ExtFundAccnt.newBuilder();
        builderFundAcc.setExtAccntId(fundAcc.getExtAccntId());
        builderFundAcc.setMarketGrp(fundAcc.getMarketGrp());
        PAccount.ExtFundAccnt fund = this.fundApi.getFundAccount(builderFundAcc.build());
        if (fund != null) {
            return this.createFundAccount(fundAcc.getMarketGrp(), fund);
        }
        return null;
    }

    private FundAccount createFundAccount(String marketGroup, PAccount.ExtFundAccnt extFundAcc) {
        FundAccount fundAcc = this.fAcc.createFundAccount(marketGroup);
        if (fundAcc != null) {
            fundAcc.update((Object)extFundAcc);
        }
        return fundAcc;
    }

    public List<FundAccount> queryFundAccountList(String id, List<String> markets) throws MException {
        String marketGroup = MarketUtils.getMarketGroup((String)markets.get(0));
        List fundList = new ArrayList();
        fundList = this.fundApi.getFundAccountList(id, marketGroup);
        LinkedList<FundAccount> list = new LinkedList<FundAccount>();
        fundList.forEach(item -> {
            FundAccount fundAcc = this.createFundAccount(marketGroup, (PAccount.ExtFundAccnt)item);
            if (fundAcc != null) {
                list.add(fundAcc);
            }
        });
        return list;
    }

    /*
     * Exception decompiling
     */
    private String genExtAccntId(String marketGroup, Account account) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[7] lbl54 : CaseStatement: default:\u000a, @NONE, blocks:[7] lbl54 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addFundAccount(Account account) throws MException {
        PAccount.ExtFundAccnt.Builder builderFundAcc = PAccount.ExtFundAccnt.newBuilder();
        builderFundAcc.setParentAccntId(account.getId());
        String type = MarketUtils.getMarketGroup((String)((String)account.getSecExc().get(0)));
        builderFundAcc.setExtAccntId(this.genExtAccntId(type, account));
        builderFundAcc.setBrokerId(account.getBrokerId());
        builderFundAcc.setInvestorId(account.getInvestorId());
        String excStr = account.getSecExc().toString();
        excStr = excStr.substring(1, excStr.length() - 1);
        builderFundAcc.setInvestableMarkets(excStr);
        builderFundAcc.setCurrencyId(account.getCurCode());
        String decrypt = "";
        try {
            decrypt = DesEncrypt.encrypt((String)account.getPwd(), (String)"ficc2018");
        }
        catch (Exception e) {
            logger.error("\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            throw new MException(-1, "\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
        }
        builderFundAcc.setPassword(decrypt);
        PAccount.ExtFundAccnt fundAcc = builderFundAcc.build();
        this.fundApi.addFundAccount(fundAcc, type);
    }

    @Override
    public void updateFundAccount(Account account) throws MException {
        PAccount.ExtFundAccnt.Builder builderFundAcc = PAccount.ExtFundAccnt.newBuilder();
        builderFundAcc.setParentAccntId(account.getId());
        String type = MarketUtils.getMarketGroup((String)((String)account.getSecExc().get(0)));
        builderFundAcc.setExtAccntId(this.genExtAccntId(type, account));
        builderFundAcc.setBrokerId(account.getBrokerId());
        builderFundAcc.setInvestorId(account.getInvestorId());
        String excStr = account.getSecExc().toString();
        excStr = excStr.substring(1, excStr.length() - 1);
        builderFundAcc.setInvestableMarkets(excStr);
        builderFundAcc.setCurrencyId(account.getCurCode());
        if (!StringUtils.isEmpty((String)account.getPwd())) {
            String decrypt = "";
            try {
                decrypt = DesEncrypt.encrypt((String)account.getPwd(), (String)"ficc2018");
            }
            catch (Exception e) {
                logger.error("\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
                throw new MException(-1, "\u5bc6\u7801\u52a0\u5bc6\u5931\u8d25");
            }
            builderFundAcc.setPassword(decrypt);
        }
        builderFundAcc.setStatus(Integer.parseInt(account.getStatus().getRaw()));
        PAccount.ExtFundAccnt fundAcc = builderFundAcc.build();
        this.fundApi.updateFundAccount(fundAcc, type);
    }

    @Override
    public void updateFundAccountProduct(List<Account> accountList) {
        if (accountList.isEmpty()) {
            return;
        }
        ArrayList<PFundAccntService.AccntToProduct> accToPros = new ArrayList<PFundAccntService.AccntToProduct>(16);
        for (Account accnt : accountList) {
            PFundAccntService.AccntToProduct.Builder accBuilder = PFundAccntService.AccntToProduct.newBuilder();
            accBuilder.setExtAccntId(accnt.getId());
            accBuilder.setProductId(accnt.getProductId());
            accBuilder.setProductName(accnt.getProductName());
            accToPros.add(accBuilder.build());
        }
        String type = MarketUtils.getMarketGroup((String)((String)accountList.get(0).getSecExc().get(0)));
        try {
            this.fundApi.updateFundAccount(accToPros, type);
        }
        catch (MException e) {
            logger.error("\u8d44\u91d1\u8d26\u53f7\u4ea7\u54c1\u5173\u8054\u5173\u7cfb\u6539\u53d8\u65f6\uff0c\u89e6\u53d1\u540e\u53f0\u5237\u65b0\u5931\u8d25", (Throwable)e);
        }
    }

    public FundAccount getFundAccountByCashAccntId(String cashAccId, String marketGrp) {
        if (StringUtils.isEmpty((String)cashAccId)) {
            return null;
        }
        if (this.allCashAccntIdMap.get(cashAccId) != null) {
            return this.allCashAccntIdMap.get(cashAccId);
        }
        for (FundAccount acc : this.listAllDetail) {
            if (!acc.getMarketGrp().equals(marketGrp) || !cashAccId.equals(acc.getNewCashAccntId())) continue;
            this.allCashAccntIdMap.put(cashAccId, acc);
            return acc;
        }
        return null;
    }

    @Override
    public FundAccount getFundAccount(String id, String mktGrp) {
        FundAccount acc = null;
        this.lockList.lock();
        try {
            for (FundAccount f : this.listActiveDetail) {
                if (!mktGrp.equals(f.getMarketGrp()) || !id.equals(f.getExtAccntId())) continue;
                acc = f;
                break;
            }
        }
        finally {
            this.lockList.unlock();
        }
        return acc;
    }

    public FundAccount getFundAccountByNewCashAccntId(String id, String mktGrp) {
        FundAccount acc = null;
        this.lockList.lock();
        try {
            for (FundAccount f : this.listActiveDetail) {
                if (!f.getMarketGrp().equals(mktGrp) || !f.getNewCashAccntId().equals(id)) continue;
                acc = f;
                break;
            }
        }
        finally {
            this.lockList.unlock();
        }
        return acc;
    }

    @Override
    public FundAccount getFundAccountNew(String id, String mktGrp) {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        FundAccount acc = null;
        this.lockList.lock();
        try {
            for (FundAccount f : this.listContainsExtAsset) {
                if (!f.getMarketGrp().equals(mktGrp) || !f.getNewCashAccntId().equals(id)) continue;
                acc = f;
                break;
            }
        }
        finally {
            this.lockList.unlock();
        }
        return acc;
    }

    private void changed() {
        this.sdChange.schedule(event -> this.changed.set(!this.changed.get()));
    }

    public BooleanProperty changedProperty() {
        return this.changed;
    }

    @Override
    public boolean isFundAccountLogin(String id, String mktGrp) {
        FundAccount fundAccount = null;
        try {
            fundAccount = this.getFundAccount(id, mktGrp);
            if (fundAccount == null) {
                PAccount.ExtFundAccnt extfund = this.getExtFundAccnt(id, mktGrp);
                fundAccount = this.fAcc.createFundAccount(mktGrp);
                if (fundAccount != null) {
                    fundAccount.update((Object)extfund);
                }
            }
            logger.info("\u8d26\u6237id\uff1a" + fundAccount.getInvestId() + "========\u8d26\u6237\u72b6\u6001" + fundAccount.getFlags());
            if ("1".equals(Integer.toString(fundAccount.getFlags()))) {
                return true;
            }
        }
        catch (MException e) {
            logger.error("get account login status failed", (Throwable)e);
        }
        return false;
    }

    private PAccount.ExtFundAccnt getExtFundAccnt(String id, String mktGrp) throws MException {
        PAccount.ExtFundAccnt.Builder builder = PAccount.ExtFundAccnt.newBuilder();
        builder.setMarketGrp(mktGrp);
        builder.setExtAccntId(id);
        PAccount.ExtFundAccnt extfund = this.fundApi.getFundAccount(builder.build());
        return extfund;
    }

    @Override
    public void addFundAccount(PersonalAccount white) throws MException {
        for (String curr : white.getCurrency()) {
            PAccount.ExtFundAccnt.Builder builderFundAcc = PAccount.ExtFundAccnt.newBuilder();
            builderFundAcc.setParentAccntId(white.getId());
            builderFundAcc.setAccountType(1);
            String type = MarketUtils.getMarketGroup((String)((String)white.getSecExc().get(0)));
            builderFundAcc.setExtAccntId(this.genExtAccntId(type, white, curr));
            builderFundAcc.setBrokerId(white.getBrokerId());
            builderFundAcc.setInvestorId(white.getInvestorId());
            String excStr = white.getSecExc().toString();
            excStr = excStr.substring(1, excStr.length() - 1);
            builderFundAcc.setInvestableMarkets(excStr);
            builderFundAcc.setCurrencyId(curr);
            builderFundAcc.setStatus(Integer.parseInt(white.getStatus().getRaw()));
            PAccount.ExtFundAccnt fundAcc = builderFundAcc.build();
            this.fundApi.addFundAccount(fundAcc, type);
        }
    }

    /*
     * Exception decompiling
     */
    private String genExtAccntId(String marketGroup, PersonalAccount white, String curr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl44 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl44 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void deepSupervise() {
        FilteredList ctpAccounts = this.listAllDetail.filtered(each -> each.getMarketGrp().equals("FUTURES"));
        this.ctpDeepSupervise((FilteredList<FundAccount>)ctpAccounts);
        this.femaDeepSupervise((FilteredList<FundAccount>)ctpAccounts);
    }

    private void femaPushHandle(MEvent event) {
        UserAuthenticateReport report = (UserAuthenticateReport)UserAuthenticateReport.class.cast(event.getObj());
        PMainTenance.UserAuthenticateReport uReport = report.getReport();
        if (uReport.getAuthTypeValue() == 1) {
            if (!uReport.getObject().is(PMainTenance.UserCertification.class)) {
                return;
            }
            this.lockDeepSupervise.lock();
            try {
                PMainTenance.UserCertification certification = (PMainTenance.UserCertification)uReport.getObject().unpack(PMainTenance.UserCertification.class);
                logger.info(String.valueOf(uReport.getExtAccntId()) + " " + uReport.getAuthType() + " regist");
                if (!uReport.getExtAccntId().equals(this.registingAccount)) {
                    return;
                }
                String certOutInformation = certification.getCertOutInformation();
                DeepSuperviseResp resp = new DeepSuperviseResp();
                Integer getSysInfoRes = 0;
                FutureTask<Integer> getSysInfo = new FutureTask<Integer>(() -> {
                    int result = DeepSuperviseUserApi.registerRspUserCertificate((char[])certOutInformation.toCharArray());
                    if (result != 0) {
                        logger.error(String.valueOf(uReport.getExtAccntId()) + "\u7a7f\u900f\u5f0f\u76d1\u7ba1\u6ce8\u518c\u4fe1\u606f\u5931\u8d25" + result);
                        return result;
                    }
                    logger.error(String.valueOf(uReport.getExtAccntId()) + "\u7a7f\u900f\u5f0f\u76d1\u7ba1\u6ce8\u518c\u4fe1\u606f\u6210\u529f" + result);
                    int getInfoRes = DeepSuperviseUserApi.getUserLocalSystemInfo((DeepSuperviseResp)resp);
                    if (getInfoRes != 0) {
                        logger.error(String.valueOf(uReport.getExtAccntId()) + "\u7a7f\u900f\u5f0f\u76d1\u7ba1\u83b7\u53d6\u673a\u5668\u4fe1\u606f\u5931\u8d25" + result);
                        return getInfoRes;
                    }
                    return 0;
                });
                this.exe.execute(getSysInfo);
                try {
                    getSysInfoRes = getSysInfo.get(5L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    logger.error("\u7a7f\u900f\u5f0f\u76d1\u7ba1\u83b7\u53d6\u673a\u5668\u4fe1\u606f\u8d85\u65f6\uff1a", (Throwable)e);
                }
                this.condition.signalAll();
                String cert = new String(resp.getChars(), 0, resp.getUsedLength());
                if (StringUtils.isEmpty((String)cert) || getSysInfoRes != 0) {
                    logger.error("\u7a7f\u900f\u5f0f\u76d1\u7ba1\u672a\u83b7\u53d6\u5230\u673a\u5668\u4fe1\u606f,resultCode=" + getSysInfoRes);
                    return;
                }
                logger.info(String.valueOf(uReport.getExtAccntId()) + "femas\u83b7\u53d6\u673a\u5668\u4fe1\u606f\u6210\u529f");
                DeepSuperviseInfo deepSuperviseInfo = this.deepSuperviseMap.get(uReport.getBrokerId());
                if (deepSuperviseInfo == null) {
                    logger.error(String.valueOf(uReport.getBrokerId()) + " \u6ca1\u6709\u914d\u7f6e\u8ba4\u8bc1\u4fe1\u606f");
                    return;
                }
                try {
                    this.deepApi.userAuthenticateRequest(uReport.getBrokerId(), uReport.getExtAccntId(), uReport.getInvestorId(), 2, cert.getBytes(), deepSuperviseInfo.getAppId(), deepSuperviseInfo.getToken());
                }
                catch (InvalidProtocolBufferException e) {
                    logger.error(String.valueOf(uReport.getExtAccntId()) + "\u7a7f\u900f\u5f0f\u76d1\u7ba1\u8ba4\u8bc1\u63a8\u9001\u89e3\u5305\u5931\u8d25", (Throwable)e);
                }
                catch (MException e) {
                    logger.error(String.valueOf(uReport.getExtAccntId()) + "\u7a7f\u900f\u5f0f\u76d1\u7ba1\u63d0\u4ea4\u4fe1\u606f\u5230\u540e\u53f0\u5931\u8d25", (Throwable)e);
                }
            }
            finally {
                this.lockDeepSupervise.unlock();
            }
        } else if (uReport.getAuthTypeValue() == 2) {
            logger.info(String.valueOf(uReport.getExtAccntId()) + " " + uReport.getAuthType() + " submit,status:" + uReport.getStatus());
        }
    }

    /*
     * Loose catch block
     */
    private void femaDeepSupervise(FilteredList<FundAccount> ctpAccounts) {
        for (FundAccount fundAccount : ctpAccounts) {
            if (!(fundAccount instanceof CtpFundAccount)) continue;
            try {
                CtpFundAccount ctpAccnt;
                block11: {
                    ctpAccnt = (CtpFundAccount)CtpFundAccount.class.cast(fundAccount);
                    DeepSuperviseInfo deepSuperviseInfo = this.deepSuperviseMap.get(ctpAccnt.getBrokerId());
                    if (deepSuperviseInfo == null || !"femas".equals(deepSuperviseInfo.getType())) continue;
                    DeepSuperviseResp resp = new DeepSuperviseResp();
                    String appid = deepSuperviseInfo.getAppId();
                    String pwd = deepSuperviseInfo.getToken();
                    this.lockDeepSupervise.lock();
                    logger.info(String.valueOf(ctpAccnt.getExtAccntId()) + "\u6ce8\u518c\u5f00\u59cb");
                    this.registingAccount = ctpAccnt.getExtAccntId();
                    try {
                        FutureTask<Integer> getSysInfo = new FutureTask<Integer>(() -> {
                            int result = DeepSuperviseUserApi.prepareUserCertificate((String)appid, (String)pwd, (DeepSuperviseResp)resp);
                            return result;
                        });
                        this.exe.execute(getSysInfo);
                        try {
                            int getSysInfoRes = getSysInfo.get(5L, TimeUnit.SECONDS);
                            if (getSysInfoRes != 0) {
                                logger.error(String.valueOf(ctpAccnt.getExtAccntId()) + "\u672c\u5730\u83b7\u53d6\u7a7f\u900f\u5f0f\u76d1\u7ba1\u83b7\u53d6\u8bc1\u4e66" + getSysInfoRes);
                                return;
                            }
                        }
                        catch (Exception e) {
                            logger.error("\u7a7f\u900f\u5f0f\u76d1\u7ba1\u83b7\u53d6\u673a\u5668\u4fe1\u606f\u8d85\u65f6\uff1a", (Throwable)e);
                            this.registingAccount = "";
                            this.lockDeepSupervise.unlock();
                            return;
                        }
                        String cert = new String(resp.getChars(), 0, resp.getUsedLength());
                        this.deepApi.userAuthenticateRequest(ctpAccnt.getBrokerId(), ctpAccnt.getExtAccntId(), ctpAccnt.getInvestId(), 1, cert.getBytes(), deepSuperviseInfo.getAppId(), deepSuperviseInfo.getToken());
                        this.condition.await(8000L, TimeUnit.MILLISECONDS);
                        break block11;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        this.registingAccount = "";
                        this.lockDeepSupervise.unlock();
                    }
                }
                logger.info(String.valueOf(ctpAccnt.getExtAccntId()) + "\u6ce8\u518c\u7ed3\u675f");
            }
            catch (MException | Exception e) {
                logger.error(String.valueOf(fundAccount.getExtAccntId()) + "\u7a7f\u900f\u5f0f\u76d1\u7ba1\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25", e);
            }
        }
    }

    private void ctpDeepSupervise(FilteredList<FundAccount> ctpAccounts) {
        for (FundAccount fundAccount : ctpAccounts) {
            if (!(fundAccount instanceof CtpFundAccount)) continue;
            try {
                CtpFundAccount ctpAccnt = (CtpFundAccount)CtpFundAccount.class.cast(fundAccount);
                DeepSuperviseInfo deepSuperviseInfo = this.deepSuperviseMap.get(ctpAccnt.getBrokerId());
                if (deepSuperviseInfo == null || "femas".equals(deepSuperviseInfo.getType())) continue;
                DeepSuperviseResp resp = new DeepSuperviseResp();
                int result = DeepSuperviseUserApi.ctpGetSystemInfo((DeepSuperviseResp)resp);
                if (result != 0) {
                    logger.error("ctp\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff0cresult:" + result);
                }
                byte[] res = Arrays.copyOf(resp.getBytes(), resp.getUsedLength());
                logger.info(String.valueOf(ctpAccnt.getExtAccntId()) + "ctp\u83b7\u53d6\u673a\u5668\u4fe1\u606f\u6210\u529f");
                try {
                    this.deepApi.userAuthenticateRequest(ctpAccnt.getBrokerId(), ctpAccnt.getExtAccntId(), ctpAccnt.getInvestId(), 2, res, deepSuperviseInfo.getAppId(), deepSuperviseInfo.getToken());
                }
                catch (MException mException) {
                    logger.error("ctp\u63d0\u4ea4\u7528\u6237\u4fe1\u606f\u5931\u8d25");
                }
            }
            catch (Exception e) {
                logger.error(String.valueOf(fundAccount.getExtAccntId()) + "\u7a7f\u900f\u5f0f\u76d1\u7ba1\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            }
        }
    }

    @Override
    public ObservableList<FundAccount> getListNewAccnt() {
        return this.listNewAccnt;
    }

    public void setListNewAccnt(ObservableList<FundAccount> listNewAccnt) {
        this.listNewAccnt = listNewAccnt;
    }

    public Map<String, CcsFundAccount> getMarginInvestorMap() {
        if (this.investorMap.isEmpty()) {
            for (FundAccount fund : this.listNewAccnt) {
                if (!(fund instanceof CcsFundAccount)) continue;
                CcsFundAccount marginFund = (CcsFundAccount)CcsFundAccount.class.cast(fund);
                this.investorMap.put(marginFund.getInvestId(), marginFund);
            }
        }
        return this.investorMap;
    }

    public String getNewCashAccntId(String InverstorId) {
        CcsFundAccount account = this.getMarginInvestorMap().get(InverstorId);
        if (account != null && !account.getNewCashAccntId().isEmpty()) {
            return account.getNewCashAccntId();
        }
        return "";
    }

    public String getCcsAccntId(String InverstorId) {
        CcsFundAccount account = this.getMarginInvestorMap().get(InverstorId);
        if (account != null && !account.getParentId().isEmpty()) {
            return account.getParentId();
        }
        return "";
    }

    public Map<String, CcsFundAccount> getMarginCashAccntIdMap() {
        if (this.cashAccntIdMap.isEmpty()) {
            for (FundAccount fund : this.listNewAccnt) {
                if (!(fund instanceof CcsFundAccount)) continue;
                CcsFundAccount marginFund = (CcsFundAccount)CcsFundAccount.class.cast(fund);
                this.cashAccntIdMap.put(marginFund.getNewCashAccntId(), marginFund);
            }
        }
        return this.cashAccntIdMap;
    }

    public Map<String, CcsFundAccount> getMarginAccntIdMap() {
        if (this.accntIdMap.isEmpty()) {
            for (FundAccount fund : this.listNewAccnt) {
                if (!(fund instanceof CcsFundAccount)) continue;
                CcsFundAccount marginFund = (CcsFundAccount)CcsFundAccount.class.cast(fund);
                this.accntIdMap.put(marginFund.getParentId(), marginFund);
            }
        }
        return this.accntIdMap;
    }

    public String getCcsInvestorId(String extAccntId) {
        CcsFundAccount account = this.getMarginCashAccntIdMap().get(extAccntId);
        if (account != null && !account.getInvestId().isEmpty()) {
            return account.getInvestId();
        }
        logger.error(String.valueOf(extAccntId) + "\u878d\u8d44\u878d\u5238\u8d44\u91d1\u8d26\u53f7\u8f6c\u6362\u5931\u8d25," + this.listNewAccnt.toString());
        return extAccntId;
    }

    public CcsFundAccount getCcsFundAccount(String extAccntId) {
        CcsFundAccount account = this.getMarginCashAccntIdMap().get(extAccntId);
        if (account != null && !account.getInvestId().isEmpty()) {
            return account;
        }
        return account;
    }

    public String getCcsAccntIdToInvestorId(String accntId) {
        CcsFundAccount account = this.getMarginAccntIdMap().get(accntId);
        if (account != null && !account.getInvestId().isEmpty()) {
            return account.getInvestId();
        }
        return accntId;
    }

    @Override
    public synchronized String getCcsInvesId(String acctId) {
        this.getFundAccountList();
        String investId = "";
        for (FundAccount f : this.listContainsExtAsset) {
            if (!acctId.equals(f.getParentId())) continue;
            investId = f.getInvestId();
            return investId;
        }
        return acctId;
    }

    public static void main(String[] args) {
    }

    public synchronized void queryAccntAsset() {
        if (this.accntIds.isEmpty()) {
            ObservableList<FundAccount> fundAccounts = this.getFundAccountList();
            for (FundAccount fundAccount : fundAccounts) {
                if (!fundAccount.isNeeqEnable()) continue;
                this.accntIds.add(fundAccount.getParentId());
                this.neeqAccntsMap.put(fundAccount.getParentId(), fundAccount);
            }
            if (this.accntIds.isEmpty()) {
                return;
            }
        }
        logger.info("new frame assets query" + this.accntIds.size());
        GetAccntAssetReq req = new GetAccntAssetReq();
        GetAccntAssetResp resp = null;
        req.setAccntIds(this.accntIds);
        req.setMarketGroup("CCS");
        try {
            resp = this.dataHubPositionService.getAccntAsset(req);
        }
        catch (MException | Exception e) {
            logger.error("\u65b0\u6846\u67b6\u67e5\u8be2\u603b\u8d44\u4ea7\u62a5\u9519", e);
        }
        if (resp == null) {
            return;
        }
        List assets = resp.getAssets();
        if (assets == null) {
            logger.error("\u65b0\u6846\u67b6\u67e5\u8be2\u603b\u8d44\u4ea7\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        for (Assets asset : assets) {
            FundAccount accnt = this.neeqAccntsMap.get(asset.getAccntId());
            if (accnt == null) continue;
            accnt.setNewAssetAmt(asset.getTotalAsset());
        }
        this.changed();
    }

    public List<String> getProductIds() {
        return this.productIds;
    }

    public void setProductIds(List<String> productIds) {
        this.productIds = productIds;
    }
}

