/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.core.MException;
import cms.tmx.entity.FuncModule;
import cms.tmx.javafx.MxTreeList;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IFuncService;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.scene.control.TreeItem;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FuncTreeModel {
    @Inject
    private IFuncService funcMng;
    private TreeItem<FuncModule> root;
    private Map<String, TreeItem<FuncModule>> map = new HashMap<String, TreeItem<FuncModule>>();
    private MxTreeList<FuncModule> mTreeList = new MxTreeList(FxUtils.newList());
    public static final String ROOT_ID = "F00000";
    public static final String ROOT_NAME = "\u529f\u80fd\u6811";
    private List<FuncModule> list = new LinkedList<FuncModule>();

    public TreeItem<FuncModule> getFunc(String id) {
        return this.map.get(id);
    }

    public synchronized TreeItem<FuncModule> getRoot() throws MException {
        if (this.root == null) {
            this.list = this.funcMng.getAllFunc();
            this.list.forEach(item -> {
                if (ROOT_ID.equals(item.getId())) {
                    this.root = new TreeItem(item);
                }
            });
            this.initTree();
        }
        return this.root;
    }

    public synchronized TreeItem<FuncModule> refresh() throws MException {
        return this.refreshTree();
    }

    private TreeItem<FuncModule> refreshTree() throws MException {
        this.map.clear();
        TreeItem newRoot = new TreeItem();
        List<FuncModule> newList = this.funcMng.getAllFunc();
        this.mTreeList.update(newList);
        for (TreeItem item : this.mTreeList.getObList()) {
            item.getChildren().clear();
            if (!ROOT_ID.equals(((FuncModule)item.getValue()).getId())) continue;
            newRoot.setValue((Object)((FuncModule)item.getValue()));
        }
        this.buildTree((TreeItem<FuncModule>)newRoot, ((FuncModule)newRoot.getValue()).getId());
        return newRoot;
    }

    private void initTree() throws MException {
        this.buildTreeList(this.list);
        if (this.root == null) {
            return;
        }
        this.buildTree(this.root, ((FuncModule)this.root.getValue()).getId());
    }

    private void buildTreeList(List<FuncModule> list) {
        for (FuncModule func : list) {
            this.mTreeList.add((MxObject)func);
        }
    }

    private void buildTree(TreeItem<FuncModule> root, String rootId) {
        Collections.sort(this.mTreeList.getObList(), (o1, o2) -> ((FuncModule)o1.getValue()).getSort() > ((FuncModule)o2.getValue()).getSort() ? 1 : (((FuncModule)o1.getValue()).getSort() == ((FuncModule)o2.getValue()).getSort() ? Integer.parseInt(((FuncModule)o1.getValue()).getId().substring(1)) - Integer.parseInt(((FuncModule)o2.getValue()).getId().substring(1)) : -1));
        block0: for (TreeItem itemI : this.mTreeList.getObList()) {
            this.map.put(((FuncModule)itemI.getValue()).getId(), (TreeItem<FuncModule>)itemI);
            String idI = ((FuncModule)itemI.getValue()).getId();
            String parentIdI = ((FuncModule)itemI.getValue()).getParentId();
            if (idI.isEmpty()) continue;
            if (parentIdI.equals(rootId)) {
                root.getChildren().add((Object)itemI);
                continue;
            }
            for (TreeItem itemJ : this.mTreeList.getObList()) {
                String idJ = ((FuncModule)itemJ.getValue()).getId();
                if (!idJ.equals(parentIdI)) continue;
                itemJ.getChildren().add((Object)itemI);
                continue block0;
            }
        }
    }

    public MxTreeList<FuncModule> getmTreeList() {
        return this.mTreeList;
    }

    public void setmTreeList(MxTreeList<FuncModule> mTreeList) {
        this.mTreeList = mTreeList;
    }
}

