/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.manage.models;

import cms.tmx.api.mng.IFuncApi;
import cms.tmx.core.MException;
import cms.tmx.datatype.proto.hierarchy.PRbac;
import cms.tmx.entity.FuncModule;
import cms.tmx.entity.factory.FuncFactory;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFuncService;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class FuncMngServiceImpl
implements IFuncService {
    @Inject
    private IFuncApi funcApi;
    @Inject
    private FuncFactory ff;

    @Override
    public List<FuncModule> getAllFunc() throws MException {
        LinkedList<FuncModule> list = new LinkedList<FuncModule>();
        this.funcApi.getFuncs(PRbac.GetFuncModulesReq.Option.ALL, null).forEach(item -> {
            FuncModule func = this.ff.create();
            if (!item.getIdentifier().isEmpty() && !item.getControlId().isEmpty()) {
                MxNode node = this.ff.getNode(item.getIdentifier());
                if (node == null) {
                    node = MxNodeFactory.create((String)item.getIdentifier(), (String)"");
                    this.ff.addNode(item.getIdentifier(), node);
                }
                if (node != null) {
                    func.setControlId(node.clone());
                    func.getControlId().setRaw(item.getControlId());
                }
            }
            func.update(item);
            list.add(func);
        });
        return list;
    }

    @Override
    public List<FuncModule> getFuncDetails(PRbac.GetFuncModulesReq.Option option, String id) throws MException {
        LinkedList<FuncModule> list = new LinkedList<FuncModule>();
        LinkedList<String> sList = new LinkedList<String>();
        sList.add(id);
        this.funcApi.getFuncs(option, sList).forEach(item -> {
            FuncModule func = this.ff.create();
            if (!item.getIdentifier().isEmpty() && !item.getControlId().isEmpty()) {
                MxNode node = this.ff.getNode(item.getIdentifier());
                if (node == null) {
                    node = MxNodeFactory.create((String)item.getIdentifier(), (String)"");
                    this.ff.addNode(item.getIdentifier(), node);
                }
                if (node != null) {
                    func.setControlId(node.clone());
                    func.getControlId().setRaw(item.getControlId());
                }
            }
            func.update(item);
            list.add(func);
        });
        return list;
    }

    @Override
    public List<String> getFuncByRole(String roleId) throws MException {
        if (roleId.isEmpty()) {
            return new LinkedList<String>();
        }
        return this.funcApi.getFuncByRole(roleId);
    }

    public String addFunc(FuncModule func) throws MException {
        if (func.getId().isEmpty()) {
            return "";
        }
        PRbac.FuncModule.Builder fBuilder = PRbac.FuncModule.newBuilder();
        fBuilder.setModuleId(func.getId());
        fBuilder.setModuleName(func.getName());
        fBuilder.setParentId(func.getParentId());
        fBuilder.setSort(func.getSort());
        fBuilder.setIdentifier(func.getIdentifier().getRaw());
        if (!func.getModuleType().getRaw().isEmpty()) {
            fBuilder.setTypeValue(Integer.parseInt(func.getModuleType().getRaw()));
        }
        if (func.getControlId() != null) {
            fBuilder.setControlId(func.getControlId().getRaw());
        }
        if (!func.getInterfaceList().isEmpty()) {
            func.getInterfaceList().forEach(item -> fBuilder.addInterface(item));
        }
        return this.funcApi.addFunc(fBuilder.build());
    }

    public void delFuc(String id) throws MException {
        this.funcApi.delFuc(id);
    }

    public void enableFunc(boolean enable, FuncModule func) throws MException {
        PRbac.FuncModule.Builder fBuilder = PRbac.FuncModule.newBuilder();
        fBuilder.setModuleName(func.getName());
        fBuilder.setParentId(func.getParentId());
        fBuilder.setSort(func.getSort());
        fBuilder.setModuleId(func.getId());
        fBuilder.setIdentifier(func.getIdentifier().getRaw());
        if (!func.getModuleType().getRaw().isEmpty()) {
            fBuilder.setTypeValue(Integer.parseInt(func.getModuleType().getRaw()));
        }
        if (func.getControlId() != null) {
            fBuilder.setControlId(func.getControlId().getRaw());
        }
        if (!func.getStatus().getRaw().isEmpty()) {
            fBuilder.setStatus(Integer.parseInt(func.getStatus().getRaw()));
        }
        if (!func.getInterfaceList().isEmpty()) {
            func.getInterfaceList().forEach(item -> fBuilder.addInterface(item));
        }
        fBuilder.setStatus(enable ? 1 : 3);
        this.funcApi.updateFunc(fBuilder.build());
    }

    public void updateFunc(FuncModule func) throws MException {
        PRbac.FuncModule.Builder fBuilder = PRbac.FuncModule.newBuilder();
        fBuilder.setModuleName(func.getName());
        fBuilder.setParentId(func.getParentId());
        fBuilder.setSort(func.getSort());
        fBuilder.setModuleId(func.getId());
        fBuilder.setIdentifier(func.getIdentifier().getRaw());
        if (!func.getModuleType().getRaw().isEmpty()) {
            fBuilder.setTypeValue(Integer.parseInt(func.getModuleType().getRaw()));
        }
        if (func.getControlId() != null) {
            fBuilder.setControlId(func.getControlId().getRaw());
        }
        if (!func.getStatus().getRaw().isEmpty()) {
            fBuilder.setStatus(Integer.parseInt(func.getStatus().getRaw()));
        }
        if (!func.getInterfaceList().isEmpty()) {
            func.getInterfaceList().forEach(item -> fBuilder.addInterface(item));
        }
        fBuilder.setStatus(func.getStatus().getRaw().equals("1") ? 1 : 3);
        this.funcApi.updateFunc(fBuilder.build());
    }
}

